/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#ifndef USE_HILDON
#define BASE_DIR ".osm2go/"
#else
#define BASE_DIR "/media/mmc2/osm2go/"
#endif

typedef struct settings_s {
  /* never changed */
  char *base_path;

  /* changed in osm_api.c */
  char *server, *username, *password;

  /* changed in wms.c */
  char *wms_server, *wms_path;

} settings_t;

settings_t *settings_load(void);

#endif // SETTINGS_H
