/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "appdata.h"

static void on_info_clicked(GtkButton *button, gpointer data) {
  info_dialog((appdata_t*)data);
}

static void on_node_add_clicked(GtkButton *button, gpointer data) {
  map_action_set((appdata_t*)data, MAP_ACTION_NODE_ADD);
}

static void on_way_add_clicked(GtkButton *button, gpointer data) {
  map_action_set((appdata_t*)data, MAP_ACTION_WAY_ADD);
}

static void on_trash_clicked(GtkButton *button, gpointer data) {
  map_delete_selected((appdata_t*)data);
}

static void on_ok_clicked(GtkButton *button, gpointer data) {
  printf("User ok\n");
  map_action_ok((appdata_t*)data);
}

static void on_cancel_clicked(GtkButton *button, gpointer data) {
  printf("User cancel\n");
  map_action_cancel((appdata_t*)data);
}

/* enable/disable ok and cancel button */
void icon_bar_map_cancel_ok(appdata_t *appdata, 
              gboolean cancel, gboolean ok) {
  iconbar_t *iconbar = appdata->iconbar;
  gtk_widget_set_sensitive(iconbar->ok, ok);
  gtk_widget_set_sensitive(iconbar->cancel, cancel);
}

void icon_bar_map_item_selected(appdata_t *appdata, 
		map_item_t *map_item, gboolean selected) {
  iconbar_t *iconbar = appdata->iconbar;

  gtk_widget_set_sensitive(iconbar->info, selected);

  /* currently only nodes can be deleted */
  gtk_widget_set_sensitive(iconbar->trash, selected && 
			   map_item->type == MAP_TYPE_NODE);
}

/* if a user action is on progress, then disable all buttons that */
/* cause an action to take place */
void icon_bar_map_action_idle(appdata_t *appdata, gboolean idle) {
  gint i;
  GtkWidget *action_widgets[] = {
    appdata->iconbar->node_add,
    appdata->iconbar->way_add,
    NULL
  };

  for(i=0;action_widgets[i];i++) {
    gtk_widget_set_sensitive(action_widgets[i], idle);
  }
}

GtkWidget *icon_add(GtkWidget *vbox, appdata_t *appdata, 
		    char *icon_str, 
		    void(*func)(GtkButton*, gpointer)) {
  GtkWidget *but = gtk_button_new();
  GtkWidget *icon = gtk_image_new_from_pixbuf(
		      icon_load(appdata, icon_str)); 
  gtk_button_set_image(GTK_BUTTON(but), icon);
  if(func)
    gtk_signal_connect(GTK_OBJECT(but), "clicked",
		       (GtkSignalFunc)func, appdata);

  gtk_box_pack_start(GTK_BOX(vbox), but, FALSE, FALSE, 0);
  return but;
}

GtkWidget *iconbar_new(appdata_t *appdata) {
  appdata->iconbar = g_new0(iconbar_t, 1);
  iconbar_t *iconbar = appdata->iconbar;

  GtkWidget *vbox = gtk_vbox_new(FALSE, 0);

  /* -------------------------------------------------------- */

  iconbar->info = icon_add(vbox, appdata, "info", on_info_clicked);
  iconbar->trash = icon_add(vbox, appdata, "trash", 
			    on_trash_clicked);
  iconbar->node_add = icon_add(vbox, appdata, "node_add",
			       on_node_add_clicked);
  //  iconbar->way_add = icon_add(vbox, appdata, "way_add",
  //			      on_way_add_clicked);

  GtkWidget *hbox = gtk_hbox_new(FALSE, 0);
  iconbar->ok = icon_add(hbox, appdata, "ok", on_ok_clicked);
  iconbar->cancel = icon_add(hbox, appdata, "cancel", 
			     on_cancel_clicked);
  gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  
  /* --------------------------------------------------------- */  

  icon_bar_map_item_selected(appdata, NULL, FALSE);
  icon_bar_map_cancel_ok(appdata, FALSE, FALSE);

  return vbox;
}
