/*
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * This file contains routines to read thep potlatch config file
 * to use matching colors for the map
 */

#include <sys/stat.h>
#include <ctype.h>
#include "appdata.h"

int isblank(int c);

static const char *data_paths[] = {
  "/usr/share/" PACKAGE ,   // final installation path
  "./data",                 // local path for testing
  ""
};

static gchar*
file_exists(const gchar *dir, const gchar *file) {
  gchar *fullname;
  struct stat s;
  gint status;

  fullname = (gchar*)g_malloc(strlen(dir)+1+strlen(file)+1);
  strcpy(fullname, dir);
  if(fullname[strlen(fullname)-1] != G_DIR_SEPARATOR)
    strcat(fullname, G_DIR_SEPARATOR_S);
  strcat(fullname, file);

  status = stat(fullname, &s);
  if(status == 0 && S_ISREG(s.st_mode))
    return fullname;

  g_free(fullname);
  return NULL;
}

static potlatch_color_t *read_colours(void) {
  gint i=0;
  potlatch_color_t *first = NULL;
  potlatch_color_t **cur = &first;

  do {
    gchar *fullname = file_exists(data_paths[i], "colours.txt");
    if(fullname) {
      char str[64];

      printf("%s exists\n", fullname);

      /* parse it */
      FILE *file = fopen(fullname, "r");
      if(!file) return NULL;

      while(fgets(str, sizeof(str), file) != NULL) {
	char *p = str;
	while(isblank(*p)) p++;

	if((*p != '#')&&(*p != '\r')&&(*p != '\n')) {
	  char tag[20], color[10], stroke[3], fill_color[10];
	  if(sscanf(p, "%20s %10s %3s %10s", 
		    tag, color, stroke, fill_color) == 4) {

	    *cur = g_new0(potlatch_color_t, 1);
	    (*cur)->tag = strdup(tag);
	    if(sscanf(color, "0x%x", &(*cur)->color) != 1) 
	      (*cur)->color = COLOR_NONE;
	    if(sscanf(stroke, "%d", &(*cur)->stroke) != 1) 
	      (*cur)->stroke = FALSE;
	    if(sscanf(fill_color, "0x%x", &(*cur)->fill_color) != 1) 
	      (*cur)->fill_color = COLOR_NONE;

	    cur = &((*cur)->next);
	  }
	}
      }

      fclose(file);
      return first;
    }

    i++;
  } while(data_paths[i][0]);

  return NULL;
}

potlatch_conf_t *potlatch_conf_load(void) {
  potlatch_conf_t *conf = g_new(potlatch_conf_t, 1);

  printf("loading potlatch conf\n");

  conf->colors = read_colours();

  return conf;
}
