/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef POS_H
#define POS_H

#include <math.h>

#ifndef NAN
#define NAN (0.0/0.0)
#endif

/* equatorial radius in meters */
#define POS_EQ_RADIUS     (6378137.0)

#define DEG2RAD(a)  ((a) * M_PI / 180.0)
#define RAD2DEG(a)  ((a) * 180.0 / M_PI)

/* global position */
typedef struct pos {
  float lat, lon;
} pos_t;

/* local position */
typedef struct lpos {
  gint x, y;
} lpos_t;

struct bounds_s;
void pos2lpos(struct bounds_s *bounds, pos_t *pos, lpos_t *lpos);
void pos2lpos_center(pos_t *pos, lpos_t *lpos);
void lpos2pos(struct bounds_s *bounds, lpos_t *lpos, pos_t *pos);

void pos_lat_str(char *str, int len, float latitude);
void pos_lon_str(char *str, int len, float longitude);
float pos_parse_lat(char *str);
float pos_parse_lon(char *str);
GtkWidget *pos_lat_entry_new(float lat);
GtkWidget *pos_lon_entry_new(float lon);
float pos_lat_get(GtkWidget *widget);
float pos_lon_get(GtkWidget *widget);

#endif // POS_H
