/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef APPDATA_H
#define APPDATA_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <locale.h>
#include <libintl.h>

#define LOCALEDIR "/usr/share/locale"

#define _(String) gettext(String)
#define N_(String) (String)

#ifdef USE_HILDON
#include <hildon/hildon-program.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <hildon/hildon-file-system-model.h>
#include <libosso.h>      /* required for screen saver timeout */
#define GTK_FM_OK  GTK_RESPONSE_OK
#else
#define GTK_FM_OK  GTK_RESPONSE_ACCEPT
#endif


#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-inet-connection.h>

void errorf(GtkWidget *parent, const char *fmt, ...);
void messagef(GtkWidget *parent, char *title, const char *fmt, ...);

#include "pos.h"
#include "osm.h"
#include "potlatch_conf.h"

#include "canvas.h"

typedef struct appdata {
#ifdef USE_HILDON
  HildonProgram *program;
  HildonWindow *window;
  osso_context_t *osso_context;

  /* and the ability to zoom */
  GtkWidget *fullscreen_menu_item;
#else
  GtkWidget *window;
#endif

  GtkWidget *vbox;
  struct map_s *map;
  osm_t *osm;
  potlatch_conf_t *potlatch;

  struct statusbar_s *statusbar;
  struct settings_s *settings;
  struct project_s *project;
  struct iconbar_s *iconbar;
  struct icon_s *icon;

  /* menu items to be enabled and disabled every now and then */
  gboolean gps_enabled;
  struct gps_state_s *gps_state;

  struct {
    char *import_path;
    GtkWidget *menu_item_import;
    GtkWidget *menu_item_export;
    GtkWidget *menu_item_clear;
    GtkWidget *menu_item_gps;
    struct track_s *track;
    guint handler_id;
    canvas_item_t *gps_item;      // the purple curcle
  } track;

} appdata_t;

#include "map.h"
#include "map_hl.h"
#include "osm_api.h"
#include "statusbar.h"
#include "project.h"
#include "settings.h"
#include "diff.h"
#include "iconbar.h"
#include "icon.h"
#include "info.h"
#include "track.h"
#include "gps.h"

#endif // APPDATA_H
