/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UTM_H
#define UTM_H

#define FOURTHPI   (M_PI / 4)
#define DEG2RAD(a) ((a) * M_PI / 180)
#define RAD2DEG(a) ((a) * 180.0 / M_PI)

#define UTM_FLOAT  double

typedef struct {
  int  zone;   // e.g. 32
  char band;   // e.g. U
  long easting, northing;
} utm_t;

void utm2str(char *str, int size, utm_t *utm);
void utm_utm2pos(utm_t *utm, pos_t *pos);
void utm_pos2utm(pos_t *pos, utm_t *utm, utm_t *ref);

#endif // UTM_H
