/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "appdata.h"

settings_t *settings_load(void) {
  settings_t *settings = g_new0(settings_t,1);

#ifdef USE_HILDON
  char *p;
  settings->base_path = strdup(BASE_DIR);
#else
  char *p = getenv("HOME");
  g_assert(p);

  /* build image path in home directory */
  settings->base_path =
    malloc(strlen(p)+strlen(BASE_DIR)+2);
  strcpy(settings->base_path, p);
  if(settings->base_path[strlen(settings->base_path)-1] != '/')
    strcat(settings->base_path, "/");
  strcat(settings->base_path, BASE_DIR);
#endif

  /* setup download defaults */
  settings->server = strdup("http://api.openstreetmap.org/api/0.5");
  if((p = getenv("OSM_USER")))
    settings->username = g_strdup(p);
  else
    settings->username = g_strdup(_("<your osm username>"));

  if((p = getenv("OSM_PASS")))
    settings->password = g_strdup(p);
  else
    settings->password = strdup("<password>");

  return settings;
}
