/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef POS_H
#define POS_H

#include <math.h>

#ifndef NAN
#define NAN (0.0/0.0)
#endif

typedef struct pos {
  float lat, lon;
} pos_t;

typedef struct lpos {
  gint x, y;
} lpos_t;

void pos_lat_str(char *str, int len, float latitude);
void pos_lon_str(char *str, int len, float longitude);
float pos_parse_lat(char *str);
float pos_parse_lon(char *str);
GtkWidget *pos_lat_entry_new(float lat);
GtkWidget *pos_lon_entry_new(float lon);
float pos_lat_get(GtkWidget *widget);
float pos_lon_get(GtkWidget *widget);

#endif // POS_H
