/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAP_HL_H
#define MAP_HL_H

void map_hl_cursor_draw(map_t *map, gint x, gint y);
void map_hl_cursor_clear(map_t *map);

void map_hl_touchnode_draw(map_t *map, gint x, gint y);
void map_hl_touchnode_clear(map_t *map);

GnomeCanvasItem *map_hl_new(map_t *map, 
				   GnomeCanvasGroup *parent, GType type, 
				   map_item_t *map_item,
				   const gchar *first_arg_name,
				   ...);
void map_hl_remove(appdata_t *appdata);
gboolean map_hl_item_is_highlighted(map_t *map, map_item_t *item);

#endif // MAP_HL_H
