/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of OSM2Go.
 *
 * OSM2Go is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OSM2Go is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSM2Go.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "appdata.h"

/* create a new item for the cursor */
void map_hl_cursor_draw(map_t *map, gint x, gint y) {
  if(map->cursor) 
    gtk_object_destroy(GTK_OBJECT(map->cursor));

  double wx, wy;
  gnome_canvas_window_to_world(GNOME_CANVAS(map->canvas), x, y, &wx, &wy);

  map->cursor =  gnome_canvas_item_new(
	     GNOME_CANVAS_GROUP(map->group[MAP_GROUP_DRAW]),
	     GNOME_TYPE_CANVAS_ELLIPSE,
	     "x1", wx-RADIUS, "x2", wx+RADIUS,
	     "y1", wy-RADIUS, "y2", wy+RADIUS,
	     "fill_color_rgba", HIGHLIGHT2_COLOR,
	     "width-units", 0.0,
	     NULL);   
}

void map_hl_cursor_clear(map_t *map) {
  if(map->cursor) {
    gtk_object_destroy(GTK_OBJECT(map->cursor));
    map->cursor = NULL;
  }
}

/* create a new item used for touched node */
void map_hl_touchnode_draw(map_t *map, gint x, gint y) {
  if(map->touchnode) 
    gtk_object_destroy(GTK_OBJECT(map->touchnode));

  map->touchnode =  gnome_canvas_item_new(
	     GNOME_CANVAS_GROUP(map->group[MAP_GROUP_DRAW]),
	     GNOME_TYPE_CANVAS_ELLIPSE,
	     "x1", x-2*RADIUS, "x2", x+2*RADIUS,
	     "y1", y-2*RADIUS, "y2", y+2*RADIUS,
	     "fill_color_rgba", TOUCHNODE_COLOR,
	     "width-units", 0.0,
	     NULL);   
}

void map_hl_touchnode_clear(map_t *map) {
  if(map->touchnode) {
    gtk_object_destroy(GTK_OBJECT(map->touchnode));
    map->touchnode = NULL;
  }
}

/* called whenever a highlight item is to be destroyed */
gint map_hl_item_destroy_event(GtkWidget *widget, gpointer data) {
  map_item_t *map_item = (map_item_t*)data;

  //  printf("destroying highlight map_item @ %p\n", map_item);
  g_free(map_item);
  return FALSE;
}

/* create a new item used for highlighting and move it to the */
/* highlight list */
GnomeCanvasItem *map_hl_new(map_t *map, 
		        GnomeCanvasGroup *parent, GType type, 
		        map_item_t *map_item,
			const gchar *first_arg_name,
			...) {
  /* attach highlight object */
  map_highlight_t **hl = &map->highlight;
  while(*hl) hl = &((*hl)->next);
  *hl = g_new0(map_highlight_t, 1);

  va_list args;
  va_start( args, first_arg_name);

  map_item->item = (*hl)->item = g_object_new(type, NULL);
  gnome_canvas_item_construct((*hl)->item, parent, first_arg_name, args);

  gtk_object_set_user_data(GTK_OBJECT((*hl)->item), map_item);

  gtk_signal_connect(GTK_OBJECT((*hl)->item), 
     "destroy", G_CALLBACK(map_hl_item_destroy_event), map_item);

  return (*hl)->item;
}

void map_hl_remove(appdata_t *appdata) {
  map_t *map = appdata->map;

  if(!map->highlight) return;

  printf("removing highlight\n");

  map_highlight_t *hl = map->highlight;
  while(hl) {
    map_highlight_t *next = hl->next;
    gtk_object_destroy(GTK_OBJECT(hl->item));
    g_free(hl);

    hl = next;
  }

  map->highlight = NULL;
}

gboolean map_hl_item_is_highlighted(map_t *map, map_item_t *item) {
  map_highlight_t *hl = map->highlight;
  while(hl) {
    map_item_t *hl_item = 
      (map_item_t*)gtk_object_get_user_data(GTK_OBJECT(hl->item));

    if(hl_item) {
      if((hl_item->type == item->type) && 
	 (hl_item->ptr == item->ptr))
	return TRUE;
    }

    hl = hl->next;
  }

  return FALSE;
}
