import os, subprocess, time, sys
from threading import Thread, Semaphore

class YStreamer(Thread):
    def __init__(self, observer, video):
        Thread.__init__(self)
        self.childDl = None;
        self.childMp = None;
        self.video = video
        self.justDl = False;
        self.waitCmd = Semaphore(0)
        self.observer = observer
          
    
    def procKill(self, proc, wait=False):
        if proc == None:
            return
        print "killing %d" %(proc.pid)
        if sys.platform != "win32":
            os.kill(proc.pid, 9)
        else:
            import win32api
            handle = win32api.OpenProcess(1, 0, proc.pid)
            win32api.TerminateProcess(handle, 0)
        if wait:
            self.procClean(proc)
    
    def procClean(self, proc):
        if proc == None:
            return True
        try:
            lpid,lstatus = os.waitpid(proc.pid, os.WNOHANG)
        except:
            lpid,lstatus = [-1, -1]
        if lpid != 0 or lstatus !=0:
            print "pid exited %d" %(proc.pid)
            return True
        return False

   
    def parsePercentage(self, line):
        toks = line.split(" ")
        for tok in toks:
            if tok.strip().endswith("%"):
                toks1 = tok.split("%")
                if len(toks1) > 0:
                    try:
                        return float(toks1[0])
                    except Exception:
                        return -1
        return -1
    
    def parseDownloaded(self, line):
        toks = line.split(" ")
        for tok in toks:
            if tok.endswith("k"):
                toks1 = tok.split("k")
                if len(toks1) > 0:
                    try:
                        return float(toks1[0])
                    except Exception:
                        return -1
            if tok.endswith("M"):
                toks1 = tok.split("M")
                if len(toks1) > 0:
                    try:
                        return float(toks1[0])*1000
                    except Exception:
                        return -1
        return -1
    
    def launchMplayer(self, file):
        #mplayerOpt = "-nofs"
        #hack ... observer assumed = gui
        #if self.observer.window_in_fullscreen:
        #    mplayerOpt = "-fs"
        try:
            cmd = YCfg.CMD_MPLAYER[:]
            for i in range(len(cmd)):
                if cmd[i].find("%s") != -1:
                    cmd[i] = cmd[i].replace("%s", file)
            print "launch mplayer [%s]" %(" ".join(cmd))
            
            self.childMp = subprocess.Popen(cmd, #["mplayer", "-osdlevel", "3", "-correct-pts", mplayerOpt, "--", "%s" %file],
                                            stdout=None, #open("/dev/null", "w"),
                                            close_fds=(sys.platform != "win32"))
        except:
            YCfg.log("no mplayer")
    
    def runYoutubeDl(self):
        url = self.video.url
        if not YStorage.ensurePath(self.video):
            YCfg.log("I cannot create storage. Check rights!")
            return False
        saveas = YStorage.getVideoStoragePath(self.video)
        if self.video.isStored() or self.video.isCached():
            if not self.justDl:
                self.launchMplayer(saveas)
            return True;
        try:
            print "worker is now downloading [%s] -> [%s]" %(url, saveas)
            cmd = YCfg.CMD_YTDL[:]
            for i in range(len(cmd)):
                if cmd[i].find("%s") != -1:
                    cmd[i] = cmd[i].replace("%s", url)
                if cmd[i].find("%d") != -1:
                    cmd[i] = cmd[i].replace("%d", saveas)
            print "launch youtube-dl [%s]" %(" ".join(cmd))
            self.childDl = subprocess.Popen(cmd, #["youtube-dl-x", "-o", saveas, url], 
                                             stdout=subprocess.PIPE, 
                                             stderr=subprocess.STDOUT, close_fds=(sys.platform != "win32"))
            stdout = self.childDl.stdout
            self.observer.notifyProgress(self.video, None, None)
            while True:
                line = stdout.readline()
                print line
                if not line:
                    break
                percentage = self.parsePercentage(line)
                kilo = self.parseDownloaded(line)
                #print "KB = %s percent = %s" %(kilo, percentage)
                if (percentage > 0):
                    self.observer.notifyProgress(self.video, percentage, kilo)
                #try to start a mplayer player if there is none and this is not a download
                if (percentage >= 100 or kilo > 300) and self.childMp == None and not self.justDl:
                    self.launchMplayer(saveas)
        except IOError:
            print "failed spawn"
            return False
        return True
    
    def cleanChilds(self):
        if self.procClean(self.childDl):
            #print "worker dl proc cleaned-up"
            self.childDl = None
        if self.procClean(self.childMp):
            #print "worker mp proc cleaned-up"
            self.childMp = None
            
    def addRequest(self,justDownload=True):
        self.cleanChilds()
        if self.childMp != None:
            print "a video already playing"
            return False;
        if self.childDl != None and not justDownload:
            print "video downloading, we can start playin it! "
            #TODO: this should be done in cache
            self.launchMplayer(YStorage.getVideoStoragePath(self.video))
            return True
        self.justDl = justDownload
        self.waitCmd.release()
        return True
    
    def cancelCurrentRequest(self):
        self.procKill(self.childDl, True)
        self.procKill(self.childMp, True)
    
    def terminate(self):
        print "videoserve terminating ..."
        self.procKill(self.childDl)
        self.procKill(self.childMp)
        #signal worked something fucked up happened
        self.waitCmd.release()
        self.join(1000)
        print "videoserve terminated ..."
    
    def run(self):
        #while not self.mustExit:
        if True:
            print "WORKER waiting sir"
            self.waitCmd.acquire()
            if self.video == None:
                print "WTF"
                return #time to exit
            else:
                self.runYoutubeDl()
                self.video = None
                self.cleanChilds()
        print "WORKER fired"
    

def testYtServeVideo():
    yt_s = YStreamer()
    yt_s.requestAdd("http://youtube.com/watch?v=0EHtD8q7Sgo")
    
    for i in range(20):
        yt_s.requestAdd("http://youtube.com/watch?v=0EHtD8q7Sgo")
        time.sleep(1)
if __name__ == '__main__':    
    testYtServeVideo()

from ystorage import YStorage
from yconf import YCfg
