import os, gtk, sys, traceback


try:
    import hildon
    maemo = True
except:
    maemo = False
    
class YStorage:
    #TODO: make sure this is loaded
    THUMB_LOAD = None
    def __init__(self):
        if YStorage.THUMB_LOAD == None:
            print "####aload thumb"
            YStorage.THUMB_LOAD = YStorage.loadPixbuf("mytubeload.png", 80, 80)
        pass
    
    def getVideoId(video):
        id = video.url.split("=")[1].split("&")[0]
        return id
        
    getVideoId = staticmethod(getVideoId)
    
    #removes some "not that save" caracters 
    def safeFsString(string):
        #does vfat support utf?
        string1 = string.encode('ascii', 'ignore')
        #TODO: check here
        for c in [" ", "\"", "\'", "/", "?", "!", ":"]:
            string1 = string1.replace(c, ".")
        #remove multiple dots
        string1 = string1.split(".")
        string1 = ".".join([tok for tok in string1 if len(tok) > 0])
        string1 = string1.strip(".")
        return string1
    safeFsString = staticmethod(safeFsString)
    
    def getVideoStoragePath(video):
        url = video.url
        title = YStorage.safeFsString(video.title)
        #try first with legacy storage location
        storePath = YCfg.STORE_PATH + os.path.sep + YStorage.getVideoId(video) + os.path.sep + "vid.flv"
        #try the new filename
        if not os.path.exists(storePath):
            storePath = YCfg.STORE_PATH + os.path.sep + YStorage.getVideoId(video) + os.path.sep + title + ".flv"
        print storePath
        return storePath
    getVideoStoragePath = staticmethod(getVideoStoragePath)

    def getVideoCachePath(video):
        url = video.url
        title = video.title
        storePath = YCfg.CACHE_PATH + os.path.sep + YStorage.getVideoId(video) + os.path.sep + "vid.flv"
        return storePath
    getVideoCachePath = staticmethod(getVideoCachePath)
    
    def ensurePath(video):
        try:
            url = video.url
            storeDir = YCfg.STORE_PATH + os.path.sep + YStorage.getVideoId(video)
            if not os.path.exists(storeDir):
                os.makedirs(storeDir)
            video.thumbpix.save(storeDir + os.path.sep + "thumb.png", "png")
            file = open(storeDir + os.path.sep + "info", "w")
            file.write("%s\n" %video.duration);
            file.write(video.title+"\n");
            file.write(video.url+"\n");
            file.write(str(video.rating)+"\n");
            file.write(video.desc.replace("\n", "<br>").replace("\r", "<br>")+"\n")
            file.write(video.cat+"\n")
            file.write(video.added+"\n")
            file.write(str(video.views)+"\n")
            file.write(str(video.related)+"\n")
            file.write(str(video.author)+"\n")
            file.close()
        except:
            traceback.print_exc(file=sys.stdout)
            return False
        return True
    ensurePath = staticmethod(ensurePath)
    
    def loadEntry(path):
        videoId = path
        fentry = YCfg.STORE_PATH + os.path.sep + path
        try:
            thumbPixbuf =  gtk.gdk.pixbuf_new_from_file_at_size(fentry+os.path.sep+"thumb.png", 80, 80)
        except:
            print sys.exc_info()[1]
            thumbPixbuf = YStorage.THUMB_LOAD        
        
        #read from file
        duration = 0
        title = "[default]"
        href_url = "http://www.youtube.com/watch?v="+videoId
        rating = 1
        finfo = None
        yentry = YEntry(title, href_url , "authoR", "tagS", None, "file://"+fentry+"/thumb.png")
        yentry.setThumbPix(thumbPixbuf)
        try:
            finfo = open(fentry+"/info", "r")
            yentry.duration = atoi(finfo.readline().strip())
            yentry.title = finfo.readline().strip()
            yentry.url = finfo.readline().strip()
            yentry.setRating(atof(finfo.readline().strip()))
            yentry.desc = finfo.readline().strip().replace("<br>", "\n")
            yentry.cat = finfo.readline().strip()
            yentry.added = finfo.readline().strip()
            yentry.views = atoi(finfo.readline().strip())
            yentry.related = finfo.readline().strip()
            yentry.author = finfo.readline().strip()
            finfo.close()
            
            storagePath =YStorage.getVideoStoragePath(yentry)
            if os.path.isfile(storagePath):
                yentry.downloadedKb = os.path.getsize(storagePath) >> 10
                yentry.percentDl = 100
        except:
            if finfo != None:
                finfo.close()
            print sys.exc_info()        
        
        return yentry
    loadEntry = staticmethod(loadEntry)
    
    #@param cli youtube client
    def loadFromVideo(video, cli):
        thumb_url = cli.get_smallest_thumbnail(video)
        href_url = video.link[0].href
        yentry = YEntry(video.title.text, href_url, cli.get_author(video), "tagS", None, thumb_url)
        yentry.setThumbPix(YStorage.THUMB_LOAD)
        yentry.duration = cli.get_duration(video)
        yentry.setRating(cli.get_average(video))
        yentry.desc = cli.get_description(video)
        yentry.cat = cli.get_cat(video)
        yentry.added = cli.get_date(video)
        yentry.views = cli.get_viewed(video)
        yentry.related = cli.get_related(video)
        return yentry
    loadFromVideo = staticmethod(loadFromVideo)
    
    def deleteStored(video):
        url = video.url
        storeDir = YCfg.STORE_PATH + os.path.sep + YStorage.getVideoId(video)
        try:
            print "rmdir "+storeDir
            #os.rmdir(storeDir)
            if sys.platform != "win32":
                os.system("rm -rf -- \"%s\" " %storeDir)
            else:
                os.system("rd /Q /S \"%s\" " %storeDir)
                print "rd /Q /S \"%s\" " %storeDir
            return True
        except:
            print "failed to delete the folder %s" %(storeDir)
            return False
    deleteStored = staticmethod(deleteStored)


    def getImgPath(filename):
        if os.path.isfile("images/"+filename):
            return "images/"+filename
        if os.path.isfile("/usr/share/pixmaps/"+filename):
            return "/usr/share/pixmaps/"+filename
        print "failed to get resourse "+filename
        return ""
    getImgPath = staticmethod(getImgPath)
    
    def loadPixbuf(filename, w, h):
        try:
            img = gtk.gdk.pixbuf_new_from_file_at_size(YStorage.getImgPath(filename), w, h)
            if img == None: #OS2007?
                img = gtk.gdk.pixbuf_new_from_file(YStorage.getImgPath(filename))
            return img
        except:
            print "error: cannot find pixbuf "+filename
            return None
    loadPixbuf = staticmethod(loadPixbuf)
    
    def loadImage(filename, w, h):
        pb = YStorage.loadPixbuf(filename, w, h)
        if pb == None:
            return None
        img = gtk.Image();
        img.set_from_pixbuf(pb)
        return img
    loadImage = staticmethod(loadImage)
    
#i'm allowed to do that :), python n00b
from yconf import YCfg
from yentry import YEntry
from string import atoi
from string import atof
