#Class used for both Config and Environment functions
#TODO: restructure

from ConfigParser import ConfigParser
import os, sys, gtk, traceback
try:
    import hildon
    maemo = True
except:
    maemo = False

class YCfg:
    CFG_NAME = os.path.expanduser("~")+"/.mytuberc"
    STORE_PATH_DEFAULT  = "/media/mmc2"
    STORE_PATH          = ""
    CACHE_PATH          = ""
    VER                 = "0.1.2"
    CMD_MPLAYER_DEFAULT = "mplayer -osdlevel 3 -correct-pts -- %s".split(" ")
    CMD_MPLAYER         = CMD_MPLAYER_DEFAULT
    CMD_YTDL_DEFAULT    = "youtube-dl-x -o %d -- %s".split(" ")
    CMD_YTDL            = CMD_YTDL_DEFAULT
    CMD_BROWSER_DEFAULT = "/usr/bin/browser --url"
    CMD_BROWSER         = CMD_BROWSER_DEFAULT
    GTK_THEMES_PATHS    = ["/usr/share/themes", "C:\\Program Files\\Common Files\\GTK\\2.0\\share\\themes"]
    PER_PAGE = 10
    #singleton?
    INSTANCE = None
    hiddenWindow        = None
    
    def __init__(self, gui):
        YCfg.INSTANCE = self
        self.cfg = ConfigParser()
        self.gui = gui
        #self.ensureRc()
        
        self.cfg.read(self.CFG_NAME)
        
        #default ini file
        if not self.cfg.has_section("global"):
            self.cfg.add_section("global")
            self.saveCfg()

        YCfg.STORE_PATH = self.getCfg("store", YCfg.STORE_PATH_DEFAULT)+os.path.sep+"mtube" 
        if not os.path.isdir(YCfg.STORE_PATH):
            print "storage dir does not exist "+YCfg.STORE_PATH
            self.guiAskStorePath()
        YCfg.CACHE_PATH = self.getCfg("cache", YCfg.STORE_PATH_DEFAULT)+os.path.sep+"mtube"
        #
        YCfg.CMD_MPLAYER = self.getCfg("mplayer", " ".join(YCfg.CMD_MPLAYER_DEFAULT)).split(" ")
        #
        YCfg.CMD_YTDL = self.getCfg("youtube-dl", " ".join(YCfg.CMD_YTDL_DEFAULT)).split(" ")
        #
        YCfg.CMD_BROWSER = self.getCfg("browser", YCfg.CMD_BROWSER_DEFAULT)
        #
        YCfg.PER_PAGE = int(self.getCfg("per_page", "10"))
        #
        
        self.saveCfg()
    
    
    def getCfg(self, varName, defaultVal = None):
        var = ""
        try:
            var = self.cfg.get("global", varName)
        except:
            if defaultVal != None:
                var = defaultVal
                #and save it
                self.cfg.set("global", varName, defaultVal)
        return var
        
    def setCfg(self, var, val, save=True):
        self.cfg.set("global", var, val)
        if save:
            self.saveCfg()
            
    def saveCfg(self):
        f = open(self.CFG_NAME, "w")
        self.cfg.write(f)
        f.close()
        
    def getThemesList(self):
        paths = YCfg.GTK_THEMES_PATHS
        dirs = []
        for path in paths:
            try:
                dirs = sorted([d for d in os.listdir(path) if (os.path.isfile(path+os.path.sep+d+os.path.sep+"gtk-2.0"+os.path.sep+"gtkrc"))])
                return dirs
            except:
                pass
        return dirs
    
    
    def chooseStoreFolder(self):
        if not maemo:
            fc = gtk.FileChooserDialog("Choose video storage path",
                                    None,
                                    gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, 
                                    (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                    gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        else:
            if YCfg.hiddenWindow == None:
                YCfg.hiddenWindow = hildon.Window()
            if self.gui.window == None:
                YCfg.info("Choose video storage path")
            fc = hildon.FileChooserDialog(YCfg.hiddenWindow, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
        
        fc.set_current_folder(self.getCfg("store", YCfg.STORE_PATH_DEFAULT))
        res = fc.run()
        fc.hide()

        if res == gtk.RESPONSE_ACCEPT or res == gtk.RESPONSE_OK:
            try:
                if not os.path.isdir(fc.get_filename()+os.path.sep+"mtube"):
                    os.mkdir(fc.get_filename()+os.path.sep+"mtube")
                self.setCfg("store", fc.get_filename(), False)
            except:
                YCfg.log(sys.exc_info()[1])
    
    def guiAskStorePath(self, ignore1=None):
        self.chooseStoreFolder()
        
        YCfg.STORE_PATH = self.getCfg("store", YCfg.STORE_PATH_DEFAULT)+os.path.sep+"mtube"
        YCfg.CACHE_PATH = YCfg.STORE_PATH
    
    def guiAskPrefs(self, ignore=None):
        #try to load code when needed only to speed up things
        from guiprefs import GuiPrefs
        prefs = GuiPrefs()
        prefs.show()
    
    def log(msg):
        #save the user to add another dependency here: python-osso 
        if maemo:
            cmd = "dbus-send --session --print-reply --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \"string:Aaaa! %s\"&" %msg
        else:
            cmd ="echo ERROR %s" %msg
            traceback.print_exc(file=sys.stdout)
        os.system(cmd)
    
    log = staticmethod(log)
    
    def info(msg):
        #save the user to add another dependency here: python-osso 
        if maemo:
            cmd = "dbus-send --session --print-reply --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \"string:%s\"&" %msg
        else:
            cmd ="echo [INFO] %s" %msg
        os.system(cmd)
    
    info = staticmethod(info)
    
    def setGtkTheme(themeName):
        paths = YCfg.GTK_THEMES_PATHS
        for path in paths:
            rc = path+os.path.sep+themeName+os.path.sep+"gtk-2.0"+os.path.sep+"gtkrc"
            if os.path.isfile(rc):
                gtk.rc_set_default_files([rc])
                rcCrt = gtk.settings_get_default()
                gtk.rc_reparse_all_for_settings(rcCrt,True)
                return
    
    setGtkTheme = staticmethod(setGtkTheme)