import gtk, gobject, pango
from yentry import YEntry
from ystorage import YStorage

class YCellRenderer(gtk.GenericCellRenderer):
    PIXBUF_STAR = None
    PIXBUF_STAR_W = 17
    PIXBUF_PREV = None
    PIXBUF_NEXT = None
    DETAILS_X = 70
    ANIM = ["-","\\","|","/","-","\\","|","/"]
    __gproperties__ = {
        'obj': (gobject.TYPE_PYOBJECT, 'obj', 'xxyyzz', gobject.PARAM_READWRITE),
    }
    
    def __init__(self):
        gtk.GenericCellRenderer.__init__(self)
        if YCellRenderer.PIXBUF_STAR == None:
            YCellRenderer.PIXBUF_STAR = YStorage.loadPixbuf("myt-star.png", -1, -1)
        if YCellRenderer.PIXBUF_PREV == None:
            YCellRenderer.PIXBUF_PREV = YStorage.loadPixbuf("myt-left.png", -1, -1)
            YCellRenderer.PIXBUF_NEXT = YStorage.loadPixbuf("myt-right.png", -1, -1)

    def on_get_size(self, widget, cell):
        #print self.props.obj.thumbpix.get_height()
        return 0, 0, -1, self.props.ypad +  self.props.obj.thumbpix.get_height()

    def do_get_property(self, property):
        return getattr(self, '_YCellRenderer__' + property.name)

    def do_set_property(self, property, value):
        setattr(self, '_YCellRenderer__' + property.name, value)

    def set_states(self, states):
        self.__states = states

    def on_render(self, window, widget, bg_area, cell, expose, flags):
        e = expose

        xpad = self.props.xpad
        xalign = self.props.xalign
        ypad = self.props.ypad
        yalign = self.props.yalign
        obj = self.props.obj
        percent = obj.percentDl
        
        CACHE_WIDTH = 720
        CACHE_H = 65
        
        try:
            #some exception happens here while changing pages. i'm a python n00b therefore i'm allowed to fix
            #it like this
            picW = obj.thumbW
        except:
            print "exception here1"
            return
        
        x1 = 1+picW
        
        if obj.imgCache == None:
            #print "create %d" %cell.height
            #ugly way to fix something that you are lazy to learn: height is someting < 50% of the actual heigh
            if cell.height < 60:
                return 
            #bgcolor = '#FFFFFF'; #widget.get_style().bg_gc[gtk.CELL_RENDERER_SELECTED]#.to_string()#'#FFFFFF'
            #TODO: width is set tup 720
            obj.imgCache = gtk.gdk.Pixmap(window, CACHE_WIDTH, CACHE_H, -1)
            #cmap = obj.imgCache.get_colormap()
            #fgcolor = cmap.alloc_color(bgcolor)
            #obj.bg_gc = obj.imgCache.new_gc()
            #obj.bg_gc.set_foreground(fgcolor)
            #obj.bg_gc.set_fill(gtk.gdk.SOLID)
            obj.bg_gc = widget.get_style().bg_gc[gtk.STATE_NORMAL]
            obj.fg_gc = widget.get_style().fg_gc[gtk.STATE_NORMAL]
            #obj.bg_gc = widget.get_style().bg_gc[gtk.STATE_SELECTED]
            # Fill the background        
            obj.imgCache.draw_rectangle(obj.bg_gc, True, 0, 0, CACHE_WIDTH, CACHE_H)
        
        if ((flags & gtk.CELL_RENDERER_SELECTED) > 0) != obj.rendererSelected:
            if ((flags & gtk.CELL_RENDERER_SELECTED) > 0):
                obj.bg_gc = widget.get_style().bg_gc[gtk.STATE_SELECTED]
                obj.fg_gc = widget.get_style().fg_gc[gtk.STATE_SELECTED]
            else:
                obj.bg_gc = widget.get_style().bg_gc[gtk.STATE_NORMAL]
                obj.fg_gc = widget.get_style().fg_gc[gtk.STATE_NORMAL]
            obj.dirty = True
        
        #window.begin_paint_rect((cell.x, cell.y, cell.width, cell.height))
        #render stars
        if obj.dirty:
            #print "dirty me !"
            # Fill the background        
            obj.imgCache.draw_rectangle(obj.bg_gc, True, 0, 0, CACHE_WIDTH, CACHE_H)
            #draw rating stars
            obj.imgCache.draw_pixbuf(None,YCellRenderer.PIXBUF_STAR,
                          round(5-obj.rating)*17, 0,
                          xpad*xalign+x1, ypad * yalign + 15,
                          YCellRenderer.PIXBUF_STAR_W*5, -1,
                          gtk.gdk.RGB_DITHER_NONE,
                          0, 0)
        
            #set title
            context = widget.get_pango_context()
            layout = pango.Layout(context)
            layout.set_text(obj.title)
            layout.set_font_description(pango.FontDescription("Sans 11"))
            #gc = window.new_gc()
            obj.imgCache.draw_layout(obj.fg_gc, 
                                    xpad*xalign + picW+2,
                                    ypad * yalign, layout)
                                    
            
            layout.set_text("[%s]" %YEntry.formatDuration(obj.duration))
            if (int(percent) == 100):
                if obj.downloadedKb < 1024:
                    layout.set_text("%s [%dKB]" %(layout.get_text(), obj.downloadedKb))
                else:
                    layout.set_text("%s [%.1fMB]" %(layout.get_text(), float(obj.downloadedKb)/1024))
            elif (percent > 0):
                layout.set_text(layout.get_text() +" ["+str(percent)+"%]")
            elif obj.dispAnim >= 0:
                layout.set_text(layout.get_text() +" ["+YCellRenderer.ANIM[obj.dispAnim]+"]")
            #layout.set_width(cell.width)
            layout.set_font_description(pango.FontDescription("Sans Bold 10"))
            obj.imgCache.draw_layout(obj.fg_gc, xpad*xalign + picW+2, 
                                    cell.height-20, layout)
            #draw entry thumb
            obj.imgCache.draw_pixbuf(None, obj.thumbpix,
                               0, 0,
                               xpad*xalign, ypad * yalign,
                               -1, -1,
                               gtk.gdk.RGB_DITHER_NONE,
                               0, 0)
            obj.dirty = False
        
        #draw img buffer                           
        window.draw_drawable(widget.get_style().fg_gc[gtk.STATE_NORMAL], 
                            obj.imgCache, 
                            0, 0, cell.x, cell.y , cell.width, cell.height)
        #
        if (flags & gtk.CELL_RENDERER_SELECTED):
            obj.rendererSelected = True
            #draw the arrow if expanded
            if bg_area.width > 400:
                window.draw_pixbuf(None, YCellRenderer.PIXBUF_NEXT,
                                   0, 0,
                                   cell.x + xpad*xalign+bg_area.width - YCellRenderer.DETAILS_X, cell.y + ypad * yalign + 17,
                                   -1, -1, gtk.gdk.RGB_DITHER_NONE, 0, 0)
        else:
            obj.rendererSelected = False
        #window.end_paint()