#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#import gnome.gconf
from ConfigParser import *
import sys
import os
import gtk

try:
  import hildon
except ImportError:
  hildon = None
  IS_MAEMO = False

import gobject
import mnotes_framework

class mPrefs:

  _glade_files = ['/usr/lib/mnotes/ui/mprefs.glade',]

  def __init__(self):
    print 'init pref'
    self._isFullScreen = False
    default = {
            'override_theme':'True',
            'google_login':'login',
            'google_password':'password',            
            'google_autosync':'True',
            'google_autosync_interval':'240',
            'autosync_alarm_id':'0',
            }
    self._prefs = ConfigParser(default)
    try:
      self._load_pref_file()
    except:
      pass

  def _load_pref_file(self):
    self._prefs.read('/home/user/.mPIM/mnotes.prefs')

  def _save_pref_file(self):
    fp = open('/home/user/.mPIM/mnotes.prefs','w')
    self._prefs.write(fp)
    fp.close()

  def set_value(self,key,value):
    self._prefs.set('DEFAULT',key,value)

  def set_boolean_value(self,key,b):
    if b == True:
      value = 'True'
    else:
      value = 'False'
    self._prefs.set('DEFAULT',key,value)

  def get_value(self,key):
    return self._prefs.get('DEFAULT', key)

  def get_int_value(self,key):
    return int(self._prefs.get('DEFAULT', key))

  def get_boolean_value(self,key):
    return self._prefs.get('DEFAULT', key)=='True'

  def show_ui(self):
    print 'show prefs ui'
    global hildon

    self._callbackList = None

    for path in mPrefs._glade_files:
      if os.path.isfile(path):
        self._widgetTree = gtk.glade.XML(path)
        break
    else:
      return

    self._window = self._widgetTree.get_widget("Prefs")

    self._app = None
    self._isFullScreen = False
    if hildon is not None and self._window is gtk.Window:
      warnings.warn("Hildon installed but glade file not updated to work with hildon", UserWarning, 2)
      hildon = None
    elif hildon is not None:
      self._app = hildon.Program()
      self._window = hildon.Window()
      self._window.set_border_width(0)
      self._widgetTree.get_widget("VBox").reparent(self._window)
      self._app.add_window(self._window)

      self._window.connect("key-press-event", self._on_key_press)
      self._window.connect("window-state-event", self._on_window_state_change)
    else:
      warnings.warn("No Hildon", UserWarning, 2)

    self._window.set_title("mCalendar - Prefs")

    callbackMapping = {
      # EventsList Signal
      "on_validate_clicked": self._save_prefs,
      "on_cancel_clicked": self._cancel_prefs,
      }
    self._widgetTree.signal_autoconnect(callbackMapping)

    self._children_color_bg(self._window)
    self._load_value()
    self._window.show_all()

  def _children_color_bg(self,widget):
    if (type(widget)!=gtk.Image) and (type(widget)!=gtk.Label) and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView) and (type(widget)!=gtk.Calendar):
      widget.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
      widget.modify_bg(gtk.STATE_INSENSITIVE,gtk.gdk.Color(60000,60000,60000))
      for child in widget.get_children():
        self._children_color_bg(child)

  def _save_prefs(self,widget):
    self._save_value()
    self._save_pref_file()
    self._window.hide()

  def _cancel_prefs(self,widget):
    self._load_pref_file()
    self._window.hide()

  def _on_key_press(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.keyval == gtk.keysyms.F6:
      if self._isFullScreen:
        self._window.unfullscreen()
      else: 
        self._window.fullscreen()

  def _on_window_state_change(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
      self._isFullScreen = True
    else:
      self._isFullScreen = False

  def _load_value(self):
    #gtk entry
    e_google_login = self._widgetTree.get_widget("e_google_login")
    e_google_password = self._widgetTree.get_widget("e_google_password")
    e_autosync_delay = self._widgetTree.get_widget("e_autosync_delay")
    #assign entry value
    e_google_login.set_text(self.get_value('google_login'))
    e_google_password.set_text(self.get_value('google_password'))
    e_autosync_delay.set_text(self.get_value('google_autosync_interval'))    

    #gtk checkbox
    bp_override = self._widgetTree.get_widget("bp_override")
    bp_autosync = self._widgetTree.get_widget("bp_autosync")

    #assign checkbox
    bp_override.set_active(self.get_boolean_value('override_theme'))
    bp_autosync.set_active(self.get_boolean_value('google_autosync'))

  def _save_value(self):
    #gtk entry
    e_google_login = self._widgetTree.get_widget("e_google_login")
    e_google_password = self._widgetTree.get_widget("e_google_password")
    e_autosync_delay = self._widgetTree.get_widget("e_autosync_delay")

    #assign entry value
    self.set_value('google_login',e_google_login.get_text())
    self.set_value('google_password',e_google_password.get_text())
    self.set_value('google_autosync_interval',e_autosync_delay.get_text())   

    #gtk checkbox
    bp_override = self._widgetTree.get_widget("bp_override")
    bp_autosync = self._widgetTree.get_widget("bp_autosync")

    #assign checkbox
    self.set_boolean_value('override_theme',bp_override.get_active())   
    self.set_boolean_value('google_autosync',bp_autosync.get_active())   

  def warn(self,message):
    dialog = gtk.MessageDialog(gtk.Window(),
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_ERROR,
                    gtk.BUTTONS_OK,
                    message)
    rc = dialog.run ()
    dialog.destroy ()