#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import time
import uuid
import commands
import sqlite3
import pango

DB_FORMAT = '%Y-%m-%d'
FRAMEWORK_VERSION = '0.1.1' 
DB_PATH = '/home/user/.mPIM/mnotes.db'

class Database:
        def __init__(self,path=None):
          self.db = None
          self.cursor = None
          if path != None:
            self.path = path
          else:
            self.path = '/home/user/.mPIM/mnotes.db'
          try:
            self.db = sqlite3.connect(self.path)
            self.cursor = self.db.cursor()
            
          except:
            print 'Database doesn t exist'
            self._create()
            
          self._update()

        def _create(self):
          #Try to create the folder in case of
          commands.getoutput("mkdir /home/user/.mPIM/")
          self.db = sqlite3.connect(self.path)
          self.cursor = self.db.cursor()
          self.cursor.execute('CREATE TABLE notes (uuid TEXT PRIMARY KEY, title DATETIME, description TEXT)')
          self.db.commit()
          self.cursor.execute('CREATE TABLE db_struct (version TEXT);')
          self.db.commit()
          self.cursor.execute('INSERT INTO db_struct (version) VALUES ("'+FRAMEWORK_VERSION+'");')
          self.db.commit()

        def _update(self):
          self.cursor.execute('SELECT version From db_struct;')
          for version in self.cursor.fetchall():
            v = version
            
          version = v[0]
          print version
          if version < '0.1.0':
            self._create()
          if version < '0.1.1':
            self.cursor.execute('CREATE TABLE prefs (uuid TEXT PRIMARY KEY, value DATETIME)')
            self.db.commit()
          if version != FRAMEWORK_VERSION:
            self.cursor.execute('UPDATE db_struct set version=?',[FRAMEWORK_VERSION,])
            self.db.commit()

        def close(self):
          self.db.close()

class mPrefs:
       def __init__(self):
           self.hpane_position = None
           self.load_from_db()
         
       def load_from_db(self):
           db = Database(DB_PATH)
           db.cursor.execute('SELECT uuid, value FROM prefs')
           for prefs in db.cursor.fetchall():
             if (prefs[0]=='hpane_position'):
               self.hpane_position=int(prefs[1])
           db.close()

           print self.hpane_position
           if self.hpane_position==None:
             self.save_to_db()
             
       def save_to_db(self):
           db = Database(DB_PATH)
           if self.hpane_position==None:
             self.hpane_position=150
             db.cursor.execute('INSERT INTO prefs (uuid , value) VALUES (?,?);',['hpane_position',150])
             db.db.commit()
           else:
             db.cursor.execute('UPDATE prefs SET value=? WHERE uuid=?;',[self.hpane_position,'hpane_position'])
             db.db.commit()
           db.close()

class Note:
        """This class represents one note"""

        def __init__(self,suuid='',default_title='Untitled'):

            self.title = default_title
            self.description = default_title

            if suuid=='':
              self.uuid = uuid.uuid4().__str__()
              self.new = True
            else:
              self.uuid = suuid
              self.load_from_db(self.uuid)
              self.new = False

        def load_from_db(self,suuid):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT title, description FROM notes where uuid="'+suuid+'"')
            for note in db.cursor.fetchall():
              self.description = note[1]
              self.title = note[0]
              self.new = False
            db.close()

        def save_to_db(self):
            self.title = self.description.split('\n')[0]
            db = Database(DB_PATH)
            if self.new==True:
              db.cursor.execute('INSERT INTO notes (uuid , title, description ) VALUES(?,?,?);',[self.uuid,self.title,self.description])
              db.db.commit()
            else:
              db.cursor.execute('UPDATE notes SET title=?, description=? WHERE uuid=?;',[self.title,self.description,self.uuid])
              db.db.commit()
            db.close()

        def get_bg_color(self):
          return '#FFFFFF'

        def get_fg_color(self):
          return "#000000"

        def get_style(self):
          return pango.STYLE_NORMAL

        def delete_from_db(self):
            db = Database(DB_PATH)
            db.cursor.execute('DELETE FROM notes WHERE uuid ="'+self.uuid + '";')
            db.db.commit()
            db.close()

class NotesList:
        def __init__(self):
            self.notes_list = []

        def clear(self):
            self.notes_list = []

        def get_all_notes(self):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM notes  '
            where = ''
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              note = Note(uuid[0])
              self.notes_list.append((note.title,note.uuid))
            db.close()

            return self.notes_list
            
        def get_notes_with_text(self,text):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM notes  '
            where = ' WHERE description LIKE "%' +text+ '%"'
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              note = Note(uuid[0])
              self.notes_list.append((note.title,note.uuid))
            db.close()
            print 'search results'
            print self.notes_list

            return self.notes_list
