#! /bin/bash

# Helper script for building deb packages for MediaBox extensions.
# (c) 2008 Martin Grimme  <martin.grimme@lintegra.de>

NAME_PREFIX="mediabox"

BUILD_HOME=`dirname $0`
DEBIAN_DIR=${BUILD_HOME}/debian
DATA_DIR=${BUILD_HOME}/data
CONFIG=${BUILD_HOME}/configuration.properties

. ${CONFIG}


# escape characters in a string so that it can be safely used in sed
escape_chars() {

  echo $1 | sed -e "s/\//\\\\\//g" \
                -e "s/\&/\\&/g"

}


EXTENSION_NAME=${NAME_PREFIX}-${NAME}


#
# write debian/changelog
#
echo "writing debian/changelog ..."
CURRENT_TIME=`LANG=C date +"%a, %d %b %Y %T %z"`
mv ${DEBIAN_DIR}/changelog ${DEBIAN_DIR}/changelog.orig

cat >${DEBIAN_DIR}/changelog <<END_OF_INLINE
${NAME_PREFIX}-${NAME} (${VERSION}) unstable; urgency=low

  No changelog recorded

 -- ${MAINTAINER} <${EMAIL}>  ${CURRENT_TIME}
 
END_OF_INLINE

cat ${DEBIAN_DIR}/changelog.orig >>${DEBIAN_DIR}/changelog
rm ${DEBIAN_DIR}/changelog.orig


#
# write debian/control
#
echo "writing debian/control ..."
MAEMO_ICON=`python2.5 -c "import base64; print base64.encodestring(open('${ICON}').read()).replace('\n', '')"`
MAEMO_ICON=`escape_chars "${MAEMO_ICON}"`
DESCRIPTION=`escape_chars "${DESCRIPTION}"`

cat ${DEBIAN_DIR}/control.in \
    | sed -e "s/@EXTENSION_NAME@/${EXTENSION_NAME}/g" \
          -e "s/@MAINTAINER@/${MAINTAINER}/g" \
          -e "s/@EMAIL@/${EMAIL}/g" \
          -e "s/@DEPENDENCIES@/${DEPENDENCIES}/g" \
          -e "s/@DESCRIPTION@/${DESCRIPTION}/g" \
          -e "s/@MAEMO_ICON@/${MAEMO_ICON}/g" \
    >${DEBIAN_DIR}/control


#
# write debian/copyright
#
echo "writing debian/copyright ..."
cat >${DEBIAN_DIR}/copyright <<END_OF_INLINE
Copyright (c) ${MAINTAINER} <${EMAIL}>

This extension for MediaBox is licensed under the terms of the GNU GPL.
END_OF_INLINE


#
# write debian/rules
#
echo "writing debian/rules ..."
cat ${DEBIAN_DIR}/rules.in \
    | sed -e "s/@EXTENSION_NAME@/${EXTENSION_NAME}/g" \
    >${DEBIAN_DIR}/rules


#
# build package
#
echo "building package ..."
dpkg-buildpackage -rfakeroot -sa

