/**********************************************************************************
 *	copyright (C) 2006, Dariusz Wiechecki
 *	dariusz.wiechecki@gmail.com
 *	14 August 2006, Lodz, Poland
 **********************************************************************************
 *		This file is part of str-vfs-test.
 *
 *	str-vfs-test is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	str-vfs-test is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with str-vfs-test; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *********************************************************************************/
#include <gmodule.h>
#include <stdio.h>
#include <unistd.h>
#include <dictionary_engine.h>


getting_additional get_functions; // additinal functions for concrete module (e.g. XDXF)

void print_list(GArray* list, gchar* pattern, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,pattern);
	int i = 0;
	while(g_array_index(list, gchar*, i) != NULL) 
	{
		printf("  %d. : %s\n",i+1,g_array_index(list, gchar*, i));
		i++;
	}

}

void print_translation(gchar* translation, gchar* word, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,word);
	printf("%s\n\nTRANSLATION ENDS.\n",translation);
}

void caching_progress(gdouble value, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,value);
}

int main(int argc, char** argv) 
{
	char* nameApp = "mdictionary: ";
	printf("%sStarting test program of module: dictionary_engine.\n",nameApp);
	
	gchar* current_directory = g_get_current_dir();
	printf("%sCurrent directory: %s\n",nameApp,current_directory);
	gchar* library_to_path = g_strconcat(current_directory, "/src/engine_xdxf.so", NULL);
	printf("%sEngine library should be in location:\n\t%s\n",nameApp,library_to_path);
	
	GModule *library = g_module_open(library_to_path, G_MODULE_BIND_LAZY);
	g_module_symbol (library, "engine_global_functions", (gpointer)&get_functions);
	

	if(get_functions == NULL) {
		printf("%sLoading function failed\n",nameApp);
		return 1;
	}
	else printf("%sLoading function OK\n",nameApp);
	

	EngineModule module = get_functions();
	Engine* xdxf;

        gboolean is_compatible = dict_eng_module_check(module,"/home/lukasz/MyDocs/idioms_eng_eng");
	if(is_compatible == TRUE)
	{
		printf("Location is compatible with enigne!\n");
	}
	else {
		printf("Location is not compatible with enigne!\n");
		return 1;
	}

	//printf("%sCheck OK. Module description: %s\n", nameApp, dict_eng_module_get_description(module));

	//xdxf = dict_eng_module_create_ext(module, "/home/lukasz/MyDocs/repo/mdictionary/trunk/engine/bin" , ENGINE_CREATE, caching_progress, "Current progress of caching is: %0.2f.\n", 0.03 );
	//home/stranger/mdictionary/engine0.2/
//	xdxf = dict_eng_module_create(module, "/home/stranger/mdictionary/engine0.2/" , ENGINE_NO);
//	dict_eng_set_callback(xdxf, ENGINE_PROGRESS_CACHING, caching_progress, "Current progress of caching is: %0.2f.\n");
//	dict_eng_set_progress_seed(xdxf, ENGINE_PROGRESS_CACHING, 0.02);

/*	if(dict_eng_is_optimized(xdxf) == FALSE)
	{
		printf("Dictionary has no cache!\nCreating cache file....\n");
		dict_eng_optimize(xdxf);
	}
	else {
		printf("Dictionary has already cache file!\n");
	}*/
        xdxf = dict_eng_module_create(module, "/home/lukasz/MyDocs/idioms_eng_eng" , ENGINE_CREATE);
	dict_eng_set_callback(xdxf, ENGINE_WORD_LIST_SIGNAL , print_list, "Wort list matches to pattern: %s\n");
	dict_eng_set_callback(xdxf, ENGINE_WORD_TRANSLATION_SIGNAL , print_translation, "Translation for word\'%s\':\n");
	
	dict_eng_search_word_list(xdxf,"z");
	dict_eng_search_word_translation(xdxf,"zone defense");
	//dict_eng_search_word_list(xdxf,"A");	
	
	dict_eng_destroy(xdxf);
	g_free(current_directory);
	g_free(library_to_path);
	printf("%sClosed.\n",nameApp);
	return 0;
}

