/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
#include <gmodule.h>
#include <stdio.h>
#include <unistd.h>
#include <dictionary_engine.h>

#define DICT_PATH0 "/home/str/mdictionary/stardictDicts/stardict-comn_dictd03_slovnyk_pl-ru-2.4.2"
#define DICT_PATH1 "/home/str/mdictionary/stardictDicts/stardict-comn_dictd03_slovnyk_pl-en-2.4.2"
#define DICT_PATH2 "/home/str/mdictionary/stardictDicts/stardict-dictd_www.dict.org_foldoc-2.4.2"
#define DICT_PATH3 "/home/str/mdictionary/stardictDicts/stardict-dictd_www.freedict.de_eng-fra-2.4.2"
#define DICT_PATH4 "/home/gandzia/MyDocs/.documents/stardict-comn_dictd03_engcom-2.4.2"
#define DICT_PATH5 "/home/lukasz/MyDocs/stardict-foldoc"
#define DICT_PATH6


#define DICT_PATH DICT_PATH5

gchar* dictionaries[] = {
	DICT_PATH0,
	DICT_PATH1,
	DICT_PATH2,
	DICT_PATH3,
	NULL
};

getting_additional get_functions; // additional functions for concrete module (e.g. XDXF)

void print_list(GArray* list, gchar* pattern, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,pattern);
	int i = 0;
	while(g_array_index(list, gchar*, i) != NULL) 
	{
		printf("  %d. : %s\n",i+1,g_array_index(list, gchar*, i));
		i++;
	}

}

void print_translation(gchar* translation, gchar* word, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,word);
	printf("%s\n\nTRANSLATION ENDS.\n",translation);
}

void caching_progress(gdouble value, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,value);
}

int main(int argc, char** argv) 
{
	char* nameApp = "StarDictEngine test: ";
	printf("%sStarting test program of module: dictionary_engine - StarDict\n",nameApp);

	
	gchar* current_directory = g_get_current_dir();
	printf("%sCurrent directory: %s\n",nameApp,current_directory);
	gchar* library_to_path = g_strconcat(current_directory, "/bin/engine_stardict.so", NULL);
	printf("%sEngine library should be in location:\n\t%s\n",nameApp,library_to_path);
	
	GModule *library = g_module_open(library_to_path, G_MODULE_BIND_LAZY);
	if(!library)
	{
		printf("%sLoading module failed. \nReason: %s\n",nameApp,g_module_error());
		return 1;		
	};
	
	g_module_symbol ( (library),_GLOBAL_FUNCTIONS_NAME_, (gpointer)&get_functions);
	if(get_functions == NULL)
	{
		printf("%sLoading function failed\n",nameApp);
		return 2;
	}
	else 
	{
		printf("%sLoading function OK\n",nameApp);
	}

	EngineModule module = get_functions();
	printf("Module description: %s\n",dict_eng_module_get_description(module));
	Engine* sd;
	
        gboolean is_compatible = dict_eng_module_check(module, DICT_PATH);
	if(is_compatible == TRUE)
	{
		printf("Location is compatible with enigne!\n");
	}
	else {
		printf("Location is not compatible with enigne!\n");
		return 1;
	}
	

	sd = dict_eng_module_create(module, DICT_PATH, ENGINE_NO);
	printf("Searching in dictionary: \'%s\'\n",dict_eng_get_title(sd));
	dict_eng_set_callback(sd,
			      ENGINE_WORD_LIST_SIGNAL,
			      print_list,
			      "Word list matches to pattern: %s\n"
			     );
	dict_eng_set_callback(sd,
			ENGINE_WORD_TRANSLATION_SIGNAL ,
			print_translation,
			"Translation for word\'%s\':\n"
			);

	dict_eng_search_word_list(sd,"a");
	dict_eng_search_word_list(sd,"z");
	dict_eng_search_word_translation(sd,"deb");
	dict_eng_search_word_translation(sd,"abort");
	
	
	dict_eng_destroy(sd);
	printf("%sClosed.\n",nameApp);	
	return 0;
}

