/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager */
/*@{*/
/** \file ws_mng_dictionary_utils.c
 * \brief Dictionaries common routines - code.
 */

#include <ws_mng_dictionary_utils.h>

/**
 * \param error after excuting it contains error messages if any was
 * \param param parameters given by D-Bus
 * \param app_data manager data
 */
void ws_mng_extract_dictionary( GError *error,
                                GArray* param,
                                gpointer user_data )
{
	g_debug("->%s", __FUNCTION__);
	WSMngSearchData *data = (WSMngSearchData *) user_data;
	osso_rpc_t *osso_data;

	/* get the data sended by dbus */
	osso_data = &g_array_index (param, osso_rpc_t, 0); 
	gchar* path = g_strdup(osso_data->value.s);
	gint result = -1;
	
	gchar* dest = NULL;
	if (path != NULL)
	{
		gint count = 0;
		gchar** tmp = g_strsplit(path, "/", 0);
		while(tmp[count] != NULL)
		{
			++count;
			
		}
		
		//1 is file name position in tmp array
		dest = g_strndup(path, g_strlen(path)- g_strlen(tmp[count -1]));
		g_strfreev(tmp);
	};
	
	if (dest != NULL)
	{
		ws_dbus_notify(data->dbus_data, WS_DBUS_EXTRACT_FILE);
		result = decompress_file(path, &dest);
		ws_dbus_notify(data->dbus_data, WS_DBUS_EXTRACT_FILE_FINISHED);
	};
	
	if (result > 0)
	{
		ws_dbus_server_return_extracted_dict(data->dbus_data, dest);
	}
	else
	{
		dest = "";
		ws_dbus_server_return_extracted_dict(data->dbus_data, dest);
	}

	g_free(path);
	path = NULL;
	g_debug("<-%s", __FUNCTION__);
}


/**
 * Function used to load dictionaries engines
 * \param dict_directory path to dictionaries 
 * \param data structure which contains all data of program
 */
void ws_mng_load_dict(GArray* dict_directory, WSMngSearchData* data)
{
	gint i = 0;
	gint j = 0;
	Engine* xdxf = NULL;
	g_debug("->%s", __FUNCTION__);
	EngineOptimizationFlag flag = ENGINE_NO;
	gchar* current_directory = NULL;

	for (i =0; i<dict_directory->len; i++)
	{
		current_directory = strdup(g_array_index( dict_directory,
		                                          gchar*,
		                                          i ));
		flag = ENGINE_NO;
		for (j=0; j<data->modules->len; j++)
		{
			if (dict_eng_module_check( g_array_index( data->modules,
			                                          EngineModule,
			                                          j),
			                           current_directory ) == TRUE)
			{
				/* set correct flag for engine */
				if(ws_mng_if_optimized(current_directory))
				{
					flag = ENGINE_CREATE;
				}

				/* create engine with correct flag */
				xdxf = dict_eng_module_create_ext(
				                   g_array_index( data->modules,
				                                  EngineModule,
				                                  j ),
				                   current_directory,
				                   flag,
				                   ws_mng_progress_bar,
				                   data,
				                   0.02 );

				/*set callbacks functions */
				dict_eng_set_callback( xdxf,
				                       ENGINE_WORD_LIST_SIGNAL,
				                       ws_mng_on_found_word,
				                       data );

				dict_eng_set_callback( xdxf,
				               ENGINE_WORD_TRANSLATION_SIGNAL,
				               ws_mng_on_found_translation,
				               data );

				/* adding newly created engine to Garray */
				g_array_append_val (data->dict, xdxf);

				g_free(current_directory);
				current_directory = NULL;
				xdxf = NULL;

				/* do not check next module - move directly to 
				 * next dictionary */
				break;
			}
                }
        }
        g_debug("<-%s", __FUNCTION__);
}

/*@}*/
