/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager
 */
/*@{*/

/** \file whitestork.c
 * \brief Entry point for mDictionary Manager module.
 *
 * \author Łukasz Pawlik \<lukasz.pawlik\@comarch.com\>
 * \see Manager
 */

#include <ws_manager.h>

/** \brief Entry point for manager proccess.
 *
 * Create and initialize all data needed for manager to work and start main loop
 * for its proccess.
 *
 */
int main (gint argc, gchar** argv)
{
	/* initialize GType and GObject's functions capabilities for proccess */
	g_type_init();

	WSMngSearchData* search_data = ws_manager_create();

	ws_mng_init_dbus(search_data);

	ws_mng_init(search_data);

	ws_mng_start_main_loop(search_data);

	ws_mng_close(search_data);

	return 0;
}

/*@}*/
