/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager
 */
/*@{*/
/** \file ws_mng_threads_utils.h
 * \brief Thread utilities - header.
 */
#ifndef _WS_MANAGER_THREADS_UTILS
#define _WS_MANAGER_THREADS_UTILS

#include <ws_manager.h>

#ifdef __cplusplus
extern "C" {
#endif

/** \name Thread utilities */
/*@{*/

/** \brief Structure holding all data for each thread to properly run.
 *
 * Each thread gets one instance of this strucutre in which are information 
 * about what to do and with what. This make it possible to run simultaneously
 * few thread - they will not interrput each other.
 */
struct _WSMngSearchAtom {
	WSMngSearchData *data;
	/**< pointer to global data holding by manager */
	gchar           *word;
	/**< word to search by this thread */
	GThread         *thread;
	/**< pointer to thread handler */
	GArray          *word_list;
	/**< GArray in which owner thread will keep words list -
	 * if is searching for words list */
	gchar           *trans;
	/**< buffer in which owner thread will keep word's translation -
	 * if is searching for word's translation */
};

/** \brief Structure holding all data for each thread to properly run.
 * \sa _WSMngSearchAtom
 */
typedef struct _WSMngSearchAtom WSMngSearchAtom;

/* functions for critical sections and thread handling  */
/** \brief Try to lock mutex and tell if it was locked before.
 */
gboolean         try_lock_was_locked(WSMngSearchData* data, gchar* fun);

/** \brief Tell if given mutex is locked.
 */
gboolean         is_rec_locked(GStaticRecMutex* m);

/** \brief Check if current thread should be terminated.
 */
void             stop_if_needed(WSMngSearchAtom* data);

/** \brief Clear memmory after not neede anymore WSMngSearchAtom structure.
 */
void             free_search_atom(WSMngSearchAtom* data);

/** \brief Create new WSMngSearchAtom structure.
 */
WSMngSearchAtom *create_search_atom(WSMngSearchData* app_data, gchar* word);

/*@}*/

#ifdef __cplusplus
}
#endif
#endif

/*@}*/
