/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager
 */
/*@{*/
/** \file ws_mng_searching_threads.h
 * \brief Thread generation and thread functions - header.
 */
#ifndef _WS_MANAGER_SEARCHING_THREADS
#define _WS_MANAGER_SEARCHING_THREADS

#include <ws_mng_threads_utils.h>
#include <dictionary_engine.h>
#include <ws_manager.h>

#ifdef __cplusplus
extern "C" {
#endif

/** \name Thread common routines. */
/*@{*/

/** \brief Function executed by thread - search for word list
 */
gpointer     ws_mng_search_word          (gpointer search_data);

/** \brief Used to return results of found words from threads 
 */
void         ws_mng_on_found_word        (GArray* list,
                                          gchar* pattern,
                                          gpointer user_data,
                                          EngineStatus error);

/** \brief Function executed by thread - search for particular word
 */
gpointer     ws_mng_search_translation   (gpointer search_data);

/** \brief Used to return results of transaltion from threads
 */
void         ws_mng_on_found_translation (gchar* translation,
                                          gchar* pattern,
                                          gpointer user_data,
                                          EngineStatus error);

/** \brief Function used to compare string. Used in sorting GArray object
 */
gint         ws_mng_compare_strings (gconstpointer a, gconstpointer b);

/** \brief Removes repeating words on the returned words list.
 */
void         ws_remove_multiple_words(WSMngSearchAtom* user_data);

/*@}*/

#ifdef __cplusplus
}
#endif
#endif
/*@}*/
