/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager
 */
/*@{*/
/** \file ws_mng_gconf_utils.h
 * \brief Utilities connected with GConf configuration - header.
 */
#ifndef _WS_MANAGER_GCONF_UTILS
#define _WS_MANAGER_GCONF_UTILS

#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <ws_manager.h>

#ifdef __cplusplus
extern "C" {
#endif

/** \name GConf configuration routines.
 */
/*@{*/

/** \brief GConf path to dictionaries locations.
 */
#define GCONF_KEY       "/apps/maemo/mdictionary/dictionaries"

/** \brief  GConf path to dictionary engines locations.
 */
#define GCONF_LIB_PATH  "/apps/maemo/mdictionary/engines"

/** \brief Function used to get the dictionaries location read fron GConf.
 */
GArray* ws_mng_read_gconf();

/** \brief Function used to get plugins location read from GConf
 */
GArray* ws_mng_get_engines_location();


/** \brief Function used to get bookmark library location
 */
gchar* ws_mng_get_boomark_location();


/** \brief Function used to check if optimized flag in GConf is set
 */
gboolean ws_mng_if_optimized(gchar* dict);

/*@}*/

#ifdef __cplusplus
}
#endif
#endif
/*@}*/
