/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager */
/*@{*/
/** \file ws_mng_dictionary_utils.h
 * \brief  Dictionaries common routines - header.
 */
#ifndef _WS_MANAGER_DICTIONARY_UTILS
#define _WS_MANAGER_DICTIONARY_UTILS

#include <ws_mng_gconf_utils.h>
#include <dictionary_engine.h>
#include <ws_mng_callbacks.h>
#include <ws_manager.h>
#include <untar.h>


#ifdef __cplusplus
extern "C" {
#endif

/** \name Dictionaries routines */
/*@{*/

/** \brief Extracting compressed dictionary file
 */
void ws_mng_extract_dictionary(GError *error, GArray* param, gpointer app_data);

/** \brief Function used to load dictionaries engines
 */
void ws_mng_load_dict(GArray* dict_directory, WSMngSearchData* data);

/*@}*/

#ifdef __cplusplus
}
#endif
#endif

/*@}*/
