/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager */
/*@{*/
/** \file ws_mng_callbacks.h
 * \brief Callback functions called by other modules - header.
 */
#ifndef _WS_MANAGER_CALLBACKS
#define _WS_MANAGER_CALLBACKS

#include <ws_mng_searching_threads.h>
#include <ws_mng_dictionary_utils.h>
#include <ws_mng_threads_utils.h>
#include <ws_mng_gconf_utils.h>
#include <ws_manager.h>

#ifdef __cplusplus
extern "C" {
#endif

/** \name Callback function called by other modules (GUI and engines).
 */
/*@{*/

/** \brief Function used to send information about progress of caching (engines)
 */
void ws_mng_progress_bar( double progress,
                          gpointer user_data,
                          EngineStatus error );

/** \brief Called when find word event occurs (UI)
 */
void ws_mng_on_search_word( GError *error,
                            GArray *word,
                            gpointer user_data );

/** \brief Called when find translation event occurs (UI)
 */
void ws_mng_on_search_translation( GError *error,
                                   GArray *word,
                                   gpointer user_data );

/** \brief Function used for handling signals sent by user interface (UI)
 */
void ws_mng_signal_handling( GError *error,
                             GArray *signal,
                             gpointer user_data );

/*@}*/
#ifdef __cplusplus
}
#endif
#endif
/*@}*/

