/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager */
/*@{*/
/** \file ws_mng_bookmarks_utils.h
 * \brief Utilities for Manager connected with managing bookmarks - header.
 *
 */

#ifndef _WS_MANAGER_BOOKMARKS
#define _WS_MANAGER_BOOKMARKS

#include <ws_mng_searching_threads.h>
#include <ws_mng_gconf_utils.h>
#include <dictionary_engine.h>
#include <ws_mng_callbacks.h>
#include <ws_manager.h>


#ifdef __cplusplus
	extern "C" {
#endif

/** \name Bookmarks Utils */
/*@{*/

/** \brief Add new word to bookmark dictionary.
 */
void ws_mng_add_bookmark(GError *error, GArray* param, gpointer user_data);

/** \brief Remove specified word from bookmark engine.
 */
void ws_mng_remove_bookmark(GError *error, GArray* param, gpointer user_data);

/** \brief Load bookmarks dictionary engine.
 */
void ws_mng_load_bookmark(WSMngSearchData* data);

/*@}*/

#ifdef __cplusplus
	}
#endif
#endif
/*@{*/
