/*******************************************************************************
This file is part of mDictionary

mDictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mDictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with WhiteStork; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup Manager
 */
/*@{*/
/** \file untar.h
 * \brief Exctracting *.tar.bz2 archives header.
 */
#ifndef _WS_UNTAR
#define _WS_UNTAR

#include <glib.h>
#include <untar.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bzlib.h>
#include <sys/stat.h>

/** \name Handling *.tar.bz2 files routines.
 *
 * Every dictionary downloaded from Internet is compressed with bz2 algorithm.
 * To allow user adding new dictionary downloaded from Internet directly to the
 * device, we need to add exctracting *.tar.bz2 archives support.
 */
/*@{*/

/** \brief Define block size used in the header of archive.
 */
#define BLOCK_SIZE 512

/** \brief Define buffer size for blocks.
 */
#define BUFFER_SIZE BLOCK_SIZE*32

/** \brief Translate number into its ASCI code.
 */
#define ASCII_NR(NR) (NR + 0x30)

/** \brief Structure of entry in tar header.
 *
 * See tar file specyfication for more information.
 */
typedef struct _TarHeader
{
	gchar name[100];
	gchar mode[8];
	gchar uid[8];
	gchar gid[8];
	gchar size[12];
	gchar mtime[12];
	gchar chksum[8];
	gchar typeflag;
	gchar linkname[100];
	gchar magic[6];
	gchar version[2];
	gchar uname[32];
	gchar gname[32];
	gchar devmajor[8];
	gchar devminor[8];
	gchar prefix[155];
	gchar padding[12];
	gchar *gnu_longname;
	gchar *gnu_longlink;
} TarHeader;

/** \brief Enumerate possible entries types in tar file.
 *
 * In mDictionary only File and Dir are supported. This values are used as a 
 * typeflag field in TarHeader structure.
 *
 * See tar file specyfication for more information.
 */
typedef enum _RecordType
{
	File = ASCII_NR (0),
	ARCHLINK = ASCII_NR (1),
	SYMLINK = ASCII_NR (2),
	CHARDEV = ASCII_NR (3),
	BLOCKDEV = ASCII_NR (4),
	Dir = ASCII_NR (5),
	FIFO = ASCII_NR (6),
	RESERVED = ASCII_NR (7)
} RecordType;

/** \brief Uncompress bz2 archive and extract tar file.
 *
 */
gint decompress_file(gchar *in_file, gchar **out_path);

/*@}*/

#endif /*_WS_UNTAR*/
/*@}*/

