/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
/** \addtogroup GUI
 */
/*@{*/
/** \file ws_gui_utils.c
 * \brief File with functions used in GUI.
 *
 * Functions used in GUI like hex conversion etc.
 * \author Marcin Biedron \<marcin.biedron\@comarch.com\>
 * \date 18-01-2008
 * \version 1.0.0
 */

#include <ws_gui_callbacks.h>
#include <ws_gui.h>
#include <ws_gui_layout.h>
#include <ws_gui_utils.h>
#include <ws_dbus.h>

/**
 * Function that checks if given char is hex.
 * \param tchar char that is being checked 
 */
gboolean ws_gui_is_hex ( char tchar )
{
	if (	(( 'a' <= tchar ) && ( tchar <= 'f')) || 
		(( 'A' <= tchar ) && ( tchar <= 'F')) || 
		(( '0' <= tchar ) && ( tchar <= '9')))
	{
		return TRUE;
	}
	else 
	{
		return FALSE;
	}
}

/**
 * Function that changes all hex characters into asci code.
 * \param word word to search
 * \param user_data user data passed to function
 */
void ws_gui_word_conversion( osso_rpc_t* osso_data )
{
	
	/* Looking for '%' char */	
	char* pch = strchr(osso_data->value.s, '%');
	while ( pch != NULL )
	{	
		g_debug( "[L-word] -> %s: Found percentage character in string...", __FUNCTION__ );
		/* Check if it is a hexdecimal number */
		if (( 	( pch+1 != NULL ) && ( pch+2 != NULL ) ) && 
			( ws_gui_is_hex ( pch[1] ) && ws_gui_is_hex ( pch[2] )))
		{
			char convertedWord[strlen(osso_data->value.s)];
			char tempLetterHex[2];
			char tempLetterASCI;
			int tempLetterInteger;
			tempLetterHex[0] = pch[1];
			tempLetterHex[1] = pch[2];
			int sscanfReturn = 0;
			sscanfReturn = sscanf(tempLetterHex, "%x", &tempLetterInteger);
			if (sscanfReturn == 1) 
			{
				tempLetterASCI = (char)(tempLetterInteger);
				int actualChar = pch - osso_data->value.s;
				int stringLength = strlen(osso_data->value.s);
				int i = 0;
				for ( i = 0; i < stringLength; i++)
				{
					if (i < actualChar) { convertedWord[i] = osso_data->value.s[i]; }
					if (i == actualChar) { convertedWord[ i ] = tempLetterASCI; }
					if (i > actualChar) { convertedWord[i] = osso_data->value.s[ i + 2 ]; }
				}
			}
		strcpy(osso_data->value.s, convertedWord);
		}
		pch = strchr( pch + 1, '%' );
	}
	
	/* Looking for '+' char */	
	pch = strchr(osso_data->value.s, '+');
	while ( pch != NULL )
	{	
		g_debug( "[L-word] -> %s: Found plus character in string...", __FUNCTION__ );
		pch[0] = ' ';
		pch = strchr( pch + 1, '+' );
	}
}

//end of file
