/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
/** \addtogroup GUI
 */
/*@{*/
/** \file ws_gui.c
 * \brief Main GUI file.
 *
 * GUI main loop and basic configuration of gui modules.
 * \author Anna Gadomska \<anna.gadomska\@comarch.com\>
 * \date 05-11-2007
 * \version 1.0.0
 */

#include <ws_gui.h>
#include <ws_gui_callbacks.h>
#include <ws_gui_layout.h>

//int ws_gui_init(int argc, char *argv[])
int main(int argc, char *argv[])
{
	
	
	gtk_init(&argc, &argv);

	//localization
	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);

	if (strcmp(_("ws_check"), "ws_check") == 0)
	{
		setlocale(LC_ALL, "en_GB");
		bindtextdomain(PACKAGE, LOCALEDIR);
		bind_textdomain_codeset(PACKAGE, "UTF-8");
		textdomain(PACKAGE);
	}


	WSGuiApp *ws_gui_app;
	ws_gui_app = (WSGuiApp*)g_malloc(sizeof(WSGuiApp)); 

	/*memory allocation*/
	ws_gui_app->ws_gui_w_list = 
		(struct WSGuiList*)g_malloc(sizeof(struct WSGuiList));
	ws_gui_app->ws_gui_menu = 
		(struct WSGuiMenu*)g_malloc(sizeof(struct WSGuiMenu));

	/*gconf*/
	ws_gui_app->client = gconf_client_get_default();

	ws_gui_create_window(ws_gui_app);
	ws_gui_read_adjustment(ws_gui_app);


	/*dbus wrapper*/
	ws_gui_app->dbus_data = ws_dbus_create ("mdictionaryGui", "v1.0");

	/*dbus wrapper configuration*/
	ws_dbus_config (ws_gui_app->dbus_data, 
			WS_DBUS_CONFIG_SERVICE,
			GUI_SERVICE);
	ws_dbus_config (ws_gui_app->dbus_data,
			WS_DBUS_CONFIG_OBJECT,
			GUI_OBJECT);
	ws_dbus_config (ws_gui_app->dbus_data,
			WS_DBUS_CONFIG_IFACE,
			GUI_IFACE);
	ws_dbus_config (ws_gui_app->dbus_data,
			WS_DBUS_CONFIG_REMOTE_SERVICE,
			MANAGER_SERVICE);
	ws_dbus_config (ws_gui_app->dbus_data,
			WS_DBUS_CONFIG_REMOTE_OBJECT,
			MANAGER_OBJECT);
	ws_dbus_config (ws_gui_app->dbus_data,
			WS_DBUS_CONFIG_REMOTE_IFACE,
			MANAGER_IFACE);

	//Add a list of remote methods available
	ws_dbus_add_method (ws_gui_app->dbus_data,
			"return_words",
			WS_DBUS_TYPE_GARRAY,
			WS_DBUS_TYPE_INVALID);
			
	ws_dbus_add_method (ws_gui_app->dbus_data,
			"return_translations",
			WS_DBUS_TYPE_STRING,
			WS_DBUS_TYPE_INVALID);

	ws_dbus_add_method (ws_gui_app->dbus_data,
			"return_extracted_dict",
			WS_DBUS_TYPE_STRING,
			WS_DBUS_TYPE_INVALID);

	ws_dbus_add_method (ws_gui_app->dbus_data,
			"update_progressbar",
			WS_DBUS_TYPE_DOUBLE,
			WS_DBUS_TYPE_INVALID);

	ws_dbus_add_method (ws_gui_app->dbus_data,
			"signal",
			WS_DBUS_TYPE_SIGNAL,
			WS_DBUS_TYPE_INVALID);

	ws_dbus_add_method (ws_gui_app->dbus_data,
			"search_home_applet",
			WS_DBUS_TYPE_STRING,
			WS_DBUS_TYPE_INVALID);

	//setting callbacks for local methods
	ws_dbus_set_cb (ws_gui_app->dbus_data,
			"return_words",
			ws_gui_dbus_return_words,
			ws_gui_app);

	ws_dbus_set_cb (ws_gui_app->dbus_data,
			"return_translations",
			ws_gui_dbus_return_translation,
			ws_gui_app);
	ws_dbus_set_cb (ws_gui_app->dbus_data,
			"return_extracted_dict",
			ws_dbus_server_return_extracted_bzip,
			ws_gui_app);
	ws_dbus_set_cb (ws_gui_app->dbus_data,
			"update_progressbar",
			ws_dbus_progress_bar,
			ws_gui_app);
	ws_dbus_set_cb (ws_gui_app->dbus_data,
			"signal",
			ws_gui_signal_hander,
			ws_gui_app);
	/*hisa*/
	ws_dbus_set_cb (ws_gui_app->dbus_data,
			"search_home_applet",
			ws_gui_search_home_handler,
			ws_gui_app);

	ws_dbus_connect (ws_gui_app->dbus_data);

	/*setting the clipboard*/
	ws_gui_app->ws_gui_clipboard = 
		gtk_widget_get_clipboard (GTK_WIDGET(ws_gui_app->ws_gui_html),
					GDK_SELECTION_CLIPBOARD);

	/*connecting the signals*/
	g_signal_connect(G_OBJECT (ws_gui_app->ws_gui_w_list->ws_gui_view),
			"cursor-changed",
			G_CALLBACK (ws_gui_view_cursor_changed), 
			ws_gui_app);


	g_signal_connect(G_OBJECT(ws_gui_app->ws_gui_hildon_window),
			"key-press-event",
			G_CALLBACK(hildon_key_press_listener),
			ws_gui_app);
	g_signal_connect(G_OBJECT(ws_gui_app->ws_gui_html),
			"button-press-event",
			G_CALLBACK(ws_gui_button_press),
			ws_gui_app);
	g_signal_connect(G_OBJECT(ws_gui_app->ws_gui_html),
			"button-release-event",
			G_CALLBACK(ws_gui_button_release),
			ws_gui_app);
	
	g_signal_connect(G_OBJECT(ws_gui_app->ws_gui_list_eventbox),
			"button-press-event",
			G_CALLBACK(ws_gui_list_full_dialog),
			ws_gui_app);
	g_signal_connect(G_OBJECT(ws_gui_app->ws_gui_hildon_window),
			"delete-event",
			G_CALLBACK(ws_gui_on_exit),
			ws_gui_app);

	ws_dbus_notify(ws_gui_app->dbus_data,
		WS_DBUS_ERROR_UNKNOWN);

	gtk_main();
	
	return 0;
}
/*@}*/
