/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
/** \addtogroup GUI
 */
/*@{*/
/** \file ws_gui_layout.h
 * \brief Definitions of structures used by ws_gui_layout.c
 *
 * \author Anna Gadomska \<anna.gadomska\@comarch.com\>
 * \date 05-11-2007
 * \version 1.0.0
 */
#ifndef _WS_GUI_LAYOUT
#define _WS_GUI_LAYOUT

#ifdef __cplusplus
extern "C" {
#endif

#include <ws_gui.h>
#include <ws_gui_callbacks.h>

/**
* \brief create main window
*
*/
void ws_gui_create_window(gpointer user_data);

/**
* \brief create find toolbar
*
*/
void ws_gui_create_find_toolbar(gpointer user_data);

/**
* \brief create application menu
*
*/
void ws_gui_create_main_menu (gpointer user_data);

/**
* \brief create popup menu
*
*/
void ws_gui_create_popup_menu (gpointer user_data);

/** 
 * \brief select dictionaries to use
 *
 */
void ws_gui_dictionary_chooser(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief load new dictionary files
 *
 */
void ws_gui_dictionary_loader(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief load dictionary file using given filename
 *
 */
gboolean ws_gui_load_dict(gchar *filename, gpointer user_data);

/** 
 * \brief remove dictionary from application
 *
 */
void ws_gui_dictionary_remover(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief optimize dictionaries
 *
 */
void ws_gui_dictionary_optimizer(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief open bookmark window
 *
 */
void ws_gui_dictionary_open_bookmark(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief close bookmark window
 *
 */
void ws_gui_dictionary_close_bookmark(GtkMenuItem *menuitem, 
				      gpointer user_data);

/** 
 * \brief add bookmark to bookmarks database
 *
 */
void ws_gui_dictionary_add_bookmark(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief remove bookmark from database
 *
 */
void ws_gui_dictionary_remove_bookmark(GtkMenuItem *menuitem, 
				       gpointer user_data);

/** 
 * \brief display information about application
 *
 */
void ws_gui_about_application(GtkMenuItem *menuitem, gpointer user_data);

/** 
 * \brief creates Add Bookmark dialog window
 *
 */
void ws_gui_add_bookmark_dialog(gpointer user_data);

/** 
 * \brief creates Remove Bookmark dialog window
 *
 */
void ws_gui_remove_bookmark_dialog(gpointer user_data);

void ws_gui_list_full_dialog(GtkWidget *widget, GdkEventButton *event, gpointer user_data);

#ifdef __cplusplus
}
#endif

#endif
/*@}*/
