/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
/** \defgroup GUI Dictionary's Graphical User Interface
 * \brief contains Graphical User Interface of mDictionary
 */

/** \addtogroup GUI
 */
/*@{*/
/** \file ws_gui.h
 * \brief Definitions of structures used by ws_gui.c
 *
 * \author Anna Gadomska \<anna.gadomska\@comarch.com\>
 * \date 05-11-2007
 * \version 1.0.0
 */
#ifndef _WS_GUI
#define _WS_GUI 

#ifdef __cplusplus
extern "C" {
#endif


#ifdef CHINOOK
#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-find-toolbar.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include <hildon/hildon-caption.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-window.h>
#include <hildon-widgets/hildon-banner.h>
#include <hildon-widgets/hildon-find-toolbar.h>
#include <hildon-fm/hildon-widgets/hildon-file-chooser-dialog.h>
#include <hildon-widgets/hildon-caption.h>
#endif

#include <gtk/gtkfilechooser.h>
#include <gtk/gtkdialog.h>
#include <gdk/gdkkeysyms.h>

//#include <hildon-widgets/gtk-infoprint.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gtkhtml/gtkhtml.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>

#include <ws_services.h>
#include <ws_dbus.h>

#include <gtkhtml/gtkhtml-stream.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#define ZOOM_MIN 1.000000
#define ZOOM_MAX 2.000000
#define ZOOM_STEP 0.100000
#define ZOOM_DEFAULT 1.300000
#define PRESS_TIME 1.0
#define HISTORY_LEN 5
#define SCROLL_STEP_H 50
#define SCROLL_STEP_V 20
#define GCONF_PATH "/apps/maemo/mdictionary/dictionaries"
#define GCONF_CONF "/apps/maemo/mdictionary/configuration"


#include <libintl.h>
#include <locale.h>

#define _(String) gettext (String)
#define WS_GUI_ABS(x) (((x)<0.0)?((-1)*(x)):(x))

void html_engine_unselect_all(HTMLEngine   *e);
void html_engine_block_selection (HTMLEngine   *e);
gboolean html_engine_is_selection_active (HTMLEngine *e);

typedef struct WSGuiAppData WSGuiApp;

enum
{
  COL_WORD = 0,
  NUM_COLS
};


/** \brief struct which manage layout of html (translation) area
 *
 * here are placed all components of application menu and popup menu
 */
struct HtmlLayout {
gchar *bg_color;
gchar *bg_image;
gchar *bg_font_color;

gchar *th_color;
gchar *th_image;
gchar *th_font_color;

gchar *td_color;
gchar *td_image;
gchar *td_font_color;
};

/** \brief struct which contains components of menu
 *
 * here are placed all components of application menu and popup menu
 */
struct WSGuiMenu {
	/*application menu*/
	GtkWidget *ws_gui_main_menu; ///< application submenu
	GtkWidget *ws_gui_menu_dictionaries; ///< dictionaries submenu (managing with the dictionary files)
	GtkWidget *ws_gui_menu_load_dict; ///<menuitem in dictionaries submenu; load new dictionary file into application
	GtkWidget *ws_gui_menu_select_dict; ///<menuitem in dictionaries submenu; allow to select which dictionaries are used
	GtkWidget *ws_gui_menu_remove_dict; ///<menuitem in dictionaries submenu; remove dictionary files which are no longer used
	GtkWidget *ws_gui_menu_optimize_dict; ///< menuitem used for optimizing dictionaries
	
	GtkWidget *ws_gui_menu_bookmarks; ///bookmarks submenu 
	GtkWidget *ws_gui_menu_open_bookmark; ///menuitem, opens bookmark window
	GtkWidget *ws_gui_menu_close_bookmark; ///menuitem, closes bookmark window
	GtkWidget *ws_gui_menu_add_bookmark; ///menuitem used fot adding bookmarks
	GtkWidget *ws_gui_menu_remove_bookmark; ///menuitem, allows for removing bookmarks
	
	GtkWidget *ws_gui_menu_edit; ///< edit submenu(connected with text editing)
	GtkWidget *ws_gui_menu_copy; ///< menuitem in edit submenu; copy selected text to the clipboard
	GtkWidget *ws_gui_menu_paste; ///< menuitem in edit submenu; paste content of the clipboard into find toolbar entry
	GtkWidget *ws_gui_menu_select_all; ///< menuitem in edit submenu; select whole text in the translation (html) area 
	GtkWidget *ws_gui_menu_view; ///< view submenu
	GtkWidget *ws_gui_menu_hide_list; ///< menuitem which allows to hide/show words list
	GtkWidget *ws_gui_menu_zoom_in; ///< menuitem which allows to zoom in text in the translation area
	GtkWidget *ws_gui_menu_zoom_out; ///< menuitem which allows to zoom out text in the translation area
	GtkWidget *ws_gui_menu_full_screen; ///< menuitem which allows to switch between fullscreen and normal mode
	GtkWidget *ws_gui_menu_search; ///< search submenu (connected with searching)
	GtkWidget *ws_gui_menu_find_word; ///< menuitem which allows to start searching
	GtkWidget *ws_gui_menu_find_prev; ///< menuitem which allows to find previous word from the history
	GtkWidget *ws_gui_menu_find_next; ///< menuitem which allows to find next word in the history 
	GtkWidget *ws_gui_menu_stop; ///< menuitem which stops search
	GtkWidget *ws_gui_menu_about; ///< menuitem which opens 'about application' dialog window
	GtkWidget *ws_gui_menu_close; ///< menuitem which closes the application
	
	GtkWidget *ws_gui_submenu_0; ///< submenu which is necessaty to build dictionaries submenu
	GtkWidget *ws_gui_submenu_1; ///< submenu which is necessary to build edit submenu
	GtkWidget *ws_gui_submenu_2; ///< submenu which is necessary to build view submenu
	GtkWidget *ws_gui_submenu_3; ///< submenu which is necessary to build search submenu
	GtkWidget *ws_gui_submenu_4; ///< submenu which is necessary to build search submenu
	GtkWidget *ws_gui_separator; ///< separator, it is used to provide nice layout
	
	/*ws_gui_menu popup*/
	GtkWidget *ws_gui_popup_menu;  ///< popup menu
	GtkWidget *ws_gui_popup_search;///< search option, allow to search selected text
	GtkWidget *ws_gui_popup_bookmark;///< search option, allow to search selected text
	GtkWidget *ws_gui_popup_edit; ///< edit submenu
	GtkWidget *ws_gui_popup_submenu; ///< submenu (necessary to create edit submenu)
	GtkWidget *ws_gui_popup_copy; ///< menuitem which allows to copy selected to the clipboard
	GtkWidget *ws_gui_popup_paste; ///< menuitem which allows to paste content of the clipboard into find toolbar entry
	GtkWidget *ws_gui_popup_select_all; ///<menuitem which allows to select whole text in translation area
	GtkWidget *ws_gui_popup_zoom_in; ///< menuitem which allows to zoom in text in translation area
	GtkWidget *ws_gui_popup_zoom_out; ///< menuitem which allows to zoom in text in translation area
	
	GtkWidget *ws_gui_separator1; ///< separator, it is used to provide nice layout
	GtkWidget *ws_gui_separator2; ///< separator, it is used to provide nice layout
};

/** \brief struct which contains components of words list
 *
 * here are placed all components of words list (inside left scrollwindow)
 */
struct WSGuiList {
	GtkWidget* ws_gui_list; ///< list which contains words
	GtkWidget* ws_gui_list_item; ///< item in words list (each word)
	GtkWidget* ws_gui_list_label; ///< label, necessary to place word in words list
	
	GtkObject* ws_gui_list_item_object; ///< object which stores data of selected item (from words list)
	//gchar* ws_gui_list_item_data_string; ///< variable which stores translation of word (html content)

	GtkListStore* ws_gui_store; ///< list necessary to present words list
	GtkTreeIter ws_gui_iter; ///< variable necessary to present words list
	GtkCellRenderer* ws_gui_renderer; ///< variable necessary to draw GtkTree 
	GtkTreeModel* ws_gui_model; ///< model of GtkTree
	GtkWidget* ws_gui_view; ///< variable responsible for view of GtkTree
	GtkTreeSelection* ws_gui_selection; ///< variable necessary to read selection (from words list)
};

/** \brief struct which contains all components of application
 *
 * here are placed all components of main window, toolbar, structures responsible for menus and variables responsible for adjustments, words history, banners, message dialogs and everything what user can see and use
 */
struct WSGuiAppData {
	HildonProgram *ws_gui_hildon_program; ///< handle to hildon program
	HildonWindow *ws_gui_hildon_window; ///< handle to hildon window
	gchar *welcome_note; ///< welcome note
	GtkWidget *ws_gui_html; ///< translation (html) area 
	GtkWidget *ws_gui_hpane; ///< pane; it allows to divide window into two separate panels
	HildonFindToolbar *ws_gui_hildon_find_toolbar; ///< find toolbar (placed at the bottom of the window)
	GtkToolItem *ws_gui_toobar_button_close; ///< close button at the find toolbar
	GtkToolItem *ws_gui_toobar_button_back; ///< back button at the find toolbar (history navigator)
	GtkToolItem *ws_gui_toobar_button_forward; ///< next button at the find toolbar (history navigator)
	GtkToolItem *ws_gui_toobar_button_stop; ///< stop butoon at the find toolbar (allows to stop searching)
	GtkToolItem *ws_gui_toobar_button_start; ///< stop butoon at the find toolbar (allows to stop searching)
	GtkWidget *ws_gui_banner_list_searching; ///< banner, displays message that searching is in progress
	GtkWidget *ws_gui_banner_caching; ///< banner, displays message that caching is in progress
	GtkWidget *ws_gui_banner_translation_loading; ///< banner, displays message that translation is loading
	gboolean caching_flag; ///< flag; used when caching is being performed
	gboolean loading; 
	gboolean stop_clicked; 
	GtkWidget *ws_gui_banner_extracting;
	GtkToolItem *ws_gui_toobar_button_hide; ///< button hide, allows to hide/show words list with button placed at find toolbar
	GtkWidget *ws_gui_scrolledwindow_right; ///< right scrolledwindow (placed in right pane), necessary to provide scrollbars)
	GtkWidget *ws_gui_scrolledwindow_left; ///< scrollwindow (placed in left pane), necessary to provide scrollbars)

	GtkWidget *ws_gui_list_vbox;
	GtkWidget *ws_gui_list_hbox;
	GtkWidget *ws_gui_list_label;
	GtkWidget *ws_gui_list_eventbox;
	GtkWidget *ws_gui_list_image;

	gchar *ws_gui_html_source; ///< string which contains html content (translation of word)
	
	GtkAdjustment* ws_gui_vadj; ///< vertical adjustment of left scrolledwindow (necessary to provide navigation (kardware keys) inside words list)
	GtkAdjustment* ws_gui_hadj; ///< horizontal adjustment of left scrolledwindow (necessary to provide navigation (kardware keys) inside words list)
	gdouble v_delta; ///< variable used for moving vertical scrollbar in words list
	gdouble v_new_value; ///< variable used for moving vertical scrollbar in words list
	gdouble h_delta; ///< variable used for moving horizontal scrollbar in words list
	gdouble h_new_value; ///< variable used for moving horizontal scrollbar in words list
	gdouble cur_vadj; ///< current vertical adjustment of vertical scrollbar in words list
	gdouble prev_vadj; ///< previous vertical adjustment of vertical scrollbar in words list
	gdouble cur_hadj; ///< current vertical adjustment of horizontal scrollbar in words list
	gdouble prev_hadj; ///< previous vertical adjustment of horizontal scrollbar in words list
	
	GArray *ws_gui_history; ///< words history
	GArray *ws_gui_history_list;
	GArray *ws_gui_history_iter;
	GArray *ws_gui_history_bookmarks;
	gboolean history_flag;
	gint ws_gui_history_cur_pos; ///< current position in words history array 
	

	struct WSGuiMenu *ws_gui_menu; ///< structure responsible for menus
	struct WSGuiList *ws_gui_w_list; ///< structure responsible for words list
	
	gboolean ws_gui_banner_flag; ///< flag; used for notifing if searching is in progress and banner has to be displaying
	gboolean ws_gui_full_screen_flag; ///< flag; used for informing if fullscreen mode is active
	gboolean ws_gui_double_click; ///< flag; necessary to recognize double click
	gboolean ws_gui_sel_flag; ///< flag; used to identify selected text
	
	WSDBusData *dbus_data; ///< DBUS declaration
	
	GtkWidget* ws_message_dialog; ///< message dialogs; used for informing user about errors
	
	GSList *directories; ///< list consist of directories previously read from gconf
	GSList *directories_last; ///< list consist of directories previously read from gconf
	GConfClient *client; ///< variable necessary to read from gconf
	GtkClipboard *ws_gui_clipboard; ///< application clipboard (available outside the application as well)
	GtkClipboard *ws_gui_clipboard_primary;
	PangoFontDescription* p; ///< schema, which allows to format text on widgets
	GtkWidget *licence_dialog; ///< variable necessary to create license dialog
	GTimer *timer; ///< timer, counts how long user press button (stylus)
	GArray *bookmarks_list; ///< array wchich contains bookmarked words
	gboolean bookmark_on; ///< flag which switch beetween bookmark and normal mode
	gchar *word_book; ///< word added to the bookmarks
	gchar *translation_book; ///< translation of the word added to bookmarks
	
	gboolean bookmark_avail; ///< flag, denpends on availablity of bookmarks module
	gboolean bookmark_mode; ///< flag, shows either bookmarks mode is on or off
	gchar *last_word; ///< stores last choosen word on the words list (necessary for bookmarks)
	GString *raw_translation; ///< stores current translation, if user wants to add it to bookmarks
	gchar *last_searched;
	gchar *last_searched_in_book;
	gdouble zoom;
	gboolean html_flag;
	gboolean no_words_found;
	
	gboolean first_run;
	gboolean dictionary_selection_changed;

};

#ifdef __cplusplus
}
#endif

#endif
/*@}*/
