/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
#ifndef _PC_INSTANCES_H_
#define _PC_INSTANCES_H_
#ifdef __cplusplus
extern "C" {
#endif

// stadards headers
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
// headers with unix types/functions - only for timers and files operations
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>

//------------------------------------------------------------------------------
/** \brief Get comandline by which process in /proc tree was invoked.
 *
 * @param process describes which process from /proc tree we want to check. It
 * should be only concrete directory from /proc nothing else. e.g.: /proc/self,
 * /proc/8321 etc. Something like /proc or /proc/self is not good.
 * @return string containing comandline which has invoked process. If NULL there
 * were some problems, possibly parameter were wrong or ther is no such
 * a process.
 */
char* get_process_cmdline(char* process);

//------------------------------------------------------------------------------
/** \brief Cut from commandline only program file name.
 *
 * @param cmdline commandline which from which we want to remove options.
 * @return string with only program file name, or NULL if there was any problem
 */
char* get_process_program_file(char* cmdline);

//------------------------------------------------------------------------------
/** \brief Get file name containing programm executing by current process.
 *
 * @return file name of program or NULL if there were some problems.
 */
char* get_current_process_program_file();

//------------------------------------------------------------------------------
/** \brief Check if there is another instance of current programm.
 *
 * @return integer telling how many processes were initiated with the same
 * program as curent process. If it is 1, it means there is no other procces.
 * If > 1 there is another instance.
 */
int is_already_running_this_application();



#ifdef __cplusplus
} /* extern "C" { */
#endif
#endif /* _PC_INSTANCES_H_ */
