/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/

#include <glib.h>
#include <glib/gstdio.h>
#include <sqlite.h>

const guint records_number = 1000;

// ----------------------------------------------------------------------------------
sqlite* database_make(gchar* path) {
        gchar* buffer = NULL;
        sqlite* result = NULL;
        // creatingh database
        result = sqlite_open(path,
                             0600,
                             &buffer);
        // check if everything was okey
        if(!result) {
                g_printf("Error while trying to create database:\n%s\n",buffer);
                g_free(buffer); buffer = NULL;
                return NULL;
        };
        // return pointer to database
        return result;
}
// ----------------------------------------------------------------------------------
gint database_add_test_table(sqlite* db) {
        gint result = 0;
        //gchar sql[] = "CREATE TABLE words(id INTEGER PRIMARY KEY, word TEXT UNIQUE);";
        gchar sql2[] = "CREATE TABLE translations(id INTEGER PRIMARY KEY, word TEXT, translation TEXT);";
        gchar* err = NULL;      
/*
        result = sqlite_exec(db, sql, NULL, NULL, &err);
        if(err || result!=0) {
                g_printf("Error while creating \'words\' table:\n%s\n",err);
                return 1;
        }
*/
        result = sqlite_exec(db, sql2, NULL, NULL, &err);
        if(err || result!=0) {
                g_printf("Error while creating \'translations\' table:\n%s\n",err);
                return 2;
        }

        return result;
}
// ----------------------------------------------------------------------------------
gint database_add_test_record(sqlite* db, guint i) {
        gint result = 0;
        gchar* sql = NULL;
        gchar* err = NULL;
        gint last_id = 0;
        gint word_count = 1;
        gchar buffer[] = "                     ";
        gchar last_char[] = "                      ";
        gchar tran[] = "this is a translation number 10.000 for word 10.000 word <-----";
        g_sprintf(buffer,"%d word",i);
/*
        sql = g_strconcat("INSERT INTO words VALUES(NULL,\'",buffer,"\');", NULL);        
        result = sqlite_exec(db, sql, NULL, NULL, &err);
        if(err || result!=0) {
                g_printf("Error while trying to add new word %d:\n%s\n",i,err);
                g_free(sql);
                return 1;
        }
        g_free(sql);
        last_id = sqlite_last_insert_rowid(db);
        g_sprintf(last_char,"%d",last_id);
*/
        if(i == 5000) {
                word_count = 5;
                g_printf("Adding more records for word - test\n");
        }
        gint j;
        for(j=0; j<word_count; ++j) {
                g_sprintf(tran,"this is a translation number %d for word %i",j,i);
                sql = g_strconcat("INSERT INTO translations VALUES(NULL,\'",buffer,"\',\'",tran,"\');", NULL); 
                result = sqlite_exec(db, sql, NULL, NULL, &err); 
                if(err || result!=0) {
                        g_printf("Error while trying to add new word trans %d:\n %s \n",j,err);
                        g_free(sql);
                        return 1;
                }
                g_free(sql);             
        }
        
        return result;
}
// ----------------------------------------------------------------------------------
gint main(gint argc, gchar* argv[]) {
        g_printf("Making new database with %d records...\n",records_number);
        
        // create database
        sqlite* db = database_make("ws_bookmarks");
        if(!db) return 1;

        // create table for records
        database_add_test_table(db);

        // create testing records
        guint i;
        gint code = 0;
        for(i=0; i<records_number; ++i) {
                code = database_add_test_record(db, i);
                // if there were some errors, do not continue
                if(code != 0) break;
                // give to the user some feedback about progress of proccess
                if(!(i % 50)) {
                        g_printf("%d / %d records already added to database\n",i,records_number);
                }
        }

        // close database
        sqlite_close(db);
        return 0;
}
// ----------------------------------------------------------------------------------
