/*******************************************************************************
This file is part of mdictionary.

mdictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mdictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with mdictionary; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006 ComArch S.A.
*******************************************************************************/
#include <gmodule.h>
#include <stdio.h>
#include <unistd.h>
#include <dictionary_engine.h>


getting_additional get_functions; // additinal functions for concrete module (e.g. XDXF)

void print_list(GArray* list, gchar* pattern, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,pattern);
	int i = 0;
	while(g_array_index(list, gchar*, i) != NULL) 
	{
		printf("  %d. : %s\n",i+1,g_array_index(list, gchar*, i));
		i++;
	}
        printf("--------------------------------------------------\n");
}

void print_translation(gchar* translation, gchar* word, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,word);
	printf("%s\nTRANSLATION ENDS.\n",translation);
}

void caching_progress(gdouble value, gpointer user_data, EngineStatus error) {
	printf((gchar*)user_data,value);
}

int main(int argc, char** argv) 
{
	char* nameApp = "BerkeleyDB Bookmark Engine test: ";
	printf("%sStarting test program of module: dictionary_engine.\n",nameApp);

	
	gchar* current_directory = g_get_current_dir();
	printf("%sCurrent directory: %s\n",nameApp,current_directory);
	gchar* library_to_path = g_strconcat(current_directory, "/ws_bookmark.so", NULL);
	printf("%sEngine library should be in location:\n\t%s\n",nameApp,library_to_path);
	
	GModule *library = g_module_open(library_to_path, G_MODULE_BIND_LAZY);
	if(!library) {
		printf("%sLoading module failed. \nReason: %s\n",nameApp,g_module_error());
		return 1;		
	};
	
	//dict_eng_module_get_global_functions(library,get_functions);
	g_module_symbol ( (library),_GLOBAL_FUNCTIONS_NAME_, (gpointer)&get_functions);
	if(get_functions == NULL) {
		printf("%sLoading function failed\n",nameApp);
		return 2;
	}
	else printf("%sLoading function OK\n",nameApp);

	EngineModule module = get_functions();
	gchar* desc = dict_eng_module_get_description(module);
	g_free(desc);
	printf("Module description: %s\n",desc);
	Engine* bm;

        gboolean is_compatible = dict_eng_module_check(module,"/home/lukasz/MyDocs/release/mdictionary/trunk/src/bookmarks/bdb/data");
	if(is_compatible == TRUE)
	{
		printf("Location is compatible with enigne!\n");
	}
	else {
		printf("Location is not compatible with enigne!\n");
		return 1;
	}	

        bm = dict_eng_module_create(module,
	     "/home/lukasz/MyDocs/release/mdictionary/trunk/src/bookmarks/bdb/data" ,
             ENGINE_CREATE);
	gchar* location = dict_eng_get_location(bm);
	printf("Lokalizacja: %s\n",location);
	g_free(location);
	dict_eng_set_callback(bm,
			      ENGINE_WORD_LIST_SIGNAL,
			      print_list,
			      "Word list matches to pattern: %s\n"
			     );
	dict_eng_set_callback(bm,
			      ENGINE_WORD_TRANSLATION_SIGNAL ,
			      print_translation,
			      "Translation for word: \'%s\':\n");
	
	dict_eng_add_word(bm, "stranger", "translation number 1");
	dict_eng_add_word(bm, "stranger", "translation number 2");
	dict_eng_add_word(bm, "stranger", "translation number 3");
	dict_eng_add_word(bm, "str", "translation number 1 shorter");
	dict_eng_add_word(bm, "gandzia", "rulez forever!");
	dict_eng_search_word_list(bm,"*");

	//dict_eng_remove_word(bm, "stranger");
	//dict_eng_search_word_list(bm,"*");

	dict_eng_search_word_translation(bm,"stranger");

	//dict_eng_remove_word(bm, "stranger");
	//dict_eng_add_word(bm, "stranger", "author of the plugin you are using now!");
	//dict_eng_add_word(bm, "stranger", "author of the plugin you are using now!");
	//dict_eng_add_word(bm, "stranger", "He knows gandzia.");
	//dict_eng_add_word(bm, "stranger", "He knows gandzia. 2 ");
	//dict_eng_add_word(bm, "stranger", "He knows gandzia. 3");
	//dict_eng_destroy(bm);
	//dict_eng_add_word(bm, "gandzia", "super girl!");
	//dict_eng_add_word(bm, "stranger", "He knows gandzia.");
	//dict_eng_search_word_list(bm,"*");
	//dict_eng_search_word_list(bm,"f");
	//dict_eng_search_word_list(bm,"s");
	//dict_eng_search_word_translation(sd,"1 word");
	//dict_eng_destroy(bm);
        //return 0;



        dict_eng_remove_word(bm, "stranger");
	dict_eng_remove_word(bm, "gandzia");
	dict_eng_remove_word(bm, "lukas");
        dict_eng_add_word(bm, "stranger", "autor pluginu tego wlasnie to jest!");
        dict_eng_add_word(bm, "gandzia", "rulez");
        dict_eng_add_word(bm, "lukas", "pawlik");
        dict_eng_remove_word(bm, "stranger");

        dict_eng_search_word_translation(bm,"stranger");
	
        dict_eng_add_word(bm, "stranger", "autor pluginu tego wlasnie to jest!");
        dict_eng_search_word_translation(bm,"stranger");
        dict_eng_search_word_list(bm,"gandzia");

//         printf("Lang FROM:%s\n",dict_eng_get_lang_from(bm));
//         printf("  Lang TO:%s\n",dict_eng_get_lang_to(bm));
//         printf("    Title:%s\n",dict_eng_get_title(bm));
//         printf("Icon path:%s\n",dict_eng_get_icon_path(bm));
	
	dict_eng_destroy(bm);
	g_free(current_directory);
	g_free(library_to_path);
	printf("%sClosed.\n",nameApp);	
	return 0;
}

