#include <stdio.h>
#include <stdlib.h>
#include <db/db.h>
#include <string.h>
#include <glib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>



typedef unsigned int uint;

static int bm_compare_key_trans(const DBT *a, const DBT *b) {
	uint* tmpa = (uint*)(a->data);
	uint* tmpb = (uint*)(b->data);

	if((*tmpa) == (*tmpb)) return 0;
	if(*tmpa > *tmpb)  return 1;
	else		   return -1;
}
//------------------------------------------------------------------------------
static int bm_compare_key_words(const DBT *a, const DBT *b) {
	char* tmpa = g_utf8_casefold((char*)(a->data),-1);
	char* tmpb = g_utf8_casefold((char*)(b->data),-1);
	int result = g_utf8_collate(tmpa,tmpb);
	g_free(tmpa);
	g_free(tmpb);
	return result;
}

//------------------------------------------------------------------------------
int read_berkeley_in_string_mode(DB* dbp) {
	DBT key = { NULL , 0 };
	DBT val = { NULL , 0 };

	int result = dbp->seq(dbp, &key, &val, R_FIRST);
	uint count = 1;
	uint a = 0;
	uint b = 0;
	uint c = 0;
	uint i = 0;
	uint* t = NULL;
	while(1 != result) {
		if(-1 == result) {
			printf("---Error! While sequentiall reading database\n");
			return 10;
		};
		memcpy(&a, val.data, sizeof(uint));
		t = (uint*)(val.data + sizeof(uint));
		printf("%4d. word = %-30s [%-2d record(s)] => \n",count, (char*)(key.data), a);

		for(i=0; i < a; ++i) {
			b = t[i*2];
			c = t[i*2 + 1];
			printf("\t%4u.%u. ID = %u [hash = %#x]\n",count,i+1,b,c);
		}
		
		result = dbp->seq(dbp, &key, &val, R_NEXT);
		++count;
	}
	return 0;
}
//------------------------------------------------------------------------------
int read_berkeley_in_binary_mode(DB* dbp) {
	DBT key = { NULL , 0 };
	DBT val = { NULL , 0 };

	uint count = 1;
	uint a = 0;
	char* s = NULL;
	int result = dbp->seq(dbp, &key, &val, R_FIRST);
	while(1 != result) {
		if(-1 == result) {
			printf("---Error! While sequentiall reading database\n");
			return 10;
		};
		memcpy(&a, key.data, sizeof(uint));
		s = (char*) (val.data);
		if(a == 0) {
			uint b = 0;
			memcpy(&b , val.data, sizeof(uint));
			printf("%4u. ID = %-4u value(freeID)=%u\n",count,a,b);
		}
		else {
			printf("%4u. ID = %-4u string=\'%s\'\n",count,a,s);
		}

		result = dbp->seq(dbp, &key, &val, R_NEXT);
		++count;
	}
	return 0;
}
//------------------------------------------------------------------------------
int berkeley_del_record(DB* dbp,char mode,char* id) {
	uint a;
	DBT key = { NULL , 0 };
	if('s' == mode) {
		printf("Delete key: %s...",id);
		key.data = id;
		key.size = strlen(id) + 1;
	}
	else if('b' == mode) {
		if(1 != sscanf(id,"%u",&a)) {
			printf("ID has wrong format - it should be unsigned int!\n");
			return 25;
		};
		printf("Deleting record with id=%u\n",a);
		key.size = sizeof(uint);
		key.data = &a;
	}
	else {
		printf("not supported mode for delete action!\n");
		return 24;
	};

	int result = dbp->del(dbp,&key,0);
	if(1 == result) {
		printf("... there was no such an element!\n");
	}
	else if(-1 == result) {
		printf("---Error while deleteing record!\n");
		return 29;
	}
	else {
		printf("... record deleted!\n");
	}

	return 0;
}
//------------------------------------------------------------------------------
int berkeley_fnd_record(DB* dbp,char mode,char* id) {
	uint a = 0;
	DBT key = { NULL , 0 };
	DBT val = { NULL , 0 };
	if('s' == mode) {
		printf("Searching for key: %s...\n",id);
		key.data = id;
		key.size = strlen(id) + 1;
	}
	else if('b'== mode) {
		if(1 != sscanf(id,"%u",&a)) {
			printf("ID has wrong format - it should be unsigned int!\n");
			return 35;
		};
		printf("Searching for record with id=%u\n",a);
		key.size = sizeof(uint);
		key.data = &a;
	}
	else {
		printf("not supported mode for find action!\n");
		return 30;
	};

	int result = dbp->get(dbp,&key,&val,0);
	if(1 == result) {
		printf("... there was no such a record\n");
	}
	else if(-1 == result) {
		printf("---Error while searching for the record!\n");
		return 29;
	}
	else {
		uint* t = NULL;
		uint b = 0, c = 0, i = 0;
		char* s = NULL;
		switch(mode) {
			case 's':
// ------------------------------
	memcpy(&a, val.data, sizeof(uint));
	t = (uint*)(val.data + sizeof(uint));
	printf("Element word = %-30s [%-2d record(s)] => \n", (char*)(key.data), a);

	for(i=0; i < a; ++i) {
		b = t[i*2];
		c = t[i*2 + 1];
		printf("\t%2u. ID = %u [hash = %#xu]\n",i+1,b,c);
	}
			break;
// ------------------------------
			case 'b':
// ------------------------------
	s = (char*) (val.data);
	if(a == 0) {
		memcpy(&b , val.data, sizeof(uint));
		printf("Element ID = %-4u value(freeID)=%u\n",a,b);
	}
	else {
		printf("Element ID = %-4u string=\'%s\'\n",a,s);
	}
			break;
// ------------------------------
			default:
				printf("Not supported mode!\n");
				return 30;
		}
	}
	return 0;
}
//------------------------------------------------------------------------------
int berkeley_fnd_pattern_record(DB* dbp,char mode,char* id) {
	DBT key = { NULL , 0 };
	DBT val = { NULL , 0 };

	if('s' == mode) {
		int result = dbp->seq(dbp, &key, &val, R_FIRST);
		uint count = 1;
		uint a = 0;
		uint b = 0;
		uint c = 0;
		uint i = 0;
		uint* t = NULL;
		char* tmp = g_utf8_casefold(id,-1);
		uint len = strlen(tmp);
	printf("dlugosc: %u\n",len);
		char* tmp2 = NULL;
		while(1 != result) {
			if(-1 == result) {
				printf("---Error! While sequentiall reading database\n");
				return 10;
			};
			tmp2 = g_utf8_casefold((char*)(key.data),len);
			if(0 == g_utf8_collate(tmp2,tmp) || len == 0) {
				memcpy(&a, val.data, sizeof(uint));
				t = (uint*)(val.data + sizeof(uint));
				printf("%4d. word = %-30s [%-2d record(s)] => \n",count, (char*)(key.data), a);
		
				for(i=0; i < a; ++i) {
					b = t[i*2];
					c = t[i*2 + 1];
					printf("\t%4u.%u. ID = %u [hash = %#xu]\n",count,i+1,b,c);
				}
			}
			result = dbp->seq(dbp, &key, &val, R_NEXT);
			++count;
		}
		free(tmp);
		return 0;
	}
	else {
		printf("Searching for pattern is not supported in binary mode!");
		return 65;
	}
}
//------------------------------------------------------------------------------
int berkeley_del_pattern_record(DB* dbp,char mode,char *id) {
	DBT key = { NULL , 0 };
	DBT val = { NULL , 0 };

	if('s' == mode) {
		int result = dbp->seq(dbp, &key, &val, R_FIRST);
		uint count = 0;
		uint a = 0;
		uint b = 0;
		uint c = 0;
		uint i = 0;
		uint* t = NULL;
		char* tmp = g_utf8_casefold(id,-1);
		uint len = strlen(tmp);
		char* tmp2 = NULL;
		while(1 != result) {
			if(-1 == result) {
				printf("---Error! While sequentiall reading database\n");
				return 10;
			};
			tmp2 = g_utf8_casefold((char*)(key.data),len);
			if(0 == g_utf8_collate(tmp2,tmp) || len == 0) {
				// delete actual record

				memcpy(&a, val.data, sizeof(uint));
				t = (uint*)(val.data + sizeof(uint));
				printf("Deleting record %4d. word = %-30s [%-2d record(s)] => \n",count, (char*)(key.data), a);
		
				for(i=0; i < a; ++i) {
					b = t[i*2];
					c = t[i*2 + 1];
					printf("\t%4u.%u. ID = %u [hash = %#xu]\n",count,i+1,b,c);
				}
				int result = dbp->del(dbp,&key,0);
				if(1 == result) {
					printf("---Error find element but could not delete it!\n");
				}
				else if(-1 == result) {
					printf("---Error while deleteing record!\n");
					return 29;
				}
				else {
					printf("... record deleted!\n");
				}
				count++;
			}
			free(tmp2); tmp2 = NULL;
			result = dbp->seq(dbp, &key, &val, R_NEXT);
		}
		printf("%u record were deleted totaly.\n",count);
		free(tmp);
		return 0;
	}
	else {
		printf("Searching for pattern is not supported in binary mode!");
		return 65;
	}
}
//------------------------------------------------------------------------------
int berkeley_add_record(DB* dbp,char mode,char* id, char* value) {
	DBT key = { NULL , 0 };
	DBT val = { NULL , 0 };
	
	int result = 0;
	uint a = 0, i = 0, error = 0, b = 0, c = 0;
	uint* t = NULL;
	char* tmp = malloc(200);
	char* tmp_original = tmp;
	if('s' == mode) {
		printf("Adding record with key = %s...\n",id);
		key.data = id;
		key.size = strlen(id) + 1;
		while(1) {
		if(2 != sscanf(value,"%u%[ 0-9]",&a,tmp)) {
			result = 43;
			break;
		}
		val.size = sizeof(uint) * (a*2 + 1);
		t = (uint*)malloc( val.size );
		t[0] = a;
		for(i=0; i< a; ++i) {
			if(2 != sscanf(tmp,"%u%[ 0-9]",&b,tmp)) {
				error = 1;
				break;
			};
			t[1+i*2] = b;
			int n = sscanf(tmp,"%u%[ 0-9]",&b,tmp);
			if(( (2 != n) && (i!=(a-1)) ) || ((1!=n) && (i==(a-1)))) {
				error = 1;
				break;
			};
			t[1+i*2+1] = b;
		}
		if(error) {
			printf("Wrong value for string database!\n");
			result = 44;
			break;
		}
		val.data = t;
		break ;}
	}
	else if('b'== mode) {
		if(1 != sscanf(id,"%u",&a)) {
			printf("ID has wrong format - it should be unsigned int!\n");
			return 45;
		};
		printf("Adding record with id=%u\n",a);
		key.size = sizeof(uint);
		key.data = &a;
		if(0 == a) {
			if(1 != sscanf(value,"%u",&c)) {
				printf("Value has wrong format for record with ID=0 (freeID - unsinged int)\n");
				return 46;
			};	
			val.size = key.size;
			val.data = &c;
		}
		else {
			val.size = strlen(value) + 1;
			val.data = value;
		}
	}
	else {
		printf("---Not supported mode for add action!\n");
		return 40;
	};
	
	if(0 != result) {
		if(t) free(t);
		free(tmp_original);
		return result;
	}
	
	result = dbp->put(dbp, &key, &val, R_NOOVERWRITE);
	if(1 == result) {
		printf("Such a key already exist in database!\n");
		result = 41;
	}
	else if(-1 == result) {
		printf("---Error while adding new record!\n");
		result =  49;
	}
	else {
		printf("New record has been added.\n");
		if(-1 == dbp->sync(dbp, 0)) {
			printf("---Error while saving data to file! Record could be lost.\n");
			result = 48;
		}
	}
	if(t) free(t);
	return result;
}
//------------------------------------------------------------------------------
int main(int argc, char* argv[]) {
	int help = 0, i = 0;
	for(i=1;i<argc;++i) {
		if((0 == strcmp("help",argv[i])) ||
		   (0 == strcmp("--help",argv[i])) ||
		   (0 == strcmp("-help",argv[i])) ||
		   (0 == strcmp("-h",argv[i])) ||
		   (0 == strcmp("/h",argv[i])) ||
		   (0 == strcmp("/help",argv[i]))) {
			help = 1;
			break;
		}
	}
	if((argc < 3) || help) {
		printf("[Usage: bdbprint s|b file_name.db (action identifier_of_record (optional_value))]\n"
		       "\tfile_name.db - database to open and print\n"
		       "\t           s - open in string mode, every key is treated as a string\n"
		       "\t           b - open in binary mode, every key is treated as a unsigned integer\n"
		       "\t      action - optional action to do on the base\n"
		       "\t\t       del - delete record with key=identifier_of_record\n"
		       "\t\t       add - add new record with key=identifier_of_record\n"
		       "\t\t       fnd - find record with key=identifier_of_record\n"
		       "\t\t\t    optional_value - value for add action\n");
		return 100;
	};

	char* filename = argv[2];
	char* _mode = argv[1];
	if((strlen(_mode) > 1) || ( ('s' != _mode[0]) && ('b' != _mode[0]) )) {
		printf("Wrong mode! Mode could be only s or b [\'s\' , \'b\']!\n");
		return 2;
	}
	char mode = _mode[0];

	BTREEINFO info = {
	  0,			/* permit duplicate keys? */
	  0,			/* cache size; 0 - default size */
	  0,			/* page size; 0 - default */
	  0,			/* byte order; 0 - use host order */
	  0,			/* min page number per page; 0 - default=2 */
	  bm_compare_key_words,	/* comparision function */
	  NULL			/* prefix comparision function */
	};
	if('b' == mode) {
		info.compare = bm_compare_key_trans;
	}
	u_int32_t flags = O_CREAT | O_RDWR;
	DB *dbp = dbopen(filename, flags, 0755, DB_BTREE, &info);
	if(NULL == dbp) {
		printf("Could not open database: %s!\n",filename);
		return 1;
	};

	int result = 0;
	if(argc == 3) {
		printf("Printing database: \'%s\' in mode %s :\n", filename, _mode);
		if('s' == mode) {
			result = read_berkeley_in_string_mode(dbp);
		}
		else if('b' == mode) {
			result = read_berkeley_in_binary_mode(dbp);
		}
	}
	else if(argc > 3) {
		printf("Do not print - only action... [mode=%s]\n",_mode);
		if(argc < 5) {
			printf("Wrong number of parameters! probably You did not give id of record for action.\n");
			return 21;
		};
		char* action = argv[3];
		if(strcmp(action,"del") == 0) {
			if('*' == argv[4][0]) {
				result = berkeley_del_pattern_record(dbp,mode,&(argv[4][1]));
			}
			else {
				result = berkeley_del_record(dbp,mode,argv[4]);
			}
		}
		else if(strcmp(action,"fnd") == 0) {
			if('*' == argv[4][0]) {
				result = berkeley_fnd_pattern_record(dbp,mode,argv[4]+1);
			}
			else {
				result = berkeley_fnd_record(dbp,mode,argv[4]);
			}
		}
		else if(strcmp(action,"add") == 0) {
			if(argc < 6) {
				printf("You did not give value for new record!\n");
				return 22;
			};
			result = berkeley_add_record(dbp,mode,argv[4],argv[5]);
		}
		else {
			printf("Not supported action: %s! The only good values are: add, del, fnd.\n",action);
			result = 20;
		}
	}

	dbp->close(dbp);
	return result;
}
//------------------------------------------------------------------------------
