/*******************************************************************************
This file is part of mDictionary

mDictionary is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

mDictionary is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License 
along with WhiteStork; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

Copyright 2006-2008 ComArch S.A.
*******************************************************************************/
/** \addtogroup DBusWrapperAPI
 */
/*@{*/
/** \file ws_services.h
 * \brief D-Bus Services and Interfaces names for mDictionary modules.
 *
 * This file defines names for D-Bus services, interfaces and remote objects
 * for mDictionary two main modules:
 * \li GUI
 * \li manager
 *
 * \author Dariusz Wiechecki \<dariusz.wiechecki\@comarch.com\>
 * \date 31-12-2007
 */
#ifndef WS_SERVICES_H
#define WS_SERVICES_H

/** \name D-Bus Services and Interfaces names for mDictionary modules
 * These defines how are called services, remote objects and interfaces in both
 * mDictionary modules.
 * */
/*@{*/

/** \brief Service's name for manager module.
 */
#define MANAGER_SERVICE "org.maemo.mdictionaryManager"

/** \brief Remote object's name for manager module.
 */
#define MANAGER_OBJECT "/org/maemo/mdictionaryManager"

/** \brief Interface's name for manager module.
 */
#define MANAGER_IFACE "org.maemo.mdictionaryManager"



/** \brief Service's name for GUI module.
 */
#define GUI_SERVICE "org.maemo.mdictionaryGui"

/** \brief Remote object's name for GUI module.
 */
#define GUI_OBJECT "/org/maemo/mdictionaryGui"

/** \brief Interface's name for GUI module.
 */
#define GUI_IFACE "org.maemo.mdictionaryGui"

/*@}*/
/*@}*/

#endif
