#include <hildon-widgets/hildon-window.h>
#include <hildon-widgets/hildon-program.h>
#include <string.h>
#include <sqlite.h>
#include <db/db.h>
#include <fcntl.h>
#include <unistd.h> 
#include <glib/gstdio.h>
#include <libgnomevfs/gnome-vfs.h>
#include "bm-convert.h"

#define WHITE_STORK_NAME "/usr/bin/mdictionaryManager"
#define WHITE_STORK_BOOKMARK_LOC "/usr/share/mdictionary/dictionaries/bookmarks/ws_bookmarks"
#define TMP_FILE "/media/mmc1/.bookmarks"
#define WS_BERKELEY_BOOKMARK_FILES "/usr/share/mdictionary/dictionaries/bookmarks"

#define g_strlen(string) ( NULL == (string) ? 0 : strlen(string) )

struct _MainWindow
{
	HildonWindow* window;
	HildonProgram* program;
	GtkWidget* button_import;
	GtkWidget* button_export;
	GtkWidget* button_quit;
	GtkWidget* box;
	GtkWidget* label;
};
struct _BookmarkEntry
{
	gchar* word;
	gchar* translation;
};
typedef struct _BookmarkEntry BookmarkEntry;

static void on_button_export_clicked(GtkButton *button, gpointer user_data);
static void on_button_import_clicked(GtkButton *button, gpointer user_data);
static void on_button_quit_clicked(GtkButton *button, gpointer user_data);
static gint bm_compare_key_words(const DBT *a, const DBT *b);
//static gint bm_compare_key_trans(const DBT *a, const DBT *b);
static gboolean delete_event_cb(GtkWidget *widget,
			 	GdkEvent  *event,
			 	gpointer   user_data);
static void bm_save_freeID(guint* freeID, DB* db_trans);
static gboolean bm_add_new_entry(gchar* word, gchar* translation, guint *freeID,
				DB* db_words, DB* db_trans);
static gboolean bookmark_write();
static gint compare_strings (gconstpointer a, gconstpointer b);
static void free_bookmark(BookmarkEntry* self);
MainWindow* bmc_create()
{
	g_debug("%s <->", __FUNCTION__);
	MainWindow* self = g_try_new(MainWindow, 1);
	if (self != NULL)
	{
		self->program = HILDON_PROGRAM(hildon_program_get_instance());
		g_set_application_name("mdictionary bookmark converter");
		self->window = HILDON_WINDOW(hildon_window_new());
		hildon_program_add_window(self->program, self->window);
		g_signal_connect(self->window, "delete_event", 
			G_CALLBACK(delete_event_cb), 
			self);
		
		self->box = gtk_vbox_new(FALSE, 10);
		gtk_widget_show(self->box);
		gtk_container_add(GTK_CONTAINER(self->window), self->box);

		self->label = 
			gtk_label_new("This application converts mdictionary bookmarks'"
				" database from the sqlite format to the Berkeley DB"
				" format.\nThe processed files are copied"
				" from /usr/share/mdictionary/dictionaries/bookmarks"
				" to /media/mmc1/.bookmarks directory");
		gtk_label_set_line_wrap(GTK_LABEL(self->label), TRUE);
		gtk_widget_show(self->label);
		gtk_box_pack_start(GTK_BOX(self->box), self->label, 
				FALSE, FALSE, 0);
		self->button_export = gtk_button_new_with_label("Export bookmarks");
		gtk_widget_show(self->button_export);
  		gtk_box_pack_start(GTK_BOX(self->box), self->button_export, 
				FALSE, FALSE, 0);
		
  		self->button_import = gtk_button_new_with_label("Import bookmarks");
  		gtk_widget_show(self->button_import);
  		gtk_box_pack_start(GTK_BOX(self->box), self->button_import, 
				FALSE, FALSE, 0);
		self->button_quit = gtk_button_new_with_label("Close");
  		gtk_widget_show(self->button_quit);
  		gtk_box_pack_start(GTK_BOX(self->box), self->button_quit, 
				FALSE, FALSE, 0);
		g_signal_connect((gpointer) self->button_quit, "clicked",
                    G_CALLBACK(on_button_quit_clicked),
                    self);
		g_signal_connect((gpointer) self->button_export, "clicked",
                    G_CALLBACK(on_button_export_clicked),
                    self);
  		g_signal_connect((gpointer) self->button_import, "clicked",
                    G_CALLBACK(on_button_import_clicked),
                    self);
		
		if (!g_file_test(WHITE_STORK_NAME, G_FILE_TEST_EXISTS))
		{
			gtk_widget_set_sensitive(
				GTK_WIDGET(self->button_import),
				FALSE);
			gtk_widget_set_sensitive(
				GTK_WIDGET(self->button_export),
				FALSE);
			GtkWidget* dialog = gtk_message_dialog_new(
                                	GTK_WINDOW(self->window),
                                   	GTK_DIALOG_DESTROY_WITH_PARENT,
                                   	GTK_MESSAGE_ERROR,
                                   	GTK_BUTTONS_OK,
                                   	"mdictionary not installed");
			gtk_widget_show_all(dialog);
			g_signal_connect_swapped(dialog,
                        		"response", 
                             		G_CALLBACK (gtk_widget_destroy),
                             		dialog);
		}
		
		gchar* tmp_w = g_strconcat(TMP_FILE,"/bm_words.db",NULL);
		gchar* tmp_t = g_strconcat(TMP_FILE,"/bm_trans.db",NULL);
		
		if (g_file_test(tmp_w, G_FILE_TEST_EXISTS) && 
			g_file_test(tmp_t, G_FILE_TEST_EXISTS))
		{
			gtk_widget_set_sensitive(
				GTK_WIDGET(self->button_export),
				FALSE);
		}else
		{
			gtk_widget_set_sensitive(
				GTK_WIDGET(self->button_import),
				FALSE);
		}
		gtk_widget_show_all(GTK_WIDGET(self->window));
		g_free(tmp_w);
		g_free(tmp_t);
		
		if(!gnome_vfs_initialized ()) {
                	gnome_vfs_init ();                       
        	}
	}
	else
	{
		g_debug("Not enought memory");
	}
	return self;
}

void bmc_destroy(MainWindow* self)
{
	g_debug("->%s", __FUNCTION__);
	gtk_widget_destroy(GTK_WIDGET(self->window));
	g_free(self);
	g_debug("<-%s", __FUNCTION__);
}

static gboolean delete_event_cb(GtkWidget *widget,
			 	GdkEvent  *event,
			 	gpointer   user_data)
{
	g_debug("%s->", __FUNCTION__);
	MainWindow* app = (MainWindow*) user_data;
	gtk_widget_hide_all(GTK_WIDGET(app->window));
	gtk_main_quit();
	g_debug("<-%s", __FUNCTION__);
	return TRUE;
}

static void on_button_quit_clicked(GtkButton *button, gpointer user_data)
{
	g_debug("->%s", __FUNCTION__);
	MainWindow* app = (MainWindow*) user_data;
	gtk_widget_hide_all(GTK_WIDGET(app->window));
	gtk_main_quit();
	g_debug("<-%s", __FUNCTION__);
}

static void on_button_export_clicked(GtkButton *button, gpointer user_data)
{
	g_debug("->%s", __FUNCTION__);
	MainWindow* self = (MainWindow*) user_data;
	gboolean result = bookmark_write();
	if (result)
	{
		GtkWidget* dialog = gtk_message_dialog_new(
                                   GTK_WINDOW(self->window),
                                   GTK_DIALOG_DESTROY_WITH_PARENT,
                                   GTK_MESSAGE_INFO,
                                   GTK_BUTTONS_OK,
                                   "All ok");	
		gtk_widget_show_all(dialog);
		g_signal_connect_swapped(dialog,
                        		"response", 
                             		G_CALLBACK (gtk_widget_destroy),
                             		dialog);
		gtk_widget_set_sensitive(self->button_import, TRUE);
		gtk_widget_set_sensitive(self->button_export, FALSE);
	}
	else
	{
		GtkWidget* dialog= gtk_message_dialog_new(
                                   GTK_WINDOW(self->window),
                                   GTK_DIALOG_DESTROY_WITH_PARENT,
                                   GTK_MESSAGE_ERROR,
                                   GTK_BUTTONS_OK,
                                   "Export failed");	
		gtk_widget_show_all(dialog);
		g_signal_connect_swapped(dialog,
                        		"response", 
                             		G_CALLBACK (gtk_widget_destroy),
                             		dialog);
	}
	
	g_debug("<-%s", __FUNCTION__);
}

static void on_button_import_clicked(GtkButton *button, gpointer user_data)
{
	g_debug("->%s", __FUNCTION__);
	MainWindow* self = (MainWindow*) user_data;
	//gnome_vfs_configuration_init();
	gchar* tmp_w = g_strconcat(TMP_FILE,"/bm_words.db",NULL);
	gchar* tmp_t = g_strconcat(TMP_FILE,"/bm_trans.db",NULL);
	
	gchar* dest_w = g_strconcat(WS_BERKELEY_BOOKMARK_FILES,
					"/bm_words.db",NULL);
	gchar* dest_t = g_strconcat(WS_BERKELEY_BOOKMARK_FILES,
					"/bm_trans.db",NULL);
	GnomeVFSURI* word = gnome_vfs_uri_new(tmp_w);
	GnomeVFSURI* translation = gnome_vfs_uri_new(tmp_t);
	GnomeVFSURI* dest_trans = gnome_vfs_uri_new(dest_t);
	GnomeVFSURI* dest_word = gnome_vfs_uri_new(dest_w);
	GnomeVFSResult result = gnome_vfs_xfer_uri(word,
                                        dest_word,
                                        GNOME_VFS_XFER_REMOVESOURCE,
                                        GNOME_VFS_XFER_ERROR_MODE_ABORT,
                                        GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE,
                                        NULL,
                                        NULL);
	result |= gnome_vfs_xfer_uri(translation,
                                        dest_trans,
                                        GNOME_VFS_XFER_REMOVESOURCE,
                                        GNOME_VFS_XFER_ERROR_MODE_ABORT,
                                        GNOME_VFS_XFER_OVERWRITE_MODE_REPLACE,
                                        NULL,
                                        NULL);
	
	if (GNOME_VFS_NUM_ERRORS != result)
	{
		GtkWidget* dialog = gtk_message_dialog_new(
                                   GTK_WINDOW(self->window),
                                   GTK_DIALOG_DESTROY_WITH_PARENT,
                                   GTK_MESSAGE_INFO,
                                   GTK_BUTTONS_OK,
                                   "All ok");	
		gtk_widget_show_all(dialog);
		g_signal_connect_swapped(dialog,
                        		"response", 
                             		G_CALLBACK (gtk_widget_destroy),
                             		dialog);
		gtk_widget_set_sensitive(
			GTK_WIDGET(self->button_export),
			TRUE);
		gtk_widget_set_sensitive(
			GTK_WIDGET(self->button_import),
			FALSE);
		gnome_vfs_remove_directory(TMP_FILE);
	}
	else
	{
		GtkWidget* dialog= gtk_message_dialog_new(
                                   GTK_WINDOW(self->window),
                                   GTK_DIALOG_DESTROY_WITH_PARENT,
                                   GTK_MESSAGE_ERROR,
                                   GTK_BUTTONS_OK,
                                   "Import failed");	
		gtk_widget_show_all(dialog);
		g_signal_connect_swapped(dialog,
                        		"response", 
                             		G_CALLBACK (gtk_widget_destroy),
                             		dialog);
	}
	
	g_free(tmp_w); tmp_w = NULL;
	g_free(tmp_t); tmp_t = NULL;
	g_free(dest_w); dest_w = NULL;
	g_free(dest_t); dest_t = NULL;
	gnome_vfs_uri_unref(word);
	gnome_vfs_uri_unref(translation);
	gnome_vfs_uri_unref(dest_trans);
	gnome_vfs_uri_unref(dest_word);
	//g_free(word); word = NULL;
	//g_free(translation); translation = NULL;
	//g_free(dest_trans); dest_trans = NULL;
	//g_free(dest_word); dest_word = NULL;
	
	g_debug("<-%s", __FUNCTION__);
}

static gboolean bookmark_write()
{
	sqlite* db = NULL;
	gchar* err = NULL;
	sqlite_vm* query = NULL;
        gchar* sql = NULL;
	gint sql_res = 0;
        const gchar* end;
        gint nCol = 0;
        const gchar** values = NULL;
        const gchar** head = NULL;
        gint status = 0;
        gboolean first = TRUE;
	guint id = 0;
// 	gchar* word = NULL;
// 	gchar* translation = NULL;
	GArray* bookmarks_word = g_array_new(TRUE, TRUE, sizeof(gchar*));
	GArray* bookmarks = g_array_new(TRUE, TRUE, sizeof(BookmarkEntry*));
	guint i = 0;
//------------------------------------------------------------------------------
	DB* db_words = NULL;
	DB* db_trans = NULL;
	gchar* tmp_w = g_strconcat(TMP_FILE,"/bm_words.db",NULL);
	gchar* tmp_t = g_strconcat(TMP_FILE,"/bm_trans.db",NULL);

	
	if (!g_file_test(TMP_FILE, G_FILE_TEST_IS_DIR))
	{
		int tmp = g_mkdir(TMP_FILE, 
				S_IRWXU | S_IRWXG | S_IROTH | S_IRWXO| S_IXOTH);
		if ( 0 != tmp) return FALSE;
	}
	BTREEINFO info_words = {
	  0,		/* permit duplicate keys? */
	  0,			/* cache size; 0 - default size */
	  0,			/* page size; 0 - default */
	  0,			/* byte order; 0 - use host order */
	  0,			/* min page number per page; 0 - default=2 */
	  bm_compare_key_words,	/* comparision function */
	  NULL			/* prefix comparision function */
	};
	
	BTREEINFO info_trans = {
	  0,		/* permit duplicate keys? */
	  0,			/* cache size; 0 - default size */
	  0,			/* page size; 0 - default */
	  0,			/* byte order; 0 - use host order */
	  0,			/* min page number per page; 0 - default=2 */
	  bm_compare_key_words,	/* comparision function */
	  NULL			/* prefix comparision function */
	};
	
	db_words = 
		dbopen(tmp_w,       /* On-disk file that holds the database. */
		       O_CREAT | O_RDWR,       /* flags, like O_CREAT etc. */
		       0755,        /* mode same as flags <hmmm> ? */
		       DB_BTREE,    /* type */
		       &(info_words)
		      );
	if (NULL == db_words) return FALSE;
	db_trans = dbopen(tmp_t,       /* On-disk file that holds the database. */
		       O_CREAT | O_RDWR,       /* flags, like O_CREAT etc. */
		       0755,        /* mode same as flags <hmmm> ? */
		       DB_BTREE,    /* type */
		       &(info_trans)
		      );
	if (NULL == db_trans) return FALSE;
	//bm_save_freeID(&id, db_trans);
	//id++;
	guint temp = 0;
	DBT key = { &temp, sizeof(guint)};
	DBT val = { &id, sizeof(guint) };
	db_trans->put(db_trans, &key, &val, R_NOOVERWRITE);
	db_trans->sync(db_trans, 0);
	g_free(tmp_w); tmp_w = NULL;
	g_free(tmp_t); tmp_t = NULL;
//------------------------------------------------------------------------------
	
	db = sqlite_open(WHITE_STORK_BOOKMARK_LOC, 0600,& err);
	if(!(db)) {
               g_debug("Bookmark/%s->%s() opening bookmark file failed.%s\n",
                     	(gchar*)__FILE__,
                     	(gchar*)__FUNCTION__,
                     	err
                	);
	        g_free(err);
		return FALSE;
        }
	else
	{
		sql = sqlite_mprintf("SELECT DISTINCT word FROM translations");
		sql_res = sqlite_compile(db,  /* The open database */
                                (const gchar*)sql, /* SQL statement to be compiled */
                                &end,      /* OUT: uncompiled tail of zSql */
                                &query,    /* OUT: the virtual machine */
                                &err       /* OUT: Error message. */
                                );
		if(err || sql_res!=0) {
               		g_debug("Error while compiling query:\n%s\nreason:%s\n",
				sql,err);
                	sqlite_freemem(sql); sql = NULL;
                	return FALSE;
        	}
		
		do { 
                	first = TRUE;
                	do {
                        	if(!first) sleep(1);
                        	first = FALSE;
                        	status = sqlite_step(query,
                                	        &nCol,
                                        	&values,
                                        	&head 
                                        	);
                        	if(status == SQLITE_ROW) {
					gchar* word = g_strdup((gchar*)(&(values[0][0])));
					g_debug(" word %s", word);
					g_array_append_val(bookmarks_word, word);
				}
                        } while((status == SQLITE_BUSY) && (status != SQLITE_ERROR));
        	} while((status == SQLITE_ROW) && (status != SQLITE_ERROR));
		sqlite_finalize(query, &err);
		sqlite_freemem(sql); sql = NULL;
		g_array_sort(bookmarks_word, compare_strings);
		for (i = 0; i<bookmarks_word->len; i++)
		{
		gchar* tran = NULL;
		sql = NULL;
		sql = sqlite_mprintf("SELECT translation FROM translations WHERE word LIKE '%q';",
				g_array_index(bookmarks_word, gchar*, i));
		sql_res = sqlite_compile(db,  /* The open database */
                                (const gchar*)sql, /* SQL statement to be compiled */
                                &end,      /* OUT: uncompiled tail of zSql */
                                &query,    /* OUT: the virtual machine */
                                &err       /* OUT: Error message. */
                                );
		if(err || sql_res!=0) {
               		g_debug("Error while compiling query:\n%s\nreason:%s\n",
				sql,err);
                	sqlite_freemem(sql); sql = NULL;
                	return FALSE;
        	}
		
		do { 
                	first = TRUE;
                	do {
                        	if(!first) sleep(1);
                        	first = FALSE;
                        	status = sqlite_step(query,
                                	        &nCol,
                                        	&values,
                                        	&head 
                                        	);
                        	if(status == SQLITE_ROW) {
					//id = (guint)(&(values[0][1]));
					if (tran != NULL){
					tran = g_strconcat(tran,"<BR>", 
						(gchar*)(&(values[0][0])), NULL);	
					}else{
					tran = g_strdup_printf("%s <BR>",
						(gchar*)(&(values[0][0])));
					}
				}
                        } while((status == SQLITE_BUSY) && (status != SQLITE_ERROR));
        	} while((status == SQLITE_ROW) && (status != SQLITE_ERROR));
			BookmarkEntry* new_book = g_try_new(BookmarkEntry, 1);
			new_book->word = g_array_index(bookmarks_word, gchar* ,i);
					/*g_convert(g_array_index(bookmarks_word, gchar* ,i),
                                	-1,
                                        "UTF-8",
                                        "ISO-8859-1",
                                        &bytes_read,
                                        &bytes_written,
                                        NULL);*/
			new_book->translation = tran;
					/*g_convert(tran,
                                	-1,
                                        "UTF-8",
                                        "ISO-8859-1",
                                        &bytes_read,
                                        &bytes_written,
                                        NULL);*/
			g_array_append_val(bookmarks, new_book);
			sqlite_finalize(query, &err);
			sqlite_freemem(sql); sql = NULL;
			
		}
	}
	id++;
	for (i = 0; i<bookmarks->len; i++)
	{
		BookmarkEntry* index = g_array_index(bookmarks, BookmarkEntry*, i);
		
		gboolean result = bm_add_new_entry(index->word, index->translation, &id,
						db_words, db_trans);
		if (!result) return FALSE;
	}
	
	for(i=0; i<bookmarks->len; i++)	
	{
		free_bookmark(g_array_index(bookmarks, BookmarkEntry*, i));
	}
	g_array_free(bookmarks, TRUE);
	g_array_free(bookmarks_word, TRUE);
	//g_free(word); word = NULL;
	//g_free(translation); translation = NULL;
	
	sqlite_close(db);
	db_words->close(db_words);
	db_trans->close(db_trans);
	return TRUE;
}

static gboolean bm_add_new_entry(gchar* word, gchar* translation, guint *freeID,
				DB* db_words, DB* db_trans)
{
	guint hash = g_str_hash(translation);
	gboolean result = TRUE;

	DBT new_key = { freeID , sizeof(guint) };
	DBT new_val = { translation , g_strlen(translation) + 1};
	gint db_res = db_trans->put(db_trans,
					&new_key,
					&new_val,
					R_NOOVERWRITE
					);
	if(-1 == db_res)
	{
		result = FALSE;
	}
	else
	{
		new_key.data = word;
		new_key.size = g_strlen(word) + 1;

		// { number of entries , id of the first entry , hash #1 }
		guint temp[3] = { 1 , *freeID, hash };
		new_val.data = temp;
		new_val.size = sizeof(guint) * 3;

		db_res = db_words->put(db_words,
					&new_key,
					&new_val,
					R_NOOVERWRITE
					);
		if(-1 == db_res)
		{
			new_key.data = freeID;
			new_key.size =  sizeof(guint);
			db_trans->del(db_trans, &new_key, 0);
			result = FALSE;
		}
		else
		{
			result = TRUE;
			(*freeID)++;
			g_debug("freeID %d", *freeID);
			bm_save_freeID(freeID, db_trans);
		}
	}
	db_res = db_words->sync(db_words,0);
	db_res |= db_trans->sync(db_trans,0);
	if(0 == db_res)
	{
		g_debug("Bookmark/%s->%s() adding new bookmark successful.\n",
		      (gchar*)__FILE__,(gchar*)__FUNCTION__);
	}
	else
	{
		g_debug("Bookmark/%s->%s() adding new bookmark failed.\n",
		      (gchar*)__FILE__,(gchar*)__FUNCTION__);
	}
	return result;	
}

static void bm_save_freeID(guint *freeID, DB* db_trans) {
	g_debug("Saving new freeID=%u...\n", *freeID);
	guint temp = 0;
	DBT key = { &temp, sizeof(guint)};
	DBT val = { freeID, sizeof(guint) };

	gint res = db_trans->del(db_trans, &key, 0);
	if(-1 == res)
	{
		g_debug("Error while trying to delete old freeID!\n");
		return;
	}
	else {
		g_debug("Old freeID=%u deleted successfully!\n", *freeID-1);
	}

	res = db_trans->put(db_trans, &key, &val, R_NOOVERWRITE);
	if(-1 == res || 1 == res)
	{
		g_debug("Error while trying to write new value for freeID!\n");
	}
	else {
		g_debug("New freeID=%u written successfully!\n", *freeID);
	}

	res = db_trans->sync(db_trans, 0);
	if(-1 == res || 1 == res)
	{
		
		g_debug("Error while trying to write data to file!\n");
	}
	else {
		g_debug("New data saved successfully to file!\n");
	}	
}

// static gint bm_compare_key_trans(const DBT *a, const DBT *b) {
// 	guint tmpa;// = (guint*)(a->data);
// 	guint tmpb;// = (guint*)(b->data);
// 	memcpy(&tmpa, a->data, sizeof(guint));
// 	memcpy(&tmpb, b->data, sizeof(guint));
// 
// 	if(tmpa == tmpb) return 0;
// 	if(tmpa  > tmpb) return 1;
// 	else return -1;
// }

static gint bm_compare_key_words(const DBT *a, const DBT *b) {
	gchar* tmpa = g_utf8_casefold((gchar*)(a->data),-1);
	gchar* tmpb = g_utf8_casefold((gchar*)(b->data),-1);
	gint result = g_utf8_collate(tmpa,tmpb);
	g_free(tmpa);
	g_free(tmpb);
	return result;
}

static gint compare_strings (gconstpointer a, gconstpointer b)
{
        //gets the parameters to compare
        //g_debug("--%s", __FUNCTION__);
        gchar** str1 = (gchar**)(a);
        gchar** str2 = (gchar**)(b);
        //converts a string into a form that is independent of case
        gchar* stra = g_utf8_strdown(str1[0], -1);
        gchar* strb = g_utf8_strdown(str2[0], -1);
	//g_debug("Comparing strings: %s vs. %s [ORIGINAL: %s vs. %s]\n",stra, strb, str1[0], str2[0]);
        //compare two string
        gint result = g_utf8_collate(stra, strb);
        //free memory used by converted strings
        g_free(stra); 
        g_free(strb);
        //return compare result 
        return result;
}

static void free_bookmark(BookmarkEntry* self)
{
	g_debug("->%s", __FUNCTION__);
	if (NULL != self)
	{
		g_free(self->word);
		g_free(self->translation);
		g_free(self);
	}
	g_debug("<-%s", __FUNCTION__);
}

