#ifndef NUMBERINPUT_H
#define NUMBERINPUT_H

/*
  MathJinni - A simple formular calculator
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <list>
#include <map>

#include <Lum/Model/Action.h>

#include <Lum/Object.h>
#include <Lum/String.h>

class NumberInput : public Lum::Component
{
private:
  Lum::String                                *string;
  std::map<Lum::Model::Action*,std::wstring> actionTextMap;
  Lum::Model::ActionRef                      focusInAction;
  Lum::Model::ActionRef                      focusOutAction;
  Lum::Model::ActionRef                      backspaceAction;
  Lum::Model::ActionRef                      clearAction;

private:
  Lum::Object* CreateButton(const std::wstring& label, Lum::Model::Action *action=NULL) const;
  Lum::Object* CreateTextButton(const std::wstring& label, const std::wstring& text=L"");

public:
  NumberInput();
  ~NumberInput();

  void AddString(Lum::String *string);

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
