# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2007-2009 Instituto Nokia de Tecnologia - INdT
# Author: Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
# Description: Specific optimization CFLAGS for Maemo devices.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class

ifndef _cdbs_rules_maemo_cflags
_cdbs_rules_maemo_cflags = 1

include $(_cdbs_rules_path)/buildvars.mk$(_cdbs_makefile_suffix)

ifeq ($(DEB_BUILD_ARCH),armel)
	COMMON_CFLAGS=-DNDEBUG=1 -fomit-frame-pointer -O2 -ffast-math -funsafe-math-optimizations -fno-math-errno -fsingle-precision-constant
	N770_CFLAGS=-mcpu=arm926ej-s
	N8x0_CFLAGS=-mfpu=vfp -mfloat-abi=softfp -mcpu=arm1136jf-s
	FREMANTLE_CFLAGS=-march=armv7-a -mtune=cortex-a8 -mfpu=neon -mfloat-abi=softfp
    #
    # Did someone tell us which device are we targeting?
    #
	ifneq ($(DEB_BUILD_OPTIONS),)
		ifneq (,$(findstring n8x0,$(DEB_BUILD_OPTIONS)))
			SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
		else
			ifneq (,$(findstring n770,$(DEB_BUILD_OPTIONS)))
				SPECIFIC_CFLAGS=$(N770_CFLAGS)
			endif
		endif
	endif
	#
	# Try /etc/osso_software_version
	#
	ifeq ($(SPECIFIC_CFLAGS),)
        ifeq (0,$(shell test -e /etc/osso_software_version; echo $$?))
            SW_VERSION?=$(shell cat /etc/osso_software_version|cut -d_ -f2)
			ifneq (,$(findstring $(SW_VERSION),OSSO1.1 2008SE DIABLO))
				SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
			else
				ifneq (,$(findstring $(SW_VERSION),2009SE FREMANTLE))
					SPECIFIC_CFLAGS=$(FREMANTLE_CFLAGS)
				endif
            endif
		endif
    endif
    #
    # sb-conf current may have the answer
    #
    ifeq ($(SPECIFIC_CFLAGS),)
        SB_CURRENT?=$(shell sb-conf current|cut -d_ -f1)
        ifneq (,$(findstring $(SB_CURRENT),GREGALE BORA CHINOOK DIABLO FREMANTLE))
            ifeq ($(SB_CURRENT),FREMANTLE)
                SPECIFIC_CFLAGS=$(FREMANTLE_CFLAGS)
            else
                ifeq ($(SB_CURRENT),GREGALE)
                    SPECIFIC_CFLAGS=$(N770_CFLAGS)
                else
                    SPECIFIC_CFLAGS=$(N8x0_CFLAGS)
                endif
            endif
        else
            #
            # No luck. reset everything
            #
            COMMON_CFLAGS=
            SPECIFIC_CFLAGS=
        endif
    endif
endif

CFLAGS+=$(COMMON_CFLAGS) $(SPECIFIC_CFLAGS)

endif
