#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# MA  02110-1301, USA.
#

import glob
import os
from distutils.core import setup

version = '0.0.3'

# files to install
inst_images = [ 'pixmaps/gtk-about.png', 'pixmaps/gtk-filter.png', 'pixmaps/gtk-preferences.png', 'pixmaps/gtk-search.png', 'pixmaps/gtk-clear.png', 'pixmaps/gtk-get.png', 'pixmaps/gtk-quit.png', 'pixmaps/logo.png', 'pixmaps/gtk-close.png', 'pixmaps/gtk-save.png', 'pixmaps/gtk-attachment.png', 'pixmaps/gtk-modify.png', 'pixmaps/gtk-send.png'] 
inst_dbus = [ 'py_mabugz.service' ]
inst_desktop = [ 'mabugz.desktop' ]
inst_config = ['settings.conf', 'accounts.conf']
inst_icon = ['mabugz.png' ]
inst_icon_sca = ['pixmaps/mabugz.png']
inst_py = ['mabugz.py', 'bugz.py', 'progressbar.glade', 'preferences.glade']

data_files = [
  ('share/mabugz/pixmaps', inst_images),
  ('share/applications/hildon', inst_desktop),
  ('share/dbus-1/services',   inst_dbus),
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca),
  ('share/mabugz',   inst_py),
  ('/home/user/.mabugz',   inst_config),
]



setup(
  name         = 'mabugz',
  version      = version,
  description  = 'Bugzilla client for Internet Tablets',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'https://garage.maemo.org/projects/mabugz',
  data_files   = data_files
)
