#!/usr/bin/env python
# -*- coding: UTF8 -*-
import gtk
import gtk.gdk
import gtk.glade
import hildon
import osso
import gobject
import bugz
import os
import locale
import thread
import ConfigParser
import os.path
import re
import urllib2

parar = False
## if you use OS2008, distro = 'chinook'
## else, distro = 'bora' or anything
distro = 'chinook'

(
    COLUMN_NUMBER,
    COLUMN_DESCRIPTION,
	COLUMN_STATUS,
    COLUMN_SEVERITY,
	COLUMN_PRODUCT
) = range(5)

(COLUMN_FIXED, COLUMN_ATTACH, COLUMN_AID) = range(3)

data = []
status_list = []
severity_list = []
priority_list = []
attach_list = []
attach_gets = []
gtk.gdk.threads_init()

osso_c = osso.Context("py_mabugz", "0.0.3", False)

(ENABLED, TITLE, URL, USER, PASS) = range(5)
cuentas=[]
	
config = ConfigParser.SafeConfigParser()
if os.path.exists("/home/user/.mabugz/settings.conf"):
	config.read("/home/user/.mabugz/settings.conf")
elif os.path.exists("settings.conf"): 
	config.read("settings.conf")
else:
	a=open("/home/user/.mabugz/settings.conf", "w")
	a.close()
	config.read("/home/user/.mabugz/settings.conf")

accounts = ConfigParser.SafeConfigParser()
if os.path.exists("/home/user/.mabugz/accounts.conf"):
	accounts.read("/home/user/.mabugz/accounts.conf")
elif os.path.exists("accounts.conf"): 
	accounts.read("accounts.conf")
else:
	a=open("/home/user/.mabugz/accounts.conf", "w")
	a.close()
	accounts.read("/home/user/.mabugz/accounts.conf")

if os.path.exists("/usr/share/mabugz/preferences.glade"):
	preferences_glade = "/usr/share/mabugz/preferences.glade"
else: 
	preferences_glade = "preferences.glade"	

class PyBugz(hildon.Program):
	def __init__(self):
		self.MainWindow = hildon.Window()
		self.MainWindow.set_default_size(800, 480)
		self.MainWindow.set_title('Bug Search')
		self.MainWindow.connect("destroy", self.quit)
		self.MainWindow.connect("key-press-event", self.on_key_press)
		self.MainWindow.connect("window-state-event", self.on_window_state_change)
		self.window_in_fullscreen = False 
		
## Set settings
		####debug####	
		for section in accounts.sections():
			if accounts.get(section, "enabled") == 'True':
				#print 'account: ', section	
				BugsSettings.URL = accounts.get(section, "url")
				BugsSettings.Username = accounts.get(section, "user")
				BugsSettings.Password = accounts.get(section, "password")
		#print BugsSettings.URL, BugsSettings.Username, BugsSettings.Password

		BugsSettings.Fingermenu = config.get("Settings", "fingerscroll")
		BugsSettings.Text_Color = config.get("Settings", "text_color")
		BugsSettings.Comments = config.get("Settings", "comments")

			
## Create menu       
		self.menubar = gtk.Menu()
		self.menubar.show()
		for child in self.menubar.get_children():
			child.reparent(menu)
		self.MainWindow.set_menu(self.menubar)

		if os.path.exists("/usr/share/mabugz/pixmaps/"):
			imgdir = "/usr/share/mabugz/pixmaps/"
		else:
			imgdir = "pixmaps/"

		self.menu_exit = gtk.ImageMenuItem("Exit")		
		exit_img = gtk.Image()
		exit_img.set_from_file(imgdir + "gtk-quit.png")
		self.menu_exit.set_image(exit_img)
		self.menu_exit.show()
		self.menu_exit.connect("activate", self.quit)

#Submenu settings
		self.menu_settings=gtk.ImageMenuItem("Settings")
		settings_img = gtk.Image()
		settings_img.set_from_file(imgdir + "gtk-preferences.png")			
		self.menu_settings.set_image(settings_img)
		self.menu_settings.show()
		self.menu_settings.connect("activate",self.on_settings_clicked)
		
#Submenu about		
		self.menu_about=gtk.ImageMenuItem("About")
		about_img = gtk.Image()
		about_img.set_from_file(imgdir + "gtk-about.png")		
		self.menu_about.set_image(about_img)
		self.menu_about.show()
		self.menu_about.connect("activate", Credits)		

		self.menubar.append(self.menu_settings)
		self.menubar.append(self.menu_about)
		self.menubar.append(self.menu_exit)

		self.vbox1 = gtk.VBox(False, 0)
		self.vbox1.set_spacing(0)

		self.scrolledwindow1 = gtk.ScrolledWindow()
		if distro == 'chinook':
			if BugsSettings.Fingermenu == 'True':
				hildon.hildon_helper_set_thumb_scrollbar(self.scrolledwindow1, True)
		self.scrolledwindow1.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.scrolledwindow1.set_shadow_type(gtk.SHADOW_ETCHED_IN)

		# create tree model
		model = self.__create_model()

		self.treeview1 = gtk.TreeView(model)
		self.treeview1.add_events(gtk.gdk.BUTTON_PRESS_MASK)
		self.treeview1.connect("button-press-event", self.on_button_press, model)
		self.treeview1.set_rules_hint(True)
		self.treeview1.set_headers_visible(True)
		self.treeview1.set_search_column(COLUMN_DESCRIPTION)

		self.scrolledwindow1.add(self.treeview1)

		# add columns to the tree view
		self.__add_columns(self.treeview1)

		self.vbox1.pack_start(self.scrolledwindow1, True, True, 0)

		self.hbox1 = gtk.HBox(False, 0)
		self.hbox1.set_spacing(0)

		self.entry1 = gtk.Entry()
		self.entry1.set_text("")
		self.entry1.set_editable(True)
		self.entry1.set_visibility(True)
		self.entry1.set_activates_default(True)
		self.entry1.connect("activate", self.on_search_clicked, model)
		self.hbox1.pack_start(self.entry1, True, True, 0)

		self.hbuttonbox1 = gtk.HButtonBox()
		self.hbuttonbox1.set_spacing(0)
		self.hbuttonbox1.set_layout(gtk.BUTTONBOX_DEFAULT_STYLE)

		# Search button
		self.button1 = gtk.Button()
		search_img = gtk.Image()
		search_img.set_from_file(imgdir + "gtk-search.png")
		self.button1.add(search_img)
		self.button1.connect("clicked", self.on_search_clicked, model)
		self.button1.set_size_request(50, -1)

		#Clear button
		self.button2 = gtk.Button()
		clear_img = gtk.Image()
		clear_img.set_from_file(imgdir + "gtk-clear.png")
		self.button2.add(clear_img)		
		self.button2.connect("clicked", self.on_clear_menu, model)
		self.button2.set_size_request(50, -1)

		# Get button
		self.button3 = gtk.Button()
		get_img = gtk.Image()
		get_img.set_from_file(imgdir + "gtk-get.png")
		self.button3.add(get_img)				
		self.button3.connect("clicked", self.on_get_clicked, model)
		self.button3.set_size_request(50, -1)

		#Filter button
		self.button4 = gtk.Button()
		filter_img = gtk.Image()
		filter_img.set_from_file(imgdir + "gtk-filter.png")
		self.button4.add(filter_img)			
		self.button4.connect("clicked", self.on_filter_menu)		
		self.button4.set_size_request(50, -1)

		#add buttons to hbuttonbox
		self.hbuttonbox1.pack_start(self.button1)
		self.hbuttonbox1.pack_start(self.button2)
		self.hbuttonbox1.pack_start(self.button4)
		self.hbuttonbox1.pack_start(self.button3)

		self.hbox1.pack_start(self.hbuttonbox1, False, False, 0)

		self.vbox1.pack_start(self.hbox1, False, True, 0)

		self.MainWindow.add(self.vbox1)

		self.MainWindow.show_all()

	#Functions for fullscreen
	def on_window_state_change(self, widget, event, *args):           
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self.window_in_fullscreen = True
		else:
			self.window_in_fullscreen = False

	def on_key_press(self, widget, event, *args):            
		if event.keyval == gtk.keysyms.F6:
			if self.window_in_fullscreen:
				self.MainWindow.unfullscreen ()
			else:
				self.MainWindow.fullscreen ()

	def on_button_press(self, widget, event, model):
		if event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
			self.on_get_clicked(widget, model)
			

	def quit(self, widget):
		"""Quit yourself"""
		gtk.main_quit()
		
	def on_clear_menu(self, widget, lstore):
		clearMenu = gtk.Menu()
		clearMenu1 = gtk.ImageMenuItem('Clear All')
		clearMenu1.connect('activate', self.on_clear_all, lstore)
		clearMenu2 = gtk.ImageMenuItem('Clear Search')
		clearMenu2.connect('activate', self.on_clear_search, lstore)
		
		clearfilterMenu = gtk.Menu()
		clearMenu3 = gtk.MenuItem("Clear Filters")
		clearMenu3.set_submenu(clearfilterMenu)

		clearfilterMenuAll = gtk.ImageMenuItem("Clear All") 
		clearfilterMenuAll.connect("activate",self.on_clear_all_filters)

		clearfilterMenuSta = gtk.ImageMenuItem("Clear Status") 
		clearfilterMenuSta.connect("activate",self.on_clear_status)

		clearfilterMenuSev = gtk.ImageMenuItem("Clear Severity")
		clearfilterMenuSev.connect("activate",self.on_clear_severity)

		clearfilterMenuPri = gtk.ImageMenuItem("Clear Priority")
		clearfilterMenuPri.connect("activate",self.on_clear_priority)

		clearfilterMenuAsi = gtk.ImageMenuItem("Clear Assignee")
		clearfilterMenuAsi.connect("activate",self.on_clear_assignee)

		clearfilterMenuRep = gtk.ImageMenuItem("Clear Reporter")
		clearfilterMenuRep.connect("activate",self.on_clear_reporter)

		clearfilterMenuComp = gtk.ImageMenuItem("Clear Component")
		clearfilterMenuComp.connect("activate",self.on_clear_component)

		clearfilterMenuPro = gtk.ImageMenuItem("Clear Product")
		clearfilterMenuPro.connect("activate",self.on_clear_product)

		clearfilterMenuDate = gtk.ImageMenuItem("Clear Date")
		clearfilterMenuDate.connect("activate",self.on_clear_date)
		
		clearfilterMenu.append(clearfilterMenuDate)
		clearfilterMenu.append(clearfilterMenuPro)
		clearfilterMenu.append(clearfilterMenuComp)
		clearfilterMenu.append(clearfilterMenuRep)
		clearfilterMenu.append(clearfilterMenuAsi)
		clearfilterMenu.append(clearfilterMenuPri)
		clearfilterMenu.append(clearfilterMenuSev)
		clearfilterMenu.append(clearfilterMenuSta)
		clearfilterMenu.append(clearfilterMenuAll)		
		
		clearMenu.add(clearMenu3)
		clearMenu.add(clearMenu1)
		clearMenu.add(clearMenu2)

		clearMenu.show_all()
# parent_menu_shell, parent_menu_item, func, button, activate_time, data=None
		clearMenu.popup(None, None, None, 1, 0)		
		
	def on_clear_all(self, widget, lstore):
		lstore.clear()
		self.entry1.set_text("")	
		del status_list[:]
		del severity_list[:]
		del priority_list[:]
		self.enAsisearch = None		
		self.enRepSearch = None
		self.enCompSearch = None
		self.enProSearch = None
		self.enDateFrom = None
		self.enDateTo = None
		
	def on_clear_search(self, widget, lstore):
		lstore.clear()
		self.entry1.set_text("")

	def on_clear_all_filters(self, widget):
		del status_list[:]			
		del severity_list[:]
		del priority_list[:]
		self.enAsisearch = None
		self.enRepSearch = None
		self.enCompSearch = None
		self.enProSearch = None
		self.enDateFrom = None
		self.enDateTo = None
		
	def on_clear_status(self, widget):
		del status_list[:]	

	def on_clear_severity(self, widget):
		del severity_list[:]
		
	def on_clear_priority(self, widget):
		del priority_list[:]		

	def on_clear_assignee(self, widget):
		self.enAsisearch = None

	def on_clear_reporter(self, widget):
		self.enRepSearch = None

	def on_clear_component(self, widget):
		self.enCompSearch = None

	def on_clear_product(self, widget):
		self.enProSearch = None
		
	def on_clear_date(self, widget):
		self.enDateFrom = None
		self.enDateTo = None
				
	def on_filter_menu(self, widget):
		filterMenu = gtk.Menu()
		filterMenu0 = gtk.ImageMenuItem('Filter Date')
		filterMenu0.connect('activate', self.on_filter_date)
		filterMenu1 = gtk.ImageMenuItem('Filter Status')
		filterMenu1.connect('activate', self.on_filter_status)
		filterMenu2 = gtk.ImageMenuItem('Filter Severity')
		filterMenu2.connect('activate', self.on_filter_severity)		
		filterMenu3 = gtk.ImageMenuItem('Filter Priority')
		filterMenu3.connect('activate', self.on_filter_priority)		
		filterMenu4 = gtk.ImageMenuItem('Filter Assignee')
		filterMenu4.connect('activate', self.on_filter_assignee)		
		filterMenu5 = gtk.ImageMenuItem('Filter Reporter')
		filterMenu5.connect('activate', self.on_filter_reporter)
		filterMenu6 = gtk.ImageMenuItem('Filter Component')
		filterMenu6.connect('activate', self.on_filter_component)		
		filterMenu7 = gtk.ImageMenuItem('Filter Product')
		filterMenu7.connect('activate', self.on_filter_product)
		
		filterMenu.add(filterMenu0)
		filterMenu.add(filterMenu1)
		filterMenu.add(filterMenu2)
		filterMenu.add(filterMenu3)
		filterMenu.add(filterMenu4)
		filterMenu.add(filterMenu5)
		filterMenu.add(filterMenu6)
		filterMenu.add(filterMenu7)
	
		filterMenu.show_all()
# parent_menu_shell, parent_menu_item, func, button, activate_time, data=None
		filterMenu.popup(None, None, None, 1, 0)

	def on_filter_date(self, widget):
		self.FilterDate_dlg = gtk.Dialog(title='Filter Date', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		label1 = gtk.Label('Only bugs changed between:')
		self.FilterDate_dlg.vbox.pack_start(label1, False, False, 0)
		
		hbox = gtk.HBox()
		datefrom = hildon.DateEditor()
		label2 = gtk.Label('and')		
		dateto = hildon.DateEditor()
		hbox.pack_start(datefrom, True, True, 0)
		hbox.pack_start(label2, False, False, 0)
		hbox.pack_start(dateto, True, True, 0)
		
		self.FilterDate_dlg.vbox.pack_start(hbox, False, False, 0)

		self.FilterDate_dlg.show_all()
		result = self.FilterDate_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enDateFrom = '%s-%s-%s' % datefrom.get_date()
			self.enDateTo = '%s-%s-%s' % dateto.get_date()
			self.FilterDate_dlg.destroy()
		self.FilterDate_dlg.destroy()

	def on_filter_status(self, widget):
		self.FilterSta_dlg = gtk.Dialog(title='Filter Status', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		checkbutton1 = gtk.CheckButton('Unconfirmed')
		checkbutton2 = gtk.CheckButton('New')		
		checkbutton3 = gtk.CheckButton('Assigned')	
		checkbutton4 = gtk.CheckButton('Reopened')
		checkbutton5 = gtk.CheckButton('Resolved')		
		checkbutton6 = gtk.CheckButton('Verified')			
		checkbutton7 = gtk.CheckButton('Closed')			
			
		self.FilterSta_dlg.vbox.pack_start(checkbutton1, False, False, 0)
		self.FilterSta_dlg.vbox.pack_start(checkbutton2, False, False, 0)	
		self.FilterSta_dlg.vbox.pack_start(checkbutton3, False, False, 0)
		self.FilterSta_dlg.vbox.pack_start(checkbutton4, False, False, 0)
		self.FilterSta_dlg.vbox.pack_start(checkbutton5, False, False, 0)	
		self.FilterSta_dlg.vbox.pack_start(checkbutton6, False, False, 0)		
		self.FilterSta_dlg.vbox.pack_start(checkbutton7, False, False, 0)	
		del status_list[:]

		self.FilterSta_dlg.show_all()
		result = self.FilterSta_dlg.run()
		if (result == gtk.RESPONSE_OK):
			if checkbutton1.get_active() == True:
				status_list.append('Unconfirmed')
			if checkbutton2.get_active() == True:
				status_list.append('New')
			if checkbutton3.get_active() == True:
				status_list.append('Assigned')
			if checkbutton4.get_active() == True:
				status_list.append('Reopened')
			if checkbutton5.get_active() == True:
				status_list.append('Resolved')
			if checkbutton6.get_active() == True:
				status_list.append('Verified')	
			if checkbutton7.get_active() == True:
				status_list.append('Closed')								
			print status_list
			self.FilterSta_dlg.destroy()
		self.FilterSta_dlg.destroy()
		
	def on_filter_severity(self, widget):
		self.FilterSev_dlg = gtk.Dialog(title='Filter Severity', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		checkbutton1 = gtk.CheckButton('Blocker')
		checkbutton2 = gtk.CheckButton('Critical')		
		checkbutton3 = gtk.CheckButton('Major')	
		checkbutton4 = gtk.CheckButton('Normal')
		checkbutton5 = gtk.CheckButton('Minor')		
		checkbutton6 = gtk.CheckButton('Trivial')			
		checkbutton7 = gtk.CheckButton('Enhancement')			
			
		self.FilterSev_dlg.vbox.pack_start(checkbutton1, False, False, 0)
		self.FilterSev_dlg.vbox.pack_start(checkbutton2, False, False, 0)	
		self.FilterSev_dlg.vbox.pack_start(checkbutton3, False, False, 0)
		self.FilterSev_dlg.vbox.pack_start(checkbutton4, False, False, 0)
		self.FilterSev_dlg.vbox.pack_start(checkbutton5, False, False, 0)	
		self.FilterSev_dlg.vbox.pack_start(checkbutton6, False, False, 0)		
		self.FilterSev_dlg.vbox.pack_start(checkbutton7, False, False, 0)	
		del severity_list[:]

		self.FilterSev_dlg.show_all()
		result = self.FilterSev_dlg.run()
		if (result == gtk.RESPONSE_OK):
			if checkbutton1.get_active() == True:
				severity_list.append('Blocker')
			if checkbutton2.get_active() == True:
				severity_list.append('Critical')
			if checkbutton3.get_active() == True:
				severity_list.append('Major')
			if checkbutton4.get_active() == True:
				severity_list.append('Normal')
			if checkbutton5.get_active() == True:
				severity_list.append('Minor')
			if checkbutton6.get_active() == True:
				severity_list.append('Trivial')	
			if checkbutton7.get_active() == True:
				severity_list.append('Enhancement')								
			print severity_list
			self.FilterSev_dlg.destroy()
		self.FilterSev_dlg.destroy()

	def on_filter_priority(self, widget):
		self.FilterPri_dlg = gtk.Dialog(title='Filter Priority', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		checkbutton1 = gtk.CheckButton('P1')
		checkbutton2 = gtk.CheckButton('P2')		
		checkbutton3 = gtk.CheckButton('P3')	
		checkbutton4 = gtk.CheckButton('P4')
		checkbutton5 = gtk.CheckButton('P5')		
			
			
		self.FilterPri_dlg.vbox.pack_start(checkbutton1, False, False, 0)
		self.FilterPri_dlg.vbox.pack_start(checkbutton2, False, False, 0)	
		self.FilterPri_dlg.vbox.pack_start(checkbutton3, False, False, 0)
		self.FilterPri_dlg.vbox.pack_start(checkbutton4, False, False, 0)
		self.FilterPri_dlg.vbox.pack_start(checkbutton5, False, False, 0)	
	
		del priority_list[:]

		self.FilterPri_dlg.show_all()
		result = self.FilterPri_dlg.run()
		if (result == gtk.RESPONSE_OK):
			if checkbutton1.get_active() == True:
				priority_list.append('P1')
			if checkbutton2.get_active() == True:
				priority_list.append('P2')
			if checkbutton3.get_active() == True:
				priority_list.append('P3')
			if checkbutton4.get_active() == True:
				priority_list.append('P4')
			if checkbutton5.get_active() == True:
				priority_list.append('P5')							
			print priority_list
			self.FilterPri_dlg.destroy()
		self.FilterPri_dlg.destroy()	

	def on_filter_assignee(self, widget):
		self.FilterAsi_dlg = gtk.Dialog(title='Filter Assignee', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		self.enAssignee = gtk.Entry()
		self.enAssignee.set_text('')
		self.enAssignee.set_editable(True)
		
		self.FilterAsi_dlg.vbox.pack_start(self.enAssignee, False, False, 0)	
	
		self.FilterAsi_dlg.show_all()
		
		result = self.FilterAsi_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enAsisearch = self.enAssignee.get_text()
			self.FilterAsi_dlg.destroy()
		self.FilterAsi_dlg.destroy()	

	def on_filter_reporter(self, widget):
		self.FilterRep_dlg = gtk.Dialog(title='Filter Reporter', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		self.enReporter = gtk.Entry()
		self.enReporter.set_text('')
		self.enReporter.set_editable(True)
		
		self.FilterRep_dlg.vbox.pack_start(self.enReporter, False, False, 0)	
	
		self.FilterRep_dlg.show_all()
		
		result = self.FilterRep_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enRepSearch = self.enReporter.get_text()
			self.FilterRep_dlg.destroy()
		self.FilterRep_dlg.destroy()

	def on_filter_component(self, widget):
		self.FilterComp_dlg = gtk.Dialog(title='Filter Component', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		#TODO: Treeview with component list
		self.enComponent = gtk.Entry()
		self.enComponent.set_text('')
		self.enComponent.set_editable(True)
		
		self.FilterComp_dlg.vbox.pack_start(self.enComponent, False, False, 0)	
	
		self.FilterComp_dlg.show_all()
		
		result = self.FilterComp_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enCompSearch = self.enComponent.get_text()
			self.FilterComp_dlg.destroy()
		self.FilterComp_dlg.destroy()

	def on_filter_product(self, widget):
		self.FilterPro_dlg = gtk.Dialog(title='Filter Product', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CLOSE))
		
		#TODO: Treeview with product list
		self.enProduct = gtk.Entry()
		self.enProduct.set_text('')
		self.enProduct.set_editable(True)
		
		self.FilterPro_dlg.vbox.pack_start(self.enProduct, False, False, 0)	
	
		self.FilterPro_dlg.show_all()
		
		result = self.FilterPro_dlg.run()
		if (result == gtk.RESPONSE_OK):
			self.enProSearch = self.enProduct.get_text()
			self.FilterPro_dlg.destroy()
		self.FilterPro_dlg.destroy()


	def on_settings_clicked(self, widget):
		Preferences()
		
	def __create_model(self):
		lstore = gtk.ListStore(
			gobject.TYPE_UINT,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING)

		for item in data:
			iter = lstore.append()
			lstore.set(iter,
				COLUMN_NUMBER, item[COLUMN_NUMBER],
				COLUMN_DESCRIPTION, item[COLUMN_DESCRIPTION],
				COLUMN_STATUS, item[COLUMN_STATUS],
				COLUMN_SEVERITY, item[COLUMN_SEVERITY],
				COLUMN_PRODUCT, item[COLUMN_PRODUCT])
		return lstore

	def __add_columns(self, treeview):
		model = treeview.get_model()

		# column for bug numbers
		column = gtk.TreeViewColumn('Bug', gtk.CellRendererText(),
                                    text=COLUMN_NUMBER)
		column.set_sort_column_id(COLUMN_NUMBER)
		treeview.append_column(column)

		# column for description
		column = gtk.TreeViewColumn('Description', gtk.CellRendererText(),
                                     text=COLUMN_DESCRIPTION)
		column.set_sort_column_id(COLUMN_DESCRIPTION)
		column.set_min_width(400)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_resizable(True)
		treeview.append_column(column)

		# columns for status
		column = gtk.TreeViewColumn('Status', gtk.CellRendererText(),
                                    text=COLUMN_STATUS)
		column.set_sort_column_id(COLUMN_STATUS)
		treeview.append_column(column)

		# columns for severities
		column = gtk.TreeViewColumn('Severity', gtk.CellRendererText(),
                                    text=COLUMN_SEVERITY)
		column.set_sort_column_id(COLUMN_SEVERITY)
		treeview.append_column(column)

		# column for product
		column = gtk.TreeViewColumn('Product', gtk.CellRendererText(),
                                     text=COLUMN_PRODUCT)
		column.set_sort_column_id(COLUMN_PRODUCT)
		treeview.append_column(column)

	def on_search_clicked(self, widget, lstore):
		self._do_widgets_insensitive()
		self.pgbar = ProgressBar("Searching bugs", self.MainWindow)
		thread.start_new_thread(self.on_search_conn, (lstore,))		
		
	def on_search_conn(self, lstore):
		pybugz = BugsSettings.create_bugzilla_client()
		if (pybugz == None):
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error creating Bugzilla client, please check settings."))
			return

		search_term = self.entry1.get_text()

		try:
			if BugsSettings.Comments == 'False':
				search_comm = False
			elif BugsSettings.Comments == 'True':
				search_comm = True
		except:
			search_comm = False

		try:
			assigned_term = self.enAsisearch
		except:
			assigned_term = None
			
		try:
			reporter_term = self.enRepSearch
		except:
			reporter_term = None

		try:
			component_term = self.enCompSearch
		except:
			component_term = None

		try:
			product_term = self.enProSearch
		except:
			product_term = None
			
		try:
			date_from_term = self.enDateFrom
		except:
			date_from_term = None			
		
		try:
			date_to_term = self.enDateTo
		except:
			date_to_term = None	
			
		global parar
		try:
			result = pybugz.search(search_term, comments = search_comm, status = status_list, severity = severity_list, priority = priority_list, assigned_to = assigned_term, reporter = reporter_term, component = component_term, product = product_term, date_from = date_from_term, date_to = date_to_term)
			if parar == True:
				self._do_widgets_sensitive()
				parar = False
				return
			thread.start_new_thread(self.on_search_trat, (lstore, result))
		except ValueError:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Bad Url."))			
		except RuntimeError:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Failed to login."))
		except urllib2.URLError:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Please check settings or internet connection."))		


	def on_search_trat(self, lstore, result):
		#Clear the last search at the ListStore
		gtk.gdk.threads_enter()
		lstore.clear()
		gtk.gdk.threads_leave()

		if result == None:
			self.pgbar.stop_pg()
			self._do_widgets_sensitive()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Failed to perform search"))

		if len(result) == 0:
			iter = lstore.append()
			gtk.gdk.threads_enter()
			lstore.set (iter,
				COLUMN_NUMBER, 0,
				COLUMN_DESCRIPTION, 'No bugs found',
				COLUMN_STATUS, '',
				COLUMN_SEVERITY, '',
				COLUMN_PRODUCT, '')
			self.pgbar.stop_pg()
			gtk.gdk.threads_leave()
			self._do_widgets_sensitive()
			return
		try:
			for row in result:
				global parar
				if parar == True:
					gtk.gdk.threads_enter()
					lstore.clear()
					gtk.gdk.threads_leave()
					self._do_widgets_sensitive()
					parar = False
					return
				bugid = row['bugid']
				desc = row['desc']
				status = row['status']
				severity = row['severity']
				assignee = row['assignee'].split('@')[0]
	
				one_result = (int(bugid), str(desc), str(status), str(severity), str(assignee))
				data.append(one_result)
	
				iter = lstore.append()

				gtk.gdk.threads_enter()
				lstore.set (iter,
					COLUMN_NUMBER, one_result[COLUMN_NUMBER],
					COLUMN_DESCRIPTION, one_result[COLUMN_DESCRIPTION],
					COLUMN_STATUS, one_result[COLUMN_STATUS],
					COLUMN_SEVERITY, one_result[COLUMN_SEVERITY],
					COLUMN_PRODUCT, one_result[COLUMN_PRODUCT])
				gtk.gdk.threads_leave()
		
		except:
			print "An error occurred searching bugs. Perhaps that bugzilla doesn't allow empty searches."
		self.pgbar.stop_pg()
		self._do_widgets_sensitive()

	def on_get_clicked(self, widget, lstore):
		self._do_widgets_insensitive()
		a = thread.start_new_thread(self.on_get_trat, (widget, lstore))
		self.pgbar = ProgressBar("Getting bug", self.MainWindow)


	def on_get_trat(self, widget, lstore):
		#get the bug text
		global parar
		selection = self.treeview1.get_selection()
		model, iter = selection.get_selected()
		if iter:
			bugid = lstore.get_value(iter, COLUMN_NUMBER)
		else:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: No Bug ID."))
			return
		# descargar el texto del bug
		pybugz = BugsSettings.create_bugzilla_client()
		if (pybugz == None):
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error creating Bugzilla client."))
			return
		try:
			result = pybugz.get(int(bugid))
			if parar == True:
				self._do_widgets_sensitive()
				parar = False
				return
		except urllib2.URLError, e:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Please try again or check internet connection."))
			return
		except:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()	
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error getting bug."))
			return

		if result == None:
			self._do_widgets_sensitive()
			self.pgbar.stop_pg()				
			error_text = 'Error: Bug %s not found' % bugid
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, error_text))
			
        # Print out all the fields below by extract the text
        # directly from the tag, and just ignore if we don't
        # see the tag.
		FIELDS = (
			('short_desc', 'Title'),
			('assigned_to', 'Assigneed To'),            
			('creation_ts', 'Reported'),
			('delta_ts', 'Updated'),
			('bug_status', 'Status'),
			('resolution', 'Resolution'),
			('bug_file_loc', 'URL'),
			('bug_severity', 'Severity'),
			('priority', 'Priority'),
			('reporter', 'Reporter'),
		)

		MORE_FIELDS = (
			('product', 'Product'),
			('component', 'Component'),
			('status_whiteboard', 'Whiteboard'),
			('keywords', 'Keywords'),
		)

		text_bug = ''

		try:
			self.enc = locale.getdefaultlocale()[1]
		except:
			self.enc = 'utf-8'

		for field, name in FIELDS + MORE_FIELDS:
			try:
				value = result.find('//%s' % field).text
			except AttributeError:
				continue
			text_bug += '%s: %s\n' % (name, value.encode(self.enc))

        # Print out the cc'ed people
		cced = result.findall('.//cc')
		for cc in cced:
			text_bug += '%s: %s\n' %  ('CC', cc.text)

        # print out depends
		dependson = ', '.join([d.text for d in result.findall('.//dependson')])
		blocked = ', '.join([d.text for d in result.findall('.//blocked')])
		if dependson:
			text_bug += '%s: %s\n' % ('DependsOn', dependson)

		if blocked:
			text_bug += '%s: %s\n' % ('Blocked', blocked)

		bug_comments = result.findall('//long_desc')
		bug_attachments = result.findall('//attachment')

		config = bugz.BugzConfig()
		text_bug += '%s: %d\n' % ('Comments', len(bug_comments))
		text_bug += '%s: %d\n' % ('Attachments', len(bug_attachments))
		text_bug += '%s: %s' % ('URL', '%s/%s?id=%s' % (BugsSettings.URL, config.urls['show'], bugid))

		if len(bug_comments) == 0:
			text_bug += '\nNo comments.\n'
		else:
			import textwrap
			i = 0
			wrapper = textwrap.TextWrapper(width = 80)
			for comment in bug_comments:
				who = comment.find('.//who').text.encode(self.enc)
				when = comment.find('.//bug_when').text.encode(self.enc)
				what =  comment.find('.//thetext').text
				i += 1

				text_bug += '\n\n\n[Comment #%d] %s : %s\n' % (i, who, when)

                # textcomment
				text_bug += '%s' % what

		if len(bug_attachments) == 0:
			text_bug += '\n\nNo attachments'
		else:
			for attachment in bug_attachments:
				aid = attachment.find('.//attachid').text
				desc = attachment.find('.//desc').text
				when = attachment.find('.//date').text
				text_bug += '\n\n[Attachment] [%s] [%s]' % (aid, desc.encode(self.enc))
			
		if self.window_in_fullscreen == True:
			fulls = True
		elif self.window_in_fullscreen == False:
			fulls = False
		try:
			text_color = BugsSettings.Text_Color
		except:
			text_color = "blue"
		
		if parar == True:
			self._do_widgets_sensitive()
			parar = False
			return
					
		thread.start_new_thread(self.start_bugwin, (text_bug, bugid, fulls, text_color, bug_attachments, pybugz))
		self.pgbar.stop_pg()
		self._do_widgets_sensitive()

	def start_bugwin(self, text_bug, bugid, fulls, text_color, bug_attachments, pybugz):
		gtk.gdk.threads_enter()
		GetBug(text_bug, bugid, fulls, text_color, bug_attachments, pybugz)
		gtk.gdk.threads_leave()
		
	def _do_widgets_sensitive(self):
		self.treeview1.set_sensitive(True)
		self.button1.set_sensitive(True)
		self.button2.set_sensitive(True)
		self.button3.set_sensitive(True)
		self.button4.set_sensitive(True)
		
	def _do_widgets_insensitive(self):
		self.treeview1.set_sensitive(False)
		self.button1.set_sensitive(False)
		self.button2.set_sensitive(False)
		self.button3.set_sensitive(False)
		self.button4.set_sensitive(False)

class GetBug:
	def __init__(self, text_bug, bugid, fulls, text_color, bug_attachments, pybugz):	
		def bugwin_destroy(widget):
			self.BugWindow.destroy()
		##Crear una ventana nueva 
		self.BugWindow = hildon.Window()
		self.BugWindow.set_title('Bug #' + str(bugid))
		self.BugWindow.set_default_size(800, 480)
		self.BugWindow.connect("destroy", bugwin_destroy)
		self.BugWindow.connect("key-press-event", self.on_key_press)
		self.BugWindow.connect("window-state-event", self.on_window_state_change)

		if fulls == True:
			self.BugWindow.fullscreen()
			self.bugwindow_in_fullscreen = True
		else:
			self.bugwindow_in_fullscreen = False

		self.menubar = gtk.Menu()
		self.menubar.show()
		for child in self.menubar.get_children():
			child.reparent(menu)
		self.BugWindow.set_menu(self.menubar)

		if os.path.exists("/usr/share/mabugz/pixmaps"):
			imgdir = "/usr/share/mabugz/pixmaps/"
		else:
			imgdir = "pixmaps/"

		self.menu_modify = gtk.ImageMenuItem("Modify")		
		modify_img = gtk.Image()
		modify_img.set_from_file(imgdir + "gtk-modify.png")
		self.menu_modify.set_image(modify_img)
		self.menu_modify.show()
		self.menu_modify.connect("activate", self.on_modify_clicked, pybugz, bugid)
		
		self.menu_attach = gtk.ImageMenuItem("Get attachments")		
		attach_img = gtk.Image()
		attach_img.set_from_file(imgdir + "gtk-attachment.png")
		self.menu_attach.set_image(attach_img)
		self.menu_attach.show()
		self.menu_attach.connect("activate", self.on_get_attach_clicked, bug_attachments, pybugz)
		
		self.menu_save = gtk.ImageMenuItem("Save as text")		
		save_img = gtk.Image()
		save_img.set_from_file(imgdir + "gtk-save.png")
		self.menu_save.set_image(save_img)
		self.menu_save.show()
		self.menu_save.connect("activate", self.on_save_clicked)
		
		self.menu_close = gtk.ImageMenuItem("Close")		
		close_img = gtk.Image()
		close_img.set_from_file(imgdir + "gtk-close.png")
		self.menu_close.set_image(close_img)
		self.menu_close.show()
		self.menu_close.connect("activate", bugwin_destroy)
		
		self.menubar.append(self.menu_modify)
		self.menubar.append(self.menu_attach)
		self.menubar.append(self.menu_save)
		self.menubar.append(self.menu_close)
				
		self.scrolledwindow2 = gtk.ScrolledWindow()
		if distro == 'chinook':
			if BugsSettings.Fingermenu == 'True':
				hildon.hildon_helper_set_thumb_scrollbar(self.scrolledwindow2, True)

		self.scrolledwindow2.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.scrolledwindow2.set_shadow_type(gtk.SHADOW_ETCHED_IN)

		self.view = gtk.TextView()
		self.buffer1 = self.view.get_buffer()
		self.view.set_wrap_mode(gtk.WRAP_WORD)
		self.view.set_editable(False)
		self.view.set_cursor_visible(False)
		self.buffer1.create_tag("monospace", family="monospace")
		self.buffer1.create_tag("blue_foreground", foreground=text_color)
		iter = self.buffer1.get_iter_at_offset(0)
		self.buffer1.insert_with_tags_by_name(iter, text_bug, "blue_foreground", "monospace")

		self.scrolledwindow2.add(self.view)

		self.BugWindow.add(self.scrolledwindow2)
		self.BugWindow.show_all()

	def scroll_to(self, x=0, y=0):
		v = self.scrolledwindow2.get_vadjustment()
		#TextBuffer haven't size_request but it work well ;)
		#TODO: look this
		child_height = self.scrolledwindow2.child.child.size_request()[1]
		new_adj = gtk.Adjustment(y, 0, child_height)
#		child_height = self.buffer1.size_request()[1]
#		new_adj = gtk.Adjustment(y, 0, child_height)
#		new_adj = gtk.Adjustment(y, 0, None)
		self.scrolledwindow2.set_vadjustment(new_adj)

	def scroll_by(self, dx=0, dy=0):
		v = self.scrolledwindow2.get_vadjustment()
		new_y = min(v.upper, v.value + dy)
#		print v.upper, v.value
		self.scroll_to(0, new_y)
#		print new_y

	#Functions for fullscreen
	def on_window_state_change(self, widget, event, *args):           
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self.bugwindow_in_fullscreen = True
		else:
			self.bugwindow_in_fullscreen = False

	def on_key_press(self, widget, event, *args): 
# Los valores de 100 y -100 son los 'pixels' que avanza el scroll
		if event.keyval == gtk.keysyms.Down:
			self.scroll_by(0, 100)
		elif event.keyval == gtk.keysyms.Up:
			self.scroll_by(0, -100)
		elif event.keyval == gtk.keysyms.F6:
			if self.bugwindow_in_fullscreen:
				self.BugWindow.unfullscreen()
			else:
				self.BugWindow.fullscreen()
		elif event.keyval == gtk.keysyms.Escape:
			self.BugWindow.destroy()

	def on_modify_clicked(self, widget, pybugz, bugid):
		def modifywin_destroy(widget):
			self.modify_win.destroy()
		self.modify_win = hildon.Window()
		self.modify_win.set_title('Modify Bug #' + str(bugid))
		self.modify_win.set_default_size(800, 480)
		self.modify_win.connect("destroy", modifywin_destroy)

		menubar = gtk.Menu()
		menubar.show()
		for child in menubar.get_children():
			child.reparent(menu)
		self.modify_win.set_menu(menubar)
		
		if os.path.exists("/usr/share/mabugz/pixmaps/"):
			imgdir = "/usr/share/mabugz/pixmaps/"
		else:
			imgdir = "pixmaps/"	

		menu_send = gtk.ImageMenuItem("Send")		
		send_img = gtk.Image()
		send_img.set_from_file(imgdir + "gtk-send.png")
		menu_send.set_image(send_img)
		menu_send.show()
		menu_send.connect("activate", self.on_send_clicked, pybugz, bugid)

		menu_cancel = gtk.ImageMenuItem("Cancel")		
		cancel_img = gtk.Image()
		cancel_img.set_from_file(imgdir + "gtk-close.png")
		menu_cancel.set_image(cancel_img)
		menu_cancel.show()
		menu_cancel.connect("activate", modifywin_destroy)
		
		menubar.append(menu_send)
		menubar.append(menu_cancel)
				
		notebook = gtk.Notebook()
		
		scrolledwin = gtk.ScrolledWindow()
		if distro == 'chinook':
			if BugsSettings.Fingermenu == 'True':
				hildon.hildon_helper_set_thumb_scrollbar(scrolledwin, True)
		scrolledwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		scrolledwin.set_shadow_type(gtk.SHADOW_ETCHED_IN)

		view = gtk.TextView()
		self.buff_comment = view.get_buffer()
		view.set_wrap_mode(gtk.WRAP_WORD)
		view.set_editable(True)
		view.set_cursor_visible(True)
		
		scrolledwin.add(view)

		vbox = gtk.VBox()

		hbox1 = gtk.HBox()
		label1 = gtk.Label('URL')
		self.modify_url = gtk.Entry()
		hbox1.pack_start(label1, False, False, 0)
		hbox1.pack_start(self.modify_url, True, True, 0)
		vbox.pack_start(hbox1, True, True, 0)
		
		hbox2 = gtk.HBox()
		label2 = gtk.Label('Add CC')
		self.addcc = gtk.Entry()
		hbox2.pack_start(label2, False, False, 0)
		hbox2.pack_start(self.addcc, True, True, 0)
		vbox.pack_start(hbox2, True, True, 0)	
			
		hbox3 = gtk.HBox()
		label3 = gtk.Label('Remove CC')
		self.removecc = gtk.Entry()
		hbox3.pack_start(label3, False, False, 0)
		hbox3.pack_start(self.removecc, True, True, 0)
		vbox.pack_start(hbox3, True, True, 0)
		
		page1 = gtk.Label("Comment")
		notebook.append_page(scrolledwin, page1)
		
		page2 = gtk.Label("Options")
		notebook.append_page(vbox, page2)
		
		self.modify_win.add(notebook)
		self.modify_win.show_all()

	def on_send_clicked(self, widget, pybugz, bugid):
		self.pgbar = ProgressBar("Sending...", self.BugWindow)	
		thread.start_new_thread(self.on_send_modify, (pybugz, bugid))	
		
	def on_send_modify(self, pybugz, bugid):
		if (pybugz == None):
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error creating Bugzilla client, please check settings."))
			return
		startiter = self.buff_comment.get_start_iter()
		enditer = self.buff_comment.get_end_iter()
		try:
			comment = self.buff_comment.get_text(startiter, enditer, include_hidden_chars=1)
			if comment == '':
				comment = None
		except:
			comment = None
		try:
			url = self.modify_url.get_text()
			if url == '':
				url = None
		except:
			url = None

		add_cc = self.addcc.get_text()
		remove_cc = self.removecc.get_text()
		
		try:
			result = pybugz.modify(bugid, title = None, comment = comment, url = url, status = None, resolution = None, assigned_to = None, duplicate = 0, priority = None, severity = None, add_cc = [add_cc], remove_cc = [remove_cc], add_dependson = [], remove_dependson = [], add_blocked = [], remove_blocked = [], whiteboard = None, keywords = None)
			#print result
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_INFO, "Bug modified."))
			self.modify_win.destroy()
			return
		
		except:
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "An error occurred in modifying bug."))

	def on_save_clicked(self, widget):
		self.save_dlg = hildon.FileChooserDialog(self.BugWindow, gtk.FILE_CHOOSER_ACTION_SAVE)
		self.save_dlg.set_title("Save Bug")
		self.save_dlg.set_default_response(gtk.RESPONSE_OK)
		self.save_dlg.show()
		
		buffer = self.view.get_buffer()
		startiter = buffer.get_start_iter()
		enditer = buffer.get_end_iter()
		body = buffer.get_text(startiter, enditer, include_hidden_chars=1)
		
		response = self.save_dlg.run()
		if response == gtk.RESPONSE_OK:
			try:
				self.file = self.save_dlg.get_filename()
				saveFile = open(self.file, "w")
				saveFile.write(body)
				saveFile.close()
			except:				
				thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "An error occurred in saving file."))
		self.save_dlg.destroy()
		
	def on_get_attach_clicked(self, widget, bug_attachments, pybugz):		
		self.attachments_dlg = gtk.Dialog(title='Attachments', parent=None, flags=gtk.WIN_POS_CENTER, buttons=(gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))

		self.attachments_dlg.set_border_width(4)
		self.attachments_dlg.set_default_size(-1, 250)

		vbox1 = gtk.VBox(False, 8)

		sw = gtk.ScrolledWindow()
		sw.set_shadow_type(gtk.SHADOW_ETCHED_IN)
		sw.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
		vbox1.pack_start(sw)

		del attach_gets[:]
		del attach_list[:]
		self.GetAttachmentsList(bug_attachments)

		if attach_list == []:
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: No attachments."))
			return
		model = self.__attach_model()

		treeview = gtk.TreeView(model)
		treeview.set_rules_hint(True)
		if distro == 'chinook':
			pass
		else:
			treeview.set_property("allow-checkbox-mode", False)
		treeview.set_search_column(COLUMN_ATTACH)

		sw.add(treeview)

        # add columns to the tree view
		self.__attach_columns(treeview)

		self.attachments_dlg.vbox.pack_start(vbox1, True, True, 0)
		self.attachments_dlg.show_all()

		result = self.attachments_dlg.run()
		if (result==gtk.RESPONSE_OK):
			self.download_attachments(attach_gets, pybugz)

		self.attachments_dlg.destroy()

		return result
		
	def GetAttachmentsList(self, bug_attachments):
		try:
			#aid --> attachment id
			#desc --> attach name
			
			if len(bug_attachments) == 0:
				print 'No attachments'
				#Error dialog
			else:
				for attachment in bug_attachments:
					aid = attachment.find('.//attachid').text
					desc = attachment.find('.//desc').text
					c = (False, desc, aid)
					attach_list.append(c)
				return attach_list

		except:
			print 'error getting attachments list.'
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error getting attachment list."))


	def __attach_model(self):
		lstore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_STRING)
		
		for item in attach_list:
			iter = lstore.append()
			lstore.set(iter, COLUMN_FIXED, item[COLUMN_FIXED], COLUMN_ATTACH, item[COLUMN_ATTACH], COLUMN_AID, item[COLUMN_AID])
		return lstore

	def fixed_toggled(self, cell, path, model):
		iter = model.get_iter((int(path),))
		fixed = model.get_value(iter, COLUMN_FIXED)
		fixed = not fixed
		model.set(iter, COLUMN_FIXED, fixed)

		if fixed == True:
			a = model.get_value(iter, COLUMN_AID)
			attach_gets.append(a)
		elif fixed == False:
			b = model.get_value(iter, COLUMN_AID)
			numero = attach_gets.index(b)
			del attach_gets[numero]

	def __attach_columns(self, treeview):
		model = treeview.get_model()

		renderer = gtk.CellRendererToggle()
		renderer.connect('toggled', self.fixed_toggled, model)

		column = gtk.TreeViewColumn('Fixed', renderer, active=COLUMN_FIXED)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_fixed_width(50)
		treeview.append_column(column)

		column = gtk.TreeViewColumn('Description', gtk.CellRendererText(), text=COLUMN_ATTACH)
		treeview.append_column(column)
		
		column = gtk.TreeViewColumn('ID', gtk.CellRendererText(), text=COLUMN_AID)
		treeview.append_column(column)		
		
	def download_attachments(self, attach_gets, pybugz):
		self.attachments_dlg.destroy()
		self.down_dlg = hildon.FileChooserDialog(self.BugWindow, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
		self.down_dlg.set_title("Save Attachments")
		self.down_dlg.set_default_response(gtk.RESPONSE_OK)
		self.down_dlg.show()
			
		response = self.down_dlg.run()
		
		if response == gtk.RESPONSE_OK:
			download_dir = self.down_dlg.get_current_folder()
			thread.start_new_thread(self.__on_getting_attachments, (attach_gets, pybugz, download_dir))
			self.pgbar = ProgressBar("Download attachments", self.BugWindow)
			
		self.down_dlg.destroy()
		
	def __on_getting_attachments(self, attach_gets, pybugz, download_dir):
		try:
			for i in attach_gets:
				attachid = int(i)
				print 'Getting attachment %s' % attachid
				result = pybugz.attachment(attachid)
				if not result:
					print 'Unable to get attachment'
					thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "Error: Unable to get attachment."))

				safe_filename = os.path.basename(re.sub(r'\.\.', '', result['filename']))

				file_save = download_dir + '/' + safe_filename
				open(file_save, 'wb').write(result['fd'].read())
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_INFO, "Attachments downloaded."))			
		except:
			self.pgbar.stop_pg()
			thread.start_new_thread(MsgDialog, (gtk.MESSAGE_ERROR, "An error occurred in saving the file."))



class BugzillaSettings:
	"""This class holds the necessary bugzilla settings
	URL - The bugzilla URL
	Username - The username if were necessary
	Password - The password if were necessary
	Color - Color text of Bug textview
	Comments - Search in bugs' comments
	"""
	def __init__(self, URL="", Username="", Password="", Text_Color="blue", Comments="False", Fingermenu="True"):
		self.URL = URL
		self.Username = Username
		self.Password = Password
		self.Text_Color = Text_Color
		self.Comments = Comments
		self.Fingermenu = Fingermenu

	def create_bugzilla_client(self):
		"""Quick helper routine used to create the bugzilla
		client"""
		# prepare client object
		try:
			if self.Username == '':
				pybugz = bugz.Bugz(self.URL, None, None, False, False)
			else:
				pybugz = bugz.Bugz(self.URL, self.Username, self.Password, False, False)
		except:
			return None

		return pybugz

class Credits:
	def __init__(self, widget):
		dialog = gtk.AboutDialog()
		dialog.set_name("Mabugz")
		dialog.set_version("0.0.3")
		dialog.set_copyright("Copyright © 2007")
		dialog.set_website("https://garage.maemo.org/projects/mabugz/")
		dialog.set_authors(["Daniel Martín Yerga <dyerga@gmail.com>", "", "PyBugz module written by:", "Alastair Tse <alastair@liquidx.net>"])
		dialog.set_artists(["Mabugz logo by Daniel Martin Yerga", "Icons from Gartoon Iconset. GPL License."])
		try:
 			logo = gtk.gdk.pixbuf_new_from_file("/usr/share/mabugz/pixmaps/logo.png")
		except:
			logo = gtk.gdk.pixbuf_new_from_file("pixmaps/logo.png")
		dialog.set_logo(logo)
		dialog.set_license("This program is released under the GNU\nGeneral Public License. Please visit \nhttp://www.gnu.org/copyleft/gpl.html\nfor details.")
		dialog.run()
		dialog.destroy()

class ProgressBar:
	def __init__(self, pg_text, window):
		if os.path.exists("/usr/share/mabugz/progressbar.glade"):
			self.prog_file = "/usr/share/mabugz/progressbar.glade"
		else:
			self.prog_file = "progressbar.glade"
			
		self.progTree = gtk.glade.XML(self.prog_file)
		self.w = self.progTree.get_widget("dialog1")
		self.w.set_transient_for(window)
		self.progress = self.progTree.get_widget("progressbar1")

		self.progress.set_text(pg_text)

		self.cancel_but = self.progTree.get_widget("button1")		
		self.cancel_but.connect("clicked", self.cancel_prog)
		
		self.w.show_all()
		self.active = True
		self.progress.pulse()
		self.timeout_cb = gobject.timeout_add(200, self.increment)

	def stop_pg(self):
		self.active = False
		self.w.destroy()

	def increment(self):        
		if not self.active:
            # we were disabled, so stop pulsating
			return False
		self.progress.pulse()
		return True
		
	def cancel_prog(self, widget):
		self.stop_pg()
		global parar
		parar = True
		hildon.hildon_banner_show_information(widget, 'qgn_note_infoprint', 'Stopping')


class MsgDialog:
	def __init__(self, type, msg):
		msg_dlg = gtk.MessageDialog(type=type, message_format=msg, buttons=gtk.BUTTONS_CLOSE)
		msg_dlg.set_modal(True)
		gtk.gdk.threads_enter()
		msg_dlg.run()
		gtk.gdk.threads_leave()
		msg_dlg.destroy()

class Preferences:
	def __init__(self):	
		self.acctree=gtk.glade.XML(preferences_glade)
		self.Preferences_win = self.acctree.get_widget("window1")
		self.Preferences_win.set_size_request(600, 400)
		self.Preferences_win.set_title("Preferences")
			
		del cuentas[:]
		self.GetAccounts()	
			
		self.model = self.__accounts_model()
		
		treeview = self.acctree.get_widget("treeview1")
		if distro == 'chinook':
			pass
		else:
			treeview.set_property("allow-checkbox-mode", False)
		treeview.set_headers_visible(True)
		treeview.set_rules_hint(True)
		treeview.set_model(self.model)
		treeview.connect("button-press-event", self.on_button_press, treeview)
		
		self.__accounts_columns(treeview)
		
		button1 = self.acctree.get_widget("button1")
		button1.connect("clicked", self.on_add_clicked, treeview, False)
		
		button5 = self.acctree.get_widget("button5")
		button5.connect("clicked", self.on_modify_clicked, treeview)
		
		####si no seleccionado desactivar edit y delete
		button2 = self.acctree.get_widget("button2")
		button2.connect("clicked", self.on_delete_clicked, treeview)		
		
		button3 = self.acctree.get_widget("button3")
		button3.connect("clicked", self.close_preferences)
	
		
		#### Others tab ####
		self.color_button = gtk.ColorButton()
		try:
			get_gdk_color = gtk.gdk.color_parse(BugsSettings.Text_Color)
			self.color_button.set_color(get_gdk_color)
		except:
			get_gdk_color = gtk.gdk.color_parse("#0000FE")
			self.color_button.set_color(get_gdk_color)

		hbox5 = self.acctree.get_widget("hbox5")
		hbox5.pack_start(self.color_button, False, False, 0)
		hbox5.reorder_child(self.color_button, 1)

		self.comm_button = self.acctree.get_widget("checkbutton2")				
		self.menufinger = self.acctree.get_widget("checkbutton1")

		if distro == 'chinook':
			pass
		else:
			self.menufinger.set_sensitive(False)

		if BugsSettings.Comments == 'True':
			self.comm_button.set_active(True)
		else:
			self.comm_button.set_active(False)		

		if BugsSettings.Fingermenu == 'True':
			self.menufinger.set_active(True)
		else:
			self.menufinger.set_active(False)
		
		self.Preferences_win.show_all()

	def on_button_press(self, widget, event, treeview):
		if event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
			self.on_modify_clicked(widget, treeview)
	
	def close_preferences(self, widget):
		text_color = gtk.color_selection_palette_to_string([self.color_button.get_color()])

		BugsSettings.Text_Color = text_color
		BugsSettings.Comments = str(self.comm_button.get_active())
		BugsSettings.Fingermenu = str(self.menufinger.get_active())

		settings_file=open('/home/user/.mabugz/settings.conf', 'w')	
		config.set("Settings", "fingerscroll", str(self.menufinger.get_active()))
		config.set("Settings", "comments", str(self.comm_button.get_active()))
		config.set("Settings", "text_color", text_color)
	
		config.write(settings_file)
		settings_file.close()
		
		self.Preferences_win.destroy()
		
	def __accounts_model(self):
		lstore = gtk.ListStore(gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING)
		
		for item in cuentas:
			iter = lstore.append()
			lstore.set(iter, ENABLED, item[ENABLED], TITLE, item[TITLE], URL, item[URL], USER, item[USER], PASS, item[PASS])
		return lstore
		
	def __accounts_columns(self, treeview):
		renderer = gtk.CellRendererToggle()
		renderer.connect("toggled", self.on_toggled_fixed)
		#column for enabled
		column = gtk.TreeViewColumn('Enabled', renderer, active=ENABLED)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_fixed_width(105)
		treeview.append_column(column)

        # column for title
		column = gtk.TreeViewColumn('Account', gtk.CellRendererText(), text=TITLE)
		column.set_property("expand", True)
		treeview.append_column(column)
		
        # column for url
		column = gtk.TreeViewColumn('URL', gtk.CellRendererText(), text=URL)
		column.set_property("expand", True)
		treeview.append_column(column)

        # column for user
		column = gtk.TreeViewColumn('User', gtk.CellRendererText(), text=USER)
		column.set_property("expand", True)
		treeview.append_column(column)
		
        # column for password
		column = gtk.TreeViewColumn('Password', gtk.CellRendererText(), text=PASS)
		column.set_property("visible", False)
		treeview.append_column(column)

	def on_toggled_fixed(self, cell, path):
		title, fixed, iter = self.make_default(path)
		
		if fixed == True or not fixed:
			newtitle = self.model.get_value(iter, TITLE)
			
			for i in cuentas:
				if str(i).find('True') >= 0:
					indice = cuentas.index(i)
				elif str(i).find(newtitle) >= 0:
					true_indice  = cuentas.index(i)
				
			try:
				if str(newtitle) == cuentas[indice][1]:
					#print 'iguales.'
					#print cuentas
					return
			except:
				pass
					
			if cuentas == [] or len(cuentas) == 1:
				pass
				
			else:
				try:
					old_default_acc = cuentas[indice]
					##(enabled, title, url, user, pass)
					old_default_title = old_default_acc[1]
					old_def_url = old_default_acc[2]
					old_def_user = old_default_acc[3]
					old_def_pass = old_default_acc[4]

					old_default_acc = (False, old_default_title, old_def_url, old_def_user, old_def_pass)
					#print 'def false acc modifi: ', old_default_acc
					cuentas[indice] = old_default_acc

					new_default_acc = cuentas[true_indice]
					##(enabled, title, url, user, pass)
					new_default_title = new_default_acc[1]
					new_def_url = new_default_acc[2]
					new_def_user = new_default_acc[3]
					new_def_pass = new_default_acc[4]

					new_default_acc = (True, new_default_title, new_def_url, new_def_user, new_def_pass)
					
					BugsSettings.URL = new_def_url
					BugsSettings.Username = new_def_user
					BugsSettings.Password = new_def_pass 
					#print 'NUEVOS SETTINGS: %s %s %s' % (BugsSettings.URL, BugsSettings.Username, BugsSettings.Password)
					
					#print 'def true acc modifi: ', new_default_acc
					cuentas[true_indice] = new_default_acc
				except:
					print 'bad thing occurred.'
			
			#print cuentas
			
			accounts_file=open('/home/user/.mabugz/accounts.conf', 'w')
			for title_account in accounts.sections():
				accounts.set(title_account, "enabled", 'False')
			accounts.set(newtitle, "enabled", 'True')
			accounts.write(accounts_file)
			accounts_file.close()

	def make_default(self, path):
		for i in range(len(self.model)):
			newiter = self.model.get_iter((int(i),))
			newfixed = self.model.get_value(newiter, ENABLED)
			newfixed = not newfixed
			self.model.set(newiter, ENABLED, False)	
		
		if path == None:
			if len(self.model)-1 >= 0:
				one_iter = self.model.get_iter((int(len(self.model)-1),))
				fixed = self.model.get_value(one_iter, ENABLED)
				fixed = not fixed
				self.model.set(one_iter, ENABLED, fixed)
				new_default_title = self.model.get_value(one_iter, TITLE)
			else:
				new_default_title = None
				fixed = None
				one_iter = None
		else:		
			one_iter = self.model.get_iter((int(path),))
			fixed = self.model.get_value(one_iter, ENABLED)
			fixed = not fixed
			self.model.set(one_iter, ENABLED, fixed)
			new_default_title = None	
			
		return new_default_title, fixed, one_iter
			
	def GetAccounts(self):
		for section in accounts.sections():
			title = section
			enabled = accounts.get(section, "enabled")
			if enabled == 'True':
				enabled = True
			elif enabled == 'False':
				enabled = False		
			url = accounts.get(section, "url")
			user = accounts.get(section, "user")
			password = accounts.get(section, "password")
			account = (enabled, title, url, user, password)
			cuentas.append(account)
		#print 'obtengo accounts: ', cuentas
		
	def on_add_clicked(self, widget, treeview, modify):
		self.acctree=gtk.glade.XML(preferences_glade)
		add_dialog  = self.acctree.get_widget("dialog1")
		add_dialog.set_transient_for(self.Preferences_win)
		add_dialog.add_buttons("Save", gtk.RESPONSE_OK, "Cancel", gtk.RESPONSE_CLOSE)
		
		title = self.acctree.get_widget("entry1")
		url = self.acctree.get_widget("entry2")
		user = self.acctree.get_widget("entry3")
		password = self.acctree.get_widget("entry4")
		
		if modify == True:
			add_dialog.set_title('Modify account')
			title.set_text(self.modify_title)
			url.set_text(self.modify_url)
			user.set_text(self.modify_user) 
			password.set_text(self.modify_password)
				
		acc_gtkwindow = self.acctree.get_widget("window1")
		acc_gtkwindow.destroy()	
		
		add_dialog.show_all()
		result = add_dialog.run()
		
		if (result==gtk.RESPONSE_OK):
			self.set_new_account(treeview, title, url, user, password, False)
			
		add_dialog.destroy()
		
		return result

	def set_new_account(self, treeview, title, url, user, password, modify):
		if modify == False:
			#print 'no modify'
			newtitle = title.get_text()
			newurl = url.get_text()
			newuser = user.get_text()
			newpassword = password.get_text()
		elif modify == True:
			#print 'modify'
			newtitle = self.modify_title
			newurl = self.modify_url
			newuser = self.modify_user
			newpassword = self.modify_password
		
		newaccount = (True, newtitle, newurl, newuser, newpassword) 
		#print 'new:', newaccount
		#print 'acc:', cuentas
		BugsSettings.URL = newurl
		BugsSettings.Username = newuser
		BugsSettings.Password = newpassword
		#print 'NUEVOS SETTINGS: %s %s %s' % (BugsSettings.URL, BugsSettings.Username, BugsSettings.Password)
		
		for i in cuentas:
			if str(i).find('True') >= 0:
				indice = cuentas.index(i)
				
		if cuentas == []:
			pass
		else:
			old_default_acc = cuentas[indice]
			##(enabled, title, url, user, pass)
			old_default_title = old_default_acc[1]
			old_def_url = old_default_acc[2]
			old_def_user = old_default_acc[3]
			old_def_pass = old_default_acc[4]
		 
			old_default_acc = (False, old_default_title, old_def_url, old_def_user, old_def_pass)
			#print 'def acc modifi: ', old_default_acc
			cuentas[indice] = old_default_acc

		cuentas.append(newaccount)
		#print cuentas
		
		self.model = self.__accounts_model()
		treeview.set_model(self.model)
		
		##poner default a una nada mas
		self.make_default(None)

		accounts_file=open('/home/user/.mabugz/accounts.conf', 'w')
		try:
			for title_account in accounts.sections():
				accounts.set(title_account, "enabled", 'False')
			accounts.add_section(newtitle)
			accounts.set(newtitle, "enabled", 'True')
			accounts.set(newtitle, "url", newurl)
			accounts.set(newtitle, "user", newuser)
			accounts.set(newtitle, "password", newpassword)
			accounts.write(accounts_file)
			accounts_file.close()
		except ConfigParser.NoOptionError, e:
			print e
		except ConfigParser.NoSectionError, e:
			self.write_default_accounts(accounts_file)


	def write_initial_accounts(self, accounts_file):
		accounts.add_section("Example")
		##false o true???
		accounts.set(newtitle, "enabled", 'False')
		accounts.set(newtitle, "url", 'http://bugzilla.example.com')
		accounts.set(newtitle, "user", 'user')						
		accounts.set(newtitle, "password", 'password')
		accounts.write(accounts_file)
		accounts_file.close()	

	def on_delete_clicked(self, widget, treeview):		
		selection = treeview.get_selection()
		hele, iter = selection.get_selected()
		if iter:
			title = self.model.get_value(iter, TITLE)
			enabled = self.model.get_value(iter, ENABLED)
			url = self.model.get_value(iter, URL)
			user = self.model.get_value(iter, USER)
			password = self.model .get_value(iter, PASS)

		if enabled == True:
			delaccount = (True, title, url, user, password)
		elif enabled == False:
			delaccount = (False, title, url, user, password)
			
		#print 'delaccount: ', delaccount
		#print 'accounts: ', cuentas
		cuentas.remove(delaccount)
		#print 'final accounts: ', cuentas
		
		#recrear el treeview
		self.model = self.__accounts_model()
		treeview.set_model(self.model)
			
		new_default_title, afixed, aniter = self.make_default(None)
		if new_default_title == None:
			pass
		else:
			#print new_default_title

			for i in cuentas:
				if str(i).find(new_default_title) >= 0:
					indice = cuentas.index(i)

			new_default_acc = cuentas[indice]
			#print 'default acc sin modifi: ', new_default_acc
			##(enabled, title, url, user, pass)
			new_def_url = new_default_acc[2]
			new_def_user = new_default_acc[3]
			new_def_pass = new_default_acc[4]
		 
			new_default_acc = (True, new_default_title, new_def_url, new_def_user, new_def_pass)
			#print 'def acc modifi: ', new_default_acc
			cuentas[indice] = new_default_acc
			#print 'accounts modifi: ', cuentas
				
			BugsSettings.URL = new_def_url
			BugsSettings.Username = new_def_user
			BugsSettings.Password = new_def_pass 
			#print 'NUEVOS SETTINGS: %s %s %s' % (BugsSettings.URL, BugsSettings.Username, BugsSettings.Password)
		
		accounts_file=open('/home/user/.mabugz/accounts.conf', 'w')
		try:
			for title_account in accounts.sections():
				accounts.set(title_account, "enabled", 'False')
			accounts.set(new_default_title, "enabled", 'True')
			accounts.remove_section(title)	
			accounts.write(accounts_file)
			accounts_file.close()
		except ConfigParser.NoOptionError, e:
			print e
		except ConfigParser.NoSectionError, e:
			print e
			
	def on_modify_clicked(self, widget, treeview):		
		selection = treeview.get_selection()
		hele, iter = selection.get_selected()
		if iter:
			self.modify_title = self.model.get_value(iter, TITLE)
			enabled = self.model.get_value(iter, ENABLED)
			self.modify_url = self.model.get_value(iter, URL)
			self.modify_user = self.model.get_value(iter, USER)
			self.modify_password = self.model .get_value(iter, PASS)

		if enabled == True:
			delaccount = (True, self.modify_title,self.modify_url,self.modify_user, self.modify_password)
		elif enabled == False:
			delaccount = (False, self.modify_title, self.modify_url, self.modify_user, self.modify_password)
		cuentas.remove(delaccount)
		
		self.model = self.__accounts_model()
		new_default_title, afixed, aniter = self.make_default(None)
		if new_default_title == None:
			pass
		else:
			#print new_default_title

			for i in cuentas:
				if str(i).find(new_default_title) >= 0:
					indice = cuentas.index(i)

			new_default_acc = cuentas[indice]
			#print 'default acc sin modifi: ', new_default_acc
			##(enabled, title, url, user, pass)
			new_def_url = new_default_acc[2]
			new_def_user = new_default_acc[3]
			new_def_pass = new_default_acc[4]
		 
			new_default_acc = (True, new_default_title, new_def_url, new_def_user, new_def_pass)
			#print 'def acc modifi: ', new_default_acc
			cuentas[indice] = new_default_acc
			#print 'accounts modifi: ', cuentas
				
			BugsSettings.URL = new_def_url
			BugsSettings.Username = new_def_user
			BugsSettings.Password = new_def_pass 
			#print 'NUEVOS SETTINGS: %s %s %s' % (BugsSettings.URL, BugsSettings.Username, BugsSettings.Password)
		
		accounts_file=open('/home/user/.mabugz/accounts.conf', 'w')
		try:
			accounts.remove_section(self.modify_title)	
			accounts.write(accounts_file)
			accounts_file.close()
		except ConfigParser.NoOptionError, e:
			print e
		except ConfigParser.NoSectionError, e:
			print e	
		
		result = self.on_add_clicked(widget, treeview, True)
		
		if (result==gtk.RESPONSE_CLOSE):
			self.set_new_account(treeview, self.modify_title, self.modify_url, self.modify_user, self.modify_password, True)


if __name__ == "__main__":
	BugsSettings = BugzillaSettings()
	PyBugz()
	gtk.gdk.threads_enter()
	gtk.main()
	gtk.gdk.threads_leave()
