#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import os
import threading

import gobject
import gtk
gtk.gdk.threads_init()
import gtk.glade
import datetime
import mcalendar_sync
import mcalendar_framework
import mcalendar_prefs
import dateutil
import pango
import time
import agenda_view

try:
  import hildon
  IS_MAEMO = True
except ImportError:
  IS_MAEMO = False

def ask_dialogue(win,message):
  dialog = gtk.MessageDialog(win,
                  gtk.DIALOG_MODAL,
                  gtk.MESSAGE_QUESTION,
                  gtk.BUTTONS_YES_NO,
                  message)
  rc = dialog.run ()
  dialog.destroy ()

  if rc == gtk.RESPONSE_YES:
    return True
  else:
    return False

class mCalendar(object):

  __pretty_app_name__ = "mCalendar"
  __app_name__ = "mcalendar"
  __version__ = "0.5.7"

  _glade_files = [
#    'ui/mcalendar.glade',
    '/usr/lib/mcalendar/ui/mcalendar.glade',
  ]

  def __init__(self):
    import hildon
    self._callbackList = None
    global IS_MAEMO
    for path in mCalendar._glade_files:
      if os.path.isfile(path):
        self._widgetTree = gtk.glade.XML(path)
        break
    else:
      #self.display_error_message("Cannot find mcalendar.glade")
#     gtk.main_quit()
      return


    #Get the buffer associated with the number display
    self._window = self._widgetTree.get_widget("MainWin")

    self._app = None
    self._isFullScreen = False
    if (IS_MAEMO == True) and (self._window is gtk.Window):
      print "Hildon installed but glade file not updated to work with hildon"
  #    hildon = None
    elif IS_MAEMO == True:
      gtk.set_application_name(mCalendar.__pretty_app_name__)
      self._app = hildon.Program()
      self._window = hildon.Window()
#      self._window.set_border_width(0)
      self._widgetTree.get_widget("ToHildonize").reparent(self._window)
      self._app.add_window(self._window)

    self._window.show()
    threading.Thread(target=self._launched).start()

  def _launched(self):
    global IS_MAEMO
    gtk.gdk.threads_enter()    
    if IS_MAEMO == True:
      hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('ScrolledView'),True)
#      hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('ScrolledDetails'),True)
      hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('ScrolledJournal'),True)
      self._window.connect("key-press-event", self._on_key_press)
      self._window.connect("window-state-event", self._on_window_state_change)

    if IS_MAEMO == True:
      self._window.set_title("mCalendar")
    else:
      self._window.set_title("%s" % self.__pretty_app_name__)

    callbackMapping = {
      # View Signal
      "on_bPrevious_clicked": self._previous_current_datetime,
      "on_bNext_clicked": self._next_current_datetime,
      #"on_ViewButton_clicked": self._quick_view,
      "on_TodayButton_clicked": self._quick_day_view,
      "on_WeekButton_clicked": self._quick_week_view,
      "on_MonthButton_clicked": self._quick_month_view,
      "on_BackButton_clicked": self._cancel,
      "on_ValidateButton_clicked": self._validate,

#      "on_bSearch_clicked": self._quick_search,
      "on_AddButton_clicked": self._add_event,
      # Datetime Picker Signal
#      "on_picker_minute_value_changed":self._datetimepicker_value_changed,
#      "on_picker_hour_value_changed":self._datetimepicker_value_changed,
#      "on_bPickerNextHours_clicked": self._datetimepicker_next_hour,
#      "on_bPickerPreviousHours_clicked": self._datetimepicker_previous_hour,
#      "on_bPickerNextMinutes_clicked": self._datetimepicker_next_minute,
#      "on_bPickerPreviousMinutes_clicked": self._datetimepicker_previous_minute,
      #Editor Signal
      "on_bSetStartDatetime_clicked": self._eventeditor_set_start,
      "on_bSetEndDatetime_clicked": self._eventeditor_set_end,
      "on_bSetUntil_clicked": self._eventeditor_set_until,
      "on_DeleteButton_clicked": self._eventeditor_delete,
      "on_InfoButton_clicked": self._eventeditor_show_more,
      #Show logs
      "on_LogButton_clicked":self._show_journal,
      "on_bRefreshJournal_clicked":self._refresh_journal,
      # Reccurence Editor Signal
      # "on_bCancel_Recurrency_clicked":self._recurrenceeditor_cancel,
      # "on_bOK_Recurrency_clicked":self._recurrenceeditor_validate,
      # "on_bUntil_clicked":self._recurrenceeditor_set_until,
      # Alarm Editor Signal
      # "on_bCancel_Alarm_clicked":self._alarmeditor_cancel,
      # "on_bOK_Alarm_clicked":self._alarmeditor_validate,
      "on_bDelete_Alarm_clicked":self._eventeditor_alarm_delete,
      "on_bAdd_Alarm_clicked":self._eventeditor_alarm_new,
      # Attendee Editor Signal
      # "on_bCancel_Attendees_clicked":self._attendeeeditor_cancel,
      # "on_bOK_Attendees_clicked":self._attendeeeditor_validate,
      "on_bDelete_Attendee_clicked":self._eventeditor_attendee_delete,
      "on_bAdd_Attendee_clicked":self._eventeditor_attendee_new,

    }
    self._widgetTree.signal_autoconnect(callbackMapping) 
    gtk.gdk.threads_leave()

    #load prefs
    self._prefs = mcalendar_prefs.mPrefs()

    #curent_virtual_win
    #0 -> View
    #1 -> Editor
    #2 -> DatePicker
    #3 -> Logs
    self._current_virtual_win = 0
    self._previous_virtual_win = 0
#    self._update_virtual(0)

    #current_view
    #0 -> day
    #1 -> week
    #2 -> month
    #3 -> month grid
    #4 -> week grid
    self._current_view = self._prefs.get_int_value('default_current_view')    
    self._current_datetime = datetime.datetime.now()

    gtk.gdk.threads_enter()
    if self._window:
      self._window.connect("delete-event", self._win_closebox)
    threading.Thread(target=self._idle_setup).start()
    self.timer = gobject.timeout_add(5000, self._update_sync_progress)
    gtk.gdk.threads_leave()

  def _cancel(self,widget):
    if self._current_virtual_win == 1:
      self._eventeditor_cancel(widget)
    elif self._current_virtual_win == 2:
      self._datetimepicker_cancel(widget)

  def _validate(self,widget):
    if self._current_virtual_win == 1:
      self._eventeditor_validate(widget)
    elif self._current_virtual_win == 2:
      self._datetimepicker_validate(widget)

  def _datetimepicker_validate(self,widget):
    if self._previous_virtual_win == 0:
      year,month,day = self._widgetTree.get_widget("picker_calendar").get_date()
      month = month + 1
      self._current_datetime = datetime.date(year,month,day)
      self._update_current_datetime()
      self._load_eventslist_bg()
    elif self._previous_virtual_win == 1:
      year,month,day = self._widgetTree.get_widget("picker_calendar").get_date()
      month = month + 1
      hour = self._datetimepicker_hour.get_active()
      minute = self._datetimepicker_minute.get_active()*5
      if self._datetimepicker_selector == 'start':
        self._eventeditor_event.start_datetime = datetime.datetime(year,month,day,hour,minute)
        self._eventeditor_event.start_datetime = self._eventeditor_event.start_datetime.replace(tzinfo=dateutil.tz.tzlocal())
        self._eventeditor_edit_start_datetime.set_text(mcalendar_framework.convert_for_display(self._eventeditor_event.start_datetime,'%a %x %X'))
        self._eventeditor_check_datetime()
      elif self._datetimepicker_selector == 'end':
        self._eventeditor_event.end_datetime = datetime.datetime(year,month,day,hour,minute)
        self._eventeditor_event.end_datetime = self._eventeditor_event.end_datetime.replace(tzinfo=dateutil.tz.tzlocal())
        self._eventeditor_edit_end_datetime.set_text(mcalendar_framework.convert_for_display(self._eventeditor_event.end_datetime,'%a %x %X'))
        self._eventeditor_check_datetime()
      elif self._datetimepicker_selector == 'until':
        self._eventeditor_event.until_datetime = datetime.datetime(year,month,day,hour,minute)
        self._eventeditor_event.until_datetime = self._eventeditor_event.until_datetime.replace(tzinfo=dateutil.tz.tzlocal())
        self._eventeditor_edit_until.set_text(mcalendar_framework.convert_for_display(self._eventeditor_event.until_datetime,'%a %x'))
      elif self._datetimepicker_selector == 'alarm':
        hour = self._datetimepicker_hour.get_interval()
        minute = self._datetimepicker_minute.get_value()*5
        self._alarmsList.append(('',mcalendar_framework.convert_for_display(datetime.datetime(year,month,day,hour,minute,0,tzinfo=dateutil.tz.tzlocal()),'%a %x %X')))
    self._update_virtual(self._previous_virtual_win)

  def _datetimepicker_cancel(self,widget):
    self._update_virtual(self._previous_virtual_win)

  def _update_virtual(self,num):
    self._previous_virtual_win = self._current_virtual_win
    self._current_virtual_win = num

    if self._current_virtual_win == 0:
      self._widgetTree.get_widget("VirtualView").show()
#      self._widgetTree.get_widget("datemover").hide()
      self._widgetTree.get_widget("VirtualEdit").hide()
      self._widgetTree.get_widget("VirtualLogs").hide()
      self._widgetTree.get_widget("VirtualPicker").hide()
      self._widgetTree.get_widget("AddButton").show()
      self._widgetTree.get_widget("BackButton").hide()
      self._widgetTree.get_widget("ValidateButton").hide()
      self._widgetTree.get_widget("InfoButton").hide()
      self._widgetTree.get_widget("SearchButton").hide()
      self._widgetTree.get_widget("TodayButton").show()
      self._widgetTree.get_widget("WeekButton").show()
      self._widgetTree.get_widget("MonthButton").show()
      self._widgetTree.get_widget("ViewButton").hide()
      self._widgetTree.get_widget("DeleteButton").hide()
      self._widgetTree.get_widget("bNext").show()
      self._widgetTree.get_widget("bPrevious").show()
      self._update_virtual_view(0)
    elif self._current_virtual_win == 1:
      self._widgetTree.get_widget("VirtualView").hide()
      self._widgetTree.get_widget("VirtualEdit").show()
      self._widgetTree.get_widget("VirtualLogs").hide()
      self._widgetTree.get_widget("VirtualPicker").hide()
      self._widgetTree.get_widget("AddButton").hide()
      self._widgetTree.get_widget("BackButton").show()
      self._widgetTree.get_widget("ValidateButton").show()
      self._widgetTree.get_widget("InfoButton").hide()
      self._widgetTree.get_widget("SearchButton").hide()
      self._widgetTree.get_widget("TodayButton").hide()
      self._widgetTree.get_widget("WeekButton").hide()
      self._widgetTree.get_widget("MonthButton").hide()
      self._widgetTree.get_widget("ViewButton").hide()
      self._widgetTree.get_widget("DeleteButton").show()
      self._widgetTree.get_widget("bNext").hide()
      self._widgetTree.get_widget("bPrevious").hide()
    elif self._current_virtual_win == 2:
      self._widgetTree.get_widget("VirtualView").hide()
      self._widgetTree.get_widget("VirtualEdit").hide()
      self._widgetTree.get_widget("VirtualLogs").hide()
      self._widgetTree.get_widget("VirtualPicker").show_all()
      self._widgetTree.get_widget("AddButton").hide()
      self._widgetTree.get_widget("BackButton").show()
      self._widgetTree.get_widget("ValidateButton").show()
      self._widgetTree.get_widget("InfoButton").hide()
      self._widgetTree.get_widget("SearchButton").hide()
      self._widgetTree.get_widget("TodayButton").hide()
      self._widgetTree.get_widget("WeekButton").hide()
      self._widgetTree.get_widget("MonthButton").hide()
      self._widgetTree.get_widget("ViewButton").hide()
      self._widgetTree.get_widget("DeleteButton").hide()
      self._widgetTree.get_widget("bNext").hide()
      self._widgetTree.get_widget("bPrevious").hide()
#      self._widgetTree.get_widget("picker_calendar").modify_font(pango.FontDescription('Monospace 24'))
    elif self._current_virtual_win == 3:
      self._widgetTree.get_widget("VirtualView").hide()
      self._widgetTree.get_widget("VirtualEdit").hide()
      self._widgetTree.get_widget("VirtualPicker").hide()
      self._widgetTree.get_widget("VirtualLogs").show()
      self._widgetTree.get_widget("AddButton").hide()
      self._widgetTree.get_widget("BackButton").show()
      self._widgetTree.get_widget("ValidateButton").hide()
      self._widgetTree.get_widget("InfoButton").hide()
      self._widgetTree.get_widget("SearchButton").hide()
      self._widgetTree.get_widget("TodayButton").hide()
      self._widgetTree.get_widget("WeekButton").hide()
      self._widgetTree.get_widget("MonthButton").hide()
      self._widgetTree.get_widget("ViewButton").hide()
      self._widgetTree.get_widget("DeleteButton").hide()
      self._widgetTree.get_widget("bNext").hide()
      self._widgetTree.get_widget("bPrevious").hide()

  def _win_cancel(self):
    if self._current_virtual_win == 2:
      self._update_virtual(self._previous_virtual_win)
    elif self._current_virtual_win == 1:
      self._eventeditor_cancel(self)
    elif self._current_virtual_win == 3:
      self._update_virtual(self._previous_virtual_win)

  def _win_closebox(self,widget,data):
    if (self._current_virtual_win == 0):
      self._window.destroy()
      gobject.source_remove(self.timer)
      self.timer = None
      gtk.main_quit()
      return False
    else:
      self._win_cancel()
      return True

  def _journal_window_closebox(self,widget,data):
    self._journal_window.hide()
    return True

#  def _datetimepicker_value_changed(self,widget):
#    h = int(self._datetimepicker_hour.get_value())
#    m = int(self._datetimepicker_minute.get_value())
#    self._datetimepicker_label.set_markup('<b>'+str(h)+':'+str(m)+'</b>')

#  def _datetimepicker_next_hour(self,widget):
#    h = int(self._datetimepicker_hour.get_text())
#    h = h + 1
#    if h>23:
#      h = 0
#    self._datetimepicker_hour.set_text(str(h))
#
#  def _datetimepicker_previous_hour(self,widget):
#    h = int(self._datetimepicker_hour.get_text())
#    h = h - 1
#    if h<0:
#      h = 23
#    self._datetimepicker_hour.set_text(str(h))
#
#  def _datetimepicker_next_minute(self,widget):
#    m = int(self._datetimepicker_minute.get_text())
#    m = (m + 5) - ((m + 5) % 5)
#    if m>59:
#      m = 0
#    self._datetimepicker_minute.set_text(str(m))
#
#  def _datetimepicker_previous_minute(self,widget):
#    m = int(self._datetimepicker_minute.get_text())
#    m = (m - 5) + ((m - 5) % 5)
#    if m<0:
#      m = 55
#    self._datetimepicker_minute.set_text(str(m))

  def _update_virtual_view(self,view_num):
    self._current_view = view_num
    self._load_eventslist_bg()
    if (self._current_view==0):
      self._widgetTree.get_widget("listView").show()
      self._graphicView.hide()
#      self._widgetTree.get_widget("weekView").hide()
#      self._widgetTree.get_widget("monthView").hide()
    elif (self._current_view==1):
      self._widgetTree.get_widget("listView").show()
      self._graphicView.hide()
#      self._widgetTree.get_widget("weekView").hide()
#      self._widgetTree.get_widget("monthView").hide()
    elif (self._current_view==2):
      self._widgetTree.get_widget("listView").show()
      self._graphicView.hide()
#      self._widgetTree.get_widget("weekView").hide()
#      self._widgetTree.get_widget("monthView").hide()
    elif (self._current_view==3):
      self._widgetTree.get_widget("listView").hide()
#      self._widgetTree.get_widget("weekView").hide()
#      self._widgetTree.get_widget("monthView").show()
      self._graphicView.show()
      print 'show graphicView !!!'
      self._graphicView.queue_draw()

    elif (self._current_view==4):
      self._widgetTree.get_widget("listView").hide()
      self._graphicView.show()
      print 'show graphicView !!!'
      self._graphicView.queue_draw()

#      self._widgetTree.get_widget("weekView").show()
#      self._widgetTree.get_widget("monthView").hide()
    self._update_current_datetime()

  def _quick_jump(self,date):
    self._current_datetime = date
    threading.Thread(target=self._update_virtual_view,args=[0]).start()

  def _quick_day_view(self,widget):
    self._current_datetime = datetime.datetime.now()
    threading.Thread(target=self._update_virtual_view,args=[0]).start()

  def _quick_week_view(self,widget):
    self._current_datetime = datetime.datetime.now()
    if self._prefs_grid_week_view()==True:
#      self._update_virtual_view(4)
      threading.Thread(target=self._update_virtual_view,args=[4]).start()
    else:
      threading.Thread(target=self._update_virtual_view,args=[1]).start()

  def _quick_month_view(self,widget):
      self._current_datetime = datetime.datetime.now()
      if self._prefs_grid_month_view()==True:
        threading.Thread(target=self._update_virtual_view,args=[3]).start()
#        self._update_virtual_view(3)
      else:
        threading.Thread(target=self._update_virtual_view,args=[2]).start()

  def _quick_view(self,widget):
    if self._current_view==0:
      if self._prefs_grid_week_view()==True:
        threading.Thread(target=self._update_virtual_view,args=[4]).start()
#        self._update_virtual_view(4)
      else:
        threading.Thread(target=self._update_virtual_view,args=[1]).start()
#        self._update_virtual_view(1)
    elif (self._current_view==1) or (self._current_view==4):
      if self._prefs_grid_month_view()==True:
        threading.Thread(target=self._update_virtual_view,args=[3]).start()
#        self._update_virtual_view(3)
      else:
        threading.Thread(target=self._update_virtual_view,args=[2]).start()
#        self._update_virtual_view(2)
    elif (self._current_view==2) or (self._current_view==3):
      threading.Thread(target=self._update_virtual_view,args=[0]).start()
#      self._update_virtual_view(0)
#    self._update_current_datetime()
#    self._load_eventslist_bg()

  # def _quick_week(self,widget):
    # self._current_view = 1
    # self._current_datetime = datetime.datetime.now()
    # self._update_current_datetime()
    # self._load_eventslist_bg()

  def month_view_day_clicked(self,widget,day_datetime):
#    self._current_view = 0
    self._update_virtual_view(0)
    self._current_datetime = day_datetime
    self._update_current_datetime()
    self._update_virtual(0)
    self._load_eventslist_bg()

  def _update_grid_month_view(self):
    import mcalendar_util
    nb = mcalendar_util.nb_days_in_month(self._current_datetime)
    firstday = mcalendar_util.weekday_of_first_day_in_month(self._current_datetime)
    line = 1
    col = 1
    day_list = mcalendar_framework.EventList().get_days_with_events_for_one_month(self._current_datetime)

    #week number
    weeknum = mcalendar_util.first_weeknum_in_month(self._current_datetime)
    for index in range(1,7):
      self._widgetTree.get_widget("month_l"+str(index)+"_title").set_label(str(weeknum))
      weeknum=weeknum+1

    #current month label
    self._widgetTree.get_widget('MonthViewLabel').set_markup('<i>'+self._current_datetime.strftime("%B %Y")+'</i>')
    #previous month
    for day in range(0,firstday):
      print "month_l"+str(line)+"r"+str(col)
      day_button =  self._widgetTree.get_widget("month_l"+str(line)+"r"+str(col))
      day_button.hide()
      day_button.get_parent().modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#FFFFFF'))
      col = col + 1 

    #current month
    col = firstday+1
    if col > 7:
      col = 1
      line = line + 1
    for day in range(1,nb+1):
      print "month_l"+str(line)+"r"+str(col)
      day_button = self._widgetTree.get_widget("month_l"+str(line)+"r"+str(col))      
      day_button.set_label(str(day))
#      day_button.set_size_request(15,15)

      day_button_datetime = datetime.datetime(self._current_datetime.year,self._current_datetime.month,day)
      day_button.connect('clicked',self.month_view_day_clicked,day_button_datetime)
      day_button.set_relief(gtk.RELIEF_NONE)
      day_button.show()

      for child in day_button.get_children():
        if day in day_list:
          print 'state:'+str(int(day_button.state))
          child.modify_fg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#FF0000'))
          day_button.get_parent().modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#6EABE5'))
        else:
          child.modify_fg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#000000'))
          day_button.get_parent().modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#FFFFFF'))
        col = col + 1
      if col > 7:
        col = 1
        line = line + 1        

    #next month
    for day in range((line-1)*7+col,43):
      print "month_l"+str(line)+"r"+str(col)
      day_button = self._widgetTree.get_widget("month_l"+str(line)+"r"+str(col))
      day_button.hide()
      day_button.get_parent().modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#FFFFFF'))
      col=col + 1
      if col>7:
        col = 1
        line = line + 1

  # def _quick_month(self,widget):
    # self._current_view = 2
    # self._current_datetime = datetime.datetime.now()
    #self._update_grid_month_view()
    # self._update_current_datetime()
    # self._load_eventslist_bg()

  # def _select_current_datetime(self,widget):
    # self._datetimepicker_minute.set_text(str(datetime.datetime.now().minute))
    # self._datetimepicker_hour.set_text(str(datetime.datetime.now().hour))
    # self._widgetTree.get_widget("calendar").select_month(self._current_datetime.month - 1,self._current_datetime.year)
    # self._widgetTree.get_widget("calendar").select_day(self._current_datetime.day)
    # self._update_virtual(2)

  def _update_current_datetime(self):
    format = '%A %d %B %Y'
    if (self._current_view == 0) :
      format = '%A %d %B %Y'
    elif (self._current_view == 1) or (self._current_view == 4):
      format ='Week %W %B %Y'
    elif (self._current_view == 2) or (self._current_view == 3):
      format ='%B %Y'
#    self.lCurrentDatetime.set_label(self._current_datetime.strftime(format))
    self._widgetTree.get_widget("TodayLabel").set_markup(datetime.datetime.now().strftime("%a %d"))
    self._widgetTree.get_widget("WeekLabel").set_markup(datetime.datetime.now().strftime("Week %W"))
    self._widgetTree.get_widget("MonthLabel").set_markup(datetime.datetime.now().strftime("%b %y"))

  def _previous_current_datetime(self,widget):
    if self._current_view == 0:
      diff = dateutil.relativedelta.relativedelta(days=+1)
    elif (self._current_view == 1) or (self._current_view == 4):
      diff = dateutil.relativedelta.relativedelta(weeks=+1)
    elif (self._current_view == 2) or (self._current_view == 3):
      diff = dateutil.relativedelta.relativedelta(months=+1)
    else:
      diff = dateutil.relativedelta.relativedelta(days=+1)

    self._current_datetime = self._current_datetime - diff
    self._update_current_datetime()
    self._load_eventslist_bg()

  def _next_current_datetime(self,widget):
    if self._current_view == 0:
      diff = dateutil.relativedelta.relativedelta(days=+1)
    elif (self._current_view == 1) or (self._current_view == 4):
      diff = dateutil.relativedelta.relativedelta(weeks=+1)
    elif (self._current_view == 2) or (self._current_view == 3):
      diff = dateutil.relativedelta.relativedelta(months=+1)
    else:
      diff = dateutil.relativedelta.relativedelta(days=+1)

    self._current_datetime = self._current_datetime + diff
    self._update_current_datetime()
    self._load_eventslist_bg()

  def _children_color_bg(self,widget,hex_color='#DDDDDD'):
    if (type(widget)!=gtk.TextView) and (type(widget)!=gtk.HScale) and (type(widget)!=gtk.Image) and (type(widget)!=gtk.Toolbar) and (type(widget)!=gtk.Table) and (type(widget)!=gtk.ProgressBar)  and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView) and (type(widget)!=gtk.Calendar):
#      color = gtk.gdk.color_parse('#064163')
      color = gtk.gdk.color_parse(hex_color)
      widget.modify_bg(gtk.STATE_NORMAL,color)
#      widget.modify_text(gtk.STATE_NORMAL,gtk.gdk.color_parse('#FFFFFF'))
#      widget.modify_text(gtk.STATE_ACTIVE,gtk.gdk.color_parse('#FFFFFF'))
#      widget.modify_text(gtk.STATE_PRELIGHT,gtk.gdk.color_parse('#FFFFFF'))
      widget.modify_bg(gtk.STATE_INSENSITIVE,color)
      widget.modify_bg(gtk.STATE_ACTIVE,color)
      widget.modify_bg(gtk.STATE_PRELIGHT,color)
      widget.modify_bg(gtk.STATE_SELECTED,color)      
      widget.modify_base(gtk.STATE_NORMAL,color)
      if (type(widget)!=gtk.Label):
        for child in widget.get_children():
          self._children_color_bg(child,hex_color)

  def _idle_setup(self):
    """
    If something can be done after the UI loads, push it here so it's not blocking the UI
    """

    global IS_MAEMO
    self._osso = None
    if IS_MAEMO == True:
      try:
        import osso
      except ImportError:
        osso = None
      if osso != None:
        self._osso = osso.Context(mCalendar.__app_name__, mCalendar.__version__, False)
    else:
      IS_MAEMO = False

    import mcalendar_util

    gtk.gdk.threads_enter()
    self._children_color_bg(self._widgetTree.get_widget("Toolbutton"),'#E2E2E2')
    self._children_color_bg(self._widgetTree.get_widget("Toolbutton2"),'#E2E2E2')
    self._children_color_bg(self._widgetTree.get_widget("VirtualView"),'#E9E9E9')
    self._children_color_bg(self._widgetTree.get_widget("page1_bg"),'#F0F0F0')
    self._children_color_bg(self._widgetTree.get_widget("page2_bg"),'#E9E9E9')
    self._children_color_bg(self._widgetTree.get_widget("page3_bg"),'#E9E9E9')
    self._children_color_bg(self._widgetTree.get_widget("page4_bg"),'#E9E9E9')
    self._children_color_bg(self._widgetTree.get_widget("VirtualPicker"),'#E9E9E9')
    self._children_color_bg(self._widgetTree.get_widget("VirtualLogs"),'#E9E9E9')
    for toolbuttons in self._widgetTree.get_widget("Toolbutton").get_children():
      for toolbutton in toolbuttons.get_children():
        toolbutton.set_size_request(64,64)
#        toolbutton.set_expand(True)
    gtk.gdk.threads_leave()

    gtk.gdk.threads_enter()
#    self.lCurrentDatetime = self._widgetTree.get_widget("lCurrentDateTime")
    self._update_current_datetime()
    self._window.show()
    gtk.gdk.threads_leave()

#
#    gtk.gdk.threads_enter()
#    self.bToday = self._widgetTree.get_widget("bToday")
#    self.bWeek = self._widgetTree.get_widget("bWeek")
#    self.bMonth = self._widgetTree.get_widget("bMonth")
#    self._update_quick_button()
#    gtk.gdk.threads_leave()
#
#    self._widgetTree.get_widget("ToolBarView").modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarEdit").modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarPicker").modify_bg(gtk.STATE_NORMAL,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarView").modify_bg(gtk.STATE_ACTIVE,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarEdit").modify_bg(gtk.STATE_ACTIVE,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarPicker").modify_bg(gtk.STATE_ACTIVE,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarView").modify_bg(gtk.STATE_PRELIGHT,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarEdit").modify_bg(gtk.STATE_PRELIGHT,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarPicker").modify_bg(gtk.STATE_PRELIGHT,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarView").modify_bg(gtk.STATE_SELECTED,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarEdit").modify_bg(gtk.STATE_SELECTED,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarPicker").modify_bg(gtk.STATE_SELECTED,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarView").modify_bg(gtk.STATE_INSENSITIVE ,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarEdit").modify_bg(gtk.STATE_INSENSITIVE ,gtk.gdk.color_parse('#333333'))
#    self._widgetTree.get_widget("ToolBarPicker").modify_bg(gtk.STATE_INSENSITIVE ,gtk.gdk.color_parse('#333333'))
#
    gtk.gdk.threads_enter()
    self._eventsList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self._eventsListTree = self._widgetTree.get_widget('listView')
    self._graphicView = agenda_view.AgendaView()
    self._graphicView.callback = self._quick_jump
    self._graphicView.start_hour = self.get_start_of_day().astimezone(dateutil.tz.tzlocal()).hour
    self._graphicView.end_hour = self.get_end_of_day().astimezone(dateutil.tz.tzlocal()).hour + 1
    self._widgetTree.get_widget('listView').parent.add(self._graphicView)

    self._init_list(self._eventsList,self._eventsListTree)
#    self._event_loader_process = threading.Thread(target=self._load_eventslist,args=[self._eventsList])
#    self._event_loader_process.start()
    gtk.gdk.threads_leave()

    gtk.gdk.threads_enter()
#    self._event_loader_process = threading.Thread(target=self._update_grid_month_view)
#    self._event_loader_process.start()
    gtk.gdk.threads_leave()

    gtk.gdk.threads_enter()
#    self._eventsListWeek1 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListWeek2 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListWeek3 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListWeek4 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListWeek5 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListWeek6 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListWeek7 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT,gobject.TYPE_INT)
#    self._eventsListTreeWeek1 = self._widgetTree.get_widget('weekView1')
#    self._eventsListTreeWeek2 = self._widgetTree.get_widget('weekView2')
#    self._eventsListTreeWeek3 = self._widgetTree.get_widget('weekView3')
#    self._eventsListTreeWeek4 = self._widgetTree.get_widget('weekView4')
#    self._eventsListTreeWeek5 = self._widgetTree.get_widget('weekView5')
#    self._eventsListTreeWeek6 = self._widgetTree.get_widget('weekView6')
#    self._eventsListTreeWeek7 = self._widgetTree.get_widget('weekView7')
#    self._init_list(self._eventsListWeek1,self._eventsListTreeWeek1,1)
#    self._init_list(self._eventsListWeek2,self._eventsListTreeWeek2,1)
#    self._init_list(self._eventsListWeek3,self._eventsListTreeWeek3,1)
#    self._init_list(self._eventsListWeek4,self._eventsListTreeWeek4,1)
#    self._init_list(self._eventsListWeek5,self._eventsListTreeWeek5,1)
#    self._init_list(self._eventsListWeek6,self._eventsListTreeWeek6,1)
#    self._init_list(self._eventsListWeek7,self._eventsListTreeWeek7,1)
    gtk.gdk.threads_leave()

    self._update_virtual(0)

    #Menu
    gtk.gdk.threads_enter()
    if IS_MAEMO == True:
      self.create_hildon_menu()
    else:
      print "#TODO IMPLEMENTS GTK MENU"
    gtk.gdk.threads_leave()

    #Datetime Picker Widget
    gtk.gdk.threads_enter()
    self._datetimepicker_hour = self._widgetTree.get_widget("picker_hour")
    self._datetimepicker_minute = self._widgetTree.get_widget("picker_minute")
    self._datetimepicker_label = self._widgetTree.get_widget("picker_label")
    gtk.gdk.threads_leave()
#
    #Event Editor Widget
    gtk.gdk.threads_enter()
    self._eventeditor_edit_start_datetime = self._widgetTree.get_widget("edit_start_datetime")
    self._eventeditor_edit_end_datetime = self._widgetTree.get_widget("edit_end_datetime")
#    self._eventeditor_bSetRecurrence = self._widgetTree.get_widget("bSetRecurrence")
#   self._eventeditor_bSetAlarm = self._widgetTree.get_widget("bSetAlarm")
    self._eventeditor_tDescription = self._widgetTree.get_widget("edit_description")
#    self._eventeditor_bTitle = self._widgetTree.get_widget("edit_title")
    gtk.gdk.threads_leave()
#
    #Recurrency Editor Widget
    gtk.gdk.threads_enter()
    self._eventeditor_edit_repeat_mo = self._widgetTree.get_widget("edit_repeat_mo")
    self._eventeditor_edit_repeat_tu = self._widgetTree.get_widget("edit_repeat_tu")
    self._eventeditor_edit_repeat_we = self._widgetTree.get_widget("edit_repeat_we")
    self._eventeditor_edit_repeat_th = self._widgetTree.get_widget("edit_repeat_th")
    self._eventeditor_edit_repeat_fr = self._widgetTree.get_widget("edit_repeat_fr")
    self._eventeditor_edit_repeat_sa = self._widgetTree.get_widget("edit_repeat_sa")
    self._eventeditor_edit_repeat_su = self._widgetTree.get_widget("edit_repeat_su")
    self._eventeditor_edit_frequency = self._widgetTree.get_widget("edit_frequency")
    self._eventeditor_edit_repeat = self._widgetTree.get_widget("edit_repeat")
    self._eventeditor_edit_interval = self._widgetTree.get_widget("edit_interval")
    self._eventeditor_edit_until = self._widgetTree.get_widget("edit_until")   
    gtk.gdk.threads_leave()
# 
    gtk.gdk.threads_enter()
    self._alarmsList = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_STRING)
    textrenderer = gtk.CellRendererText()
    column_datetime = gtk.TreeViewColumn("Datetime", textrenderer, text=1)
    self.alarmListTree = self._widgetTree.get_widget("alarm_list")
    self.alarmListTree.set_model(self._alarmsList)
    self.alarmListTree.append_column(column_datetime)
    gtk.gdk.threads_leave()
#
    gtk.gdk.threads_enter()
    self._attendeesList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
    textrenderer = gtk.CellRendererText()
    textrenderer.set_property('editable' , True)
    textrenderer.set_property('width' , 200)
    textrenderer.connect('edited', self.edited_cell_cb, (self._attendeesList, 1))
    column_name = gtk.TreeViewColumn("Name", textrenderer, text=1)
    textrenderer = gtk.CellRendererText()
    textrenderer.set_property('editable' , True)
    textrenderer.connect('edited', self.edited_cell_cb, (self._attendeesList, 0))
    column_id = gtk.TreeViewColumn("Id", textrenderer, text=0)
    self.attendeesListTree = self._widgetTree.get_widget("attendee_list")
    self.attendeesListTree.set_model(self._attendeesList)
    self.attendeesListTree.append_column(column_name)
    self.attendeesListTree.append_column(column_id)
    gtk.gdk.threads_leave()

    if IS_MAEMO == True:
      gtk.gdk.threads_enter()
      self._journal_window = hildon.Window()
      self._journal_window.hide()
#      self._window.set_border_width(0)
      self._widgetTree.get_widget("vbox7").reparent(self._journal_window)
      self._app.add_window(self._journal_window)
      gtk.gdk.threads_leave()

    if self._journal_window:
      self._journal_window.connect("delete-event", self._journal_window_closebox)

    return False

  def _init_list(self,a_model,a_list,type_store=0):
    a_list.connect("row-activated", self._edit_event)
    a_list.set_model(a_model)
    a_list.set_grid_lines(False)
    textrenderer = gtk.CellRendererText()
    textrenderer.set_property('background-set' , True)
    textrenderer.set_property('foreground-set' , True)
    textrenderer.set_property('wrap-mode' , pango.WRAP_WORD)
    textrenderer.set_property('style' , True)
    if type_store==1:
#      textrenderer.set_property('width' , 0)
      #textrenderer.set_property('wrap-width' , 50)
      textrenderer.set_property('wrap-width',75)
      textrenderer.set_property('alignment',pango.ALIGN_CENTER)

    column_datetime = gtk.TreeViewColumn("Datetime", textrenderer, markup=1)
    column_datetime.add_attribute(textrenderer, 'background', 3)
    column_datetime.add_attribute(textrenderer, 'foreground', 4)
    if type_store==1:
      column_datetime.add_attribute(textrenderer, 'height', 6)
    column_datetime.add_attribute(textrenderer, 'style', 5)
    a_list.append_column(column_datetime)
    column_title = gtk.TreeViewColumn("Description", textrenderer, text=2)
    column_title.add_attribute(textrenderer, 'background', 3)
    column_title.add_attribute(textrenderer, 'foreground', 4)
    column_title.add_attribute(textrenderer, 'style', 5)
    if type_store==0:
      a_list.append_column(column_title)

  def _on_window_state_change(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
      self._isFullScreen = True
    else:
      self._isFullScreen = False

  def _prefs_grid_month_view(self):
    if self._prefs.get_value('use_grid_month_view') == 'True':
      return True
    else:
      return False

  def _prefs_grid_week_view(self):
    if self._prefs.get_value('use_grid_week_view') == 'True':
      return True
    else:
      return False

  def _prefs_get_show_freetime_in_day(self):
    if self._prefs.get_value('show_freetime_in_day_view') == 'True':
      return True
    else:
      return False

  def get_start_of_day(self):
    t = datetime.datetime.strptime('20090101 '+self._prefs.get_value('start_of_day'),'%Y%m%d %H:%M:%S')
    t = t.replace(tzinfo=dateutil.tz.tzlocal())
    t = t.astimezone(dateutil.tz.tzutc())  
    return t
  def get_end_of_day(self):
    t = datetime.datetime.strptime('20090101 '+self._prefs.get_value('end_of_day'),'%Y%m%d %H:%M:%S')
    t = t.replace(tzinfo=dateutil.tz.tzlocal())
    t = t.astimezone(dateutil.tz.tzutc())  
    return t

  def is_start_of_day(self,date):
    t = self.get_start_of_day()
    if (date.hour == t.hour) and (date.minute == t.minute): 
      return True
    else:
      return False

  def is_end_of_day(self,date):
    t = self.get_end_of_day()
    if (date.hour == t.hour) and (date.minute == t.minute): 
      return True
    else:
      return False

  def _prefs_get_datetime_format(self):
    if self._prefs_get_view_style() == 1:
      return self._prefs.get_value('datetime_format')
    else:
      return self._prefs.get_value('datetime_format_markup')

  def _prefs_get_allday_format(self):
    if (self._prefs_get_view_style() == 1):
      return self._prefs.get_value('allday_format')
    else:
      return self._prefs.get_value('allday_format_markup')

  def _prefs_get_view_style(self):
    return 0
    return int(self._prefs.get_value('view_style'))

  def _eventsList_append(self,eventsList,uuid,datetime, title, fg_color,bg_color,style,duration=0):
    if eventsList.get_n_columns()==7:
      if duration == 0:
        duration = 0
      eventsList.append((uuid,datetime+'\n'+title, '', fg_color,bg_color,style,duration/2))
    else:
      if (self._prefs_get_view_style() == 1) and (datetime!=''):
        if title != '':
          separator = '\n'
        else:
          separator=''
        tupple = (uuid,'',title + separator + datetime, fg_color,bg_color,style)
        eventsList.append(tupple)
      else:
        eventsList.append((uuid,datetime, title, fg_color,bg_color,style))

  def _datetime_to_string(self,sdatetime,edatetime):
    if self.is_start_of_day(sdatetime) and self.is_end_of_day(edatetime):
      return self._prefs_get_allday_format()
    else:
      if (self._prefs_get_view_style() == 1) and not (self._current_view == 4):
        return mcalendar_framework.convert_for_display(sdatetime,self._prefs_get_datetime_format()) + ' - '  + mcalendar_framework.convert_for_display(edatetime,self._prefs_get_datetime_format()) 
      else:
        return mcalendar_framework.convert_for_display(sdatetime,self._prefs_get_datetime_format()) + '\n' + mcalendar_framework.convert_for_display(edatetime,self._prefs_get_datetime_format()) 

  def _load_eventslist_bg(self):

    print 'Load event : type view :'+str(self._current_view)
    self._eventsList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self._eventsListTree.set_model(self._eventsList)
    self._event_loader_process = threading.Thread(target=self._load_eventslist,args=[self._eventsList])
    self._event_loader_process.start()

  def _get_week_details(self,date):
    nb_day = date.weekday()
    diff = datetime.timedelta(days=nb_day)
    first_day = date - diff
    nb_day = 6 - date.weekday()
    diff = datetime.timedelta(days=nb_day)
    last_day = date + diff
    return (first_day,last_day)

  def _load_eventslist(self,eventsList,index=0):
    print 'index:'+str(index)
    print 'current_view:'+str(self._current_view)
    #TODO
    #GUI To show sync
    gtk.gdk.threads_enter()
#    self._widgetTree.get_widget("SearchButton").show()

    global IS_MAEMO
    #if IS_MAEMO == True:
      #banner = hildon.hildon_banner_show_animation(self._window, None, "Loading events ...")
    gtk.gdk.threads_leave()

    #Day View (LIST)
    if self._current_view == 0:
      gtk.gdk.threads_enter()
      eventsList.clear()
      gtk.gdk.threads_leave()
      event_uuid_list =  mcalendar_framework.EventList().get_events_for_one_day(self._current_datetime)
      event_uuid_list.sort()
      last_hour,last_minute,last_second = (self.get_start_of_day().hour,self.get_start_of_day().minute,self.get_start_of_day().second)
      print 'lasthour:'+str(last_hour)
      print 'lastminute:'+str(last_minute)
      event = None
      gtk.gdk.threads_enter()
      self._eventsList_append(eventsList,"","",self._current_datetime.strftime("%A %x"),"#7893B5","#FFFFFF",pango.STYLE_ITALIC)
      gtk.gdk.threads_leave()

      for (event_date,event_uuid) in event_uuid_list:
        if self._eventsList != eventsList:
          return False
        event = mcalendar_framework.Event(event_uuid)
        sdatetime = self._datetime_to_string(event.start_datetime,event.end_datetime)
        if self._prefs_get_show_freetime_in_day() == True:
          if (last_hour < event.start_datetime.hour) or ((last_minute < event.start_datetime.minute) and (last_hour == event.start_datetime.hour)):
            gtk.gdk.threads_enter()
            self._eventsList_append(eventsList,"new",self._datetime_to_string(datetime.datetime(event_date.year,event_date.month,event_date.day,last_hour,last_minute,last_second,tzinfo=dateutil.tz.tzutc()),event_date),"","#DEFFD8","#000000",pango.STYLE_ITALIC)
            gtk.gdk.threads_leave()
        if (last_hour < event.end_datetime.hour) or ((last_minute < event.end_datetime.minute) and (last_hour == event.end_datetime.hour)): 
          last_hour,last_minute = event.end_datetime.hour,event.end_datetime.minute
        gtk.gdk.threads_enter()
        self._eventsList_append(eventsList,event.uuid,sdatetime,event.title,event.get_fg_color(),event.get_bg_color(),pango.STYLE_NORMAL)
        gtk.gdk.threads_leave()
      if self._prefs_get_show_freetime_in_day() == True:
        if event != None:
          if not self.is_end_of_day(event.end_datetime):
            t = self.get_end_of_day()
            hh,mm,ss = (t.hour,t.minute,t.second)
            gtk.gdk.threads_enter()
            self._eventsList_append(eventsList,"new",self._datetime_to_string(event.end_datetime,datetime.datetime(event.end_datetime.year,event.end_datetime.month,event.end_datetime.day,hh,mm,ss,tzinfo=dateutil.tz.tzutc())),"","#DEFFD8","#000000",pango.STYLE_ITALIC)
            gtk.gdk.threads_leave()
        else:
          t = self.get_start_of_day()
          h,m,s = (t.hour,t.minute,t.second)
          t = self.get_end_of_day()
          hh,mm,ss = (t.hour,t.minute,t.second)
          gtk.gdk.threads_enter()
          self._eventsList_append(eventsList,"",self._datetime_to_string(datetime.datetime(self._current_datetime.year,self._current_datetime.month,self._current_datetime.day,h,m,s,tzinfo=dateutil.tz.tzlocal()),datetime.datetime(self._current_datetime.year,self._current_datetime.month,self._current_datetime.day,hh,mm,ss,tzinfo=dateutil.tz.tzlocal())),"","#D8FFF5","#000000",pango.STYLE_ITALIC)
          gtk.gdk.threads_leave()

    #Week View (LIST)
    elif self._current_view == 1:
      print 'test'
      last_date = None
      gtk.gdk.threads_enter()
      eventsList.clear()
      self._eventsList_append(eventsList,"","",self._current_datetime.strftime("Week %W %B %Y"),"#7893B5","#FFFFFF",pango.STYLE_ITALIC)
      gtk.gdk.threads_leave()

      week_start,week_end = self._get_week_details(self._current_datetime)
      event_uuid_list =  mcalendar_framework.EventList().get_events_for_date_interval(week_start,week_end)
      event_uuid_list.sort()
      for (event_date,event_uuid) in event_uuid_list:
        if self._eventsList != eventsList:
          return False
        if (event_date.date()!=last_date) :
          last_date = event_date.date()
          gtk.gdk.threads_enter()
          self._eventsList_append(eventsList,"","",event_date.strftime("%A %x"),"#064163","#FFFFFF",pango.STYLE_ITALIC)
          gtk.gdk.threads_leave()
        event = mcalendar_framework.Event(event_uuid)
        sdatetime = self._datetime_to_string(event.start_datetime,event.end_datetime)
        gtk.gdk.threads_enter()
        self._eventsList_append(eventsList,event.uuid,sdatetime,event.title,event.get_fg_color(),event.get_bg_color(),pango.STYLE_NORMAL)
        gtk.gdk.threads_leave()

    #Month View (LIST)
    elif (self._current_view == 2):
      last_date = None
      gtk.gdk.threads_enter()
      eventsList.clear()
      self._eventsList_append(eventsList,"","",self._current_datetime.strftime("%B %Y"),"#7893B5","#FFFFFF",pango.STYLE_ITALIC)
      gtk.gdk.threads_leave()
      event_uuid_list =  mcalendar_framework.EventList().get_events_for_one_month(self._current_datetime)
      event_uuid_list.sort()
      for (event_date,event_uuid) in event_uuid_list:
        if self._eventsList != eventsList:
          return False
        if (event_date.date()!=last_date) :
          last_date = event_date.date()
          gtk.gdk.threads_enter()
          self._eventsList_append(eventsList,"","",event_date.strftime("%A %x"),"#064163","#FFFFFF",pango.STYLE_ITALIC)
          gtk.gdk.threads_leave()
        event = mcalendar_framework.Event(event_uuid)
        sdatetime = self._datetime_to_string(event.start_datetime,event.end_datetime)
        gtk.gdk.threads_enter()
        self._eventsList_append(eventsList,event.uuid,sdatetime,event.title,event.get_fg_color(),event.get_bg_color(),pango.STYLE_NORMAL)
        gtk.gdk.threads_leave()

    #Month View (GRID)
    elif (self._current_view == 3):
      last_date = None
      event_uuid_list =  mcalendar_framework.EventList().get_events_for_one_month(self._current_datetime)
      event_uuid_list.sort()
      gtk.gdk.threads_enter()
      self._graphicView.mode = 2
      self._graphicView.current_date = self._current_datetime.replace(day=1,tzinfo=dateutil.tz.tzlocal())
      for (event_date,event_uuid) in event_uuid_list:
        self._graphicView.eventsList.append((event_date,mcalendar_framework.Event(event_uuid)))      
      self._graphicView.queue_draw()
      gtk.gdk.threads_leave()
    elif (self._current_view == 4):
      # one day at time
      week_start,week_end = self._get_week_details(self._current_datetime)
      event_uuid_list =  mcalendar_framework.EventList().get_events_for_date_interval(week_start,week_end)
      event_uuid_list.sort()
      self._graphicView.current_date = week_start 
#      for event in event_uuid_list:
      self._graphicView.mode = 1
      self._graphicView.eventsList= []
      for (event_date,event_uuid) in event_uuid_list:
        self._graphicView.eventsList.append((event_date,mcalendar_framework.Event(event_uuid)))
        #self._eventsList_append(eventsList,"new",self._datetime_to_string(event.end_datetime,datetime.datetime(event.end_datetime.year,event.end_datetime.month,event.end_datetime.day,hh,mm,ss,tzinfo=dateutil.tz.tzutc())),"","#DEFFD8","#FFFFFF",pango.STYLE_ITALIC,duration)
      gtk.gdk.threads_enter()
      self._graphicView.queue_draw()
      gtk.gdk.threads_leave()

    #TODO
    #GUI Close sync
    #gtk.gdk.threads_enter()
    #self._widgetTree.get_widget("SearchButton").hide()
    #gtk.gdk.threads_leave()

    return False

  def _add_event(self,widget):
    self._open_event('')

  def _eventeditor_show_more(self,widget):
    if self._eventeditor_more == True:
#      self._widgetTree.get_widget("frame_calendar").hide()
#      self._widgetTree.get_widget("frame_attendees").hide()
#      self._widgetTree.get_widget("frame_reminder").hide()
#      self._widgetTree.get_widget("frame_reccurency").hide()
      self._eventeditor_more = False
    else:
#      self._widgetTree.get_widget("frame_calendar").show()
#      self._widgetTree.get_widget("frame_attendees").show()
#      self._widgetTree.get_widget("frame_reminder").show()
#      self._widgetTree.get_widget("frame_reccurency").show()
      self._eventeditor_more = True

  def _open_event(self,uuid,default_start=None,default_end=None):
    print 'open event' + uuid
    if default_start == None:
      default_start = self._current_datetime
      diff = datetime.timedelta(hours=1)
      default_end = self._current_datetime+diff

    if (default_start!=None) and (default_end!=None):
      event = mcalendar_framework.Event(uuid,default_start,default_end)
    else:
      event = mcalendar_framework.Event(uuid)
    self._eventeditor_event = event
#    self._widgetTree.get_widget("frame_calendar").hide()
#    self._widgetTree.get_widget("frame_attendees").hide()
#    self._widgetTree.get_widget("frame_reminder").hide()
#    self._widgetTree.get_widget("frame_reccurency").hide()
    self._eventeditor_more = False
    self._eventeditor_edit_start_datetime.set_text( mcalendar_framework.convert_for_display(event.start_datetime,'%a %x %X'))
    self._eventeditor_edit_end_datetime.set_text(mcalendar_framework.convert_for_display(event.end_datetime,'%a %x %X'))
#    self._eventeditor_bTitle.set_text()
    print 'event title:'+event.title
    self._eventeditor_tDescription.get_buffer().set_text(event.description)   

    #Recurrency load
    until = self._eventeditor_event.get_until()
    if (until != None) or (until == ''):
      self._eventeditor_edit_until.set_text(until.strftime('%a %x'))
    else:
      self._eventeditor_edit_until.set_text('No End')
    if self._eventeditor_event.repeat == True:
      self._eventeditor_edit_repeat.set_active(True)
    else:
      self._eventeditor_edit_repeat.set_active(False)
    interval = self._eventeditor_event.get_interval()
    if interval != None:
      self._eventeditor_edit_interval.set_text(str(interval))
    else:
      interval = 1
    byday = self._eventeditor_event.get_byday()
    if byday!=None:
      self._eventeditor_edit_repeat_mo.set_active(0 in byday)
      self._eventeditor_edit_repeat_tu.set_active(1 in byday)
      self._eventeditor_edit_repeat_we.set_active(2 in byday)
      self._eventeditor_edit_repeat_th.set_active(3 in byday)
      self._eventeditor_edit_repeat_fr.set_active(4 in byday)
      self._eventeditor_edit_repeat_sa.set_active(5 in byday)
      self._eventeditor_edit_repeat_su.set_active(6 in byday)
    frequency = self._eventeditor_event.get_frequency()
    if frequency!=None:
      if frequency==3:
        self._eventeditor_edit_frequency.set_active(0)
      if frequency==2:
        self._eventeditor_edit_frequency.set_active(1)
      if frequency==1:
        self._eventeditor_edit_frequency.set_active(2)
      if frequency==0:
        self._eventeditor_edit_frequency.set_active(3)

    #Attendee  and alarm Load
    self._eventeditor_load_attendees()
    self._eventeditor_load_alarm()

    self._update_virtual(1)

  def _eventeditor_check_datetime(self):
    if self._eventeditor_event.start_datetime>self._eventeditor_event.end_datetime:
      self._eventeditor_event.end_datetime = self._eventeditor_event.start_datetime.replace(hour=self._eventeditor_event.start_datetime.hour+1)
      self._eventeditor_edit_end_datetime.set_text(mcalendar_framework.convert_for_display(self._eventeditor_event.end_datetime,'%a %x %X'))

  def _update_sync_progress(self):
#    mcalendar_framework.LogIt().clear()
    status = mcalendar_framework.LogIt().get_status()
    print 'update sync status:'+status
    if (status == 'Sync finished') or (status=='')or (status == 'GCal list refreshed'):
      if self.timer != None:
        gobject.source_remove(self.timer)
        self.timer = None
      self.timer = gobject.timeout_add(60000, self._update_sync_progress)
      self._widgetTree.get_widget("VirtualLogs").hide()
      self._widgetTree.get_widget("VirtualLogsLabel").set_label(status)
    else:
      if status == 'Error occurs during last sync !':
        self.timer = gobject.timeout_add(60000, self._update_sync_progress)
      else:
        self.timer = gobject.timeout_add(5000, self._update_sync_progress)
      self._widgetTree.get_widget("VirtualLogs").show()
      self._widgetTree.get_widget("VirtualLogsLabel").set_label(status)
    return False

  def _eventeditor_set_start(self,widget):
    self._datetimepicker_minute.set_active(((mcalendar_framework.convert_for_read(self._eventeditor_event.start_datetime).minute))/5)
    self._datetimepicker_hour.set_active((mcalendar_framework.convert_for_read(self._eventeditor_event.start_datetime).hour))
#    self._datetimepicker_label.set_markup('<b>'+mcalendar_framework.convert_for_read(self._eventeditor_event.start_datetime).strftime('%X')+'</b>')
    self._widgetTree.get_widget("picker_calendar").select_month(self._eventeditor_event.start_datetime.month - 1,self._eventeditor_event.start_datetime.year)
    self._widgetTree.get_widget("picker_calendar").select_day(self._eventeditor_event.start_datetime.day)
    self._datetimepicker_selector = 'start'
    self._update_virtual(2)

  def _eventeditor_set_end(self,widget):
    self._datetimepicker_minute.set_active(((mcalendar_framework.convert_for_read(self._eventeditor_event.end_datetime).minute))/5)
    self._datetimepicker_hour.set_active((mcalendar_framework.convert_for_read(self._eventeditor_event.end_datetime).hour))
    self._widgetTree.get_widget("picker_calendar").select_month(self._eventeditor_event.end_datetime.month - 1,self._eventeditor_event.end_datetime.year)
    self._widgetTree.get_widget("picker_calendar").select_day(self._eventeditor_event.end_datetime.day)
    self._datetimepicker_selector = 'end'
    self._update_virtual(2)

  # def _eventeditor_set_recurrence(self,widget):
    # self._recurrenceeditor_load()
    # self._update_virtual(3)

  def _eventeditor_load_alarm(self):
    self._alarmsList.clear()
    for alarm in self._eventeditor_event.alarms:
      #print alarm.alarm_datetime 
      if type(alarm.alarm_datetime)== datetime.datetime:
        self._alarmsList.append((alarm.alarm_id,alarm.alarm_datetime.strftime('%a %x %X')))
    # self._update_virtual(4)

  def _eventeditor_load_attendees(self):
    self._attendeesList.clear()
    for attendee in self._eventeditor_event.who:
      self._attendeesList.append((attendee.email,attendee.name))
    #self._update_virtual(5)

  def _eventeditor_cancel(self,widget):
    self._update_virtual(0)

  def _eventeditor_validate(self,widget):
    #base
#    self._eventeditor_event.title = self._eventeditor_bTitle.get_text()
    start,end = self._eventeditor_tDescription.get_buffer().get_bounds()
    text = self._eventeditor_tDescription.get_buffer().get_text(start,end)
    self._eventeditor_event.title = text.split('\n')[0]
    self._eventeditor_event.description = text
    #attendee
    self._eventeditor_event.clear_attendees()
    iter = self._attendeesList.get_iter_root()
    while(iter):
      name = self._attendeesList.get_value(iter, 1)
      email = self._attendeesList.get_value(iter, 0)
      self._eventeditor_event.add_attendee(name,email)
      iter = self._attendeesList.iter_next(iter)

    #alarm
    self._eventeditor_event.clear_alarm()
    iter = self._alarmsList.get_iter_root()
    while(iter):
      oneAlarm = self._alarmsList.get_value(iter, 1)
      print oneAlarm
      self._eventeditor_event.add_alarm(datetime.datetime.strptime(oneAlarm,'%a %x %X'))
      iter = self._alarmsList.iter_next(iter)
    self._update_virtual(1)

    #Reccurency
    if (self._eventeditor_edit_until.get_text()=='No End') or (self._eventeditor_edit_until.get_text() == ''):
      until = ''
    else:
      until = datetime.datetime.strptime(self._eventeditor_edit_until.get_text(),'%a %x')
    self._eventeditor_event.set_freq(self._eventeditor_edit_frequency.get_active_text())
    self._eventeditor_event.set_until(until)
    self._eventeditor_event.set_interval(int(self._eventeditor_edit_interval.get_text()))
    self._eventeditor_event.set_repeat(self._eventeditor_edit_repeat.state==1)

    byday = []
    if self._eventeditor_edit_repeat_mo.state==1:
      byday.append(0)
    if self._eventeditor_edit_repeat_tu.state==1:
      byday.append(1)
    if self._eventeditor_edit_repeat_we.state==1:
      byday.append(2)
    if self._eventeditor_edit_repeat_th.state==1:
      byday.append(3)
    if self._eventeditor_edit_repeat_fr.state==1:
      byday.append(4)
    if self._eventeditor_edit_repeat_sa.state==1:
      byday.append(5)
    if self._eventeditor_edit_repeat_su.state==1:
      byday.append(6)

    self._eventeditor_event.set_byday(byday)

    self._eventeditor_event.save_to_db()
    self._load_eventslist_bg()
    self._update_virtual(0)

  def _eventeditor_delete(self,widget):
    if ask_dialogue(self._window,'Do you really want to delete this event ?')==True:
      self._eventeditor_event.delete_from_db()
      self._load_eventslist_bg()
      self._update_virtual(0)

  def _edit_event(self,widget,*args):
    print 'edit_event'

#    if (self._current_view == 4):
      # one day at time
    selection = widget.get_selection()
    model, selection_iter = selection.get_selected()

    if (selection_iter):
      uuid = model.get_value(selection_iter, 0)
      print uuid
      if uuid != 'noteditable':
        if (uuid == 'new') or  (uuid==''):
          print model.get_value(selection_iter, 1)
          if (model.get_value(selection_iter, 1)!=self._prefs_get_allday_format()):
            print model.get_value(selection_iter, 1)
            if self._prefs_get_view_style() != 1:
              start_time = datetime.datetime.strptime(model.get_value(selection_iter, 1).split('\n')[0],self._prefs_get_datetime_format())
              end_time = datetime.datetime.strptime(model.get_value(selection_iter, 1).split('\n')[1],self._prefs_get_datetime_format())
            else:
              start_time = datetime.datetime.strptime(model.get_value(selection_iter, 1).split(' - ')[0],self._prefs_get_datetime_format())
              end_time = datetime.datetime.strptime(model.get_value(selection_iter, 1).split(' - ')[1],self._prefs_get_datetime_format())

          else:
            print 'debug 9'
            start_time = self.get_start_of_day()
            end_time = self.get_end_of_day()
          start_datetime = datetime.datetime(self._current_datetime.year,self._current_datetime.month,self._current_datetime.day,start_time.hour,start_time.minute,0).replace(tzinfo=dateutil.tz.tzlocal()) 
          end_datetime = datetime.datetime(self._current_datetime.year,self._current_datetime.month,self._current_datetime.day,end_time.hour,end_time.minute,0).replace(tzinfo=dateutil.tz.tzlocal())
#          start_time = start_time
#            end_time = end_time.replace(tzinfo=dateutil.tz.tzlocal())
          self._open_event('',start_datetime,end_datetime)
        else:
          self._open_event(uuid)

    return

  def _eventeditor_attendee_new(self,widget):
    self._attendeesList.append(('email','name'))

  def _eventeditor_attendee_delete(self,widget):
    if ask_dialogue(self._window,'Do you really want to delete this person ?')==True:
      selection = self.attendeesListTree.get_selection()
      model, selection_iter = selection.get_selected()
      if (selection_iter):
        self._attendeesList.remove(selection_iter)

  def _eventeditor_alarm_new(self,widget):
    self._datetimepicker_minute.set_value((datetime.datetime.now().minute))
    self._datetimepicker_hour.set_value((datetime.datetime.now().hour))
    self._widgetTree.get_widget("picker_calendar").select_month(self._current_datetime.month - 1,self._current_datetime.year)
    self._widgetTree.get_widget("picker_calendar").select_day(self._current_datetime.day)
    self._datetimepicker_selector = 'alarm'
    self._update_virtual(2)
#    self._widgetTree.get_widget("frame_attendees").hide()
#    self._widgetTree.get_widget("frame_attendees").show()

  def _eventeditor_alarm_delete(self,widget):
    if ask_dialogue(self._window,'Do you really want to delete this event ?')==True:
      selection = self.alarmListTree.get_selection()
      model, selection_iter = selection.get_selected()
      if (selection_iter):
        self._alarmsList.remove(selection_iter)

  def edited_cell_cb(self,cell, path, new_text, user_data):
      liststore, column = user_data
      liststore[path][column] = new_text
      return

  def _eventeditor_set_until(self,widget):
    if (self._eventeditor_edit_until.get_text()=='No End'):
      until = self._eventeditor_event.get_until()
      if until == None:
        until = datetime.datetime.now()
    else:
      until = datetime.datetime.strptime(self._eventeditor_edit_until.get_text(),'%a %x')
    self._datetimepicker_minute.set_active(((until.minute))/5)
    self._datetimepicker_hour.set_active((until.hour))
    self._widgetTree.get_widget("picker_calendar").select_month(until.month - 1,until.year)
    self._widgetTree.get_widget("picker_calendar").select_day(until.day)
    self._datetimepicker_selector = 'until'
    self._update_virtual(2)

  def _show_prefs_ui(self,widget):
    self._prefs.show_ui()

  def create_hildon_menu(self):
    self.menubar = gtk.Menu ()
    self._window.set_menu(self.menubar)
    accel_group = gtk.AccelGroup ()
    self._window.add_accel_group (accel_group)

    #Sync
    item = gtk.ImageMenuItem (gtk.STOCK_REFRESH, accel_group)
    item.get_child().set_text('Launch Google Sync')
    item.connect ("activate", self.launch_sync_bg)
    item.show ()
    self.menubar.append (item)

    #Sync
    item = gtk.ImageMenuItem (gtk.STOCK_DIALOG_INFO, accel_group)
    item.get_child().set_text('Show Sync Journal')
    item.connect ("activate", self._show_journal)
    item.show ()
    self.menubar.append (item)

    #Preferences
    item = gtk.ImageMenuItem (gtk.STOCK_PREFERENCES, accel_group)
    item.connect ("activate", self._show_prefs_ui)
    item.show ()
    self.menubar.append (item)

    #Separator
    item = gtk.SeparatorMenuItem ()
    item.show ()
    self.menubar.append (item)

    #About
    item = gtk.ImageMenuItem (gtk.STOCK_ABOUT, accel_group)
    item.connect ("activate", self.onAbout)
    item.show ()
    self.menubar.append (item)

  def _on_key_press(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.keyval == gtk.keysyms.F6:
      if self._isFullScreen:
        self._window.unfullscreen()
      else:
        self._window.fullscreen()

  def launch_sync_bg(self,widget):
    self.timer = gobject.timeout_add(5000, self._update_sync_progress)
    self._widgetTree.get_widget("VirtualLogs").show()
    self._widgetTree.get_widget("VirtualLogsLabel").set_label('Launching synchronization')
    self._sync_thread = threading.Thread(target=self._launch_sync)
    self._sync_thread.start()

  def _launch_sync(self):
    sync = mcalendar_sync.GSync(str(self._prefs.get_value('google_login')).encode(),str(self._prefs.get_value('google_password')).encode())
    sync.refresh_gcal_list()
    sync.sync_events()
    if sync.get_last_error()!=None:
      self.warn(sync.get_last_error())

  def warn(self,message):
    gtk.gdk.threads_enter()
    dialog = gtk.MessageDialog(gtk.Window(),
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_ERROR,
                    gtk.BUTTONS_OK,
                    message)
    rc = dialog.run ()
    dialog.destroy ()
    gtk.gdk.threads_leave()

  def _refresh_journal(self,widget):
    logs = mcalendar_framework.LogIt().get()
    logs_text = ''
    for line in logs:
      logs_text = logs_text +datetime.datetime.fromtimestamp(int(line[0])).strftime('%x %X')+':'+line[1]+ '\n'
    self._widgetTree.get_widget("Journal").get_buffer().set_text(logs_text)

  def _show_journal(self,widget):
    self._refresh_journal(None)
    self._journal_window.show()

  def onAbout(self, widget):
    dialog = gtk.AboutDialog()
    dialog.set_name(self.__pretty_app_name__)
    dialog.set_logo_icon_name(self.__app_name__)
    dialog.set_authors(("Benoit HERVIER (Khertan)","","Thanks to :","",""))
    dialog.set_comments('a PIM Calendar for Maemo')
    dialog.set_version(self.__version__)
    dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
    dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
    dialog.set_website("http://khertan.net/")
    dialog.connect ("response", lambda d, r: d.destroy())
    dialog.show()

def run_mcalendar():
  gtk.gdk.threads_init()
  if IS_MAEMO == True:
    gtk.set_application_name(mCalendar.__pretty_app_name__)
  handle = mCalendar()
  gtk.main()

if __name__ == "__main__":
  run_mcalendar()