#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import time
import uuid
import commands
import sqlite3
import dateutil.rrule
import dateutil.relativedelta
import os
#import mcalendar_sync
import urllib

DB_FORMAT = '%Y-%m-%d %H:%M:%S'
FRAMEWORK_VERSION = '0.8'
HOME_PATH = os.path.expanduser("~")
DB_PATH = HOME_PATH + '/.mPIM/mcalendar2.db'
LAUNCH_UPDATE_DB_ONCE = False
try:
  import osso.alarmd
  IS_MAEMO = True
except:
  IS_MAEMO = False

def convert_for_display(d,format):
  d = d.astimezone(dateutil.tz.tzlocal())
  return d.strftime(format)

def convert_for_read(d):
  d = d.astimezone(dateutil.tz.tzlocal())
  return d

def convert_for_save(d):
  d = d.astimezone(dateutil.tz.tzutc())
  return d.strftime(DB_FORMAT)

class Database:
        def __init__(self,path=None):
          self.db = None
          self.cursor = None
          if path != None:
            self.path = path
          else:
            self.path = DB_PATH
          try:
            self.db = sqlite3.connect(self.path,isolation_level=None)
            self.cursor = self.db.cursor()
            global LAUNCH_UPDATE_DB_ONCE
            if LAUNCH_UPDATE_DB_ONCE==False:
              LAUNCH_UPDATE_DB_ONCE=True
              try:
                self._update()
              except StandardError,e:
                print e
                self._create()
          except:
            print 'Database doesn t exist'
            self._create()

        def _create(self):
          #Try to create the folder in case of
          commands.getoutput("mkdir "+HOME_PATH+ '/.mPIM/')
          print self.path
#          self.db = sqlite3.connect(self.path)
#          self.cursor = self.db.cursor()
          self.cursor.execute('CREATE TABLE events (uuid TEXT PRIMARY KEY, start_datetime DATETIME, end_datetime DATETIME,title TEXT, description TEXT, repeat INTEGER, repeat_rule TEXT, repeat_exdate TEXT, last_update DATETIME, google_event_id TEXT, google_cal_id TEXT)')
          self.db.commit()
          self.cursor.execute('CREATE TABLE attendees (event_uuid TEXT, who_id TEXT, name TEXT, statut TEXT )')
          self.db.commit()
          self.cursor.execute('CREATE TABLE alarms (event_uuid TEXT, alarm_id INTEGER, alarm_datetime DATETIME, alarm_activated INTEGER, alarm_description TEXT)')
          self.db.commit()
          self.cursor.execute('CREATE TABLE google_cal (id TEXT PRIMARY KEY,access_level TEXT, color TEXT, last_update TEXT, to_sync INTEGER, is_default INTEGER);')
          self.db.commit()
          self.cursor.execute('CREATE TABLE sync_logs (date DATETIME,text TEXT);')
          self.db.commit()
          self.cursor.execute('CREATE TABLE db_struct (version TEXT);')
          self.db.commit()
          self.cursor.execute('INSERT INTO db_struct (version) VALUES ("'+FRAMEWORK_VERSION+'");')
          self.db.commit()
#          self.db.close()

        def _update(self):
          self.cursor.execute('SELECT version From db_struct;')
          for version in self.cursor.fetchall():
            v = version[0]

          self.cursor.execute('UPDATE db_struct SET version="'+FRAMEWORK_VERSION+'";')
          self.db.commit()

          if v < '0.5':
            self._create()

          if v < '0.6':
            self.cursor.execute('CREATE TABLE sync_logs (date DATETIME,text TEXT);')
            self.db.commit()

          if v < '0.8':
            self.cursor.execute('ALTER TABLE attendees MODIFY statut TEXT;')
            self.db.commit()

        def close(self):
          self.db.close()

class LogIt:
  def __init__(self):
    inited = True

  def append(self,text):
    d = time.mktime(datetime.datetime.now().timetuple())
    if (text=='Sync finished'):
      d=d+1
    db = Database(DB_PATH)
    db.cursor.execute('INSERT INTO sync_logs (date,text) VALUES (?,?);',[str(d),text])       
    db.db.commit()
    db.close()
    print str(d)+':'+text

  def clear(self):
    db = Database(DB_PATH)
    db.cursor.execute('DELETE FROM sync_logs') 
    db.db.commit()
    db.close()

  def get_status(self):
    db = Database(DB_PATH)
    db.cursor.execute('SELECT date,text FROM sync_logs ORDER BY date DESC')
    r = db.cursor.fetchall()
    db.close()
    if len(r)>0:
      if (r[0][1]!='Sync finished') and ((time.mktime(datetime.datetime.now().timetuple())-int(r[0][0])>1800)):
        return 'Error occurs during last sync !'
      return r[0][1]
    else:
      return ''

  def get(self):
    db = Database(DB_PATH)
    db.cursor.execute('SELECT date,text FROM sync_logs ORDER BY date ASC') 
    r = db.cursor.fetchall()
    db.close()
    return r

class CalendarList:
        def __init__(self):
            self.calendar_list = []

        def clear(self):
            self.calendar_list = []

        def get_default_gcal_id(self):
          gcal_list = []
          db = Database(DB_PATH)
          db.cursor.execute('SELECT id FROM google_cal where is_default=1;')
          for cal_id in db.cursor.fetchall():
            return cal_id[0]
          db.close()
          return 'default'

        def get_calendars(self):
            db = Database(DB_PATH)
            select = 'SELECT id FROM google_cal  '
            where = ' '
            query = select + where
            db.cursor.execute(query)
            for uuid in db.cursor.fetchall():
              self.calendar_list.append(Calendar(uuid[0]))

            return self.calendar_list

class Calendar:
  def __init__(self,gcal_id):
    self.gcal_id = gcal_id
    self.access_level = None
    self.last_update = datetime.datetime(2000,01,01,0,0,0,tzinfo=dateutil.tz.tzutc())
    self.to_sync = False
    self.color = None
    self.default = False
    self.load_from_db()

  def load_from_db(self):
    db = Database(DB_PATH)
    db.cursor.execute('SELECT access_level, color, last_update, to_sync, is_default FROM google_cal where id="'+self.gcal_id+'";')
    self.new = True
    for cal in db.cursor.fetchall():
      self.new = False
      self.access_level = cal[0]
      self.last_update = datetime.datetime.strptime(cal[2],DB_FORMAT)
      self.to_sync = int(cal[3])==True
      self.default = int(cal[4])==True
      self.color = cal[1]
    db.close()

  def save_to_db(self):
    if self.new == True:
      db = Database(DB_PATH)
      db.cursor.execute('INSERT INTO google_cal (id, access_level, color, last_update, to_sync, is_default) VALUES (?,?,?,?,?,?);',[self.gcal_id,self.access_level,self.color,self.last_update.strftime(DB_FORMAT),str(int(self.to_sync)),str(int(self.default))])
      db.db.commit()
      db.close()
    else:
      db = Database(DB_PATH)
      db.cursor.execute('UPDATE google_cal SET access_level=?, color=?, last_update=?, to_sync=?, is_default=? WHERE id=?;',[self.access_level,self.color,self.last_update.strftime(DB_FORMAT),str(int(self.to_sync)),str(int(self.default)),self.gcal_id])
      db.db.commit()
      db.close()  

class Attendee:
        def __init__(self,email,name,statut):
          self.email = email
          self.name = name
          self.statut = statut

class Alarm:
        def __init__(self,event_uuid,alarm_id='',alarm_datetime=datetime.datetime.now(), alarm_activated=True,description=''):
          self.event_uuid = event_uuid
          self.alarm_id = alarm_id
          if (alarm_datetime.tzinfo==None):
            alarm_datetime=alarm_datetime.replace(tzinfo=dateutil.tz.tzutc())
          self.alarm_datetime = alarm_datetime.astimezone(dateutil.tz.tzlocal())
          self.alarm_activated = alarm_activated
          self.alarm_description = description

        def strip_accents(self,string):
          import unicodedata
          return unicodedata.normalize('NFKD', unicode(string)).encode('ASCII', 'ignore')

        def save_to_db(self):
          db = Database(DB_PATH)
          db.cursor.execute('DELETE from alarms where alarm_id = "'+str(self.alarm_id)+'";')
          db.db.commit()
          db.close()          
          self._unactivate()
          self._activate()

        def _unactivate(self):
          if (self.alarm_id!='') and (IS_MAEMO==True):
            try:
              osso.alarmd.get_alarm(self.alarm_id).cancel_alarm()
            except:
              LogIt().append('Error on alarmd : '+str(e))

        def _activate(self):
#          LogIt().append('Activate alarm at '+str())
          print 'activate alarm'
          print 'activated:'+str(self.alarm_activated)
          print 'IS_MAEMO:'+str(IS_MAEMO)
          print 'datetime(local):'+str(self.alarm_datetime.astimezone(dateutil.tz.tzlocal()).utctimetuple())
          if (self.alarm_activated == 1) and (IS_MAEMO==True):
            try:
              self.alarm_id = osso.alarmd.add_alarm(time.mktime(self.alarm_datetime.astimezone(dateutil.tz.tzlocal()).utctimetuple()),title=self.strip_accents(self.alarm_description))
            except StandardError,e:
              LogIt().append('Error on alarmd : '+str(e))
          db = Database(DB_PATH)
          db.cursor.execute('INSERT INTO alarms (alarm_id,alarm_datetime,event_uuid,alarm_activated,alarm_description) VALUES (?,?,?,?,?) ;', [str(self.alarm_id),self.alarm_datetime.strftime(DB_FORMAT),self.event_uuid,self.alarm_activated,self.alarm_description])
          db.db.commit()
          db.close()        

class Event:
        """This class represents one event"""

        def __init__(self,suuid='',default_start_datetime=None,default_end_datetime=None):

            self.start_datetime = datetime.datetime.now()
            one_hour = datetime.timedelta(hours=1)
            self.end_datetime = datetime.datetime.now() + one_hour
            self.repeat = False
            self.repeat_rule = ''
            self.title = ''
            self.who = []
            self.description = ''
            self.google_event_id = ''
            self.google_cal_id = CalendarList().get_default_gcal_id()
            self.lastup = datetime.date(1974,1,1)
            self.alarms = []

            if suuid=='':
              self.uuid = uuid.uuid4().__str__()
              self.new = True
              if default_start_datetime!=None:
                self.start_datetime = default_start_datetime
              if default_end_datetime!=None:  
                self.end_datetime = default_end_datetime
                self.start_datetime = self.start_datetime.replace(tzinfo=dateutil.tz.tzutc())
                self.end_datetime = self.end_datetime.replace(tzinfo=dateutil.tz.tzutc())
            else:
              self.uuid = suuid
              self.load_from_db(self.uuid)
              self.new = False

        def load_from_db(self,suuid):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT  start_datetime, end_datetime, description, repeat,google_event_id,last_update,repeat_rule,google_cal_id,title FROM events where uuid="'+suuid+'"')
            for event in db.cursor.fetchall():
              self.start_datetime = datetime.datetime.strptime(event[0],DB_FORMAT)
              self.start_datetime = self.start_datetime.replace(tzinfo=dateutil.tz.tzutc())

              self.end_datetime = datetime.datetime.strptime(event[1],DB_FORMAT)
              self.end_datetime = self.end_datetime.replace(tzinfo=dateutil.tz.tzutc())
              self.repeat = int(event[3])
              if event[2] != None:
                self.description = event[2]
              if event[8] != None:
                self.title = event[8]
              self.lastup = datetime.datetime.strptime(event[5],DB_FORMAT)
              self.lastup = self.lastup.replace(tzinfo=dateutil.tz.tzutc())
#              LogIt().append('DEBUG:load_from_db().lastup:'+str(self.lastup))
              self.google_event_id = event[4]
              if event[7] != None:
                self.google_cal_id = event[7]
              else:
                self.google_cal_id = 'default'
              self.repeat_rule = event[6]
              self.new = False

              db2 = Database(DB_PATH)
              db2.cursor.execute('SELECT alarm_datetime,alarm_id, alarm_activated,alarm_description FROM alarms WHERE event_uuid="'+suuid+'";')
              for alarm in db2.cursor.fetchall():
                self.alarms.append(Alarm(suuid,alarm[1],(datetime.datetime.strptime(alarm[0],DB_FORMAT)),int(alarm[2])==1,alarm[3]))

              db2.cursor.execute('SELECT who_id,name,statut FROM attendees WHERE event_uuid="'+suuid+'"')
              for attendee in db2.cursor.fetchall():
                if ('ACCEPTED' in attendee[2]) or ('TENTATIVE' in attendee[2]) or ('INVITED' in attendee[2]):
                  self.who.append(Attendee(attendee[0],attendee[1],attendee[2]))
              db2.close()
            db.close()

        def add_attendee(self,name,email):
          self.who.append(Attendee(email,name,'INVITED'))

        def get_interval(self):
          if self.repeat_rule != '':
            return dateutil.rrule.rrulestr(str(self.repeat_rule))._interval
          else:
            return 1

        def get_frequency(self):
          if self.repeat_rule != '':
            return dateutil.rrule.rrulestr(str(self.repeat_rule))._freq
          else:
            return 1

        def set_freq(self,freq):
          if freq == 'Yearly':
            freq = dateutil.rrule.YEARLY
          elif freq == 'Monthly':
            freq = dateutil.rrule.MONTHLY
          elif freq == 'Weekly':
            freq = dateutil.rrule.WEEKLY
          elif freq == 'Daily':        
            freq = dateutil.rrule.DAILY  
          if self.repeat_rule != '':
            rule = dateutil.rrule.rrulestr(str(self.repeat_rule))            
            rule._freq = freq
          else:
            rule = dateutil.rrule.rrule(freq)
          self.repeat_rule = str(rule)

        def get_freq(self):
          if self.repeat_rule != '':
            freq = dateutil.rrule.rrulestr(str(self.repeat_rule))._freq
            if freq == dateutil.rrule.YEARLY:
              return 'Yearly'
            elif freq == dateutil.rrule.MONTHLY:
              return 'Monthly'
            elif freq == dateutil.rrule.WEEKLY:
              return 'Weekly'
            elif freq == dateutil.rrule.DAILY:
              return 'Daily'
          else:
            return None

        def set_byday(self,tup):
          rule = dateutil.rrule.rrulestr(str(self.repeat_rule))
          rule._byweekday = tup
          self.repeat_rule = str(rule)

        def get_byday(self):
          if self.repeat_rule != '':
            return dateutil.rrule.rrulestr(str(self.repeat_rule))._byweekday
          else:
            return None

        def get_until(self):
          if self.repeat_rule != '':
#            print self.repeat_rule
#            print dateutil.rrule.rrulestr(str(self.repeat_rule),dtstart=self.start_datetime)._until
#            print type(dateutil.rrule.rrulestr(str(self.repeat_rule),dtstart=self.start_datetime))
#            print dir(dateutil.rrule.rrulestr(str(self.repeat_rule),dtstart=self.start_datetime))
            return dateutil.rrule.rrulestr(str(self.repeat_rule),dtstart=self.start_datetime)._until
          else:
            return None

        def set_until(self,until):
          rule = dateutil.rrule.rrulestr(str(self.repeat_rule))
          rule._until = until
          self.repeat_rule = str(rule)

        def set_interval(self,interval):
          rule = dateutil.rrule.rrulestr(str(self.repeat_rule))
          rule._interval = interval
          self.repeat_rule = str(rule)
#          print self.repeat_rule 

        def set_repeat(self,value):
          self.repeat = value

        def add_alarm(self,d):
          self.alarms.append(Alarm(self.uuid,'',d,True,self.title))

        def clear_attendees(self):
          self.who = [] 

        def clear_alarm(self):
            self.alarms = []

        def save_to_db(self):
            db = Database(DB_PATH)
            self.lastup = datetime.datetime.now()
            self.lastup = self.lastup.replace(tzinfo=dateutil.tz.tzlocal()).astimezone(dateutil.tz.tzutc())
            
            if self.new==False:
              db.cursor.execute('DELETE FROM alarms where event_uuid = ?;',[self.uuid,])
              db.db.commit()
            for alarm in self.alarms:
              alarm.save_to_db()

            if self.google_cal_id == None:
              self.google_cal_id = "default"

            if (len(self.google_event_id.split('/'))>5) and (self.google_cal_id=="default"):
              self.google_cal_id = urllib.unquote( self.google_event_id.split('/')[5] )

            if self.new==False:
              db.cursor.execute('DELETE FROM attendees where event_uuid = ?;',[self.uuid,])
              db.db.commit()
            for attendee in self.who:
              db.cursor.execute('INSERT INTO attendees (event_uuid,who_id,name,statut) VALUES (?,?,?,?);',[self.uuid,attendee.email,attendee.name,str(attendee.statut)])
              db.db.commit()

            if self.new==True:
              db.cursor.execute('INSERT INTO events (uuid , start_datetime, end_datetime, description, repeat, last_update,google_event_id,repeat_rule,google_cal_id,title) VALUES(?,?,?,?,?,?,?,?,?,?);',[self.uuid,convert_for_save(self.start_datetime),convert_for_save(self.end_datetime),self.description, str(int(self.repeat)) ,self.lastup.strftime(DB_FORMAT),str(self.google_event_id),self.repeat_rule,self.google_cal_id,self.title])
              db.db.commit()
            else:
              db.cursor.execute('UPDATE events SET start_datetime=?, end_datetime=?, description=?, repeat=?, last_update=?,google_event_id=?,repeat_rule=?,google_cal_id=?,title=? WHERE uuid=?;',[convert_for_save(self.start_datetime),convert_for_save(self.end_datetime),self.description, str(int(self.repeat)) ,self.lastup.strftime(DB_FORMAT),str(self.google_event_id),self.repeat_rule,self.google_cal_id,self.title,self.uuid])
              db.db.commit()
            db.close()

        def load_event_from_google_id(self):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT uuid FROM events where google_event_id LIKE "%'+self.google_event_id+'%"')
            for event_uuid in db.cursor.fetchall():
              self.uuid = event_uuid[0]
              print 'uuid from google id found'
            db.close()
            self.load_from_db(self.uuid)

        def get_fg_color(self):
          return "#D8E6FF"

        def get_bg_color(self):
          return "#000000"

        def delete_from_db(self):
            db = Database(DB_PATH)
            if self.google_event_id == '':
              db.cursor.execute('DELETE FROM events WHERE uuid ="'+self.uuid + '";')
              db.db.commit()
            else:
              db.cursor.execute('UPDATE events set description="DELETED" WHERE uuid ="'+self.uuid + '";')
              db.db.commit()
            db.close()

class EventList:
        def __init__(self):
            self.events_list = []

        def clear(self):
            self.events_list = []

        def get_event_deleted(self):
            db = Database(DB_PATH)
            select = 'SELECT uuid FROM events  '
            where = ' WHERE description="DELETED"'
            query = select + where
            db.cursor.execute(query)
            for uuid in db.cursor.fetchall():
              self.events_list.append(uuid[0])

            return self.events_list

        def get_event_not_updated_since(self,since_datetime):
            db = Database(DB_PATH)
            select = 'SELECT uuid FROM events  '
            where = ' WHERE last_update>=?;'
            query = select + where
            db.cursor.execute(query,[since_datetime.strftime(DB_FORMAT)])
            for uuid in db.cursor.fetchall():
              self.events_list.append(uuid[0])

            return self.events_list

        def get_event_new(self):
            db = Database(DB_PATH)
            select = 'SELECT uuid FROM events  '
            where = ' WHERE google_event_id=""'
            query = select + where
            db.cursor.execute(query)
            for uuid in db.cursor.fetchall():
              self.events_list.append(uuid[0])

            return self.events_list

        def get_events_for_one_day(self,date):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM events  '
            where = ' WHERE description<>"DELETED"'
            query = select + where
            query = query + ' AND (((start_datetime<="'+date.strftime("%Y-%m-%d 23:59:59")+'") AND (end_datetime>="'+date.strftime("%Y-%m-%d 00:00:00")+'"))'
            query = query + ' OR (repeat=1  )'
            query = query + ')'

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              event = Event(uuid[0])
              if (not event.repeat): #or (event.repeat and (self.view_datetime.weekday() in googleToDays(byday))):
                self.events_list.append((event.start_datetime,event.uuid))
              else:
                for d in range((event.end_datetime.date() - event.start_datetime.date()).days + 1):
                  diff = datetime.timedelta(days=(d))
                  compare_date = event.start_datetime + diff
                  if len(dateutil.rrule.rrulestr(str(event.repeat_rule),dtstart=compare_date).between(datetime.datetime(date.year,date.month,date.day,0,0,0,tzinfo=dateutil.tz.tzutc()),datetime.datetime(date.year,date.month,date.day,23,59,59,tzinfo=dateutil.tz.tzutc())))>0:
                    self.events_list.append((datetime.datetime(date.year,date.month,date.day,event.start_datetime.hour,event.start_datetime.minute,event.start_datetime.second,tzinfo=dateutil.tz.tzutc()),event.uuid))
            db.close()

            return self.events_list

        def get_events_for_date_interval(self,start_date,end_date):

            db = Database(DB_PATH)
            select = 'SELECT uuid FROM events  '
            where = ' WHERE description<>"DELETED"'
            query = select + where

            #Single Events
            query = query + ' AND (((start_datetime<="'+end_date.strftime("%Y-%m-%d 23:59:59")+'") AND (end_datetime>="'+start_date.strftime("%Y-%m-%d 00:00:00")+'"))'
            #Reccuring Events
            query = query + ' OR (repeat=1  )'
            query = query + ')'

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              event = Event(uuid[0])
              if (not event.repeat):
                self.events_list.append((event.start_datetime,event.uuid))
              else:
                for d in range((event.end_datetime.date() - event.start_datetime.date()).days + 1):
                  diff = datetime.timedelta(days=(d))
                  compare_date = event.start_datetime + diff
                  for eventreccur in list(dateutil.rrule.rrulestr(str(event.repeat_rule),dtstart=compare_date).between(datetime.datetime(start_date.year,start_date.month,start_date.day,0,0,0,tzinfo=dateutil.tz.tzutc()),datetime.datetime(end_date.year,end_date.month,end_date.day,23,59,59,tzinfo=dateutil.tz.tzutc()))):
                    self.events_list.append((eventreccur,event.uuid))
            db.close()

            return self.events_list

        def get_events_for_one_week(self,date):
            return self.get_events_for_date_interval(date+dateutil.relativedelta.relativedelta(day=1),date+dateutil.relativedelta.relativedelta(day=31))

        def get_events_for_one_month(self,date):
            return self.get_events_for_date_interval(date+dateutil.relativedelta.relativedelta(day=1),date+dateutil.relativedelta.relativedelta(day=31))

        def get_days_with_events_for_one_month(self,date):
            day_list = []
            for events in self.get_events_for_date_interval(date+dateutil.relativedelta.relativedelta(day=1),date+dateutil.relativedelta.relativedelta(day=31)):
              if events[0].day not in day_list:
                day_list.append(events[0].day)
            return day_list

        def get_all_events(self):
          return self.get_events_for_date_interval(datetime.datetime(1990,1,1),datetime.datetime(2010,1,1))