#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#import gnome.gconf
from ConfigParser import *
import sys
import os
import gtk
import datetime

HOME_PATH = os.path.expanduser("~")
PREFS_PATH = HOME_PATH + '/.mPIM/mcalendar.prefs'

try:
  import hildon
except ImportError:
  hildon = None
  IS_MAEMO = False

import gobject
import mcalendar_framework

class mPrefs:

  _glade_files = ['/usr/lib/mcalendar/ui/mprefs.glade',]

  def __init__(self):
    print 'init pref'
    self._isFullScreen = False
    default = {
            'override_theme':'True',
            'show_freetime_in_day_view':'True',
            'freetime_bg_color':'#E5E5FF',
            'datetime_format':'%H:%M',
            'datetime_format_markup':'<b>%H:%M</b>',
            'time_format':'%H:%M',
            'time_format_markup':'<b>%H:%M</b>',
            'allday_format':'All day',
            'allday_format_markup':'<b>All\nday</b>',
            'view_style':'1',
            'google_login':'login',
            'google_password':'password',            
            'google_autosync':'True',
            'google_autosync_interval':'240',
            'google_sync_alarm':'False',
            'autosync_alarm_id':'0',
            'default_current_view':'0',
            'display_day_separator':'True',
            'use_google_color':'False',
            'use_grid_week_view':'True',
            'use_grid_month_view':'True',
            'start_of_day':'09:00:00',
            'end_of_day':'18:00:00',
            }
    self._prefs = ConfigParser(default)
    try:
      self._load_pref_file()
    except:
      pass
    #Try to set alarm autosync
    try:
      self.manage_auto_sync()
    except:
      pass

  def _load_pref_file(self):
    self._prefs.read(PREFS_PATH)

  def _save_pref_file(self):
    fp = open(PREFS_PATH,'w')
    self._prefs.write(fp)
    fp.close()

  def set_value(self,key,value):
    self._prefs.set('DEFAULT',key,value)

  def set_boolean_value(self,key,b):
    if b == True:
      value = 'True'
    else:
      value = 'False'
    self._prefs.set('DEFAULT',key,value)

  def get_value(self,key):
    return self._prefs.get('DEFAULT', key)

  def get_int_value(self,key):
    return int(self._prefs.get('DEFAULT', key))

  def get_boolean_value(self,key):
    return self._prefs.get('DEFAULT', key)=='True'

  def manage_auto_sync(self):#,activate_autosync,autosync_interval,know_autosync_id):
    import osso.alarmd
    activate_autosync = self.get_boolean_value('google_autosync')
    autosync_interval = self.get_int_value('google_autosync_interval')
    know_autosync_id = self.get_int_value('autosync_alarm_id')

    if (know_autosync_id != 0) and (activate_autosync==False):
      osso.alarmd.get_alarm(activate_autosync).cancel_alarm()
      self.set_value('autosync_alarm_id',know_autosync_id)
      self._save_pref_file()

    elif (know_autosync_id == 0) and (activate_autosync==True):
      diff = datetime.timedelta(minutes=1)
      timer = datetime.datetime.now() + diff
      know_autosync_id = osso.alarmd.add_alarm(time.mktime(timer.timetuple()),flags=385,exec_name='python /usr/lib/mcalendar/mcalendar_sync.py',recurrence=autosync_interval,recurrence_count=-1)
      self.set_value('autosync_alarm_id',know_autosync_id)
      self._save_pref_file()

  def show_ui(self):
    print 'show prefs ui'
    global hildon

    self._callbackList = None

    for path in mPrefs._glade_files:
      if os.path.isfile(path):
        self._widgetTree = gtk.glade.XML(path)
        break
    else:
      return

    self._window = self._widgetTree.get_widget("Prefs")

    self._app = None
    self._isFullScreen = False
    if hildon is not None and self._window is gtk.Window:
      warnings.warn("Hildon installed but glade file not updated to work with hildon", UserWarning, 2)
      hildon = None
    elif hildon is not None:
      self._app = hildon.Program()
      self._window = hildon.Window()
      self._window.set_border_width(0)
      self._widgetTree.get_widget("VBox").reparent(self._window)
      self._app.add_window(self._window)
#     hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow2'),True)
#     hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow5'),True)
#     hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow5'),True)

      self._window.connect("key-press-event", self._on_key_press)
      self._window.connect("window-state-event", self._on_window_state_change)
    else:
      warnings.warn("No Hildon", UserWarning, 2)

    self._window.set_title("mCalendar - Prefs")

    callbackMapping = {
      # EventsList Signal
      "on_validate_clicked": self._save_prefs,
      "on_cancel_clicked": self._cancel_prefs,
      "on_refresh_cal_clicked": self._refresh_cal_list_prefs,
      }
    self._widgetTree.signal_autoconnect(callbackMapping)

    self._children_color_bg(self._window)
    self._load_value()
    self._window.show_all()

  def _children_color_bg(self,widget):
    if (type(widget)!=gtk.Image) and (type(widget)!=gtk.Label) and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView) and (type(widget)!=gtk.Calendar):
      widget.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
      widget.modify_bg(gtk.STATE_INSENSITIVE,gtk.gdk.Color(60000,60000,60000))
      for child in widget.get_children():
        self._children_color_bg(child)

  def _save_prefs(self,widget):
    print 'notyet'
    self._save_value()
    self._save_pref_file()
    self._window.hide()

  def _cancel_prefs(self,widget):
    self._load_pref_file()
    self._window.hide()

  def _on_key_press(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.keyval == gtk.keysyms.F6:
      if self._isFullScreen:
        self._window.unfullscreen()
      else: 
        self._window.fullscreen()

  def _on_window_state_change(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
      self._isFullScreen = True
    else:
      self._isFullScreen = False

  def _refresh_cal_list_prefs(self,widget):
    import mcalendar_sync
    sync = mcalendar_sync.GSync(self.get_value('google_login'),self.get_value('google_password'))
    sync.refresh_gcal_list()
    if sync.get_last_error()!=None:
      self.warn(sync.get_last_error())

  def _load_value(self):
    #gtk entry
    fDate = self._widgetTree.get_widget("fDate")
    fTime = self._widgetTree.get_widget("fTime")
    fAllWeek_view = self._widgetTree.get_widget("fAllWeek_view")
    e_google_login = self._widgetTree.get_widget("e_google_login")
    e_google_password = self._widgetTree.get_widget("e_google_password")
    e_autosync_delay = self._widgetTree.get_widget("e_autosync_delay")
    e_start_of_day = self._widgetTree.get_widget("eStartDayTime")
    e_end_of_day = self._widgetTree.get_widget("eEndDayTime")
    #assign entry value
    fDate.set_text(self.get_value('datetime_format'))
    fTime.set_text(self.get_value('time_format'))
    fAllWeek_view.set_text(self.get_value('allday_format'))
    e_google_login.set_text(self.get_value('google_login'))
    e_google_password.set_text(self.get_value('google_password'))
    e_autosync_delay.set_text(self.get_value('google_autosync_interval'))    
    e_start_of_day.set_text(self.get_value('start_of_day'))
    e_end_of_day.set_text(self.get_value('end_of_day'))    

    #gtk checkbox
    bp_override = self._widgetTree.get_widget("bp_override")
    c_show_freetime = self._widgetTree.get_widget("c_show_freetime")
    bp_autosync = self._widgetTree.get_widget("bp_autosync")
    c_display_day_line = self._widgetTree.get_widget("c_display_day_line")
    bp_popupalarm = self._widgetTree.get_widget("bp_popupalarm")
    bp_use_google_color = self._widgetTree.get_widget("bp_use_google_color")
    c_grid_week = self._widgetTree.get_widget("c_grid_week")
    c_grid_month = self._widgetTree.get_widget("c_grid_month")

    #assign checkbox
    bp_override.set_active(self.get_boolean_value('override_theme'))
    c_show_freetime.set_active(self.get_boolean_value('show_freetime_in_day_view'))
    bp_autosync.set_active(self.get_boolean_value('google_autosync'))
    c_display_day_line.set_active(self.get_boolean_value('display_day_separator'))
    bp_popupalarm.set_active(self.get_boolean_value('google_sync_alarm'))
    bp_use_google_color.set_active(self.get_boolean_value('use_google_color'))
    c_grid_week.set_active(self.get_boolean_value('use_grid_week_view'))
    c_grid_month.set_active(self.get_boolean_value('use_grid_month_view'))

    #TreeView
    self._CalendarList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)
    # id,to_sync,is_default,last_update
    self._CalendarListTree = self._widgetTree.get_widget("CalendarList")
    self._CalendarListTree.set_model(self._CalendarList)
    self._CalendarListTree.set_headers_visible(True)

    checkboxrenderer_tosync = gtk.CellRendererToggle()
    checkboxrenderer_tosync.set_property('activatable' , True)
    checkboxrenderer_tosync.connect("toggled", self.gcal_list_edited_checkbox_cb, (self._CalendarList, 1))    
    checkboxrenderer_default = gtk.CellRendererToggle()
    checkboxrenderer_default.set_property('activatable' , True)
    checkboxrenderer_default.connect("toggled", self.gcal_list_edited_checkbox_cb, (self._CalendarList, 2))    

    textrenderer = gtk.CellRendererText()
    textrenderer.set_property('editable' , False)
    etextrenderer = gtk.CellRendererText()
    etextrenderer.connect('edited', self.gcal_list_edited_cell_cb, (self._CalendarList, 3))
    etextrenderer.set_property('editable' , True)

    column_id = gtk.TreeViewColumn("Id", textrenderer, text=0)
    self._CalendarListTree.append_column(column_id)
    column_tosync = gtk.TreeViewColumn("Sync", checkboxrenderer_tosync, active=1)
    self._CalendarListTree.append_column(column_tosync)
    column_default = gtk.TreeViewColumn("Default", checkboxrenderer_default, active=2)
    self._CalendarListTree.append_column(column_default)
    column_lastupdate = gtk.TreeViewColumn("Last Update", etextrenderer, text=3)
    self._CalendarListTree.append_column(column_lastupdate)

    calendar_list =  mcalendar_framework.CalendarList().get_calendars()
    for calendar in calendar_list:
      self._CalendarList.append((calendar.gcal_id,calendar.to_sync,calendar.default,calendar.last_update))    

  def gcal_list_edited_cell_cb(self,cell, path, new_text, user_data):
      liststore, column = user_data
      liststore[path][column] = new_text

      calendar = mcalendar_framework.Calendar(liststore[path][0])
      if column == 3:
        calendar.last_update = datetime.datetime.strptime(liststore[path][3],mcalendar_framework.DB_FORMAT)
      calendar.save_to_db()
      return

  def gcal_list_edited_checkbox_cb(self,cell, path, user_data):
    liststore, column = user_data
    liststore[path][column] = not liststore[path][column]
    calendar = mcalendar_framework.Calendar(liststore[path][0])
    if column == 1:
      calendar.to_sync = int(liststore[path][1])
    if column == 2:
      calendar.default = int(liststore[path][2])
    calendar.save_to_db()
    return

  def _save_value(self):
    #gtk entry
    fDate = self._widgetTree.get_widget("fDate")
    fTime = self._widgetTree.get_widget("fTime")
    fAllWeek_view = self._widgetTree.get_widget("fAllWeek_view")
    e_google_login = self._widgetTree.get_widget("e_google_login")
    e_google_password = self._widgetTree.get_widget("e_google_password")
    e_autosync_delay = self._widgetTree.get_widget("e_autosync_delay")
    e_start_of_day = self._widgetTree.get_widget("eStartDayTime")
    e_end_of_day = self._widgetTree.get_widget("eEndDayTime")

    #assign entry value
    self.set_value('datetime_format',fDate.get_text())
    self.set_value('time_format',fTime.get_text())
    self.set_value('allday_format',fAllWeek_view.get_text())
    self.set_value('google_login',e_google_login.get_text())
    self.set_value('google_password',e_google_password.get_text())
    self.set_value('google_autosync_interval',e_autosync_delay.get_text())   
    self.set_value('start_of_day',e_start_of_day.get_text())
    self.set_value('end_of_day',e_end_of_day.get_text())

    #gtk checkbox
    bp_override = self._widgetTree.get_widget("bp_override")
    c_show_freetime = self._widgetTree.get_widget("c_show_freetime")
    bp_autosync = self._widgetTree.get_widget("bp_autosync")
    c_display_day_line = self._widgetTree.get_widget("c_display_day_line")
    bp_popupalarm = self._widgetTree.get_widget("bp_popupalarm")
    bp_use_google_color = self._widgetTree.get_widget("bp_use_google_color")
    c_grid_week = self._widgetTree.get_widget("c_grid_week")
    c_grid_month = self._widgetTree.get_widget("c_grid_month")

    #assign checkbox
    self.set_boolean_value('override_theme',bp_override.get_active())   
    self.set_boolean_value('show_freetime_in_day_view',c_show_freetime.get_active())   
    self.set_boolean_value('google_autosync',bp_autosync.get_active())   
    self.set_boolean_value('display_day_separator',c_display_day_line.get_active())   
    self.set_boolean_value('google_sync_alarm',bp_popupalarm.get_active())   
    self.set_boolean_value('use_google_color',bp_use_google_color.get_active())       
    self.set_boolean_value('use_grid_week_view',c_grid_week.get_active())       
    self.set_boolean_value('use_grid_month_view',c_grid_month.get_active())       

  def warn(self,message):
    dialog = gtk.MessageDialog(gtk.Window(),
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_ERROR,
                    gtk.BUTTONS_OK,
                    message)
    rc = dialog.run ()
    dialog.destroy ()