#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import datetime
import uuid
import sqlite3
import commands
import gobject
gobject.threads_init()

import threading
import string
import time
import socket
import pango

DATE_FORMAT = "%x"
TIME_FORMAT = "%X"
DAY_VIEW_FORMAT = "<b>%H:%M</b>"
WEEK_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
MONTH_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
ALLDAY_VIEW_FORMAT = "<b>All day</b>"
ALLWEEK_VIEW_FORMAT = "<b>%a %d\nAll day</b>"
ALLMONTH_VIEW_FORMAT = "<b>%a %d\nAll day</b>"
OVERRIDE_THEME = True
DB_FORMAT = '%Y-%m-%d %H:%M'
FIRST_DAY_WEEK = 0
DAY_START_HOUR = 8
DAY_START_MINUTE = 0
DAY_END_HOUR = 18
DAY_END_MINUTE = 0
GOOGLE_REMINDER = True
USE_GOOGLE_COLOR = True
DISPLAY_DAY = True

VERSION = '0.4.6'

try:
        import pygtk
        pygtk.require("2.0")
except:
        pass
try:
        import gtk
        import gtk.glade
except:
        sys.exit(1)
def children_color_bg(widget):
  if (type(widget)!=gtk.Image) and (type(widget)!=gtk.Label) and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView):
    widget.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
#    widget.modify_fg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
    widget.modify_bg(gtk.STATE_INSENSITIVE,gtk.gdk.Color(60000,60000,60000))
    for child in widget.get_children():
      children_color_bg(child)

def strip_accents(string):
  import unicodedata
  return unicodedata.normalize('NFKD', unicode(string)).encode('ASCII', 'ignore')

def eventToList(start_datetime,start_format,end_datetime,end_format,description,uuid,d1="",d2="",fg="#000000",bg="#FFFFFF"):
  debug('---')
  debug(description)
  debug(start_datetime)
  debug(start_datetime)
  debug(fg)
  debug(bg)
  debug('uuid : '+str(uuid))

  if ((start_datetime.hour==0) and (start_datetime.minute==0)) and ((end_datetime.hour==23) and (end_datetime.minute==59)):
    if start_format == WEEK_VIEW_FORMAT: 
      start_format = ALLWEEK_VIEW_FORMAT
    elif start_format == MONTH_VIEW_FORMAT: 
      start_format = ALLMONTH_VIEW_FORMAT
    else:
      start_format = ALLDAY_VIEW_FORMAT
    end_format = ''

  if (start_format==DAY_VIEW_FORMAT) and (end_format==DAY_VIEW_FORMAT):
    ds = start_datetime.strftime(start_format)+'\n'+end_datetime.strftime(end_format)
    de = ''
  else:
    ds = start_datetime.strftime(start_format)
    de = end_datetime.strftime(end_format)

  return (ds,de,description,uuid,d1,d2,fg,bg)

def addMonth(date, n=1):
    # add n+1 months to date then subtract 1 day
    # to get eom, last day of target month
    OneDay = datetime.timedelta(days=1)
    q,r = divmod(date.month+n, 12)
    eom = datetime.datetime(date.year+q, r+1, 1,date.hour,date.minute,date.second) - OneDay
    if date.month != (date+OneDay).month or date.day >= eom.day:
        return eom
    return eom.replace(day=date.day)

def startDay(d):
  return d.replace(hour=DAY_START_HOUR,minute=DAY_START_MINUTE)

def endDay(d):
  return d.replace(hour=DAY_END_HOUR,minute=DAY_END_MINUTE)

def endMonth(d):
    d = d.replace(day=1)
    d = addMonth(d)
    diff = datetime.timedelta(days=1)
    d = d - diff
    debug(d)
    return d

def supMonth(date, n=1):
    OneDay = datetime.timedelta(days=1)
    q,r = divmod(date.month-n, 12)
    debug(date.year)
    debug(q)
    eom = datetime.datetime(date.year+q, r+1, 1,date.hour,date.minute,date.second) - OneDay
    if date.month != (date+OneDay).month or date.day >= eom.day:
        return eom
    return eom.replace(day=date.day)

def getWeekDetails(date):
  nb_day = date.weekday()
  diff = datetime.timedelta(days=nb_day)
  first_day = date - diff
  nb_day = 6 - date.weekday()
  diff = datetime.timedelta(days=nb_day)
  last_day = date + diff
  return (first_day,last_day)

def googleToDays(s):
  d = []
  if s != None:
    if 'SU' in s:
      d.append(6)
    if 'MO' in s:
      d.append(0)
    if 'TU' in s:
      d.append(1)
    if 'WE' in s:
      d.append(2)
    if 'TH' in s:
      d.append(3)
    if 'FR' in s:
      d.append(4)
    if 'SA' in s:
      d.append(5)
    if 'SU' in s:
      d.append(6)

  if len(d)==0:
    d = [0,1,2,3,4,5,6]

  return d

def dateToGoogle(d,format=0):
  hours=str((abs(time.altzone)) / 3600)
  minutes=str((abs(time.altzone)) % 3600)
  if len(minutes)==1:
    minutes = '0'+minutes
  if len(hours)==1:
    hours = '0'+hours
  if time.altzone<0:
    sep='+'
  else:
    sep='-'
  if format==0:
    return d.strftime("%Y-%m-%dT%H:%M:%S.000"+sep+hours+':'+minutes)
  elif format==1:
    diff = datetime.timedelta(seconds=time.altzone)
    return (d + diff).strftime("%Y%m%dT%H%M00")
  elif format==2:
    return d.strftime("%Y%m%d")

def dateFromGoogle(d,format=0):
  if format==1:
    debug('google reccurent date: %s' % (d))
    da = datetime.datetime.strptime(d[0:13], "%Y%m%dT%H%M")
    diff = datetime.timedelta(seconds=(-time.altzone))
    debug('Diff : %s' % (time.altzone))
    debug('Google converted date %s' % (da+diff))
    return da + diff

  elif format==2:
    da = datetime.datetime.strptime(d[0:8], "%Y%m%d")
    return da
  elif format==4:
    da = dateFromGoogle(d)
    if 'T' not in d:
      da = da.replace(hour=0,minute=0)
    return da
  elif format==5:
    da = dateFromGoogle(d)
    if 'T' not in d:
      da = da.replace(hour=23,minute=59)
      diff = datetime.timedelta(days=1)
      da = da - diff
    return da
  else:
    debug('Google date %s' % (d))
    if len(d)>16:
      da = datetime.datetime.strptime(d[0:16], "%Y-%m-%dT%H:%M")
    else:
      da = datetime.datetime.strptime(d, "%Y-%m-%d")
      return da

    diff = datetime.timedelta(seconds=(-time.altzone))
    debug('Diff : %s' % (time.altzone))
    debug('Google converted date %s' % (da+diff))
    return da + diff

def debug(s):
  print str(s)