#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import datetime
import uuid
import sqlite3
import commands
import urllib
import gobject
gobject.threads_init()

import threading
import string
import time
import socket
import pango

from mutils import *

try:
        import pygtk
        pygtk.require("2.0")
except:
        pass
try:
        import gtk
        import gtk.glade
except:
        sys.exit(1)

try:
  import hildon
  HILDON_SUPPORT = True
except:
  HILDON_SUPPORT = False

class Event:
        """This class represents one event"""

        def __init__(self,suuid="",widget=None,start="",end=""):

            self.start_datetime = datetime.datetime.now()
            one_hour = datetime.timedelta(hours=1)
            self.end_datetime = datetime.datetime.now() + one_hour
            self.repeat = False
            self.repeat_until = datetime.datetime(9999,9,9)
            self.repeat_number = 1
            self.repeat_byday = ''
            self.frequency = ''
            self.description = ''
            self.googleid = ''
            self.cal_id = 'default'
            self.lastup = datetime.date(1974,1,1)
            self.alarm = False
            self.alarm_value = 0
            self.alarm_id = 0

            if suuid=="":
              self.uuid = uuid.uuid4().__str__()
              self.new = True
              if start<>"":
                self.start_datetime = datetime.datetime.strptime(start,DB_FORMAT)
                self.end_datetime = datetime.datetime.strptime(end,DB_FORMAT)
              debug("new uuid : " + self.uuid)
            else:
              self.uuid = suuid
              self.loadFromDB(self.uuid,widget)
              self.new = False
              debug("old uuid : " + self.uuid)

        def loadFromDB(self,suuid,widget):
            debug("load")
            widget.dbcur.execute('SELECT  start, end, description, repeat, repeatvalue, until,googleid,lastup,frequency,byday,alarm,alarm_value,alarm_id,cal_id FROM events where uuid="'+suuid+'"')
            for event in widget.dbcur.fetchall():
              self.start_datetime = datetime.datetime.strptime(event[0],DB_FORMAT)
              self.end_datetime = datetime.datetime.strptime(event[1],DB_FORMAT)
              self.repeat = int(event[3])
              self.repeat_until =  datetime.datetime.strptime(event[5],DB_FORMAT)
              self.repeat_number = int(event[4])
              self.description = event[2]
              self.lastup = datetime.datetime.strptime(event[7],DB_FORMAT)
              self.googleid = event[6]
              if event[13] != None:
                self.cal_id = event[13]
              self.frequency = event[8]
              self.repeat_byday = event[9]
              if event[10]!=None:
                self.alarm = int(event[10])
                self.alarm_value = int(event[11])
                self.alarm_id = int(event[12])

              debug(self.description)
              debug(self.lastup)

        def saveToDB(self,widget):
            import osso.alarmd
            if (len(googleToDays(self.repeat_byday))<7) and (self.frequency=='Week(s)'):
              self.frequency='Day(s)'
            debug("saveToDB") 
            if self.alarm_id != 0:
              try:
                osso.alarmd.get_alarm(self.alarm_id).cancel_alarm()
              except StandardError,e:
                print e
                pass
              self.alarm_id = 0

            if (self.alarm == True):
              diff = datetime.timedelta(minutes=int(self.alarm_value))
              d = self.start_datetime - diff
              self.alarm_id = osso.alarmd.add_alarm(time.mktime(d.timetuple()),title=strip_accents(self.description))
              debug(self.alarm_id)

            if self.cal_id == None:
              self.cal_id = "default"

            debug('cal_id'+str(self.cal_id))
            debug('google_id:'+str(self.googleid))
            if (self.googleid!="") and (self.cal_id=="default"):
              self.cal_id = urllib.unquote( self.googleid.split('/')[5] )
            debug('cal_id'+str(self.cal_id))
            debug('google_id:'+str(self.googleid))

            if self.new==True:
              widget.dbcur.execute('INSERT INTO events (uuid , start, end, description, repeat, repeatvalue, until, lastup,googleid,frequency,byday,alarm,alarm_value,alarm_id,cal_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);',[self.uuid,self.start_datetime.strftime(DB_FORMAT),self.end_datetime.strftime(DB_FORMAT),self.description, str(int(self.repeat)) , str(self.repeat_number), self.repeat_until.strftime(DB_FORMAT),self.lastup.strftime(DB_FORMAT),str(self.googleid),self.frequency,self.repeat_byday,str(int(self.alarm)), str(self.alarm_value),self.alarm_id,self.cal_id])
              widget.db.commit()
            else:
              widget.dbcur.execute('UPDATE events SET start=?, end=?, description=?, repeat=?, repeatvalue=?, until=?, lastup=?,googleid=?,frequency=?, byday=?,alarm=?,alarm_value=?,alarm_id=?,cal_id=? WHERE uuid=?;',[self.start_datetime.strftime(DB_FORMAT),self.end_datetime.strftime(DB_FORMAT),self.description, str(int(self.repeat)) , str(self.repeat_number), self.repeat_until.strftime(DB_FORMAT),self.lastup.strftime(DB_FORMAT),str(self.googleid),self.frequency,self.repeat_byday,str(int(self.alarm)), str(self.alarm_value),self.alarm_id,self.cal_id,self.uuid])
              widget.db.commit()

        def delFromDB(self,widget):
            debug("delFromDB")
            if self.googleid == '':
              widget.dbcur.execute('DELETE FROM events WHERE uuid ="'+self.uuid + '";')
              widget.db.commit()
            else:
              widget.dbcur.execute('UPDATE events set description="DELETED" WHERE uuid ="'+self.uuid + '";')
              widget.db.commit()

        def setFrequencyFromGoogle(self,f):
          if f == 'DAILY':
            self.frequency='Day(s)'
          elif f == 'WEEKLY':
            self.frequency='Week(s)'
          elif f == 'MONTHLY':
            self.frequency='Month(s)'
          elif f == 'YEARLY':
            self.frequency='Year(s)'

        def googleFrequency(self):
          if self.frequency=='Day(s)':
            return 'DAILY'
          elif self.frequency=='Week(s)':
            return 'WEEKLY'
          elif self.frequency=='Month(s)':
            return 'MONTHLY'
          elif self.frequency=='Year(s)':
            return 'YEARLY'

class EventEditor:
        """This class is used to edit and view event"""

        def __init__(self, suuid,widget,start="",end=""):

                #setup the glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.event = Event(suuid,widget,start,end)
                self.widget = widget

        def Update(self,widget):
            debug("Update EventEditor")
#            self.event.repeat = self.bRepeat.get_active()
#            self.event.repeat_number =  int(self.eNumber.get_text())
#            if self.bFrequency.get_active_text()!=None:
#              self.event.frequency = self.bFrequency.get_active_text()
            start,end = self.tDescription.get_buffer().get_bounds()
            self.event.description = self.tDescription.get_buffer().get_text(start,end)
            self.event.lastup = datetime.datetime.now()
            debug(self.event.frequency)
            self.event.saveToDB(self.widget)
            self.widget.updateList()
            self.window.hide()

        def Cancel(self,widget):
            debug("Cancel EventEditor")
            self.window.hide()

        def Delete(self,widget):
            debug("Delete EventEditor")
            self.event.delFromDB(self.widget)
            self.widget.updateList()
            self.window.hide()

        def timePicker(self,date):
            h = date.hour
            m = date.minute
            if HILDON_SUPPORT:
              D = hildon.TimePicker(hildon.Window())
              D.set_time(h,m)
              D.run()
              h,m = D.get_time()
              D.destroy()
            return datetime.datetime.combine(date,datetime.time(h,m))

        def datePicker(self,date):   
            debug(date)
            if date.year==9999:
              date = datetime.datetime.now()

            d = date.day
            m = date.month
            y = date.year
            debug(y)
            if HILDON_SUPPORT:
              D = hildon.CalendarPopup(hildon.Window(),y,m,d)
              if(D.run()==gtk.RESPONSE_OK):
                y,m,d = D.get_date()
              else:
                y = 9999
                m = 9
                d = 9
              D.destroy()
            return datetime.datetime.combine(datetime.date(y,m,d),date.time())

        def dateControl(self):
          if self.event.start_datetime>self.event.end_datetime:
            diff = datetime.timedelta(hours=1)
            self.event.end_datetime=self.event.start_datetime+ diff
            self.bEndDate.set_label(self.event.end_datetime.strftime(DATE_FORMAT))
            self.bEndTime.set_label(self.event.end_datetime.strftime(TIME_FORMAT))
          if self.event.start_datetime>self.event.repeat_until:
            self.event.repeat_until = self.event.start_datetime
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def setStartDate(self,widget):
            d = self.datePicker(self.event.start_datetime)
            if d.year!=9999:
              self.event.start_datetime = d
            self.bStartDate.set_label(self.event.start_datetime.strftime(DATE_FORMAT))
            self.dateControl()

        def setEndDate(self,widget):
            d = self.datePicker(self.event.end_datetime)
            if d.year!=9999:
              self.event.end_datetime = d
            self.bEndDate.set_label(self.event.end_datetime.strftime(DATE_FORMAT))
            self.dateControl()

        def setUntilDate(self,widget):
            self.event.repeat_until = self.datePicker(self.event.repeat_until)
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def openAlarmWin(self,widget):
            AlarmEditor(self.event,self).show()

        def openReccurenceWin(self,widget):
            ReccurenceEditor(self.event,self).show()

        def setStartTime(self,widget):
            self.event.start_datetime = self.timePicker(self.event.start_datetime)
            self.bStartTime.set_label(self.event.start_datetime.strftime(TIME_FORMAT))
            self.dateControl()

        def setEndTime(self,widget):
            self.event.end_datetime = self.timePicker(self.event.end_datetime)
            self.bEndTime.set_label(self.event.end_datetime.strftime(TIME_FORMAT))
            self.dateControl()

        def show(self):
            #load the dialog from the glade file
            self.wTree = gtk.glade.XML(self.gladefile, "EditEvent")
            self.window = self.wTree.get_widget("EditEvent")
            self.window.show_all()
#            if HILDON_SUPPORT:
#              self.window = hildon.Window()
#            else:
#              self.window = gtk.Window()
#            self.vbox = self.wTree.get_widget("vbox1")
#            self.vbox.reparent(self.window)
#            self.window.set_title(self.editevent_win.get_title())
            self.window.connect("destroy", self.Cancel)
            if self.widget.window_in_fullscreen:
              self.window_in_fullscreen = True
              self.window.fullscreen ()
            else:
              self.window_in_fullscreen = False
              self.window.unfullscreen ()
            self.window.connect("key-press-event", self.on_key_press)
            self.window.connect("window-state-event", self.on_window_state_change)
            if HILDON_SUPPORT:
              self.widget.app.add_window(self.window)

            #Create our dictionay and connect it
            dic = {
                       "on_bOK_clicked" : self.Update,
                       "on_bCancel_clicked" : self.Cancel,
                       "on_bDelete_clicked" : self.Delete,
                       "on_bStartDate_clicked" : self.setStartDate,
                       "on_bStartTime_clicked" : self.setStartTime ,
                       "on_bEndDate_clicked" : self.setEndDate ,
                       "on_bEndTime_clicked" : self.setEndTime, 
                       "on_bSetReccurence_clicked" : self.openReccurenceWin, 
                       "on_bSetAlarm_clicked" : self.openAlarmWin}
            self.wTree.signal_autoconnect(dic)

            #Get all of the Entry Widgets and set their text
            self.bStartDate = self.wTree.get_widget("bStartDate")
            self.bStartTime = self.wTree.get_widget("bStartTime")
            self.bEndDate = self.wTree.get_widget("bEndDate")
            self.bEndTime = self.wTree.get_widget("bEndTime")
            self.tDescription = self.wTree.get_widget("tDescription")
            self.bSetReccurence = self.wTree.get_widget("bSetReccurence")
            self.bSetAlarm = self.wTree.get_widget("bSetAlarm")

            self.bStartDate.set_label(self.event.start_datetime.strftime(DATE_FORMAT))
            self.bStartTime.set_label(self.event.start_datetime.strftime(TIME_FORMAT))
            self.bEndDate.set_label(self.event.end_datetime.strftime(DATE_FORMAT))
            self.bEndTime.set_label(self.event.end_datetime.time().strftime(TIME_FORMAT))
            self.tDescription.get_buffer().set_text(self.event.description)

            if self.event.alarm == True:
              self.bSetAlarm.set_label('Alarm '+str(self.event.alarm_value)+' minute(s) before')
              self.bSetAlarm.set_size_request(-1,-1)
            if self.event.repeat == True:
              self.bSetReccurence.set_label('Repeat every '+str(self.event.repeat_number)+' '+self.event.frequency)
              self.bSetReccurence.set_size_request(-1,-1)

            debug("Open EventEditor : "+self.event.description)

            if OVERRIDE_THEME==True:
              children_color_bg(self.window)

            self.window.show_all()

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
          elif event.keyval == gtk.keysyms.F7:
            print "plus"

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

class ReccurenceEditor:
        """This class is used to edit and view event"""

        def __init__(self, event,widget,start="",end=""):

                #setup the glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.event = event
                self.widget = widget.widget
                self.edit = widget

        def Update(self,widget):
            debug("Update ReccurenceEditor")
            self.event.repeat = self.bRepeat.get_active()
            self.event.repeat_number =  int(self.eNumber.get_text())
            self.event.repeat_byday = ""
            for dayweek in range(0,7):
              awidget = self.wTree.get_widget("bDay"+str(dayweek))
              debug("bDay"+str(dayweek))
              if awidget.get_active() == True:
                if dayweek == 0:
                  self.event.repeat_byday= self.event.repeat_byday+'MO;'
                elif dayweek == 1:
                  self.event.repeat_byday= self.event.repeat_byday+'TU;'
                elif dayweek == 2:
                  self.event.repeat_byday= self.event.repeat_byday+'WE;'
                elif dayweek == 3:
                  self.event.repeat_byday= self.event.repeat_byday+'TH;'
                elif dayweek == 4:
                  self.event.repeat_byday= self.event.repeat_byday+'FR;'
                elif dayweek == 5:
                  self.event.repeat_byday= self.event.repeat_byday+'SA;'
                elif dayweek == 6:
                  self.event.repeat_byday= self.event.repeat_byday+'SU;'

                if len(self.event.repeat_byday)>0:
                  self.event.repeat_byday = self.event.repeat_byday[0:len(self.event.repeat_byday)]

            debug('repeat_byday : '+self.event.repeat_byday)                 
            if self.bFrequency.get_active_text()!=None:
              self.event.frequency = self.bFrequency.get_active_text()
#            self.event.saveToDB(self.widget)
            if self.event.repeat == True:
              self.edit.bSetReccurence.set_label('Repeat every '+str(self.event.repeat_number)+' '+self.event.frequency)
            else:
              self.edit.bSetReccurence.set_label('Set Reccurence') 
            self.edit.bSetReccurence.set_size_request(-1,-1)
            self.window.hide()

        def Cancel(self,widget):
            debug("Cancel ReccurenceEditor")
            self.window.hide()

        def timePicker(self,date):
            h = date.hour
            m = date.minute
            if HILDON_SUPPORT:
              D = hildon.TimePicker(hildon.Window())
              D.set_time(h,m)
              D.run()
              h,m = D.get_time()
              D.destroy()
            return datetime.datetime.combine(date,datetime.time(h,m))

        def datePicker(self,date):   
            debug(date)
            if date.year==9999:
              date = datetime.datetime.now()
            d = date.day
            m = date.month
            y = date.year
            debug(y)
            if HILDON_SUPPORT:
              D = hildon.CalendarPopup(hildon.Window(),y,m,d)
              if(D.run()==gtk.RESPONSE_OK):
                y,m,d = D.get_date()
              else:
                y = 9999
                m = 9
                d = 9
              D.destroy()
            return datetime.datetime.combine(datetime.date(y,m,d),date.time())

        def dateControl(self):
          if self.event.start_datetime>self.event.repeat_until:
            self.event.repeat_until = self.event.start_datetime
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def setUntilDate(self,widget):
            self.event.repeat_until = self.datePicker(self.event.repeat_until)
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def show(self):
            #load the dialog from the glade file
            self.wTree = gtk.glade.XML(self.gladefile, "EditRecurrence")
            self.editreccurence_win = self.wTree.get_widget("EditRecurrence")
            if HILDON_SUPPORT:
              self.window = hildon.Window()
            else:
              self.window = gtk.Window()
            self.vbox = self.wTree.get_widget("vbox16")
            self.vbox.reparent(self.window)
#            self.window.set_title(self.editreccurence_win.get_title())
            self.window.connect("destroy", self.Cancel)
            if self.widget.window_in_fullscreen:
              self.window_in_fullscreen = True
              self.window.fullscreen ()
            else:
              self.window_in_fullscreen = False
              self.window.unfullscreen ()
            self.window.connect("key-press-event", self.on_key_press)
            self.window.connect("window-state-event", self.on_window_state_change)
            if HILDON_SUPPORT:
              self.widget.app.add_window(self.window)

            #Create our dictionay and connect it
            dic = {
                       "on_bOK_clicked" : self.Update,
                       "on_bCancel_clicked" : self.Cancel,
                       "on_bUntil_clicked" : self.setUntilDate }
            self.wTree.signal_autoconnect(dic)

            #Get all of the Entry Widgets and set their text
            self.bUntil = self.wTree.get_widget("bUntil")
            self.bRepeat = self.wTree.get_widget("bRepeat")
            self.eNumber = self.wTree.get_widget("eNumber")
            self.bFrequency = self.wTree.get_widget("bFrequency")

            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))
            self.bRepeat.set_active(self.event.repeat)
            self.eNumber.set_text(self.event.repeat_number.__str__())
            if self.event.frequency=='Day(s)':
              self.bFrequency.set_active(0)
            if self.event.frequency=='Week(s)':
              self.bFrequency.set_active(1)
            if self.event.frequency=='Month(s)':
              self.bFrequency.set_active(2)
            if self.event.frequency=='Year(s)':
              self.bFrequency.set_active(3)

            for dayweek in googleToDays(self.event.repeat_byday):
              awidget = self.wTree.get_widget("bDay"+str(dayweek))
              awidget.set_active(True)

            debug("Open ReccurenceEditor : "+self.event.description)

            if OVERRIDE_THEME==True:
              children_color_bg(self.window)

            self.window.show_all()

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
          elif event.keyval == gtk.keysyms.F7:
            print "plus"

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

class AlarmEditor:
        """This class is used to edit and view event"""

        def __init__(self, event,widget,start="",end=""):

                #setup the glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.event = event
                self.widget = widget.widget
                self.edit = widget

        def Update(self,widget):
            debug("Update AlarmEditor")
            self.event.alarm = self.bAlarm.get_active()
            self.event.alarm_value =  int(self.bAlarm_value.get_text())
#            self.event.saveToDB(self.widget)
            if self.event.alarm == True:
              self.edit.bSetAlarm.set_label('Alarm '+str(self.event.alarm_value)+' minute(s) before')
            else:
              self.edit.bSetAlarm.set_label('Set Alarm')  
            self.edit.bSetAlarm.set_size_request(-1,-1)
            self.window.hide()

        def Cancel(self,widget):
            debug("Cancel AlarmEditor")
            self.window.hide()

        def show(self):
            #load the dialog from the glade file
            self.wTree = gtk.glade.XML(self.gladefile, "EditAlarm")
            self.editreccurence_win = self.wTree.get_widget("EditAlarm")
            if HILDON_SUPPORT:
              self.window = hildon.Window()
            else:
              self.window = gtk.Window()
            self.vbox = self.wTree.get_widget("vbox6")
            self.vbox.reparent(self.window)
#            self.window.set_title(self.editreccurence_win.get_title())
            self.window.connect("destroy", self.Cancel)
            if self.widget.window_in_fullscreen:
              self.window_in_fullscreen = True
              self.window.fullscreen ()
            else:
              self.window_in_fullscreen = False
              self.window.unfullscreen ()
            self.window.connect("key-press-event", self.on_key_press)
            self.window.connect("window-state-event", self.on_window_state_change)
            if HILDON_SUPPORT:
              self.widget.app.add_window(self.window)

            #Create our dictionay and connect it
            dic = {
                       "on_bOK_clicked" : self.Update,
                       "on_bCancel_clicked" : self.Cancel }
            self.wTree.signal_autoconnect(dic)

            #Get all of the Entry Widgets and set their text
            self.bAlarm = self.wTree.get_widget("bAlarm")
            self.bAlarm_value = self.wTree.get_widget("bAlarmMinutes")

            self.bAlarm.set_active(self.event.alarm)
            self.bAlarm_value.set_text(self.event.alarm_value.__str__())

            debug("Open AlarmEditor : "+self.event.description)

            if OVERRIDE_THEME==True:
              children_color_bg(self.window)

            self.window.show_all()

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
          elif event.keyval == gtk.keysyms.F7:
            print "plus"

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

class EventsDisplay:
    tree = ""
    store = ""
    colonnes = ["Start","End","Description","uuid","start","end","fg","bg",'style']

    def __init__(self,tree):
        self.tree = tree
        self.store = gtk.ListStore(str,str,str,str,str,str,str,str,int)
        self.tree.set_model(self.store)

        self.cell = gtk.CellRendererText()
        self.cell.set_property('background-set' , True)
        self.cell.set_property('foreground-set' , True)
        self.cell.set_property('wrap-mode' , pango.WRAP_WORD)
#        self.cell.set_property('editable' , True)
        self.cell.set_property('style' , True)

        self.__addCol__("Start",'markup')
        #self.__addCol__("End")
        self.__addCol__("Description",'text')
#        self.__addCol__("fg")
#        self.__addCol__("bg")
#
    def __addCol__ (self,lib,typ):
        col = gtk.TreeViewColumn(lib)
        self.tree.append_column(col)
        col.pack_start(self.cell, True)
#        col.add_attribute(self.cell, 'label', self.colonnes.index(lib))
        col.add_attribute(self.cell, typ,self.colonnes.index(lib))
        col.add_attribute(self.cell, 'background', 7)
        col.add_attribute(self.cell, 'foreground', 6)
        col.add_attribute(self.cell, 'style', 8)
#        col.add_attribute(self.cell, 'use_markup', 8)
