#!/usr/bin/env python

import sys
import datetime
import uuid
import sqlite3
import commands
import gobject
gobject.threads_init()

import threading
import string
import time
import socket
import pango

try:
  import hildon
  HILDON_SUPPORT = True
except:
  HILDON_SUPPORT = False

DATE_FORMAT = "%x"
TIME_FORMAT = "%X"
DAY_VIEW_FORMAT = "<b>%H:%M</b>"
WEEK_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
MONTH_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
DB_FORMAT = '%Y-%m-%d %H:%M'
FIRST_DAY_WEEK = 0
DAY_START_HOUR = 8
DAY_START_MINUTE = 0
DAY_END_HOUR = 18
DAY_END_MINUTE = 0

VERSION = '0.3.3'

try:
        import pygtk
        pygtk.require("2.0")
except:
        pass
try:
        import gtk
        import gtk.glade
except:
        sys.exit(1)

def addMonth(date, n=1):
    # add n+1 months to date then subtract 1 day
    # to get eom, last day of target month
    OneDay = datetime.timedelta(days=1)
    q,r = divmod(date.month+n, 12)
    eom = datetime.datetime(date.year+q, r+1, 1,date.hour,date.minute,date.second) - OneDay
    if date.month != (date+OneDay).month or date.day >= eom.day:
        return eom
    return eom.replace(day=date.day)

def startDay(d):
  return d.replace(hour=DAY_START_HOUR,minute=DAY_START_MINUTE)

def endDay(d):
  return d.replace(hour=DAY_END_HOUR,minute=DAY_END_MINUTE)

def endMonth(d):
    d = d.replace(day=1)
    d = addMonth(d)
    diff = datetime.timedelta(days=1)
    d = d - diff
    debug(d)
    return d

def supMonth(date, n=1):
    OneDay = datetime.timedelta(days=1)
    q,r = divmod(date.month-n, 12)
    debug(date.year)
    debug(q)
    eom = datetime.datetime(date.year+q, r+1, 1,date.hour,date.minute,date.second) - OneDay
    if date.month != (date+OneDay).month or date.day >= eom.day:
        return eom
    return eom.replace(day=date.day)

def getWeekDetails(date):
  nb_day = date.weekday()
  diff = datetime.timedelta(days=nb_day)
  first_day = date - diff
  nb_day = 6 - date.weekday()
  diff = datetime.timedelta(days=nb_day)
  last_day = date + diff
  return (first_day,last_day)

def googleToDays(s):
  d = []
  if 'SU' in s:
    d.append(6)
  if 'MO' in s:
    d.append(0)
  if 'TU' in s:
    d.append(1)
  if 'WE' in s:
    d.append(2)
  if 'TH' in s:
    d.append(3)
  if 'FR' in s:
    d.append(4)
  if 'SA' in s:
    d.append(5)
  if 'SU' in s:
    d.append(6)

  if len(d)==0:
    d = [0,1,2,3,4,5,6]

  return d

def dateToGoogle(d,format=0):
  hours=str((abs(time.altzone)) / 3600)
  minutes=str((abs(time.altzone)) % 3600)
  if len(minutes)==1:
    minutes = '0'+minutes
  if len(hours)==1:
    hours = '0'+hours
  if time.altzone<0:
    sep='+'
  else:
    sep='-'
  if format==0:
    return d.strftime("%Y-%m-%dT%H:%M:%S.000"+sep+hours+':'+minutes)
  elif format==1:
    diff = datetime.timedelta(seconds=time.altzone)
    return (d + diff).strftime("%Y%m%dT%H%M00")
  elif format==2:
    return d.strftime("%Y%m%d")

def dateFromGoogle(d,format=0):
  if format==1:
    debug('google reccurent date: %s' % (d))
    da = datetime.datetime.strptime(d[0:13], "%Y%m%dT%H%M")
    diff = datetime.timedelta(seconds=(-time.altzone))
    debug('Diff : %s' % (time.altzone))
    debug('Google converted date %s' % (da+diff))
    return da + diff

  elif format==2:
    da = datetime.datetime.strptime(d[0:8], "%Y%m%d")
    return da
  elif format==4:
    da = dateFromGoogle(d)
    if 'T' not in d:
      da = da.replace(hour=0,minute=0)
    return da
  elif format==5:
    da = dateFromGoogle(d)
    if 'T' not in d:
      da = da.replace(hour=23,minute=59)
      diff = datetime.timedelta(days=1)
      da = da - diff
    return da
  else:
    debug('Google date %s' % (d))
    if len(d)>16:
      da = datetime.datetime.strptime(d[0:16], "%Y-%m-%dT%H:%M")
    else:
      da = datetime.datetime.strptime(d, "%Y-%m-%d")

    diff = datetime.timedelta(seconds=(-time.altzone))
    debug('Diff : %s' % (time.altzone))
    debug('Google converted date %s' % (da+diff))
    return da + diff

def debug(s):
  print str(s)

class _IdleObject(gobject.GObject):
    """
    Override gobject.GObject to always emit signals in the main thread
    by emmitting on an idle handler
    """
    def __init__(self):
        gobject.GObject.__init__(self)

    def emit(self, *args):
        gobject.idle_add(gobject.GObject.emit,self,*args)

class _Thread(threading.Thread, _IdleObject):
    """
    Cancellable thread which uses gobject signals to return information
    to the GUI.
    """
    __gsignals__ =  { 
            "completed": (
                gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, []),
            "error": (
                gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [
                gobject.TYPE_STRING]),
            "progress": (
                gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [
                gobject.TYPE_FLOAT])
            }

    def __init__(self, *args):
        threading.Thread.__init__(self)
        _IdleObject.__init__(self)
        self.cancelled = False
        self.data = args[0]
        self.name = args[1]
        self.setName("%s" % self.name)

    def cancel(self):
        """
        Threads in python are not cancellable, so we implement our own
        cancellation logic
        """
        self.cancelled = True

    def run(self):
        print "Running %s" % str(self)
        import gdata
        import gdata.calendar.service
        import gdata.service
        import atom.service
        import gdata.calendar

        last_update = datetime.date(1970,01,01)
        try:
          if HILDON_SUPPORT:
            db_path='/home/user/.mPIM/mcalendar.db'
          else:
            db_path='mcalendar.db'
          self.db = sqlite3.connect(db_path)

          self.dbcur = self.db.cursor()

          cal_client = gdata.calendar.service.CalendarService()
          self.dbcur.execute('SELECT id,content FROM prefs')       
          for prefs in self.dbcur.fetchall():
            if prefs[0]=='email':
              cal_client.email = prefs[1]
            if prefs[0]=='password':
              cal_client.password = prefs[1]
            if prefs[0]=='last_update':
              last_update = datetime.datetime.strptime(prefs[1],DB_FORMAT)
          future_update = datetime.datetime.now()  
          cal_client.source = 'mCalendar ' + VERSION
          cal_client.ProgrammaticLogin()  
          self.emit("progress", 10)

          #Delete Google Event
          debug('Delete google event deleted locally')
          self.dbcur.execute('SELECT googleid,uuid FROM events WHERE description="DELETED"')       
          for an_event in self.dbcur.fetchall():
              anid = an_event[0]
              print anid
              try:
                deleted_event = cal_client.GetCalendarEventEntry(anid)   
                cal_client.DeleteEvent(deleted_event.GetEditLink().href)
              except gdata.service.RequestError,e:
                self.emit("error", str(e))  
          self.dbcur.execute('DELETE FROM events WHERE description="DELETED"')       
          self.db.commit()
          self.emit("progress", 20)

          #send local update
          self.dbcur.execute('SELECT uuid FROM events WHERE googleid!="" AND lastup>"'+last_update.strftime(DB_FORMAT)+'"')       
          for an_event in self.dbcur.fetchall():
            e = Event(an_event[0],self)
            debug('uuid to update on google : %s' % (an_event[0]))
            event = cal_client.GetCalendarEventEntry(e.googleid)
            event.title = atom.Title(text=e.description)

            if e.repeat==True:
              recurrence_data = ('DTSTART;TZID=Etc/GMT:'+dateToGoogle(e.start_datetime,1)+'\r\n'     
                   + 'DTEND;TZID=Etc/GMT:'+dateToGoogle(e.end_datetime,1)+'\r\n'
                   + 'RRULE:FREQ='+e.googleFrequency()+';UNTIL='+dateToGoogle(e.repeat_until,2)+';INTERVAL='+str(e.repeat_number))
              if e.repeat_byday != "":
                recurrence_data  = recurrence_data + ";BYDAY=" +e.repeat_byday
              recurrence_data  = recurrence_data +'\r\n' 
              debug(recurrence_data)
              event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
            if len(event.when)==0:
              event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))
            else:
              event.when[0] = gdata.calendar.When(start_time=dateToGoogle(e.start_datetime) , end_time=dateToGoogle(e.end_datetime) )

            event.updated.text = dateToGoogle(e.lastup)
            debug(2)
            debug(event.GetEditLink())
            debug(event.GetEditLink().href)
            cal_client.UpdateEvent(event.GetEditLink().href, event)
          self.emit("progress", 40)

          #Create Update Event
          start_index = 1
          end_reached = False
          
          while(end_reached == False):
            debug('Get All Google Events')
            query = gdata.calendar.service.CalendarEventQuery('default', 'private', 'full', None, {"ctz":"utc"})
            query.updated_min = dateToGoogle(last_update)
            query.max_results = 3
            query.start_index = str(start_index)
            debug(dateToGoogle(last_update))
            feed = cal_client.CalendarQuery(query)
            debug(4)
            self.emit("progress", 60)
            if len(feed.entry)<5:
              end_reached = True
            for i, an_event in enumerate(feed.entry):
              an_event.id.text = string.replace(an_event.id.text,'composite','full')
              self.dbcur.execute('SELECT uuid,lastup FROM events WHERE googleid="'+an_event.id.text+'"')       
              uuid = ''
              debug(5)
              for event in self.dbcur.fetchall():
                uuid = event[0]
                updated = event[1]
  
              debug('status:')
              debug(an_event.event_status.value)
              if an_event.event_status.value=='CANCELED':
                debug('Delete local event deleted on google : %s' % (an_event.id.text))
                self.dbcur.execute('DELETE FROM events WHERE googleid="'+an_event.id.text+'"')       
                self.db.commit()
              else:
                e = Event(uuid,self)
                if uuid == '':
                  #new event
                  for a_when in an_event.when:
                    e.start_datetime = dateFromGoogle(a_when.start_time,format=4)
                    e.end_datetime = dateFromGoogle(a_when.end_time,format=5)
                    for reminder in a_when.reminder:
                      e.alarm=True
                      e.alarm_value = reminder.minutes
                  e.description = an_event.title.text
                  e.googleid = an_event.id.text
                  print dir(an_event.send_event_notifications)
                  print an_event.send_event_notifications
  #                if an_event.reminder != None:
  #                  print 'Reminder'
  #                  print an_event.reminder
  #                if an_event.updated==None:
  #                  debug('updated=None')
                  e.lastup = dateFromGoogle(an_event.updated.text)
                  if an_event.recurrence == None:
                    debug('recurrence=None')
                    e.repeat = False
                  else:
                      debug('recurrence=True')     
                      debug(an_event.recurrence.text)             
                      e.repeat=True
                      rstring = an_event.recurrence.text
                      rstring = rstring.split('\n')
                      if len(rstring[2]) != 0 :
                        for line in rstring:
                            if 'DTSTART' in line:
                              value = line.split(':')[1]
                              if 'T' in value:
                                e.start_datetime = dateFromGoogle(value,1)
                              else:
                                e.start_datetime = dateFromGoogle(value,2)
                                e.start_datetime = e.start_datetime.replace(hour=0,minute=0)
                            elif 'DTEND' in line:
                              value = line.split(':')[1]
                              if 'T' in value:
                                e.end_datetime = dateFromGoogle(value,1)
                              else:
                                e.end_datetime = dateFromGoogle(value,2)
                                e.end_datetime = e.end_datetime.replace(hour=23,minute=59)
                                diff = datetime.timedelta(days=1)
                                e.end_datetime = e.end_datetime - diff
  
                            if "RRULE" in line:
                              print 'line 320:'+line
                              line = line.replace('RRULE:','')
                              lines = line.split(';')
                              e.repeat_number = 1
                              e.repeat_until = datetime.datetime(9999,9,9)
                              for value in lines:
                                if "FREQ=" in value:
                                  value = value.replace('FREQ=','')
                                  e.setFrequencyFromGoogle(value)
                                elif "UNTIL=" in value:
                                  value = value.replace('UNTIL=','')
                                  if 'T' in value:
                                    e.repeat_until = dateFromGoogle(value,1)
                                  else:
                                    e.repeat_until = dateFromGoogle(value,2)
                                if "INTERVAL=" in value:
                                  value = value.replace('INTERVAL=','')
                                  e.repeat_number = int(value)
                                if "BYDAY=" in value:
                                  value = value.replace('BYDAY=','')
                                  e.repeat_byday = value
  
                  e.saveToDB(self)
                else:
                  #check update
                  google_update = dateFromGoogle(an_event.updated.text)
                  debug('dates : ...')
                  debug(google_update)
                  debug(e.lastup)
                  if google_update==e.lastup:
                    debug('Events match %s' % (uuid))
                  elif google_update<e.lastup:
                    self.emit("error", 'WARNING')  
                    debug('Need to update google %s' % (uuid))
                    debug('Google utc update  date : %s' %(str(an_event.updated.text)))
                    debug('Google timezone update  date : %s' %(str(google_update)))
                    debug('Local update date : %s' %(str(e.lastup)))
                    an_event.title.text = e.description
                    debug(dir(an_event))
                    an_event.updated.text = dateToGoogle(e.lastup)
                    for a_when in an_event.when:
                      a_when.start_time = dateToGoogle(e.start_datetime)                  
                      a_when.end_time = dateToGoogle(e.end_datetime)
                    an_event.updated.text = dateToGoogle(e.lastup)
                    debug('Local utc update date : %s' %(str(an_event.updated.text)))
                    cal_client.UpdateEvent(an_event.GetEditLink().href, an_event)
                  elif google_update>e.lastup:
                    debug('update local event %s' % (uuid))
                    print an_event
                    for a_when in an_event.when:
                      e.start_datetime = dateFromGoogle(a_when.start_time,format=4)
                      e.end_datetime = dateFromGoogle(a_when.end_time,format=5)
                      for reminder in a_when.reminder:
  		                  e.alarm=True
  		                  e.alarm_value = reminder.minutes
                    e.description = an_event.title.text
                    e.googleid = an_event.id.text
                    e.lastup = dateFromGoogle(an_event.updated.text)
  #                  if an_event.reminder != None:
  #	                  print 'Reminder'
  #	                  print an_event.reminder
  
                    if an_event.recurrence == None:
                      debug('recurrence=None')
                    else:
                      debug('recurrence=True')
  
                      e.repeat=True
                      rstring = an_event.recurrence.text
                      rstring = rstring.split('\n')
                      if len(rstring[2]) != 0 :
                        for line in rstring:
                            if 'DTSTART' in line:
                              value = line.split(':')[1]
                              if 'T' in value:
                                e.start_datetime = dateFromGoogle(value,1)
                              else:
                                e.start_datetime = dateFromGoogle(value,2)
                                e.start_datetime = e.start_datetime.replace(hour=0,minute=0)
                            elif 'DTEND' in line:
                              value = line.split(':')[1]
                              if 'T' in value:
                                e.end_datetime = dateFromGoogle(value,1)
                              else:
                                e.end_datetime = dateFromGoogle(value,2)
                                e.end_datetime = e.end_datetime.replace(hour=23,minute=59)
                                diff = datetime.timedelta(days=1)
                                e.end_datetime = e.end_datetime - diff
  
                            if "RRULE" in line:
                              print 'line 402:'+line
                              line = line.replace('RRULE:','')
                              lines = line.split(';')
                              e.repeat_number = 1
                              e.repeat_until = datetime.datetime(9999,9,9)
                              for value in lines:
                                if "FREQ=" in value:
                                  value = value.replace('FREQ=','')
                                  e.setFrequencyFromGoogle(value)
                                elif "UNTIL=" in value:
                                  value = value.replace('UNTIL=','')
                                  if 'T' in value:
                                    e.repeat_until = dateFromGoogle(value,1)
                                  else:
                                    e.repeat_until = dateFromGoogle(value,2)
                                if "INTERVAL=" in value:
                                  value = value.replace('INTERVAL=','')
                                  e.repeat_number = int(value)
                                if "BYDAY=" in value:
                                  value = value.replace('BYDAY=','')
                                  e.repeat_byday = value
  
                    e.saveToDB(self)
                    debug(dir(an_event))
                    debug(dir(an_event.recurrence))
                    if (an_event.recurrence!=None):
                      debug(an_event.recurrence.text)
            start_index = start_index + 3

          #send new
          self.emit("progress", 80)
          self.dbcur.execute('SELECT uuid FROM events WHERE googleid=""')       
          for an_event in self.dbcur.fetchall():
            e = Event(an_event[0],self)
            debug('new uuid to send : %s' % (an_event[0]))
            event = gdata.calendar.CalendarEventEntry()
            event.author.append(atom.Author(name=atom.Name(text='mCalendar')))
            event.title = atom.Title(text=e.description)
            if e.repeat==True:
              recurrence_data = ('DTSTART;TZID=Etc/GMT:'+dateToGoogle(e.start_datetime,1)+'\r\n'     
                   + 'DTEND;TZID=Etc/GMT:'+dateToGoogle(e.end_datetime,1)+'\r\n'
                   + 'RRULE:FREQ='+e.googleFrequency()+';UNTIL='+dateToGoogle(e.repeat_until,2)+';INTERVAL='+str(e.repeat_number))
              if e.repeat_byday != "":
                reccurence_data = reccurence_data + ";BYDAY=" +e.repeat_byday
              reccurence_data = reccurence_data + '\r\n'
              debug(recurrence_data)
              event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
              event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))              
            else:
              event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))
            new_event = cal_client.InsertEvent(event,'/calendar/feeds/default/private/full')
            e.googleid = new_event.id.text
            e.saveToDB(self)

          self.emit("progress", 90)

          self.dbcur.execute('UPDATE prefs SET content="'+future_update.strftime(DB_FORMAT)+'" WHERE id ="last_update";')
          self.db.commit()

          self.emit("progress", 100)

        except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,e:

          self.emit("error", str(e))  
          import traceback
          e = traceback.print_exc()
          debug(e)

        self.emit("completed")

class ThreadManager:
    """
    Manages many FooThreads. This involves starting and stopping
    said threads, and respecting a maximum num of concurrent threads limit
    """
    def __init__(self, maxConcurrentThreads):
        self.maxConcurrentThreads = maxConcurrentThreads
        self.Threads = {}
        self.pendingThreadArgs = []

    def _register_thread_completed(self, thread, *args):
        """
        Decrements the count of concurrent threads and starts any 
        pending threads if there is space
        """
        del(self.Threads[args])
        running = len(self.Threads) - len(self.pendingThreadArgs)

        print "%s completed. %s running, %s pending" % (
                            thread, running, len(self.pendingThreadArgs))

        if running < self.maxConcurrentThreads:
            try:
                args = self.pendingThreadArgs.pop()
                print "Starting pending %s" % self.Threads[args]
                self.Threads[args].start()
            except IndexError: pass

    def make_thread(self, completedCb, progressCb,errorCb, userData,  *args):
        """
        Makes a thread with args. The thread will be started when there is
        a free slot
        """
        running = len(self.Threads) - len(self.pendingThreadArgs)

        if args not in self.Threads:
            thread = _Thread(*args)
            thread.connect("completed", completedCb, userData)
            thread.connect("completed", self._register_thread_completed, *args)
            thread.connect("progress", progressCb, userData)
            thread.connect("error", errorCb, userData)
            self.Threads[args] = thread

            if running < self.maxConcurrentThreads:
                print "Starting %s" % thread
                self.Threads[args].start()
            else:
                print "Queing %s" % thread
                self.pendingThreadArgs.append(args)

    def stop_all_threads(self, block=False):
        """
        Stops all threads. If block is True then actually wait for the thread
        to finish (may block the UI) 
        """
        for thread in self.Threads.values():
            thread.cancel()
            if block:
                if thread.isAlive():
                    thread.join()

class mAlert:

  def __init__(self,message="Unknown error"):
    dialog = gtk.MessageDialog(gtk.Window(),
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_ERROR,
                    gtk.BUTTONS_OK,
                    message)
    rc = dialog.run ()
    dialog.destroy ()

class Event:
        """This class represents one event"""

        def __init__(self,suuid="",widget=None,start="",end=""):

            self.start_datetime = datetime.datetime.now()
            one_hour = datetime.timedelta(hours=1)
            self.end_datetime = datetime.datetime.now() + one_hour
            self.repeat = False
            self.repeat_until = datetime.datetime(9999,9,9)
            self.repeat_number = 1
            self.repeat_byday = ''
            self.frequency = ''
            self.description = ''
            self.googleid = ''
            self.lastup = datetime.date(1974,1,1)
            self.alarm = False
            self.alarm_value = 0
            self.alarm_id = 0
            print 'test'
            print start
            print suuid

            if suuid=="":
              self.uuid = uuid.uuid4().__str__()
              self.new = True
              if start<>"":
                self.start_datetime = datetime.datetime.strptime(start,DB_FORMAT)
                self.end_datetime = datetime.datetime.strptime(end,DB_FORMAT)
              debug("new uuid : " + self.uuid)
            else:
              self.uuid = suuid
              self.loadFromDB(self.uuid,widget)
              self.new = False
              debug("old uuid : " + self.uuid)

        def loadFromDB(self,suuid,widget):
            debug("load")
            widget.dbcur.execute('SELECT  start, end, description, repeat, repeatvalue, until,googleid,lastup,frequency,byday,alarm,alarm_value,alarm_id FROM events where uuid="'+suuid+'"')
            for event in widget.dbcur.fetchall():
              self.start_datetime = datetime.datetime.strptime(event[0],DB_FORMAT)
              self.end_datetime = datetime.datetime.strptime(event[1],DB_FORMAT)
              self.repeat = int(event[3])
              self.repeat_until =  datetime.datetime.strptime(event[5],DB_FORMAT)
              self.repeat_number = int(event[4])
              self.description = event[2]
              self.lastup = datetime.datetime.strptime(event[7],DB_FORMAT)
              self.googleid = event[6]
              self.frequency = event[8]
              self.repeat_byday = event[9]
              self.alarm = int(event[10])
              self.alarm_value = int(event[11])
              self.alarm_id = int(event[12])

              debug(self.description)
              debug(self.lastup)

        def saveToDB(self,widget):
            import osso.alarmd
            debug("saveToDB") 
            if self.alarm_id != 0:
              osso.alarmd.get_alarm(self.alarm).cancel_alarm()
              self.alarm_id = 0

            if self.alarm == True:
              diff = datetime.timedelta(minutes=int(self.alarm_value))
              d = self.start_datetime - diff
              self.alarm_id = osso.alarmd.add_alarm(time.mktime(d.timetuple()),title=self.description)
              debug(self.alarm_id)

            if self.new==True:
              widget.dbcur.execute('INSERT INTO events (uuid , start, end, description, repeat, repeatvalue, until, lastup,googleid,frequency,byday,alarm,alarm_value,alarm_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?);',[self.uuid,self.start_datetime.strftime(DB_FORMAT),self.end_datetime.strftime(DB_FORMAT),self.description, str(int(self.repeat)) , str(self.repeat_number), self.repeat_until.strftime(DB_FORMAT),self.lastup.strftime(DB_FORMAT),str(self.googleid),self.frequency,self.repeat_byday,str(int(self.alarm)), str(self.alarm_value),self.alarm_id])
              widget.db.commit()
            else:
              widget.dbcur.execute('UPDATE events SET start=?, end=?, description=?, repeat=?, repeatvalue=?, until=?, lastup=?,googleid=?,frequency=?, byday=?,alarm=?,alarm_value=?,alarm_id=? WHERE uuid=?;',[self.start_datetime.strftime(DB_FORMAT),self.end_datetime.strftime(DB_FORMAT),self.description, str(int(self.repeat)) , str(self.repeat_number), self.repeat_until.strftime(DB_FORMAT),self.lastup.strftime(DB_FORMAT),str(self.googleid),self.frequency,self.repeat_byday,str(int(self.alarm)), str(self.alarm_value),self.alarm_id,self.uuid])
              widget.db.commit()

        def delFromDB(self,widget):
            debug("delFromDB")
            if self.googleid == '':
              widget.dbcur.execute('DELETE FROM events WHERE uuid ="'+self.uuid + '";')
              widget.db.commit()
            else:
              widget.dbcur.execute('UPDATE events set description="DELETED" WHERE uuid ="'+self.uuid + '";')
              widget.db.commit()

        def setFrequencyFromGoogle(self,f):
          if f == 'DAILY':
            self.frequency='Day(s)'
          elif f == 'WEEKLY':
            self.frequency='Week(s)'
          elif f == 'MONTHLY':
            self.frequency='Month(s)'
          elif f == 'YEARLY':
            self.frequency='Year(s)'

        def googleFrequency(self):
          if self.frequency=='Day(s)':
            return 'DAILY'
          elif self.frequency=='Week(s)':
            return 'WEEKLY'
          elif self.frequency=='Month(s)':
            return 'MONTHLY'
          elif self.frequency=='Year(s)':
            return 'YEARLY'

class EventEditor:
        """This class is used to edit and view event"""

        def __init__(self, suuid,widget,start="",end=""):

                #setup the glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.event = Event(suuid,widget,start,end)
                self.widget = widget

        def Update(self,widget):
            debug("Update EventEditor")
#            self.event.repeat = self.bRepeat.get_active()
#            self.event.repeat_number =  int(self.eNumber.get_text())
#            if self.bFrequency.get_active_text()!=None:
#              self.event.frequency = self.bFrequency.get_active_text()
            start,end = self.tDescription.get_buffer().get_bounds()
            self.event.description = self.tDescription.get_buffer().get_text(start,end)
            self.event.lastup = datetime.datetime.now()
            debug(self.event.frequency)
            self.event.saveToDB(self.widget)
            self.widget.updateList()
            self.window.hide()

        def Cancel(self,widget):
            debug("Cancel EventEditor")
            self.window.hide()

        def Delete(self,widget):
            debug("Delete EventEditor")
            self.event.delFromDB(self.widget)
            self.widget.updateList()
            self.window.hide()

        def timePicker(self,date):
            h = date.hour
            m = date.minute
            if HILDON_SUPPORT:
              D = hildon.TimePicker(hildon.Window())
              D.set_time(h,m)
              D.run()
              h,m = D.get_time()
              D.destroy()
            return datetime.datetime.combine(date,datetime.time(h,m))

        def datePicker(self,date):   
            d = date.day
            m = date.month
            y = date.year
            if HILDON_SUPPORT:
              D = hildon.CalendarPopup(hildon.Window(),d,m,y)
              if(D.run()==gtk.RESPONSE_OK):
                y,m,d = D.get_date()
              D.destroy()
            return datetime.datetime.combine(datetime.date(y,m,d),date.time())

        def dateControl(self):
          if self.event.start_datetime>self.event.end_datetime:
            diff = datetime.timedelta(hours=1)
            self.event.end_datetime=self.event.start_datetime+ diff
            self.bEndDate.set_label(self.event.end_datetime.strftime(DATE_FORMAT))
            self.bEndTime.set_label(self.event.end_datetime.strftime(TIME_FORMAT))
          if self.event.start_datetime>self.event.repeat_until:
            self.event.repeat_until = self.event.start_datetime
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def setStartDate(self,widget):
            self.event.start_datetime = self.datePicker(self.event.start_datetime)
            self.bStartDate.set_label(self.event.start_datetime.strftime(DATE_FORMAT))
            self.dateControl()

        def setEndDate(self,widget):
            self.event.end_datetime = self.datePicker(self.event.end_datetime)
            self.bEndDate.set_label(self.event.end_datetime.strftime(DATE_FORMAT))
            self.dateControl()

        def setUntilDate(self,widget):
            self.event.repeat_until = self.datePicker(self.event.repeat_until)
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def openAlarmWin(self,widget):
            AlarmEditor(self.event,self).show()

        def openReccurenceWin(self,widget):
            ReccurenceEditor(self.event,self).show()

        def setStartTime(self,widget):
            self.event.start_datetime = self.timePicker(self.event.start_datetime)
            self.bStartTime.set_label(self.event.start_datetime.strftime(TIME_FORMAT))
            self.dateControl()

        def setEndTime(self,widget):
            self.event.end_datetime = self.timePicker(self.event.end_datetime)
            self.bEndTime.set_label(self.event.end_datetime.strftime(TIME_FORMAT))
            self.dateControl()

        def show(self):
            #load the dialog from the glade file
            self.wTree = gtk.glade.XML(self.gladefile, "EditEvent")
            self.editevent_win = self.wTree.get_widget("EditEvent")
            if HILDON_SUPPORT:
              self.window = hildon.Window()
            else:
              self.window = gtk.Window()
            self.vbox = self.wTree.get_widget("vbox1")
            self.vbox.reparent(self.window)
            self.window.set_title(self.editevent_win.get_title())
            self.window.connect("destroy", self.Cancel)
            if self.widget.window_in_fullscreen:
              self.window_in_fullscreen = True
              self.window.fullscreen ()
            else:
              self.window_in_fullscreen = False
              self.window.unfullscreen ()
            self.window.connect("key-press-event", self.on_key_press)
            self.window.connect("window-state-event", self.on_window_state_change)
            if HILDON_SUPPORT:
              self.widget.app.add_window(self.window)

            #Create our dictionay and connect it
            dic = {
                       "on_bOK_clicked" : self.Update,
                       "on_bCancel_clicked" : self.Cancel,
                       "on_bDelete_clicked" : self.Delete,
                       "on_bStartDate_clicked" : self.setStartDate,
                       "on_bStartTime_clicked" : self.setStartTime ,
                       "on_bEndDate_clicked" : self.setEndDate ,
                       "on_bEndTime_clicked" : self.setEndTime, 
                       "on_bSetReccurence_clicked" : self.openReccurenceWin, 
                       "on_bSetAlarm_clicked" : self.openAlarmWin}
            self.wTree.signal_autoconnect(dic)

            #Get all of the Entry Widgets and set their text
            self.bStartDate = self.wTree.get_widget("bStartDate")
            self.bStartTime = self.wTree.get_widget("bStartTime")
            self.bEndDate = self.wTree.get_widget("bEndDate")
            self.bEndTime = self.wTree.get_widget("bEndTime")
            self.tDescription = self.wTree.get_widget("tDescription")
            self.bSetReccurence = self.wTree.get_widget("bSetReccurence")
            self.bSetAlarm = self.wTree.get_widget("bSetAlarm")

            self.bStartDate.set_label(self.event.start_datetime.strftime(DATE_FORMAT))
            self.bStartTime.set_label(self.event.start_datetime.strftime(TIME_FORMAT))
            self.bEndDate.set_label(self.event.end_datetime.strftime(DATE_FORMAT))
            self.bEndTime.set_label(self.event.end_datetime.time().strftime(TIME_FORMAT))
            self.tDescription.get_buffer().set_text(self.event.description)

            if self.event.alarm == True:
              self.bSetAlarm.set_label('Alarm '+str(self.event.alarm_value)+' minute(s) before')
              self.bSetAlarm.set_size_request(-1,-1)
            if self.event.repeat == True:
              self.bSetReccurence.set_label('Repeat every '+str(self.event.repeat_number)+' '+self.event.frequency)
              self.bSetReccurence.set_size_request(-1,-1)

            debug("Open EventEditor : "+self.event.description)

            self.window.show_all()

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
          elif event.keyval == gtk.keysyms.F7:
            print "plus"

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

class ReccurenceEditor:
        """This class is used to edit and view event"""

        def __init__(self, event,widget,start="",end=""):

                #setup the glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.event = event
                self.widget = widget.widget
                self.edit = widget

        def Update(self,widget):
            debug("Update ReccurenceEditor")
            self.event.repeat = self.bRepeat.get_active()
            self.event.repeat_number =  int(self.eNumber.get_text())
            self.event.repeat_byday = ""
            for dayweek in range(0,7):
              awidget = self.wTree.get_widget("bDay"+str(dayweek))
              debug("bDay"+str(dayweek))
              if awidget.get_active() == True:
                if dayweek == 0:
                  self.event.repeat_byday= self.event.repeat_byday+'MO;'
                elif dayweek == 1:
                  self.event.repeat_byday= self.event.repeat_byday+'TU;'
                elif dayweek == 2:
                  self.event.repeat_byday= self.event.repeat_byday+'WE;'
                elif dayweek == 3:
                  self.event.repeat_byday= self.event.repeat_byday+'TH;'
                elif dayweek == 4:
                  self.event.repeat_byday= self.event.repeat_byday+'FR;'
                elif dayweek == 5:
                  self.event.repeat_byday= self.event.repeat_byday+'SA;'
                elif dayweek == 6:
                  self.event.repeat_byday= self.event.repeat_byday+'SU;'

                if len(self.event.repeat_byday)>0:
                  self.event.repeat_byday = self.event.repeat_byday[0:len(self.event.repeat_byday)]

            debug('repeat_byday : '+self.event.repeat_byday)                 
            if self.bFrequency.get_active_text()!=None:
              self.event.frequency = self.bFrequency.get_active_text()
#            self.event.saveToDB(self.widget)
            if self.event.repeat == True:
              self.edit.bSetReccurence.set_label('Repeat every '+str(self.event.repeat_number)+' '+self.event.frequency)
            else:
              self.edit.bSetReccurence.set_label('Set Reccurence') 
            self.edit.bSetReccurence.set_size_request(-1,-1)
            self.window.hide()

        def Cancel(self,widget):
            debug("Cancel ReccurenceEditor")
            self.window.hide()

        def timePicker(self,date):
            h = date.hour
            m = date.minute
            if HILDON_SUPPORT:
              D = hildon.TimePicker(hildon.Window())
              D.set_time(h,m)
              D.run()
              h,m = D.get_time()
              D.destroy()
            return datetime.datetime.combine(date,datetime.time(h,m))

        def datePicker(self,date):   
            d = date.day
            m = date.month
            y = date.year
            if HILDON_SUPPORT:
              D = hildon.CalendarPopup(hildon.Window(),d,m,y)
              if(D.run()==gtk.RESPONSE_OK):
                y,m,d = D.get_date()
              D.destroy()
            return datetime.datetime.combine(datetime.date(y,m,d),date.time())

        def dateControl(self):
          if self.event.start_datetime>self.event.repeat_until:
            self.event.repeat_until = self.event.start_datetime
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def setUntilDate(self,widget):
            self.event.repeat_until = self.datePicker(self.event.repeat_until)
            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))

        def show(self):
            #load the dialog from the glade file
            self.wTree = gtk.glade.XML(self.gladefile, "EditRecurrence")
            self.editreccurence_win = self.wTree.get_widget("EditRecurrence")
            if HILDON_SUPPORT:
              self.window = hildon.Window()
            else:
              self.window = gtk.Window()
            self.vbox = self.wTree.get_widget("vbox16")
            self.vbox.reparent(self.window)
            self.window.set_title(self.editreccurence_win.get_title())
            self.window.connect("destroy", self.Cancel)
            if self.widget.window_in_fullscreen:
              self.window_in_fullscreen = True
              self.window.fullscreen ()
            else:
              self.window_in_fullscreen = False
              self.window.unfullscreen ()
            self.window.connect("key-press-event", self.on_key_press)
            self.window.connect("window-state-event", self.on_window_state_change)
            if HILDON_SUPPORT:
              self.widget.app.add_window(self.window)

            #Create our dictionay and connect it
            dic = {
                       "on_bOK_clicked" : self.Update,
                       "on_bCancel_clicked" : self.Cancel,
                       "on_bUntil_clicked" : self.setUntilDate }
            self.wTree.signal_autoconnect(dic)

            #Get all of the Entry Widgets and set their text
            self.bUntil = self.wTree.get_widget("bUntil")
            self.bRepeat = self.wTree.get_widget("bRepeat")
            self.eNumber = self.wTree.get_widget("eNumber")
            self.bFrequency = self.wTree.get_widget("bFrequency")

            if (self.event.repeat_until.year==9999):
              self.bUntil.set_label('No end')
            else:
              self.bUntil.set_label(self.event.repeat_until.strftime(DATE_FORMAT))
            self.bRepeat.set_active(self.event.repeat)
            self.eNumber.set_text(self.event.repeat_number.__str__())
            if self.event.frequency=='Day(s)':
              self.bFrequency.set_active(0)
            if self.event.frequency=='Week(s)':
              self.bFrequency.set_active(1)
            if self.event.frequency=='Month(s)':
              self.bFrequency.set_active(2)
            if self.event.frequency=='Year(s)':
              self.bFrequency.set_active(3)

            for dayweek in googleToDays(self.event.repeat_byday):
              awidget = self.wTree.get_widget("bDay"+str(dayweek))
              awidget.set_active(True)

            debug("Open ReccurenceEditor : "+self.event.description)

            self.window.show_all()

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
          elif event.keyval == gtk.keysyms.F7:
            print "plus"

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

class AlarmEditor:
        """This class is used to edit and view event"""

        def __init__(self, event,widget,start="",end=""):

                #setup the glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.event = event
                self.widget = widget.widget
                self.edit = widget

        def Update(self,widget):
            debug("Update AlarmEditor")
            self.event.alarm = self.bAlarm.get_active()
            self.event.alarm_value =  int(self.bAlarm_value.get_text())
#            self.event.saveToDB(self.widget)
            if self.event.alarm == True:
              self.edit.bSetAlarm.set_label('Alarm '+str(self.event.alarm_value)+' minute(s) before')
            else:
              self.edit.bSetAlarm.set_label('Set Alarm')  
            self.edit.bSetAlarm.set_size_request(-1,-1)
            self.window.hide()

        def Cancel(self,widget):
            debug("Cancel AlarmEditor")
            self.window.hide()

        def show(self):
            #load the dialog from the glade file
            self.wTree = gtk.glade.XML(self.gladefile, "EditAlarm")
            self.editreccurence_win = self.wTree.get_widget("EditAlarm")
            if HILDON_SUPPORT:
              self.window = hildon.Window()
            else:
              self.window = gtk.Window()
            self.vbox = self.wTree.get_widget("vbox6")
            self.vbox.reparent(self.window)
            self.window.set_title(self.editreccurence_win.get_title())
            self.window.connect("destroy", self.Cancel)
            if self.widget.window_in_fullscreen:
              self.window_in_fullscreen = True
              self.window.fullscreen ()
            else:
              self.window_in_fullscreen = False
              self.window.unfullscreen ()
            self.window.connect("key-press-event", self.on_key_press)
            self.window.connect("window-state-event", self.on_window_state_change)
            if HILDON_SUPPORT:
              self.widget.app.add_window(self.window)

            #Create our dictionay and connect it
            dic = {
                       "on_bOK_clicked" : self.Update,
                       "on_bCancel_clicked" : self.Cancel }
            self.wTree.signal_autoconnect(dic)

            #Get all of the Entry Widgets and set their text
            self.bAlarm = self.wTree.get_widget("bAlarm")
            self.bAlarm_value = self.wTree.get_widget("bAlarmMinutes")

            self.bAlarm.set_active(self.event.alarm)
            self.bAlarm_value.set_text(self.event.alarm_value.__str__())

            debug("Open AlarmEditor : "+self.event.description)

            self.window.show_all()

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
          elif event.keyval == gtk.keysyms.F7:
            print "plus"

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

class EventsDisplay:
    tree = ""
    store = ""
    colonnes = ["Start","End","Description","uuid","start","end"]

    def __init__(self,tree):
        self.tree = tree
        self.store = gtk.ListStore(str,str,str,str,str,str)
        self.tree.set_model(self.store)
        self.cell = gtk.CellRendererText()
        self.__addCol__("Start")
        self.__addCol__("End")
        self.__addCol__("Description")

    def __addCol__ (self,lib):
        col = gtk.TreeViewColumn(lib)

        self.tree.append_column(col)
        col.pack_start(self.cell, True)
        col.add_attribute(self.cell, 'markup', self.colonnes.index(lib))

class mPrefs:

        def __init__(self,widget):
                self.widget = widget
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.wTree = gtk.glade.XML(self.gladefile, "Prefs")       
                if HILDON_SUPPORT:
                  self.window = hildon.Window()
                else:
                  self.window = gtk.Window()
                self.prefs_win = self.wTree.get_widget("Prefs")
                self.vbox = self.wTree.get_widget("vbox9")
                self.vbox.reparent(self.window)
                self.window.set_title(self.prefs_win.get_title())
                self.window.connect("destroy", self.cancel)
                self.widget.app.add_window(self.window)

                #Create our dictionay and connect it
                dic = {
                       "on_bOK_clicked" : self.validate,
                       "on_bCancel_clicked" : self.cancel}
                self.wTree.signal_autoconnect(dic)

                self.bEmail = self.wTree.get_widget("bEmail")
                self.bPassword = self.wTree.get_widget("bPassword")
                self.bPassword.set_invisible_char('*')
                self.bPassword.set_visibility(False)
                self.bLastUpdate = self.wTree.get_widget("bLastUpdate")
                self.fDate = self.wTree.get_widget("fDate")
                self.fTime = self.wTree.get_widget("fTime")
                self.fDay_view = self.wTree.get_widget("fDay_view")
                self.fWeek_view = self.wTree.get_widget("fWeek_view")
                self.fMonth_view = self.wTree.get_widget("fMonth_view")
                self.wStart_time = self.wTree.get_widget("wStart_time")
                self.wEnd_time = self.wTree.get_widget("wEnd_time")

                self.widget.dbcur.execute('SELECT id,content FROM prefs')       
                for prefs in self.widget.dbcur.fetchall():
                  if prefs[0]=='email':
                    self.bEmail.set_text(prefs[1])
                  if prefs[0]=='password':
                    self.bPassword.set_text(prefs[1])
                  if prefs[0]=='last_update':
                    self.bLastUpdate.set_text(prefs[1])
                  if prefs[0]=='date_format':
                    self.fDate.set_text(prefs[1])
                  if prefs[0]=='time_format':
                    self.fTime.set_text(prefs[1])
                  if prefs[0]=='day_view':
                    self.fDay_view.set_text(prefs[1])
                  if prefs[0]=='week_view':
                    self.fWeek_view.set_text(prefs[1])
                  if prefs[0]=='month_view':
                    self.fMonth_view.set_text(prefs[1])
                  if prefs[0]=='wstart_time':
                    self.wStart_time.set_text(prefs[1])
                  if prefs[0]=='wend_time':
                    self.wEnd_time.set_text(prefs[1])

                self.window.show_all()

        def cancel(self,widget):
                self.window.hide()

        def validate(self,widget):
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.bEmail.get_text()+'" where id = "email"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.bLastUpdate.get_text()+'" where id = "last_update"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.bPassword.get_text()+'" where id = "password"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fDate.get_text()+'" where id = "date_format"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fTime.get_text()+'" where id = "time_format"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fDay_view.get_text()+'" where id = "day_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fWeek_view.get_text()+'" where id = "week_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.fMonth_view.get_text()+'" where id = "month_view"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.wStart_time.get_text()+'" where id = "wstart_time"')
                self.widget.db.commit()
                self.widget.dbcur.execute('UPDATE prefs SET content="'+self.wEnd_time.get_text()+'" where id = "wend_time"')
                self.widget.db.commit()

#                self.widget.loadPrefs()

                self.window.hide()

class mCalendar:
        """This is the mCalendar Application"""
        def createTable(self):
          try:
            self.dbcur.execute('CREATE TABLE events (uuid TEXT PRIMARY KEY, start DATETIME, end DATETIME, description TEXT, repeat INTEGER, repeatvalue INTEGER, frequency TEXT,until DATETIME, lastup DATETIME, googleid TEXT, byday TEXT, alarm INTEGER, alarm_value INTEGER, alarm_id INTEGER)')
            self.db.commit()
            self.dbcur.execute('CREATE TABLE prefs (id TEXT PRIMARY KEY,content TEXT);')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("last_update","2008-01-01 00:00");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("password","password");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("email","email");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("day_view","<b>%H:%M</b>");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("week_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("month_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("date_format","%x");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("time_format","%X");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wstart_time","09:00");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wend_time","18:00");')
            self.db.commit()
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("VERSION",?);',[VERSION])
            self.db.commit()

          except StandardError,e:
            debug(e)
            try:
              self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("VERSION",?);',[VERSION])
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD byday TEXT')    
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD alarm INTEGER')    
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD alarm_value INTEGER')    
              self.db.commit()
              self.dbcur.execute('ALTER TABLE events ADD alarm_id INTEGER')    
              self.db.commit()

            except StandardError,e:
              debug(e)

        def __init__(self):
                try:
                  if HILDON_SUPPORT:
                    db_path='/home/user/.mPIM/mcalendar.db'
                  else:
                    db_path='mcalendar.db'
                  self.db = sqlite3.connect(db_path)
                  self.dbcur = self.db.cursor()
                except StandardError,e:
                  debug(e)
                  commands.getoutput("mkdir /home/user/.mPIM/")
                  if HILDON_SUPPORT:
                    db_path='/home/user/.mPIM/mcalendar.db'
                  else:
                     db_path='mcalendar.db'
                  self.db = sqlite3.connect(db_path)
                  self.dbcur = self.db.cursor()

                try:
                  self.dbcur.execute('SELECT content FROM prefs WHERE id = "VERSION";')
                  v = self.dbcur.fetchall()

                  if len(v)==0:
                    print 'no version'
                    self.createTable()

#                  else:                 
#                    for version in v:
#                      if v < '0.3.0':
#                        dosomething 
                except StandardError,e:
                  debug(e)
                  print 'no db'
                  self.createTable()    

                self.dbcur.execute('UPDATE prefs SET content=? WHERE id="VERSION"',[VERSION])    
                self.db.commit()

                #Current_view :
                #    0 = Today
                #    1 = Week
                #    2 = Month
                self.current_view=0
                self.view_datetime = datetime.datetime.now()

                #Set the Glade file
                if HILDON_SUPPORT:
                  self.gladefile = "/usr/lib/mcalendar/mcalendar.glade"
                else:
                  self.gladefile = "mcalendar.glade"
                self.wTree = gtk.glade.XML(self.gladefile, "CalendarView")
                if HILDON_SUPPORT:
                  self.app = hildon.Program()     
                  gtk.set_application_name('')   
                  self.window = hildon.Window()
                else:
                  self.window = gtk.Window()
                self.window.connect("key-press-event", self.on_key_press)
                self.window.connect("window-state-event", self.on_window_state_change)  
                self.window_in_fullscreen = False #The window isn't in full screen mode initially.

#                self.window.set_icon('mcalendar')
                #set a win background
#                pixbuf = gtk.gdk.pixbuf_new_from_file('background_pattern.png')
#                pixmap, mask = pixbuf.render_pixmap_and_mask()
#                width, height = pixmap.get_size()
#                del pixbuf
#                self.window.set_app_paintable(gtk.TRUE)
#                self.window.resize(width, height)
#                self.window.realize()
#                self.window.window.set_back_pixmap(pixmap, gtk.FALSE)
#                del pixmap 
#
                self.loadPrefs()
#                hildon.hildon_helper_set_thumb_scrollbar(True,True)
                self.calendarview_win = self.wTree.get_widget("CalendarView")
                self.vbox = self.wTree.get_widget("vbox8")
                if HILDON_SUPPORT:
                  hildon.hildon_helper_set_thumb_scrollbar(self.wTree.get_widget("scrolledwindow3"),True)
                self.vbox.reparent(self.window)
                self.window.set_title(self.calendarview_win.get_title())
                self.window.connect("destroy", self.Quit)
                if HILDON_SUPPORT:
                  self.app.add_window(self.window)

                #Create our dictionay and connect it
                dic = {
                       "on_bNew_clicked" : self.AddEvent,
                       "on_bNext_clicked" : self.nextButton,
                       "on_bPrevious_clicked" : self.previousButton,
                       "on_bFreetime_clicked" : self.bFreetime,
                       "on_bToday_clicked" : self.bToday,
                       "on_bWeek_clicked" : self.bWeek,
                       "on_bMonth_clicked" : self.bMonth,
                       "on_tDisplay_row_activated" : self.EditEvent}
                self.wTree.signal_autoconnect(dic)

                #connect data
                self.list = self.wTree.get_widget("tDisplay")
                self.data = EventsDisplay(self.list)

                #get gui objects
                self.bToday = self.wTree.get_widget("bToday")
                self.bWeek = self.wTree.get_widget("bWeek")
                self.bMonth = self.wTree.get_widget("bMonth")

                self.lCurrentDate = self.wTree.get_widget("lCurrentDate")
#                self.lCurrentTime = self.wTree.get_widget("lCurrentTime")

                #set gui data
                self.updateCurrentDatetime()
#                self.timer = gobject.timeout_add(30000, self.updateCurrentDatetime)
                self.updateCurrentDayButton()                
                self.updateViewDateButton()

                self.pendingModel = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
                self.completeModel = gtk.ListStore(gobject.TYPE_STRING)
                self._make_view(self.pendingModel, "Pending Threads", True, self.vbox)

                self.updateList()
                self.create_menu()

                self.window.show_all()
                self.progress_view.hide()

        def setDefaultPrefs(self):
          self.dbcur.execute('SELECT id from Prefs where id="date_format"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("date_format","%x");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="day_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("day_view","<b>%H:%M</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="week_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("week_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="month_view"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("month_view","<b>%a %d\n%H:%M</b>");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="time_format"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("time_format","%X");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="wstart_time"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wstart_time","09:00");')
            self.db.commit()
          self.dbcur.execute('SELECT id from Prefs where id="wend_time"')
          if len(self.dbcur.fetchall())==0:
            self.dbcur.execute('INSERT INTO prefs (id,content) VALUES ("wend_time","18:00");')
            self.db.commit()

        def loadPrefs(self):
          self.setDefaultPrefs()

          global DATE_FORMAT
          DATE_FORMAT = "%x"
          global TIME_FORMAT
          TIME_FORMAT = "%X"
          global DAY_VIEW_FORMAT
          DAY_VIEW_FORMAT = "<b>%H:%M</b>"
          global WEEK_VIEW_FORMAT
          WEEK_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
          global MONTH_VIEW_FORMAT
          MONTH_VIEW_FORMAT = "<b>%a %d\n%H:%M</b>"
          global FIRST_DAY_WEEK
          FIRST_DAY_WEEK = 0
          global DAY_START_HOUR
          DAY_START_HOUR = 8
          global DAY_START_MINUTE
          DAY_START_MINUTE = 0
          global DAY_END_HOUR
          DAY_END_HOUR = 18
          global DAY_END_MINUTE
          DAY_END_MINUTE = 0

          self.dbcur.execute('SELECT id,content from Prefs')
          for prefs in self.dbcur.fetchall():
            if prefs[0]=='date_format':
              DATE_FORMAT = str(prefs[1])
            elif prefs[0]=='time_format':
              TIME_FORMAT = str(prefs[1])
            elif prefs[0]=='day_view':
              DAY_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='week_view':
              WEEK_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='month_view':
              MONTH_VIEW_FORMAT = str(prefs[1])
            elif prefs[0]=='wstart_time':
              DAY_START_HOUR = int(str(prefs[1])[0:2])
              DAY_START_MINUTE = int(str(prefs[1])[3:5])
              debug((prefs[1])[0:2])
              debug(DAY_START_HOUR)
              debug(DAY_START_MINUTE)
            elif prefs[0]=='wend_time':
              DAY_END_HOUR = int(str(prefs[1])[0:2])
              DAY_END_MINUTE = int(str(prefs[1])[3:5])

        def on_window_state_change(self, widget, event, *args):
          if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
          else:
            self.window_in_fullscreen = False

        def on_key_press(self, widget, event, *args):
          if event.keyval == gtk.keysyms.F6:
          # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
              self.window.unfullscreen ()
            else:
              self.window.fullscreen ()
          elif event.keyval == gtk.keysyms.F8:
            print "moins"
            self.previousButton(self)
          elif event.keyval == gtk.keysyms.F7:
            print "plus"
            self.nextButton(self)

        def Quit(self,widget):
                self.db.close()
                gtk.main_quit()
                exit()

        def AddEvent(self, widget):
                edit = EventEditor("",self)
                edit.show()

        def EditEvent(self, widget,a,b):
          selection = self.list.get_selection()
          # Get the selection iter
          model, selection_iter = selection.get_selected()

          if (selection_iter):
            suuid = self.data.store.get_value(selection_iter, 3)
            start = self.data.store.get_value(selection_iter, 4)
            end = self.data.store.get_value(selection_iter, 5)
            edit = EventEditor(suuid,self,start,end)
            edit.show()

        def updateCurrentDatetime(self):
          self.current_datetime = datetime.datetime.now()
#          self.lCurrentTime.set_markup(self.current_datetime.strftime(DAY_VIEW_FORMAT))
          debug('current datetime updated')
          return True

        def updateCurrentDayButton(self):
          self.bToday.set_label(self.current_datetime.strftime('%A %d'))
          self.bMonth.set_label(self.current_datetime.strftime('%B %Y'))
          self.bWeek.set_label(self.current_datetime.strftime('Week %W'))

        def updateViewDateButton(self):
          if (self.current_view == 0) or (self.current_view == 3):
            self.lCurrentDate.set_label(self.view_datetime.strftime('%A %d %B %Y'))
          elif self.current_view == 1:
            self.lCurrentDate.set_label(self.view_datetime.strftime('Week %W'))
          elif self.current_view == 2:
            self.lCurrentDate.set_label(self.view_datetime.strftime('%B %Y'))
#          self.lCurrentDate.set_size_request(-1,-1)

        def nextButton(self,widget):
          if (self.current_view == 0) or (self.current_view == 3):
            diff = datetime.timedelta(days=1)
            self.view_datetime = self.view_datetime + diff
          elif self.current_view == 1:
            diff = datetime.timedelta(weeks=1)
            self.view_datetime = self.view_datetime + diff
          elif self.current_view == 2:
            self.view_datetime = addMonth(self.view_datetime,1)

          self.updateViewDateButton()
          self.updateList()

        def previousButton(self,widget):
          if (self.current_view == 0) or (self.current_view == 3):
            diff = datetime.timedelta(days=1)
            self.view_datetime = self.view_datetime - diff
          elif self.current_view == 1:
            diff = datetime.timedelta(weeks=1)
            self.view_datetime = self.view_datetime - diff
          elif self.current_view == 2:
            self.view_datetime = supMonth(self.view_datetime,1)
          self.updateViewDateButton()
          self.updateList()

        def bToday(self,widget):
          self.current_view = 0
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def bFreetime(self,widget):
          self.current_view = 3
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def bWeek(self,widget):
          self.current_view = 1
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def bMonth(self,widget):
          self.current_view = 2
          self.view_datetime = self.current_datetime
          self.updateViewDateButton()
          self.updateList()

        def updateList(self):
            debug("UpdateList")
            self.data.store.clear()
            #test

            if self.current_view==0:
              where = ' WHERE ((start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'"'
              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'")'
              #reccuring
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'
#              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")'
            elif self.current_view==1:
              firstWeekDay,lastWeekDay = getWeekDetails(self.view_datetime)

              where = ' WHERE (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'"'
              where = where + ' AND end>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'"'
              #reccuring
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)<=7.0 ) '
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))<=7.0 ) '
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND (('+str((lastWeekDay.year*12)+lastWeekDay.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+lastWeekDay.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+firstWeekDay.strftime("%Y-%m-%d 00:00")+'" AND (('+str((lastWeekDay.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'

            elif self.current_view==2:
              where = ' WHERE (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'"'
              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'"'
              #reccuring
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-01 00:00")+'")-(julianday(start))) % repeatvalue)<31.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-01 00:00")+'")-(julianday(start))) % (repeatvalue*7))<31.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-31 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-01 00:00")+'" AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'
            elif self.current_view==3:
              where = ' WHERE ((start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'"'
              where = where + ' AND end>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'")'
              #reccuring
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Day(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % repeatvalue)=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Week(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND ((julianday("'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'")-(julianday(start))) % (repeatvalue*7))=0.0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Month(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND (('+str((self.view_datetime.year*12)+self.view_datetime.month)+'-(strftime("%m",start)+(strftime("%Y",start)*12))) % (repeatvalue))==0 ) '
              where = where + ' OR (start<="'+self.view_datetime.strftime("%Y-%m-%d 23:59")+'" AND repeat=1 AND frequency="Year(s)" AND until>="'+self.view_datetime.strftime("%Y-%m-%d 00:00")+'" AND strftime("%d",start)='+str(self.view_datetime.day)+' AND strftime("%m",start)='+str(self.view_datetime.month)+' AND (('+str((self.view_datetime.year))+'-((strftime("%Y",start)))) % (repeatvalue))==0 ) '
              where = where + ')'

            else:
              where = ""
#            self.dbcur.execute('SELECT strftime("%Y",start)*12,start from events')       
#            for event in self.dbcur.fetchall():
#              debug('Month %s' % str(event[0]))
#              debug('Date %s' %event[1])
#
            if self.current_view == 3:
              notfreetime = []

            self.dbcur.execute('SELECT  start, end, description,uuid,repeat,repeatvalue,frequency,until,byday FROM events  '+where + '  AND description<>"DELETED" ORDER by start')       
            for event in self.dbcur.fetchall():
#              debug(event[4])
#              debug(event[5])
              repeat = event[4]
              repeatvalue = int(event[5])
              frequency = event[6]
              byday = event[8]
              until = datetime.datetime.strptime(event[7],DB_FORMAT)
              start_datetime = datetime.datetime.strptime(event[0],DB_FORMAT)
              end_datetime = datetime.datetime.strptime(event[1],DB_FORMAT)
              debug('byday : %s' % byday)  
              if self.current_view==0:
                if (not repeat) or (repeat and (self.view_datetime.weekday() in googleToDays(byday))):
                  self.data.store.append((start_datetime.strftime(DAY_VIEW_FORMAT)+'\n'+end_datetime.strftime(DAY_VIEW_FORMAT),'',event[2],event[3],"",""))                
              elif self.current_view==1:
                if not repeat:
                  self.data.store.append((start_datetime.strftime(WEEK_VIEW_FORMAT),'',event[2],event[3],"",""))
                else:
                  if frequency=="Day(s)":
                    diff = datetime.timedelta(days=repeatvalue)
                    debug('repeatvalue : %s' % str(repeatvalue))
                    debug('byday : %s' % byday)
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
                      if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.data.store.append((d.strftime(WEEK_VIEW_FORMAT),'',event[2],event[3]))
                      d = d+diff       
                      debug(d) 
                  elif frequency=="Week(s)":
                    debug('byday : %s' % byday)
                    diff = datetime.timedelta(days=repeatvalue*7)
                    d = start_datetime
                    while ((d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1])) and (self.view_datetime.weekday() in googleToDays(byday)) :
                      if (d.strftime("%W")==self.view_datetime.strftime("%W")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.data.store.append((d.strftime(WEEK_VIEW_FORMAT),'',event[2],event[3],"",""))
                      d = d+diff
                  elif frequency=="Month(s)":
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
                      if (d.strftime("%W")==self.view_datetime.strftime("%W")):
                        self.data.store.append((d.strftime(WEEK_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                      d = addMonth(d,repeatvalue) 
                  elif frequency=="Year(s)":
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= getWeekDetails(self.view_datetime)[1]):
                      if ((d.strftime("%Y")==self.view_datetime.strftime("%Y")) and (d.strftime("%W")==self.view_datetime.strftime("%W"))) :
                        self.data.store.append((d.strftime(WEEK_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                      d = addMonth(d,repeatvalue*12) 

              elif self.current_view==2:
                if not repeat:
                  self.data.store.append((start_datetime.strftime(MONTH_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                else:
                  if frequency=="Day(s)":
                    diff = datetime.timedelta(days=repeatvalue)
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if (d.strftime("%m")==self.view_datetime.strftime("%m")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.data.store.append((d.strftime(MONTH_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                      d = d+diff         
                  elif frequency=="Week(s)":
                    diff = datetime.timedelta(days=repeatvalue*7)
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if (d.strftime("%m")==self.view_datetime.strftime("%m")) and (self.view_datetime.weekday() in googleToDays(byday)):
                        self.data.store.append((d.strftime(MONTH_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                      d = d+diff            
                  elif frequency=="Month(s)":
                    debug('test')
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if (d.strftime("%m")==self.view_datetime.strftime("%m")) :
                        self.data.store.append((d.strftime(MONTH_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                      d = addMonth(d,repeatvalue)                
                  elif frequency=="Year(s)":
                    debug('test')
                    d = start_datetime
                    while (d.date() <= until.date()) and (d <= endMonth(self.view_datetime)):
                      if ((d.strftime("%Y")==self.view_datetime.strftime("%Y")) and (d.strftime("%m")==self.view_datetime.strftime("%m"))):
                        self.data.store.append((d.strftime(MONTH_VIEW_FORMAT),end_datetime.strftime(''),event[2],event[3],"",""))
                      d = addMonth(d,repeatvalue*12)    
              elif self.current_view==3:
#                self.data.store.append((start_datetime.strftime(DAY_VIEW_FORMAT)+'\n'+end_datetime.strftime(DAY_VIEW_FORMAT),'',event[2],''))                
                if self.view_datetime.weekday() in googleToDays(byday):
                 notfreetime.append((start_datetime,end_datetime))

            if self.current_view == 3:
              freetime_start = startDay(self.view_datetime)
              freetime_end = endDay(self.view_datetime)
              for start_datetime,end_datetime in notfreetime:
                if freetime_end > start_datetime:
                  freetime_end = start_datetime

              if freetime_end > startDay(self.view_datetime):
                self.data.store.append((startDay(self.view_datetime).strftime(DAY_VIEW_FORMAT)+'\n'+freetime_end.strftime(DAY_VIEW_FORMAT),'','Free Time','',startDay(self.view_datetime).strftime(DB_FORMAT),freetime_end.strftime(DB_FORMAT)))

              first = True
              for start_datetime,end_datetime in notfreetime:
                if first==False:
                  freetime_end = start_datetime
#                  print freetime_start
#                  print freetime_end
                  if freetime_end > freetime_start:
                    self.data.store.append((freetime_start.strftime(DAY_VIEW_FORMAT)+'\n'+freetime_end.strftime(DAY_VIEW_FORMAT),'','Free Time','',freetime_start.strftime(DB_FORMAT),freetime_end.strftime(DB_FORMAT)))
                  freetime_start = end_datetime
                else:
                  first = False
                  freetime_start = end_datetime

              if freetime_start.strftime(DB_FORMAT) < endDay(self.view_datetime).strftime(DB_FORMAT) and (len(notfreetime)>0):
                self.data.store.append((freetime_start.strftime(DAY_VIEW_FORMAT)+'\n'+ endDay(self.view_datetime).strftime(DAY_VIEW_FORMAT),'','Free Time','',freetime_start.strftime(DB_FORMAT),endDay(self.view_datetime).strftime(DB_FORMAT)))

        def callPrefs(self,widget):
          mPrefs(self)
          self.loadPrefs()
          self.updateList()

        def create_menu(self):
          self.menubar = gtk.Menu ()
          if HILDON_SUPPORT:
            self.window.set_menu(self.menubar)

          item = gtk.MenuItem ('Synchro')
          item.connect ("activate", self.synchro)
          item.show ()
          self.menubar.append (item)

          item = gtk.MenuItem ('Preferences')
          item.connect ("activate", self.callPrefs)
          item.show ()
          self.menubar.append (item)

          item = gtk.MenuItem ('_Help')
          item.show ()
          self.menubar.append (item)

          menu = gtk.Menu ()
          menu.show ()
          item.set_submenu (menu)
          item = gtk.ImageMenuItem (gtk.STOCK_ABOUT)
          item.connect ("activate", self.onAbout)
          item.show ()
          menu.append (item)

        def onAbout(self, widget):
          dialog = gtk.AboutDialog()
          dialog.set_name("mCalendar")
          dialog.set_version(VERSION)
          dialog.set_logo_icon_name("mcalendar")
#          dialog.set_icon("/usr/share/pixmaps/mcalendar64.png")
          dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
          dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
          dialog.set_website("http://khertan.net/")
          dialog.connect ("response", lambda d, r: d.destroy())
          dialog.show()

        def synchro(self,widget):
          #win = hildon.Window()
          #box = gtk.VBox(False,3)
#          win.add(box)
#          stopButton = gtk.Button("Stop Synchro")
##          stopButton.connect("clicked",self.stop_threads)
#          box.pack_start(stopButton,False,False)
#          self.pendingModel = gtk.ListStore(gobject.TYPE_STRING,gobject.TYPE_INT)
#          self.completeModel = gtk.ListStore(gobject.TYPE_STRING)
#          self._make_view(self.pendingModel, "Pending Threads", True, self.vbox)
          #self._make_view(self.completeModel,"Completed Threads", False, self.vbox)
          self.manager = ThreadManager(1)
          self.vbox.show_all()
#          win.show_all()

          name = "Google Calendar Sync"
          data = 100
          rowref = self.pendingModel.insert(0,(name,0)) 

          #THE ACTUAL THREAD BIT
          self.manager.make_thread(
                          self.thread_finished,
                          self.thread_progress,
                          self.thread_error,
                          rowref,data,name)

        def thread_finished(self, thread, rowref):
          self.pendingModel.remove(rowref)
          if len(self.pendingModel)==0:
            self.progress_view.hide()
            self.updateList()
          self.completeModel.insert(0,(thread.name,))

        def thread_progress(self, thread, progress, rowref):
          self.pendingModel.set_value(rowref,1,int(progress))

        def thread_error(self, thread, error, rowref):
          mAlert(error)

        def _make_view(self, model, title, showProgress, vbox):
          self.progress_view = gtk.TreeView(model)
          self.progress_view.append_column(gtk.TreeViewColumn(title, gtk.CellRendererText(), text=0))
          if showProgress:
            self.progress_view.append_column(gtk.TreeViewColumn("Progress", gtk.CellRendererProgress(), value=1))
          vbox.pack_start(self.progress_view)

#        def synchro_now2(self,show_error=True):
#          import gdata
#          import gdata.calendar.service
#          import gdata.service
#          import atom.service
#          import gdata.calendar
#
#          last_update = datetime.date(1970,01,01)
#          try:
#            cal_client = gdata.calendar.service.CalendarService()
#            self.dbcur.execute('SELECT id,content FROM prefs')       
#            for prefs in self.dbcur.fetchall():
#              if prefs[0]=='email':
#                cal_client.email = prefs[1]
#              if prefs[0]=='password':
#                cal_client.password = prefs[1]
#              if prefs[0]=='last_update':
#                last_update = datetime.datetime.strptime(prefs[1],'%Y-%m-%d %H:%M')
#            future_update = datetime.datetime.now()  
#            cal_client.source = 'mCalendar ' + VERSION
#            cal_client.ProgrammaticLogin()  
#
#            #Delete Google Event
#            debug('Delete google event deleted locally')
#            self.dbcur.execute('SELECT googleid,uuid FROM events WHERE description="DELETED"')       
#            for an_event in self.dbcur.fetchall():
#                anid = an_event[0]
#                print anid
#                try:
#                  deleted_event = cal_client.GetCalendarEventEntry(anid)   
#                  cal_client.DeleteEvent(deleted_event.GetEditLink().href)
#                except gdata.service.RequestError,e:
#                  mAlert(str(e))
#            self.dbcur.execute('DELETE FROM events WHERE description="DELETED"')       
#            self.db.commit()
#
#            #send local update
#            self.dbcur.execute('SELECT uuid FROM events WHERE googleid!="" AND lastup>"'+last_update.strftime('%Y-%m-%d %H:%M')+'"')       
#            for an_event in self.dbcur.fetchall():
#              e = Event(an_event[0],self)
#              debug('uuid to update on google : %s' % (an_event[0]))
##              event = gdata.calendar.CalendarEventEntry(e.googleid)
#              event = cal_client.GetCalendarEventEntry(e.googleid)
##              event.author.append(atom.Author(name=atom.Name(text='mCalendar')))
#              event.title = atom.Title(text=e.description)
##              event.content = atom.Content(text='')
#
#              debug(1)
#              if e.repeat==True:
#                recurrence_data = ('DTSTART;VALUE=DATE:'+dateToGoogle(e.start_datetime,1)+'\r\n'     
#                     + 'DTEND;VALUE=DATE:'+dateToGoogle(e.end_datetime,1)+'\r\n'
#                     + 'RRULE:FREQ='+e.googleFrequency()+';UNTIL='+dateToGoogle(e.repeat_until,2)+';INTERVAL='+str(e.repeat_number)+'\r\n')
#                debug(recurrence_data)
#                event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
#              if len(event.when)==0:
#                event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))
#              else:
#                event.when[0] = gdata.calendar.When(start_time=dateToGoogle(e.start_datetime) , end_time=dateToGoogle(e.end_datetime) )
#
#              event.updated.text = dateToGoogle(e.lastup)
#              debug(2)
#              cal_client.UpdateEvent(event.GetEditLink().href, event)
#
#            #Create Update Event
#            debug('Get All Google Events')
#            query = gdata.calendar.service.CalendarEventQuery('default', 'private', 'full', None, {"ctz":"utc"})
#            query.updated_min = dateToGoogle(last_update)
#            #query.singleevents=True
#            debug(dateToGoogle(last_update))
##            query.start_min = '2008-05-01'
##            query.start_max = '2008-05-31'
#            feed = cal_client.CalendarQuery(query)
#            debug(4)
#
#            for i, an_event in enumerate(feed.entry):
#              an_event.id.text = string.replace(an_event.id.text,'composite','full')
#              self.dbcur.execute('SELECT uuid,lastup FROM events WHERE googleid="'+an_event.id.text+'"')       
#              uuid = ''
#              debug(5)
#              for event in self.dbcur.fetchall():
#                uuid = event[0]
#                updated = event[1]
#
#              debug('status:')
#              debug(an_event.event_status.value)
#              if an_event.event_status.value=='CANCELED':
#                debug('Delete local event deleted on google : %s' % (an_event.id.text))
#                self.dbcur.execute('DELETE FROM events WHERE googleid="'+an_event.id.text+'"')       
#                self.db.commit()
#              else:
#                e = Event(uuid,self)
#                if uuid == '':
#                  #new event
#                  for a_when in an_event.when:
#                    e.start_datetime = dateFromGoogle(a_when.start_time)
#                    e.end_datetime = dateFromGoogle(a_when.end_time)
#                  e.description = an_event.title.text
#                  e.googleid = an_event.id.text
#                  if an_event.updated==None:
#                    debug('updated=None')
#                  e.lastup = dateFromGoogle(an_event.updated.text)
#                  if an_event.recurrence == None:
#                    debug('recurrence=None')
#                    e.repeat = False
#                  else:
#                      debug('recurrence=True')                  
#                      e.repeat=True
#                      rstring = an_event.recurrence.text
#                      rstring = rstring.split('\n')
#                      if len(rstring[2]) != 0 :
#                        for line in rstring:
#                            if 'DTSTART' in line:
#                              value = line.split(':')[1]
#                              if 'T' in value:
#                                e.start_datetime = dateFromGoogle(value,1)
#                              else:
#                                e.start_datetime = dateFromGoogle(value,2)
#                            elif 'DTEND' in line:
#                              value = line.split(':')[1]
#                              if 'T' in value:
#                                e.end_datetime = dateFromGoogle(value,1)
#                              else:
#                                e.end_datetime = dateFromGoogle(value,2)
#                            if "UNTIL" in line:
#                              line = line.replace('RRULE:FREQ=','')
#                              line = line.replace('UNTIL=','')
#                              line = line.replace('INTERVAL=','')
#                              print line
#                              if len(line.split(';'))>2:
#                                frequency,until,value = line.split(';')
#                              else:
#                                frequency,until = line.split(';')
#                                value = '1'
#                              if value.isdigit():
#                                e.repeat_number = int(value)
#                              else:
#                                if 'BYMONTHDAY' in value:
#                                  frequency,value=('Month(s)',1)
#
#                              if 'T' in until:
#                                e.repeat_until = dateFromGoogle(until,1)
#                              else:
#                                e.repeat_until = dateFromGoogle(until,2)
#                              e.setFrequencyFromGoogle(frequency)
#
#                  e.saveToDB(self)
#                else:
#                  #check update
#                  google_update = dateFromGoogle(an_event.updated.text)
#                  debug('dates : ...')
#                  debug(google_update)
#                  debug(e.lastup)
#                  if google_update==e.lastup:
#                    debug('Events match %s' % (uuid))
#                  elif google_update<e.lastup:
#                    mAlert('WARNING')
#                    debug('Need to update google %s' % (uuid))
#                    debug('Google utc update  date : %s' %(str(an_event.updated.text)))
#                    debug('Google timezone update  date : %s' %(str(google_update)))
#                    debug('Local update date : %s' %(str(e.lastup)))
#                    an_event.title.text = e.description
#                    debug(dir(an_event))
#                    an_event.updated.text = dateToGoogle(e.lastup)
#                    for a_when in an_event.when:
#                      a_when.start_time = dateToGoogle(e.start_datetime)                  
#                      a_when.end_time = dateToGoogle(e.end_datetime)
#                    an_event.updated.text = dateToGoogle(e.lastup)
#                    debug('Local utc update date : %s' %(str(an_event.updated.text)))
#                    cal_client.UpdateEvent(an_event.GetEditLink().href, an_event)
#                  elif google_update>e.lastup:
#                    debug('update local event %s' % (uuid))
#                    for a_when in an_event.when:
#                      e.start_datetime = dateFromGoogle(a_when.start_time)
#                      e.end_datetime = dateFromGoogle(a_when.end_time)
#                    e.description = an_event.title.text
#                    e.googleid = an_event.id.text
#                    e.lastup = dateFromGoogle(an_event.updated.text)
#                    if an_event.recurrence == None:
#                      debug('recurrence=None')
#                    else:
#                      debug('recurrence=True')
#
#                      e.repeat=True
#                      rstring = an_event.recurrence.text
#                      rstring = rstring.split('\n')
#                      if len(rstring[2]) != 0 :
#                        for line in rstring:
#                            if 'DTSTART' in line:
#                              value = line.split(':')[1]
#                              if 'T' in value:
#                                e.start_datetime = dateFromGoogle(value,1)
#                              else:
#                                e.start_datetime = dateFromGoogle(value,2)
#                                e.start_datetime.hour = 0
#                                e.start_datetime.minute = 0
#                            elif 'DTEND' in line:
#                              value = line.split(':')[1]
#                              if 'T' in value:
#                                e.end_datetime = dateFromGoogle(value,1)
#                              else:
#                                e.end_datetime = dateFromGoogle(value,2)
#                                e.start_datetime.hour = 23
#                                e.start_datetime.minute = 59
#                            if "UNTIL" in line:
#                              line = line.replace('RRULE:FREQ=','')
#                              line = line.replace('UNTIL=','')
#                              line = line.replace('INTERVAL=','')
#                              if len(line.split(';'))>2:
#                                frequency,until,value = line.split(';')
#                              else:
#                                frequency,until = line.split(';')
#                                value = '1'
#                              if value.isdigit():
#                                e.repeat_number = int(value)
#                              else:
#                                if 'BYMONTHDAY' in value:
#                                  frequency,value=('Month(s)',1)
#                              if 'T' in until:
#                                e.repeat_until = dateFromGoogle(until,1)
#                              else:
#                                e.repeat_until = dateFromGoogle(until,2)
#                              e.setFrequencyFromGoogle(frequency)
#
#                    e.saveToDB(self)
#                    debug(dir(an_event))
#                    debug(dir(an_event.recurrence))
#                    if (an_event.recurrence!=None):
#                      debug(an_event.recurrence.text)
##                    debug(an_event.recurrence.__getattribute__('DTSTART'))
#
#            #send new
#            self.dbcur.execute('SELECT uuid FROM events WHERE googleid=""')       
#            for an_event in self.dbcur.fetchall():
#              e = Event(an_event[0],self)
#              debug('new uuid to send : %s' % (an_event[0]))
#              event = gdata.calendar.CalendarEventEntry()
#              event.author.append(atom.Author(name=atom.Name(text='mCalendar')))
#              event.title = atom.Title(text=e.description)
#              if e.repeat==True:
#                recurrence_data = ('DTSTART;VALUE=DATE:'+dateToGoogle(e.start_datetime,1)+'\r\n'     
#                     + 'DTEND;VALUE=DATE:'+dateToGoogle(e.end_datetime,1)+'\r\n'
#                     + 'RRULE:FREQ='+e.googleFrequency()+';UNTIL='+dateToGoogle(e.repeat_until,2)+';INTERVAL='+str(e.repeat_number)+'\r\n')
#                debug(recurrence_data)
#                event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
#                event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))              
#              else:
#                event.when.append(gdata.calendar.When(start_time=dateToGoogle(e.start_datetime), end_time=dateToGoogle(e.end_datetime)))
#              new_event = cal_client.InsertEvent(event,'/calendar/feeds/default/private/full')
#              e.googleid = new_event.id.text
#              e.saveToDB(self)
#
#            self.dbcur.execute('UPDATE prefs SET content="'+future_update.strftime("%Y-%m-%d %H:%M")+'" WHERE id ="last_update";')
#            self.db.commit()
#
#          except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,e:
#            import traceback
#            e = traceback.print_exc()
#            debug(e)
#            if show_error:
#              mAlert(str(e))
#
#          self.updateList()

if __name__ == "__main__":

        gtk.settings_get_default().set_long_property("gtk-button-images",1,"")
        mCal = mCalendar()
        gtk.main()

#              debug(event[4])
#              debug(event[5])