/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/. 
 */

#include <glib/gerror.h>
#include <glib/gtypes.h>
#include <glib/gutils.h>        /* for G_INLINE_FUNC */
#include <glib/gatomic.h>       /* for g_atomic_pointer_get */
#include <glib/gthread.h>
#include <glib-object.h>

G_BEGIN_DECLS

void g_warn_message           (const char     *domain,
                               const char     *file,
                               int             line,
                               const char     *func,
                               const char     *warnexpr);

#define g_warn_if_fail(expr)    do { if G_LIKELY (expr) ; else \
                                       g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, #expr); } while (0)

//#define g_return_if_fail(expr)		G_STMT_START{			\
//     if G_LIKELY(expr) { } else       					\
//       {								\
//	 g_return_if_fail_warning (G_LOG_DOMAIN,			\
//		                   __PRETTY_FUNCTION__,		        \
//		                   #expr);				\
//	 return;							\
//       };				}G_STMT_END
//
//#define g_return_val_if_fail(expr,val)	G_STMT_START{			\
//     if G_LIKELY(expr) { } else						\
//       {								\
//	 g_return_if_fail_warning (G_LOG_DOMAIN,			\
//		                   __PRETTY_FUNCTION__,		        \
//		                   #expr);				\
//	 return (val);							\
//       };				}G_STMT_END
//
//#define G_ONCE_INIT { G_ONCE_STATUS_NOTCALLED, NULL }

//static void soup_init_threads ();

gpointer g_once_impl (GOnce *once, GThreadFunc func, gpointer arg);

//#ifdef G_ATOMIC_OP_MEMORY_BARRIER_NEEDED
//# define g_once(once, func, arg) g_once_impl ((once), (func), (arg))
//#else /* !G_ATOMIC_OP_MEMORY_BARRIER_NEEDED*/
//# define g_once(once, func, arg) \
//  (((once)->status == G_ONCE_STATUS_READY) ? \
//   (once)->retval : \
//   g_once_impl ((once), (func), (arg)))
//#endif /* G_ATOMIC_OP_MEMORY_BARRIER_NEEDED */

/* initialize-once guards, keyed by value_location */
G_INLINE_FUNC gboolean  g_once_init_enter       (volatile gsize *value_location);
gboolean				g_once_init_enter_impl 	(volatile gsize *value_location);
void                    g_once_init_leave      	(volatile gsize *value_location,
                                                 gsize initialization_value);
#if defined (G_CAN_INLINE) || defined (__G_THREAD_C__)
G_INLINE_FUNC gboolean
g_once_init_enter (volatile gsize *value_location)
{
  if G_LIKELY (g_atomic_pointer_get ((void*volatile*) value_location) != NULL)
    return FALSE;
  else
    return g_once_init_enter_impl (value_location);
}
#endif /* G_CAN_INLINE || __G_THREAD_C__ */

/**
 * GCancellable:
 * 
 * Allows actions to be cancelled.
 */
typedef struct _GCancellable        SoupCancellable;
typedef struct _GCancellableClass   SoupCancellableClass;

SoupCancellable *g_cancellable_new 					(void);
gboolean      g_cancellable_is_cancelled            (SoupCancellable  *cancellable);
void		  g_cancellable_cancel 					(SoupCancellable *cancellable);

int			  g_strcmp0 							(const char *str1, const char *str2);

G_END_DECLS
