// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
		
		
//#####################################################################
//#####################################################################
//##################################################################### messagelist :: by gary birkett
//#####################################################################
//#####################################################################

int messagelist_additem(liqcell *messagelist,char *time,char *user,char *message)
{
	// insert a new item into the messagelist object
	
	//liqapp_log("messagelist_additem start");
	
	liqcell *backplane = liqcell_child_lookup(messagelist, "backplane");
	
	
		liqapp_log("messagelist_additem creating '%s'",message);
	
		//############################# messageitem1:messageitem
		liqcell *messageitem1 = liqcell_quickcreatevis("messageitem1", "messageitem", 0, 0, messagelist->w, 38);
		liqcell_propsets(messageitem1,"time",time);
		liqcell_propsets(messageitem1,"user",user);
		liqcell_propsets(messageitem1,"text",message);
		liqcell_child_append(  backplane, messageitem1);
		liqcell_handlerrun(messageitem1,"refresh",NULL);		// call the refresh
		

		//liqapp_log("messagelist_additem setting position");
		liqcell_child_arrange_easycol(  backplane );
		//backplane->h+=64;
		if(backplane->h <= messagelist->h)
		{
			backplane->y=0;
		}
		else
		{
			backplane->y=-(backplane->h - messagelist->h);
		}

	//liqapp_log("messagelist_additem complete");
	return 0;
}
		
		
/**	
 * messagelist widget refresh, all params set, present yourself to the user.
 */	
static int messagelist_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}
/**	
 * messagelist dialog_open - the user zoomed into the dialog
 */	
static int messagelist_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * messagelist dialog_close - the dialog was closed
 */	
static int messagelist_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * messagelist widget shown - occurs once per lifetime
 */	
static int messagelist_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * messagelist mouse - occurs all the time as you stroke the screen
 */	
static int messagelist_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagelist click - occurs when a short mouse stroke occured
 */	
static int messagelist_click(liqcell *self, liqcelleventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagelist keypress - the user pressed a key
 */	
static int messagelist_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagelist keyrelease - the user released a key
 */	
static int messagelist_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagelist paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int messagelist_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * messagelist dynamic resizing
 */	
static int messagelist_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float sx=((float)self->w)/((float)self->innerw);
	float sy=((float)self->h)/((float)self->innerh);
	
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
	//	liqcell *messageitem1 = liqcell_child_lookup(backplane, "messageitem1");
	//	liqcell *messageitem2 = liqcell_child_lookup(backplane, "messageitem2");
	//	liqcell *messageitem3 = liqcell_child_lookup(backplane, "messageitem3");
	//	liqcell *messageitem4 = liqcell_child_lookup(backplane, "messageitem4");
	//	liqcell *messageitem5 = liqcell_child_lookup(backplane, "messageitem5");
	liqcell_setrect_autoscale( backplane, 2,0, 596,274, sx,sy);
	//liqcell_setrect_autoscale( messageitem1, 0,0, 596,52, sx,sy);
	//liqcell_setrect_autoscale( messageitem2, 0,52, 596,52, sx,sy);
	//liqcell_setrect_autoscale( messageitem3, 0,104, 596,52, sx,sy);
	//liqcell_setrect_autoscale( messageitem4, 0,156, 596,52, sx,sy);
	//liqcell_setrect_autoscale( messageitem5, 0,208, 596,52, sx,sy);
	return 0;
}

/**	
 * messagelist_child_test_seek this function shows how to access members
 */	
	  
static void messagelist_child_test_seek(liqcell *self)
{	  
	liqcell *resize1 = liqcell_child_lookup(self, "resize1");
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
	//	liqcell *messageitem1 = liqcell_child_lookup(backplane, "messageitem1");
	//	liqcell *messageitem2 = liqcell_child_lookup(backplane, "messageitem2");
	//	liqcell *messageitem3 = liqcell_child_lookup(backplane, "messageitem3");
	//	liqcell *messageitem4 = liqcell_child_lookup(backplane, "messageitem4");
	//	liqcell *messageitem5 = liqcell_child_lookup(backplane, "messageitem5");
}	  
/**	
 * create a new messagelist widget
 */	
liqcell *messagelist_create()
{
	liqcell *self = liqcell_quickcreatewidget("messagelist", "form", 620, 276);
	if(!self) {liqapp_log("liqcell error not create 'messagelist'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# backplane:picturebox
	liqcell *backplane = liqcell_quickcreatevis("backplane", "picturebox", 2, 0, 596, 274);
	//liqcell_setfont(	backplane, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	//liqcell_propsets(  backplane, "textcolor", "rgb(255,255,255)" );
	//liqcell_propsets(  backplane, "backcolor", "rgb(128,128,128)" );
		liqcell_handleradd(backplane,    "mouse",   liqcell_easyhandler_kinetic_mouse );
		////############################# messageitem1:messageitem
		//liqcell *messageitem1 = liqcell_quickcreatevis("messageitem1", "messageitem", 0, 0, 596, 52);
		//liqcell_child_append(  backplane, messageitem1);
		////############################# messageitem2:messageitem
		//liqcell *messageitem2 = liqcell_quickcreatevis("messageitem2", "messageitem", 0, 52, 596, 52);
		//liqcell_child_append(  backplane, messageitem2);
		////############################# messageitem3:messageitem
		//liqcell *messageitem3 = liqcell_quickcreatevis("messageitem3", "messageitem", 0, 104, 596, 52);
		//liqcell_child_append(  backplane, messageitem3);
		////############################# messageitem4:messageitem
		//liqcell *messageitem4 = liqcell_quickcreatevis("messageitem4", "messageitem", 0, 156, 596, 52);
		//liqcell_child_append(  backplane, messageitem4);
		////############################# messageitem5:messageitem
		//liqcell *messageitem5 = liqcell_quickcreatevis("messageitem5", "messageitem", 0, 208, 596, 52);
		//liqcell_child_append(  backplane, messageitem5);
	liqcell_child_append(  self, backplane);
	//liqcell_propsets(  self, "backcolor", "rgb(0,40,0)" );
	liqcell_handleradd_withcontext(self, "refresh", messagelist_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown", messagelist_shown ,self);
	liqcell_handleradd_withcontext(self, "resize", messagelist_resize ,self);
	//liqcell_handleradd_withcontext(self, "keypress", messagelist_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", messagelist_keyrelease ,self);
	//liqcell_handleradd_withcontext(self, "mouse", messagelist_mouse,self );
	//liqcell_handleradd_withcontext(self, "click", messagelist_click ,self);
	//liqcell_handleradd_withcontext(self, "paint", messagelist_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open", messagelist_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", messagelist_dialog_close ,self);
	return self;
}

